/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.metrics.AbstractGauge;
import com.twitter.common.metrics.Counter;
import com.twitter.common.metrics.Gauge;
import com.twitter.common.metrics.HistogramInterface;
import com.twitter.common.metrics.MetricRegistry;
import com.twitter.common.metrics.Snapshot;

class ScopedRegistry
implements MetricRegistry {
    @VisibleForTesting
    public static final String DEFAULT_SCOPE_DELIMITER = ".";
    private final MetricRegistry parent;
    private final String name;

    @VisibleForTesting
    ScopedRegistry(MetricRegistry metricRegistry, String string) {
        this.parent = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.name = MorePreconditions.checkNotBlank((String)string);
    }

    @Override
    public MetricRegistry scope(String string) {
        return new ScopedRegistry(this, string);
    }

    private String scopeName(String string) {
        return this.name + DEFAULT_SCOPE_DELIMITER + string;
    }

    @Override
    public <T extends Number> void register(Gauge<T> gauge) {
        this.registerGauge(gauge);
    }

    @Override
    public <T extends Number> Gauge<T> registerGauge(final Gauge<T> gauge) {
        String string = this.scopeName(gauge.getName());
        return this.parent.registerGauge(new AbstractGauge<T>(string){

            @Override
            public T read() {
                return gauge.read();
            }
        });
    }

    public boolean unregister(Gauge gauge) {
        return this.parent.unregister(gauge);
    }

    @Override
    public Counter createCounter(String string) {
        return this.parent.createCounter(this.scopeName(string));
    }

    @Override
    public Counter registerCounter(String string) {
        return this.createCounter(string);
    }

    @Override
    public boolean unregister(Counter counter) {
        return this.parent.unregister(counter);
    }

    @Override
    public HistogramInterface createHistogram(String string) {
        return this.parent.createHistogram(this.scopeName(string));
    }

    @Override
    public HistogramInterface registerHistogram(final HistogramInterface histogramInterface) {
        HistogramInterface histogramInterface2 = new HistogramInterface(){

            @Override
            public String getName() {
                return ScopedRegistry.this.scopeName(histogramInterface.getName());
            }

            @Override
            public void clear() {
                histogramInterface.clear();
            }

            @Override
            public void add(long l) {
                histogramInterface.add(l);
            }

            @Override
            public Snapshot snapshot() {
                return histogramInterface.snapshot();
            }
        };
        this.parent.registerHistogram(histogramInterface2);
        return histogramInterface2;
    }

    @Override
    public boolean unregister(HistogramInterface histogramInterface) {
        return this.parent.unregister(histogramInterface);
    }

    @Override
    public boolean unregister(String string) {
        return this.parent.unregister(this.scopeName(string));
    }
}

