/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.metrics;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.collections.BoundedQueue;
import com.twitter.common.metrics.MetricListener;
import com.twitter.common.metrics.TimeSeriesProvider;
import com.twitter.common.util.Clock;
import java.util.Map;
import java.util.Set;

public class TimeSeriesListeningProvider
implements TimeSeriesProvider,
MetricListener {
    private final BoundedQueue<Number> timestamps;
    private final LoadingCache<String, BoundedQueue<Number>> timeseries;
    private final Clock clock;

    public TimeSeriesListeningProvider(final int n, Clock clock) {
        Preconditions.checkNotNull((Object)clock, (Object)"Clock can not be null.");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Timeseries size must be positive.");
        this.clock = clock;
        this.timestamps = new BoundedQueue(n);
        Supplier<BoundedQueue<Number>> supplier = new Supplier<BoundedQueue<Number>>(){

            public BoundedQueue<Number> get() {
                BoundedQueue boundedQueue = new BoundedQueue(n);
                for (int i = 0; i < TimeSeriesListeningProvider.this.timestamps.size() - 1; ++i) {
                    boundedQueue.add((Object)0L);
                }
                return boundedQueue;
            }
        };
        this.timeseries = CacheBuilder.newBuilder().build(CacheLoader.from((Supplier)supplier));
    }

    @Override
    public synchronized Set<String> getAvailableSeries() {
        return ImmutableSet.copyOf(this.timeseries.asMap().keySet());
    }

    @Override
    public synchronized Iterable<Number> getTimeSeries(String string) {
        if (!this.timeseries.asMap().containsKey(string)) {
            return null;
        }
        return Iterables.unmodifiableIterable((Iterable)((Iterable)this.timeseries.getUnchecked((Object)string)));
    }

    @Override
    public synchronized Iterable<Number> getTimestamps() {
        return Iterables.unmodifiableIterable(this.timestamps);
    }

    @Override
    public synchronized void updateStats(Map<String, Number> map) {
        this.timestamps.add((Object)this.clock.nowMillis());
        for (Map.Entry<String, Number> entry : map.entrySet()) {
            BoundedQueue boundedQueue = (BoundedQueue)this.timeseries.getUnchecked((Object)entry.getKey());
            boundedQueue.add((Object)entry.getValue());
        }
    }
}

