/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class InetSocketAddressHelper {
    public static final Function<String, InetSocketAddress> STR_TO_INET = new Function<String, InetSocketAddress>(){

        public InetSocketAddress apply(String string) {
            return InetSocketAddressHelper.parse(string);
        }
    };
    public static final Function<Integer, InetSocketAddress> INT_TO_INET = new Function<Integer, InetSocketAddress>(){

        public InetSocketAddress apply(Integer n) {
            try {
                return InetSocketAddressHelper.getLocalAddress(n);
            }
            catch (UnknownHostException unknownHostException) {
                throw Throwables.propagate((Throwable)unknownHostException);
            }
        }
    };
    public static final Function<InetSocketAddress, String> INET_TO_STR = new Function<InetSocketAddress, String>(){

        public String apply(InetSocketAddress inetSocketAddress) {
            return InetSocketAddressHelper.toString(inetSocketAddress);
        }
    };

    public static InetSocketAddress parse(String string) {
        Preconditions.checkNotNull((Object)string);
        String[] stringArray = string.split(":", 2);
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid socket address spec: " + string);
        }
        String string2 = stringArray[0];
        int n = InetSocketAddressHelper.asPort(stringArray[1]);
        return StringUtils.isEmpty((String)string2) ? new InetSocketAddress(n) : InetSocketAddress.createUnresolved(string2, n);
    }

    public static String toString(InetSocketAddress inetSocketAddress) {
        Preconditions.checkNotNull((Object)inetSocketAddress);
        return inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort();
    }

    private static int asPort(String string) {
        if ("*".equals(string)) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port: " + string, numberFormatException);
        }
    }

    public static InetSocketAddress getLocalAddress(int n) throws UnknownHostException {
        String string = InetAddress.getLocalHost().getHostAddress();
        return new InetSocketAddress(string, n);
    }

    private InetSocketAddressHelper() {
    }

    public static Set<InetSocketAddress> convertToSockets(Iterable<String> iterable) {
        return Sets.newHashSet((Iterable)Iterables.transform(iterable, STR_TO_INET));
    }
}

