/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlHelper {
    private static final Logger LOG = Logger.getLogger(UrlHelper.class.getName());
    private static final Pattern URL_PROTOCOL_REGEX = Pattern.compile("^https?://", 2);

    public static String getDomain(String string) {
        try {
            return UrlHelper.getDomainChecked(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.finest("Malformed url: " + string);
            return null;
        }
    }

    public static String getDomainChecked(String string) throws URISyntaxException {
        Preconditions.checkNotNull((Object)string);
        string = UrlHelper.addProtocol(string);
        return new URI(string).getHost();
    }

    public static String getPath(String string) {
        Preconditions.checkNotNull((Object)string);
        string = UrlHelper.addProtocol(string);
        try {
            return new URI(string).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.info("Malformed url: " + string);
            return null;
        }
    }

    public static String stripUrlParameters(String string) {
        Preconditions.checkNotNull((Object)string);
        int n = string.indexOf("?");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String stripUrlParameters(URL uRL) {
        return UrlHelper.stripUrlParameters(uRL.toString());
    }

    public static String addProtocol(String string) {
        Preconditions.checkNotNull((Object)string);
        Matcher matcher = URL_PROTOCOL_REGEX.matcher(string);
        if (!matcher.find()) {
            string = "http://" + string;
        }
        return string;
    }

    public static List<String> getDomainLevels(String string) {
        Preconditions.checkNotNull((Object)string);
        if (!string.startsWith("www")) {
            string = "www." + string;
        }
        Joiner joiner = Joiner.on((String)".");
        LinkedList linkedList = Lists.newLinkedList(Arrays.asList(string.split("\\.")));
        LinkedList linkedList2 = Lists.newLinkedList();
        while (!linkedList.isEmpty()) {
            linkedList2.add(joiner.join((Iterable)linkedList));
            linkedList.remove(0);
        }
        return linkedList2;
    }
}

