/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.twitter.common.collections.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UrlTokenizerUtil {
    private static final ImmutableSet.Builder<Pair<String, String>> TWO_PART_TLD_BUILDER = ImmutableSet.builder();
    private static Set<Pair<String, String>> TWO_PART_TLDS = null;

    public static List<String> getReversedDomainParts(String string, int n) {
        ArrayList arrayList = Lists.newArrayList();
        String[] stringArray = string.split("\\.");
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            arrayList.add(string2);
        }
        Collections.reverse(arrayList);
        if (arrayList.size() >= 2 && TWO_PART_TLDS.contains(Pair.of(arrayList.get(1), arrayList.get(0)))) {
            arrayList.set(0, (String)arrayList.get(1) + "." + (String)arrayList.get(0));
            arrayList.remove(1);
        }
        if (arrayList.size() > n) {
            return arrayList.subList(0, n);
        }
        if (arrayList.size() < n) {
            int n3 = n - arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public static boolean isTLD(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return true;
        }
        if (stringArray.length == 2) {
            return TWO_PART_TLDS.contains(Pair.of((Object)stringArray[bl ? 1 : 0], (Object)stringArray[bl ? 0 : 1]));
        }
        return false;
    }

    static {
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"2000", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ab", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ab", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"abo", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"at"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"be"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"gn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"im"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ma"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"pg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"rs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"tz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"ug"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"yu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"zm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ac", (Object)"zw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"act", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ad", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"adm", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"adult", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"adv", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"adygeya", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aero", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aero", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aeroport", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"agr", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"agrar", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"agro", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ah", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aichi", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aid", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ak", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"akita", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"al", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aland", (Object)"fi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"alderney", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"alt", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"alt", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"altai", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"am", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"amur", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"amursk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"aomori", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ar", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"arkhangelsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"army", (Object)"mil"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"arq", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"art", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"art", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"art", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"art", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"art", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"arts", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"arts", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"arts", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asn", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asn", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ass", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"assedic", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"assn", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asso", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asso", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asso", (Object)"gp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asso", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asso", (Object)"mc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"asso", (Object)"re"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"astrakhan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"at", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"at", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"atm", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ato", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"au", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"au", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"auto", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"av", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"avocat", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"avoues", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"az", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"baikal", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"barreau", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bashkiria", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bbs", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bc", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bd", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"be", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bel", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"belgie", (Object)"be"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"belgorod", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bg", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bialystok", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bib", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bio", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bir", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"biz", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bj", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bl", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bmd", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bolt", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bourse", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"br", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"brand", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"british-library", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"bryansk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"buryatia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"busan", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"c", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ca", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ca", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ca", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"casino", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cbg", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cc", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cci", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ch", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ch", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chambagri", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chel", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chelyabinsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cherkassy", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chernigov", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chernovtsy", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chiba", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chirurgiens-dentistes", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chita", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chukotka", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chungbuk", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chungnam", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"chuvashia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cim", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"city", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"city", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ck", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"club", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cmw", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cn", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cn", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cng", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cnt", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ag"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ao"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"at"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"bw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ck"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"dk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"im"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ls"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ma"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"mu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"mz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"rs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"tv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"tz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ug"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"uz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"vi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"yu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"zm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"co", (Object)"zw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ac"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"af"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ag"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ai"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"an"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"aw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"bz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"cd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ch"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"dm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"es"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"gu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"hk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"hn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"hr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"io"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"jm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"jo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"kg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ki"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"kw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ky"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"kz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"la"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"lb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"lc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"li"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"lr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"mx"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"nc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"nf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ni"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"np"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"py"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"qa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"re"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"sy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"uy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"uz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"vc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"vi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ws"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"com", (Object)"ye"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"conf", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"conf", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"consulado", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"coop", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"coop", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"coop", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"coop", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"coop", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cpa", (Object)"pro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cq", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cri", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"crimea", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"csiro", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ct", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cul", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cv", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"cz", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"d", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"daegu", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"daejeon", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dagestan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dc", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"de", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"de", (Object)"net"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"de", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"de", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"de", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"de", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dk", (Object)"org"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dk", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dn", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dnepropetrovsk", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dni", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dns", (Object)"be"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"donetsk", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dp", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dpn", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dr", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"dudinka", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"e-burg", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"e", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"e164", (Object)"arpa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ebiz", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ecn", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ed", (Object)"ao"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ed", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ed", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ac"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"af"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ai"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"an"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"bt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ck"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"dm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"es"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"gh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"gi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"gp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"gr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"gu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"hk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"hn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"it"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"jm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"jo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"kg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"kw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ky"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"kz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"lb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"lc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"lr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"mx"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ni"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"np"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"py"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"qa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"rs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"sv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"uy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"vi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ws"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"ye"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"yu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edu", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"edunet", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ehime", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ekloges", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"embaixada", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eng", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ens", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ernet", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"erotica", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"erotika", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"es", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"es", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"esp", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"etc", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eti", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eu", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eu", (Object)"org"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eu", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eu", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"eun", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"experts-comptables", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"f", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fam", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"far", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fareast", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fax", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fed", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fgov", (Object)"be"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fh", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fhs", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fhsk", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fhv", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fi", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fie", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"film", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fin", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fin", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"firm", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"firm", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"firm", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"firm", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"firm", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fj", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fl", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fm", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fnd", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"folkebibl", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"forum", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fot", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fr", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fr", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"from", (Object)"hr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fst", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fukui", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fukuoka", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fukushima", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"fylkesbibl", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"g", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"g12", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ga", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"game", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"games", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gangwon", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gb", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gb", (Object)"net"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gc", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gd", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gda", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gdansk", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"geek", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gen", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gen", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gen", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"geometre-expert", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ggf", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gifu", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gmina", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"tz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"go", (Object)"ug"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"es"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"hn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"mx"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"ni"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gob", (Object)"sv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gok", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gon", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gop", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gos", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gouv", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gouv", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gouv", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ac"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"af"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ai"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"bt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"by"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ch"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ck"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"cx"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"dm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"gh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"gi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"gn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"gr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"gu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"hk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ie"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"im"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"io"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"it"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"jm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"jo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"kg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"kw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ky"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"kz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"li"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ma"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"np"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"py"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"qa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"rs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"sy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"to"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"vi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ws"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"ye"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"zm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gov", (Object)"zw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"govt", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gr", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"greta", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"grozny", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"grp", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gs", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gsm", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gub", (Object)"uy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"guernsey", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gunma", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gv", (Object)"ao"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gv", (Object)"at"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gwangju", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gx", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gyeongbuk", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gyeonggi", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gyeongnam", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"gz", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"h", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ha", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hb", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"he", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"health", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"herad", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hi", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hi", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hiroshima", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hk", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hl", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hn", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hokkaido", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hotel", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hotel", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hs", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hu", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"huissier-justice", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"hyogo", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"i", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ia", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ibaraki", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"icnet", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"id", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"id", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"id", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"id", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"id", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"id", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"idf", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"idn", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"idrett", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"idv", (Object)"hk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"idv", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"if", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"il", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"imb", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"in-addr", (Object)"arpa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"in", (Object)"rs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"in", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"in", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"in", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"incheon", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ind", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"inf", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"inf", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"info", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ing", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ingatlan", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"inima", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"int", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"intl", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ip6", (Object)"arpa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"iris", (Object)"arpa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"irkutsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"isa", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ishikawa", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"isla", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"it", (Object)"ao"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"it", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ivano-frankivsk", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ivanovo", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"iwate", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"iwi", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"iz", (Object)"hr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"izhevsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jamal", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jar", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jeju", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jeonbuk", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jeonnam", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jersey", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jet", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jl", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jobs", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jogasz", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jor", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"joshkar-ola", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"js", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"jx", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"k-uralsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"k", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"k12", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"k12", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"k12", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kagawa", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kagoshima", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kalmykia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kaluga", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kamchatka", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kanagawa", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kanazawa", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"karelia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"katowice", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kawasaki", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kazan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kchr", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kemerovo", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kg", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kh", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"khabarovsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"khakassia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kharkov", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kherson", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"khmelnitskiy", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"khv", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kids", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kiev", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kirov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kirovograd", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kitakyushu", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"km", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kms", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kobe", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kochi", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"koenig", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"komforb", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"komi", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kommunalforbund", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kommune", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"komvux", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"konyvelo", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kostroma", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kr", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"krakow", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"krasnoyarsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ks", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ks", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kuban", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kumamoto", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kurgan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kursk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kustanai", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kuzbass", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kv", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ky", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kyonggi", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"kyoto", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"la", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lakas", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lanarb", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lanbib", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"law", (Object)"pro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"law", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lel", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lg", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lg", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lipetsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lkd", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ln", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lodz", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"gi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ltd", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lublin", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lugansk", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lutsk", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"lviv", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"m", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ma", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"magadan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"magnitka", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mail", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"maori", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mari-el", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mari", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"marine", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mat", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"matsuyama", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mb", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"md", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"me", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"me", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"pro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"med", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"medecin", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"media", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"media", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mi", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mi", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"miasta", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mie", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ac"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"by"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"gh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"gu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"hn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"io"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"jo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"kg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"kw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"kz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"lb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"lt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"lu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"np"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"sh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"sk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"uy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"ye"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mil", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"miyagi", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"miyazaki", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mk", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mn", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mo", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mo", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mob", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mobi", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mobil", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mobile", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mod", (Object)"gi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mod", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mod", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mordovia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mosreg", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ms", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ms", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"msk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mt", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"muni", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"murmansk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mus", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"museum", (Object)"mn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"museum", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"museum", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"museum", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"museum", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"museum", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"music", (Object)"mobi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"mytis", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"n", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nagano", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nagasaki", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nagoya", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nakhodka", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nalchik", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"hr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"name", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nara", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nat", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"national-library-scotland", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"naturbruksgymn", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"navy", (Object)"mil"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nb", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nc", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nd", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ne", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ne", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ne", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ne", (Object)"tz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ne", (Object)"ug"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ne", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nel", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ac"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"af"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ag"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ai"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"an"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"bz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"cd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ch"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ck"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"dm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"gn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"gp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"gr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"gu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"hk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"hn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"im"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"io"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"jm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"jo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"kg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ki"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"kw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ky"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"kz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"la"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"lb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"lc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"li"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"lr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"lu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ma"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"mx"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"nc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"nf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ni"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"np"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"py"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"qa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"rw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"sy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"uy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"uz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"vc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"vi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ws"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"ye"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"net", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"new", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"news", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nf", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ngo", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ngo", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ngo", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ngo", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nh", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nhs", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nic", (Object)"im"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nic", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nic", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nic", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nieruchomosci", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"niigata", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nikolaev", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nj", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nkz", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nl", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nls", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nm", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nm", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nnov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"no", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"ad"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"ag"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"es"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"ni"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"re"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nom", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nome", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"norilsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"not", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"notaires", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"novosibirsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ns", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nsn", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nsw", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nt", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nt", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nt", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ntr", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nu", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nui", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nv", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"nx", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ny", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"o", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"od", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"odessa", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"odo", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"off", (Object)"ai"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"og", (Object)"ao"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"oh", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"oita", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ok", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"okayama", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"okinawa", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"olsztyn", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"omsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"on", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"opole", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"at"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"th"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"tz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"ug"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"or", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"orenburg", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ac"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ag"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ai"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"an"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ar"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"bz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"cd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ch"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ck"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"cu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"dm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"er"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"es"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"et"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"fk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"gu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"hk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"hn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"il"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"im"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"io"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"jm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"jo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"kg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ki"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"kw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ky"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"kz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"la"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"lb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"lc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"li"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"lr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ls"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"lu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"lv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ma"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"mx"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"my"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"nc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ni"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"np"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pe"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ph"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"py"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"qa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"rs"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sb"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"sy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"tw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"uy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"uz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"vc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"vi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"vu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ws"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"ye"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"yu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"zm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"org", (Object)"zw"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"oryol", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"osaka", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"oskol", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"otc", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"oz", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pa", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"palana", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"parliament", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"parliament", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"parti", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pb", (Object)"ao"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pc", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pe", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pe", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"penza", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"per", (Object)"kh"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"per", (Object)"sg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"perm", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"perso", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pharmacien", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pl", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pl", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"plc", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"plc", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"plc", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"plo", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pol", (Object)"dz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pol", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pol", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"police", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"poltava", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"port", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"powiat", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"poznan", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pp", (Object)"az"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pp", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pp", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ppg", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"prd", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"prd", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"press", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"press", (Object)"ma"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"press", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"presse", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pri", (Object)"ee"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"principe", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"priv", (Object)"at"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"priv", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"priv", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"priv", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"ec"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"mv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"pr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pro", (Object)"vn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"psc", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"psi", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pskov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ptz", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pub", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"publ", (Object)"pt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pvt", (Object)"ge"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"pyatigorsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"qc", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"qc", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"qh", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"qld", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"qsl", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"re", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"realestate", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rec", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rec", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rec", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rec", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"red", (Object)"sv"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"reklam", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rel", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rel", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"res", (Object)"in"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ri", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rnd", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rnrt", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rns", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rnu", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rovno", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rs", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ru", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ru", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rubtsovsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"rv", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ryazan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"s", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sa", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sa", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sa", (Object)"cr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"saga", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"saitama", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sakhalin", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"samara", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"saotome", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sapporo", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"saratov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sark", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sc", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sc", (Object)"ke"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sc", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sc", (Object)"ug"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sc", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"ae"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"gg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"ir"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"je"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"ly"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"ng"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"om"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"sa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"uk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sch", (Object)"zm"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"school", (Object)"fj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"school", (Object)"nz"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"school", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sci", (Object)"eg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sd", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sd", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"se", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"se", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sebastopol", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sec", (Object)"ps"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sendai", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"seoul", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sex", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sex", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sg", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sh", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"shiga", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"shimane", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"shizuoka", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"shop", (Object)"ht"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"shop", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"shop", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"simbirsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sk", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sklep", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sld", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sld", (Object)"pa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"slg", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"slupsk", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"smolensk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sn", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"snz", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"soc", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"soros", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sos", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"spb", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sport", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"srv", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sshn", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"stat", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"stavropol", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"store", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"store", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"store", (Object)"st"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"store", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"stv", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"suli", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sumy", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"surgut", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"sx", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"syzran", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"szczecin", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"szex", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"szkola", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"t", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"takamatsu", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tambov", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"targi", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tas", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tatarstan", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"te", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tec", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tel", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tel", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tel", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"telecom", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"telememo", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ternopil", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"test", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tirana", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tj", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tld", (Object)"am"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tlf", (Object)"nr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"cy"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"mc"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"mg"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tm", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tmp", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tn", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tochigi", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tokushima", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tokyo", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tom", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tomsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"torun", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tottori", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tourism", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tourism", (Object)"tn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"toyama", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tozsde", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"travel", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"travel", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"trd", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tsaritsyn", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tula", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tur", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"turystyka", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tuva", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tv", (Object)"bo"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tv", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tv", (Object)"sd"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tver", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tw", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tx", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"tyumen", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"u", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"udm", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"udmurtia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uk", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uk", (Object)"net"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uk", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ulan-ude", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ulsan", (Object)"kr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"unam", (Object)"na"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"unbi", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uniti", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"unsa", (Object)"ba"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"upt", (Object)"al"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uri", (Object)"arpa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"urn", (Object)"arpa"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"us", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"us", (Object)"tf"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"us", (Object)"tt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"ut", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"utazas", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"utsunomiya", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uu", (Object)"mt"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uy", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"uzhgorod", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"va", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vatican", (Object)"va"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vdonsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vet", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"veterinaire", (Object)"fr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vgs", (Object)"no"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vic", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"video", (Object)"hu"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vinnica", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vladikavkaz", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vladimir", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vladivostok", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vn", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"volgograd", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vologda", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"voronezh", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vrn", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vt", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"vyatka", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"w", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wa", (Object)"au"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wa", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wakayama", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"warszawa", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"waw", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"weather", (Object)"mobi"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"co"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"do"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"id"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"lk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"pk"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"tj"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"tr"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"ve"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"web", (Object)"za"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wi", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wroc", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wroclaw", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wv", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"www", (Object)"ro"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"wy", (Object)"us"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"x", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"xj", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"xz", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"y", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yakutia", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yamagata", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yamaguchi", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yamal", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yamanashi", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yaroslavl", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yekaterinburg", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yk", (Object)"ca"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yn", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yokohama", (Object)"jp"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"yuzhno-sakhalinsk", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"z", (Object)"se"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"za", (Object)"com"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"za", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zaporizhzhe", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zgora", (Object)"pl"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zgrad", (Object)"ru"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zhitomir", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zj", (Object)"cn"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zlg", (Object)"br"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zp", (Object)"ua"));
        TWO_PART_TLD_BUILDER.add((Object)Pair.of((Object)"zt", (Object)"ua"));
        TWO_PART_TLDS = TWO_PART_TLD_BUILDER.build();
    }
}

