/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.twitter.common.base.Command;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ExecutorServiceShutdown
implements Command {
    private static final Logger LOG = Logger.getLogger(ExecutorServiceShutdown.class.getName());
    private final ExecutorService executor;
    private final Amount<Long, Time> gracePeriod;

    public ExecutorServiceShutdown(ExecutorService executorService, Amount<Long, Time> amount) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.gracePeriod = (Amount)Preconditions.checkNotNull(amount);
    }

    public void execute() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination((Long)this.gracePeriod.as((Unit)Time.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination((Long)this.gracePeriod.as((Unit)Time.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                    LOG.warning("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

