/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.twitter.distributedlog.thrift.service;

import org.apache.commons.lang.builder.HashCodeBuilder;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.apache.thrift.*;
import org.apache.thrift.async.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.transport.*;
import org.apache.thrift.protocol.*;

import com.twitter.util.Future;
import com.twitter.util.Function;
import com.twitter.util.Function2;
import com.twitter.util.Try;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.finagle.thrift.ThriftClientRequest;

public class DistributedLogService {
  public interface Iface {
    public ServerInfo handshake() throws TException;
    public ServerInfo handshakeWithClientInfo(ClientInfo clientInfo) throws TException;
    public WriteResponse heartbeat(String stream, WriteContext ctx) throws TException;
    public WriteResponse heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options) throws TException;
    public WriteResponse write(String stream, ByteBuffer data) throws TException;
    public WriteResponse writeWithContext(String stream, ByteBuffer data, WriteContext ctx) throws TException;
    public BulkWriteResponse writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx) throws TException;
    public WriteResponse truncate(String stream, String dlsn, WriteContext ctx) throws TException;
    public WriteResponse release(String stream, WriteContext ctx) throws TException;
    public WriteResponse create(String stream, WriteContext ctx) throws TException;
    public WriteResponse delete(String stream, WriteContext ctx) throws TException;
    public void setAcceptNewStream(boolean enabled) throws TException;
  }

  public interface AsyncIface {
    public void handshake(AsyncMethodCallback<AsyncClient.handshake_call> resultHandler) throws TException;
    public void handshakeWithClientInfo(ClientInfo clientInfo, AsyncMethodCallback<AsyncClient.handshakeWithClientInfo_call> resultHandler) throws TException;
    public void heartbeat(String stream, WriteContext ctx, AsyncMethodCallback<AsyncClient.heartbeat_call> resultHandler) throws TException;
    public void heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options, AsyncMethodCallback<AsyncClient.heartbeatWithOptions_call> resultHandler) throws TException;
    public void write(String stream, ByteBuffer data, AsyncMethodCallback<AsyncClient.write_call> resultHandler) throws TException;
    public void writeWithContext(String stream, ByteBuffer data, WriteContext ctx, AsyncMethodCallback<AsyncClient.writeWithContext_call> resultHandler) throws TException;
    public void writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx, AsyncMethodCallback<AsyncClient.writeBulkWithContext_call> resultHandler) throws TException;
    public void truncate(String stream, String dlsn, WriteContext ctx, AsyncMethodCallback<AsyncClient.truncate_call> resultHandler) throws TException;
    public void release(String stream, WriteContext ctx, AsyncMethodCallback<AsyncClient.release_call> resultHandler) throws TException;
    public void create(String stream, WriteContext ctx, AsyncMethodCallback<AsyncClient.create_call> resultHandler) throws TException;
    public void delete(String stream, WriteContext ctx, AsyncMethodCallback<AsyncClient.delete_call> resultHandler) throws TException;
    public void setAcceptNewStream(boolean enabled, AsyncMethodCallback<AsyncClient.setAcceptNewStream_call> resultHandler) throws TException;
  }

  public interface ServiceIface {
    public Future<ServerInfo> handshake();
    public Future<ServerInfo> handshakeWithClientInfo(ClientInfo clientInfo);
    public Future<WriteResponse> heartbeat(String stream, WriteContext ctx);
    public Future<WriteResponse> heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options);
    public Future<WriteResponse> write(String stream, ByteBuffer data);
    public Future<WriteResponse> writeWithContext(String stream, ByteBuffer data, WriteContext ctx);
    public Future<BulkWriteResponse> writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx);
    public Future<WriteResponse> truncate(String stream, String dlsn, WriteContext ctx);
    public Future<WriteResponse> release(String stream, WriteContext ctx);
    public Future<WriteResponse> create(String stream, WriteContext ctx);
    public Future<WriteResponse> delete(String stream, WriteContext ctx);
    public Future<Void> setAcceptNewStream(boolean enabled);
  }

  public static class Client implements TServiceClient, Iface {
    public static class Factory implements TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(TProtocol iprot, TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(TProtocol prot)
    {
      this(prot, prot);
    }

    public Client(TProtocol iprot, TProtocol oprot)
    {
      iprot_ = iprot;
      oprot_ = oprot;
    }

    protected TProtocol iprot_;
    protected TProtocol oprot_;

    protected int seqid_;

    public TProtocol getInputProtocol()
    {
      return this.iprot_;
    }

    public TProtocol getOutputProtocol()
    {
      return this.oprot_;
    }

    public ServerInfo handshake() throws TException
    {
      send_handshake();
      return recv_handshake();
    }

    public void send_handshake() throws TException
    {
      oprot_.writeMessageBegin(new TMessage("handshake", TMessageType.CALL, ++seqid_));
      handshake_args args = new handshake_args();
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public ServerInfo recv_handshake() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "handshake failed: out of sequence response");
      }
      handshake_result result = new handshake_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "handshake failed: unknown result");
    }
    public ServerInfo handshakeWithClientInfo(ClientInfo clientInfo) throws TException
    {
      send_handshakeWithClientInfo(clientInfo);
      return recv_handshakeWithClientInfo();
    }

    public void send_handshakeWithClientInfo(ClientInfo clientInfo) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.CALL, ++seqid_));
      handshakeWithClientInfo_args args = new handshakeWithClientInfo_args();
      args.setClientInfo(clientInfo);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public ServerInfo recv_handshakeWithClientInfo() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "handshakeWithClientInfo failed: out of sequence response");
      }
      handshakeWithClientInfo_result result = new handshakeWithClientInfo_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "handshakeWithClientInfo failed: unknown result");
    }
    public WriteResponse heartbeat(String stream, WriteContext ctx) throws TException
    {
      send_heartbeat(stream, ctx);
      return recv_heartbeat();
    }

    public void send_heartbeat(String stream, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("heartbeat", TMessageType.CALL, ++seqid_));
      heartbeat_args args = new heartbeat_args();
      args.setStream(stream);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_heartbeat() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "heartbeat failed: out of sequence response");
      }
      heartbeat_result result = new heartbeat_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "heartbeat failed: unknown result");
    }
    public WriteResponse heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options) throws TException
    {
      send_heartbeatWithOptions(stream, ctx, options);
      return recv_heartbeatWithOptions();
    }

    public void send_heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.CALL, ++seqid_));
      heartbeatWithOptions_args args = new heartbeatWithOptions_args();
      args.setStream(stream);
      args.setCtx(ctx);
      args.setOptions(options);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_heartbeatWithOptions() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "heartbeatWithOptions failed: out of sequence response");
      }
      heartbeatWithOptions_result result = new heartbeatWithOptions_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "heartbeatWithOptions failed: unknown result");
    }
    public WriteResponse write(String stream, ByteBuffer data) throws TException
    {
      send_write(stream, data);
      return recv_write();
    }

    public void send_write(String stream, ByteBuffer data) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("write", TMessageType.CALL, ++seqid_));
      write_args args = new write_args();
      args.setStream(stream);
      args.setData(data);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_write() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "write failed: out of sequence response");
      }
      write_result result = new write_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "write failed: unknown result");
    }
    public WriteResponse writeWithContext(String stream, ByteBuffer data, WriteContext ctx) throws TException
    {
      send_writeWithContext(stream, data, ctx);
      return recv_writeWithContext();
    }

    public void send_writeWithContext(String stream, ByteBuffer data, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("writeWithContext", TMessageType.CALL, ++seqid_));
      writeWithContext_args args = new writeWithContext_args();
      args.setStream(stream);
      args.setData(data);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_writeWithContext() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "writeWithContext failed: out of sequence response");
      }
      writeWithContext_result result = new writeWithContext_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "writeWithContext failed: unknown result");
    }
    public BulkWriteResponse writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx) throws TException
    {
      send_writeBulkWithContext(stream, data, ctx);
      return recv_writeBulkWithContext();
    }

    public void send_writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.CALL, ++seqid_));
      writeBulkWithContext_args args = new writeBulkWithContext_args();
      args.setStream(stream);
      args.setData(data);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public BulkWriteResponse recv_writeBulkWithContext() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "writeBulkWithContext failed: out of sequence response");
      }
      writeBulkWithContext_result result = new writeBulkWithContext_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "writeBulkWithContext failed: unknown result");
    }
    public WriteResponse truncate(String stream, String dlsn, WriteContext ctx) throws TException
    {
      send_truncate(stream, dlsn, ctx);
      return recv_truncate();
    }

    public void send_truncate(String stream, String dlsn, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("truncate", TMessageType.CALL, ++seqid_));
      truncate_args args = new truncate_args();
      args.setStream(stream);
      args.setDlsn(dlsn);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_truncate() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "truncate failed: out of sequence response");
      }
      truncate_result result = new truncate_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "truncate failed: unknown result");
    }
    public WriteResponse release(String stream, WriteContext ctx) throws TException
    {
      send_release(stream, ctx);
      return recv_release();
    }

    public void send_release(String stream, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("release", TMessageType.CALL, ++seqid_));
      release_args args = new release_args();
      args.setStream(stream);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_release() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "release failed: out of sequence response");
      }
      release_result result = new release_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "release failed: unknown result");
    }
    public WriteResponse create(String stream, WriteContext ctx) throws TException
    {
      send_create(stream, ctx);
      return recv_create();
    }

    public void send_create(String stream, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("create", TMessageType.CALL, ++seqid_));
      create_args args = new create_args();
      args.setStream(stream);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_create() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "create failed: out of sequence response");
      }
      create_result result = new create_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "create failed: unknown result");
    }
    public WriteResponse delete(String stream, WriteContext ctx) throws TException
    {
      send_delete(stream, ctx);
      return recv_delete();
    }

    public void send_delete(String stream, WriteContext ctx) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("delete", TMessageType.CALL, ++seqid_));
      delete_args args = new delete_args();
      args.setStream(stream);
      args.setCtx(ctx);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public WriteResponse recv_delete() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "delete failed: out of sequence response");
      }
      delete_result result = new delete_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "delete failed: unknown result");
    }
    public void setAcceptNewStream(boolean enabled) throws TException
    {
      send_setAcceptNewStream(enabled);
      recv_setAcceptNewStream();
    }

    public void send_setAcceptNewStream(boolean enabled) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.CALL, ++seqid_));
      setAcceptNewStream_args args = new setAcceptNewStream_args();
      args.setEnabled(enabled);
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_setAcceptNewStream() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      if (msg.seqid != seqid_) {
        throw new TApplicationException(TApplicationException.BAD_SEQUENCE_ID, "setAcceptNewStream failed: out of sequence response");
      }
      setAcceptNewStream_result result = new setAcceptNewStream_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      return;
    }
  }

  public static class AsyncClient extends TAsyncClient implements AsyncIface {
    public static class Factory implements TAsyncClientFactory<AsyncClient> {
      private TAsyncClientManager clientManager;
      private TProtocolFactory protocolFactory;
      public Factory(TAsyncClientManager clientManager, TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void handshake(AsyncMethodCallback<handshake_call> resultHandler) throws TException {
      checkReady();
      handshake_call method_call = new handshake_call(resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class handshake_call extends TAsyncMethodCall {

      public handshake_call(AsyncMethodCallback<handshake_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("handshake", TMessageType.CALL, 0));
        handshake_args args = new handshake_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ServerInfo getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_handshake();
      }
     }
    public void handshakeWithClientInfo(ClientInfo clientInfo, AsyncMethodCallback<handshakeWithClientInfo_call> resultHandler) throws TException {
      checkReady();
      handshakeWithClientInfo_call method_call = new handshakeWithClientInfo_call(clientInfo, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class handshakeWithClientInfo_call extends TAsyncMethodCall {
      private ClientInfo clientInfo;

      public handshakeWithClientInfo_call(ClientInfo clientInfo, AsyncMethodCallback<handshakeWithClientInfo_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.clientInfo = clientInfo;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.CALL, 0));
        handshakeWithClientInfo_args args = new handshakeWithClientInfo_args();
        args.setClientInfo(clientInfo);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ServerInfo getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_handshakeWithClientInfo();
      }
     }
    public void heartbeat(String stream, WriteContext ctx, AsyncMethodCallback<heartbeat_call> resultHandler) throws TException {
      checkReady();
      heartbeat_call method_call = new heartbeat_call(stream, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class heartbeat_call extends TAsyncMethodCall {
      private String stream;
      private WriteContext ctx;

      public heartbeat_call(String stream, WriteContext ctx, AsyncMethodCallback<heartbeat_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("heartbeat", TMessageType.CALL, 0));
        heartbeat_args args = new heartbeat_args();
        args.setStream(stream);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_heartbeat();
      }
     }
    public void heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options, AsyncMethodCallback<heartbeatWithOptions_call> resultHandler) throws TException {
      checkReady();
      heartbeatWithOptions_call method_call = new heartbeatWithOptions_call(stream, ctx, options, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class heartbeatWithOptions_call extends TAsyncMethodCall {
      private String stream;
      private WriteContext ctx;
      private HeartbeatOptions options;

      public heartbeatWithOptions_call(String stream, WriteContext ctx, HeartbeatOptions options, AsyncMethodCallback<heartbeatWithOptions_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.ctx = ctx;
        this.options = options;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.CALL, 0));
        heartbeatWithOptions_args args = new heartbeatWithOptions_args();
        args.setStream(stream);
        args.setCtx(ctx);
        args.setOptions(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_heartbeatWithOptions();
      }
     }
    public void write(String stream, ByteBuffer data, AsyncMethodCallback<write_call> resultHandler) throws TException {
      checkReady();
      write_call method_call = new write_call(stream, data, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class write_call extends TAsyncMethodCall {
      private String stream;
      private ByteBuffer data;

      public write_call(String stream, ByteBuffer data, AsyncMethodCallback<write_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.data = data;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("write", TMessageType.CALL, 0));
        write_args args = new write_args();
        args.setStream(stream);
        args.setData(data);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_write();
      }
     }
    public void writeWithContext(String stream, ByteBuffer data, WriteContext ctx, AsyncMethodCallback<writeWithContext_call> resultHandler) throws TException {
      checkReady();
      writeWithContext_call method_call = new writeWithContext_call(stream, data, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class writeWithContext_call extends TAsyncMethodCall {
      private String stream;
      private ByteBuffer data;
      private WriteContext ctx;

      public writeWithContext_call(String stream, ByteBuffer data, WriteContext ctx, AsyncMethodCallback<writeWithContext_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.data = data;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("writeWithContext", TMessageType.CALL, 0));
        writeWithContext_args args = new writeWithContext_args();
        args.setStream(stream);
        args.setData(data);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_writeWithContext();
      }
     }
    public void writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx, AsyncMethodCallback<writeBulkWithContext_call> resultHandler) throws TException {
      checkReady();
      writeBulkWithContext_call method_call = new writeBulkWithContext_call(stream, data, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class writeBulkWithContext_call extends TAsyncMethodCall {
      private String stream;
      private List<ByteBuffer> data;
      private WriteContext ctx;

      public writeBulkWithContext_call(String stream, List<ByteBuffer> data, WriteContext ctx, AsyncMethodCallback<writeBulkWithContext_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.data = data;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.CALL, 0));
        writeBulkWithContext_args args = new writeBulkWithContext_args();
        args.setStream(stream);
        args.setData(data);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public BulkWriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_writeBulkWithContext();
      }
     }
    public void truncate(String stream, String dlsn, WriteContext ctx, AsyncMethodCallback<truncate_call> resultHandler) throws TException {
      checkReady();
      truncate_call method_call = new truncate_call(stream, dlsn, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class truncate_call extends TAsyncMethodCall {
      private String stream;
      private String dlsn;
      private WriteContext ctx;

      public truncate_call(String stream, String dlsn, WriteContext ctx, AsyncMethodCallback<truncate_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.dlsn = dlsn;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("truncate", TMessageType.CALL, 0));
        truncate_args args = new truncate_args();
        args.setStream(stream);
        args.setDlsn(dlsn);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_truncate();
      }
     }
    public void release(String stream, WriteContext ctx, AsyncMethodCallback<release_call> resultHandler) throws TException {
      checkReady();
      release_call method_call = new release_call(stream, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class release_call extends TAsyncMethodCall {
      private String stream;
      private WriteContext ctx;

      public release_call(String stream, WriteContext ctx, AsyncMethodCallback<release_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("release", TMessageType.CALL, 0));
        release_args args = new release_args();
        args.setStream(stream);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_release();
      }
     }
    public void create(String stream, WriteContext ctx, AsyncMethodCallback<create_call> resultHandler) throws TException {
      checkReady();
      create_call method_call = new create_call(stream, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class create_call extends TAsyncMethodCall {
      private String stream;
      private WriteContext ctx;

      public create_call(String stream, WriteContext ctx, AsyncMethodCallback<create_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("create", TMessageType.CALL, 0));
        create_args args = new create_args();
        args.setStream(stream);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_create();
      }
     }
    public void delete(String stream, WriteContext ctx, AsyncMethodCallback<delete_call> resultHandler) throws TException {
      checkReady();
      delete_call method_call = new delete_call(stream, ctx, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class delete_call extends TAsyncMethodCall {
      private String stream;
      private WriteContext ctx;

      public delete_call(String stream, WriteContext ctx, AsyncMethodCallback<delete_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.stream = stream;
        this.ctx = ctx;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("delete", TMessageType.CALL, 0));
        delete_args args = new delete_args();
        args.setStream(stream);
        args.setCtx(ctx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public WriteResponse getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_delete();
      }
     }
    public void setAcceptNewStream(boolean enabled, AsyncMethodCallback<setAcceptNewStream_call> resultHandler) throws TException {
      checkReady();
      setAcceptNewStream_call method_call = new setAcceptNewStream_call(enabled, resultHandler, this, protocolFactory, transport);
      manager.call(method_call);
    }

    public static class setAcceptNewStream_call extends TAsyncMethodCall {
      private boolean enabled;

      public setAcceptNewStream_call(boolean enabled, AsyncMethodCallback<setAcceptNewStream_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.enabled = enabled;
      }

      public void write_args(TProtocol prot) throws TException {
        prot.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.CALL, 0));
        setAcceptNewStream_args args = new setAcceptNewStream_args();
        args.setEnabled(enabled);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TException {
        if (getState() != State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        TMemoryInputTransport memoryTransport = new TMemoryInputTransport(getFrameBuffer().array());
        TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setAcceptNewStream();
      }
     }
   }


  public static class ServiceToClient implements ServiceIface {
    private com.twitter.finagle.Service<ThriftClientRequest, byte[]> service;
    private TProtocolFactory protocolFactory;
    public ServiceToClient(com.twitter.finagle.Service<ThriftClientRequest, byte[]> service, TProtocolFactory protocolFactory) {
      
      this.service = service;
      this.protocolFactory = protocolFactory;
    }

    public Future<ServerInfo> handshake() {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("handshake", TMessageType.CALL, 0));
        handshake_args __args__ = new handshake_args();
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<ServerInfo>>() {
          public Future<ServerInfo> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_handshake());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<ServerInfo> handshakeWithClientInfo(ClientInfo clientInfo) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.CALL, 0));
        handshakeWithClientInfo_args __args__ = new handshakeWithClientInfo_args();
        __args__.setClientInfo(clientInfo);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<ServerInfo>>() {
          public Future<ServerInfo> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_handshakeWithClientInfo());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> heartbeat(String stream, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("heartbeat", TMessageType.CALL, 0));
        heartbeat_args __args__ = new heartbeat_args();
        __args__.setStream(stream);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_heartbeat());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> heartbeatWithOptions(String stream, WriteContext ctx, HeartbeatOptions options) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.CALL, 0));
        heartbeatWithOptions_args __args__ = new heartbeatWithOptions_args();
        __args__.setStream(stream);
        __args__.setCtx(ctx);
        __args__.setOptions(options);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_heartbeatWithOptions());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> write(String stream, ByteBuffer data) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("write", TMessageType.CALL, 0));
        write_args __args__ = new write_args();
        __args__.setStream(stream);
        __args__.setData(data);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_write());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> writeWithContext(String stream, ByteBuffer data, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("writeWithContext", TMessageType.CALL, 0));
        writeWithContext_args __args__ = new writeWithContext_args();
        __args__.setStream(stream);
        __args__.setData(data);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_writeWithContext());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<BulkWriteResponse> writeBulkWithContext(String stream, List<ByteBuffer> data, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.CALL, 0));
        writeBulkWithContext_args __args__ = new writeBulkWithContext_args();
        __args__.setStream(stream);
        __args__.setData(data);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<BulkWriteResponse>>() {
          public Future<BulkWriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_writeBulkWithContext());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> truncate(String stream, String dlsn, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("truncate", TMessageType.CALL, 0));
        truncate_args __args__ = new truncate_args();
        __args__.setStream(stream);
        __args__.setDlsn(dlsn);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_truncate());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> release(String stream, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("release", TMessageType.CALL, 0));
        release_args __args__ = new release_args();
        __args__.setStream(stream);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_release());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> create(String stream, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("create", TMessageType.CALL, 0));
        create_args __args__ = new create_args();
        __args__.setStream(stream);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_create());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<WriteResponse> delete(String stream, WriteContext ctx) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("delete", TMessageType.CALL, 0));
        delete_args __args__ = new delete_args();
        __args__.setStream(stream);
        __args__.setCtx(ctx);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<WriteResponse>>() {
          public Future<WriteResponse> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              return Future.value((new Client(__prot__)).recv_delete());
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
    public Future<Void> setAcceptNewStream(boolean enabled) {
      try {
        // TODO: size
        TMemoryBuffer __memoryTransport__ = new TMemoryBuffer(512);
        TProtocol __prot__ = this.protocolFactory.getProtocol(__memoryTransport__);
        __prot__.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.CALL, 0));
        setAcceptNewStream_args __args__ = new setAcceptNewStream_args();
        __args__.setEnabled(enabled);
        __args__.write(__prot__);
        __prot__.writeMessageEnd();


        byte[] __buffer__ = Arrays.copyOfRange(__memoryTransport__.getArray(), 0, __memoryTransport__.length());
        ThriftClientRequest __request__ = new ThriftClientRequest(__buffer__, false);
        Future<byte[]> __done__ = this.service.apply(__request__);
        return __done__.flatMap(new Function<byte[], Future<Void>>() {
          public Future<Void> apply(byte[] __buffer__) {
            TMemoryInputTransport __memoryTransport__ = new TMemoryInputTransport(__buffer__);
            TProtocol __prot__ = ServiceToClient.this.protocolFactory.getProtocol(__memoryTransport__);
            try {
              (new Client(__prot__)).recv_setAcceptNewStream();
              return Future.value(null);
            } catch (Exception e) {
              return Future.exception(e);
            }
          }
        });
      } catch (TException e) {
        return Future.exception(e);
      }
    }
  }

  public static class Processor implements TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(Iface iface)
    {
      iface_ = iface;
      processMap_.put("handshake", new handshake());
      processMap_.put("handshakeWithClientInfo", new handshakeWithClientInfo());
      processMap_.put("heartbeat", new heartbeat());
      processMap_.put("heartbeatWithOptions", new heartbeatWithOptions());
      processMap_.put("write", new write());
      processMap_.put("writeWithContext", new writeWithContext());
      processMap_.put("writeBulkWithContext", new writeBulkWithContext());
      processMap_.put("truncate", new truncate());
      processMap_.put("release", new release());
      processMap_.put("create", new create());
      processMap_.put("delete", new delete());
      processMap_.put("setAcceptNewStream", new setAcceptNewStream());
    }

    protected static interface ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException;
    }

    private Iface iface_;
    protected final HashMap<String,ProcessFunction> processMap_ = new HashMap<String,ProcessFunction>();

    public boolean process(TProtocol iprot, TProtocol oprot) throws TException
    {
      TMessage msg = iprot.readMessageBegin();
      ProcessFunction fn = processMap_.get(msg.name);
      if (fn == null) {
        TProtocolUtil.skip(iprot, TType.STRUCT);
        iprot.readMessageEnd();
        TApplicationException x = new TApplicationException(TApplicationException.UNKNOWN_METHOD, "Invalid method name: '"+msg.name+"'");
        oprot.writeMessageBegin(new TMessage(msg.name, TMessageType.EXCEPTION, msg.seqid));
        x.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
        return true;
      }
      fn.process(msg.seqid, iprot, oprot);
      return true;
    }

    private class handshake implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        handshake_args args = new handshake_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("handshake", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        handshake_result result = new handshake_result();
        result.success = iface_.handshake();
        
        oprot.writeMessageBegin(new TMessage("handshake", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class handshakeWithClientInfo implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        handshakeWithClientInfo_args args = new handshakeWithClientInfo_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        handshakeWithClientInfo_result result = new handshakeWithClientInfo_result();
        result.success = iface_.handshakeWithClientInfo(args.clientInfo);
        
        oprot.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class heartbeat implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        heartbeat_args args = new heartbeat_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("heartbeat", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        heartbeat_result result = new heartbeat_result();
        result.success = iface_.heartbeat(args.stream, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("heartbeat", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class heartbeatWithOptions implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        heartbeatWithOptions_args args = new heartbeatWithOptions_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        heartbeatWithOptions_result result = new heartbeatWithOptions_result();
        result.success = iface_.heartbeatWithOptions(args.stream, args.ctx, args.options);
        
        oprot.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class write implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        write_args args = new write_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("write", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        write_result result = new write_result();
        result.success = iface_.write(args.stream, args.data);
        
        oprot.writeMessageBegin(new TMessage("write", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class writeWithContext implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        writeWithContext_args args = new writeWithContext_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("writeWithContext", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        writeWithContext_result result = new writeWithContext_result();
        result.success = iface_.writeWithContext(args.stream, args.data, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("writeWithContext", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class writeBulkWithContext implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        writeBulkWithContext_args args = new writeBulkWithContext_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        writeBulkWithContext_result result = new writeBulkWithContext_result();
        result.success = iface_.writeBulkWithContext(args.stream, args.data, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class truncate implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        truncate_args args = new truncate_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("truncate", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        truncate_result result = new truncate_result();
        result.success = iface_.truncate(args.stream, args.dlsn, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("truncate", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class release implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        release_args args = new release_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("release", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        release_result result = new release_result();
        result.success = iface_.release(args.stream, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("release", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class create implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        create_args args = new create_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("create", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        create_result result = new create_result();
        result.success = iface_.create(args.stream, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("create", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class delete implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        delete_args args = new delete_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("delete", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        delete_result result = new delete_result();
        result.success = iface_.delete(args.stream, args.ctx);
        
        oprot.writeMessageBegin(new TMessage("delete", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
    private class setAcceptNewStream implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        setAcceptNewStream_args args = new setAcceptNewStream_args();
        try {
          args.read(iprot);
        } catch (TProtocolException e) {
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
          oprot.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.EXCEPTION, seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return;
        }
        iprot.readMessageEnd();
        setAcceptNewStream_result result = new setAcceptNewStream_result();
        iface_.setAcceptNewStream(args.enabled);
        
        oprot.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }
    }
  }

  public static class Service extends com.twitter.finagle.Service<byte[], byte[]> {
    private final ServiceIface iface;
    private final TProtocolFactory protocolFactory;
    protected HashMap<String, Function2<TProtocol, Integer, Future<byte[]>>> functionMap = new HashMap<String, Function2<TProtocol, Integer, Future<byte[]>>>();
    public Service(final ServiceIface iface, final TProtocolFactory protocolFactory) {
      this.iface = iface;
      this.protocolFactory = protocolFactory;
      functionMap.put("handshake", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          handshake_args args = new handshake_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("handshake", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<ServerInfo> future;
          try {
            future = iface.handshake();
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<ServerInfo, Future<byte[]>>() {
              public Future<byte[]> apply(ServerInfo value) {
                handshake_result result = new handshake_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("handshake", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("handshakeWithClientInfo", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          handshakeWithClientInfo_args args = new handshakeWithClientInfo_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<ServerInfo> future;
          try {
            future = iface.handshakeWithClientInfo(args.clientInfo);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<ServerInfo, Future<byte[]>>() {
              public Future<byte[]> apply(ServerInfo value) {
                handshakeWithClientInfo_result result = new handshakeWithClientInfo_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("handshakeWithClientInfo", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("heartbeat", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          heartbeat_args args = new heartbeat_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("heartbeat", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.heartbeat(args.stream, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                heartbeat_result result = new heartbeat_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("heartbeat", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("heartbeatWithOptions", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          heartbeatWithOptions_args args = new heartbeatWithOptions_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.heartbeatWithOptions(args.stream, args.ctx, args.options);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                heartbeatWithOptions_result result = new heartbeatWithOptions_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("heartbeatWithOptions", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("write", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          write_args args = new write_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("write", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.write(args.stream, args.data);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                write_result result = new write_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("write", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("writeWithContext", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          writeWithContext_args args = new writeWithContext_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("writeWithContext", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.writeWithContext(args.stream, args.data, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                writeWithContext_result result = new writeWithContext_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("writeWithContext", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("writeBulkWithContext", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          writeBulkWithContext_args args = new writeBulkWithContext_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<BulkWriteResponse> future;
          try {
            future = iface.writeBulkWithContext(args.stream, args.data, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<BulkWriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(BulkWriteResponse value) {
                writeBulkWithContext_result result = new writeBulkWithContext_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("writeBulkWithContext", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("truncate", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          truncate_args args = new truncate_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("truncate", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.truncate(args.stream, args.dlsn, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                truncate_result result = new truncate_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("truncate", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("release", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          release_args args = new release_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("release", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.release(args.stream, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                release_result result = new release_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("release", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("create", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          create_args args = new create_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("create", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.create(args.stream, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                create_result result = new create_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("create", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("delete", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          delete_args args = new delete_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("delete", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<WriteResponse> future;
          try {
            future = iface.delete(args.stream, args.ctx);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<WriteResponse, Future<byte[]>>() {
              public Future<byte[]> apply(WriteResponse value) {
                delete_result result = new delete_result();
                result.success = value;
                result.setSuccessIsSet(true);

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("delete", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
      functionMap.put("setAcceptNewStream", new Function2<TProtocol, Integer, Future<byte[]>>() {
        public Future<byte[]> apply(final TProtocol iprot, final Integer seqid) {
          setAcceptNewStream_args args = new setAcceptNewStream_args();
          try {
            args.read(iprot);
          } catch (TProtocolException e) {
            try {
              iprot.readMessageEnd();
              TApplicationException x = new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage());
              TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
              TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

              oprot.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.EXCEPTION, seqid));
              x.write(oprot);
              oprot.writeMessageEnd();
              oprot.getTransport().flush();
              byte[] buffer = Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length());
              return Future.value(buffer);
            } catch (Exception e1) {
              return Future.exception(e1);
            }
          } catch (Exception e) {
            return Future.exception(e);
          }

          try {
            iprot.readMessageEnd();
          } catch (Exception e) {
            return Future.exception(e);
          }
          Future<Void> future;
          try {
            future = iface.setAcceptNewStream(args.enabled);
          } catch (Exception e) {
            future = Future.exception(e);
          }

          try {
            return future.flatMap(new Function<Void, Future<byte[]>>() {
              public Future<byte[]> apply(Void value) {
                setAcceptNewStream_result result = new setAcceptNewStream_result();

                try {
                  TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
                  TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);

                  oprot.writeMessageBegin(new TMessage("setAcceptNewStream", TMessageType.REPLY, seqid));
                  result.write(oprot);
                  oprot.writeMessageEnd();

                  return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
                } catch (Exception e) {
                  return Future.exception(e);
                }
              }
            }).rescue(new Function<Throwable, Future<byte[]>>() {
              public Future<byte[]> apply(Throwable t) {
                return Future.exception(t);
              }
            });
          } catch (Exception e) {
            return Future.exception(e);
          }
        }
      });
    }

    public Future<byte[]> apply(byte[] request) {
      TTransport inputTransport = new TMemoryInputTransport(request);
      TProtocol iprot = protocolFactory.getProtocol(inputTransport);

      TMessage msg;
      try {
        msg = iprot.readMessageBegin();
      } catch (Exception e) {
        return Future.exception(e);
      }

      Function2<TProtocol, Integer, Future<byte[]>> fn = functionMap.get(msg.name);
      if (fn == null) {
        try {
          TProtocolUtil.skip(iprot, TType.STRUCT);
          iprot.readMessageEnd();
          TApplicationException x = new TApplicationException(TApplicationException.UNKNOWN_METHOD, "Invalid method name: '"+msg.name+"'");
          TMemoryBuffer memoryBuffer = new TMemoryBuffer(512);
          TProtocol oprot = protocolFactory.getProtocol(memoryBuffer);
          oprot.writeMessageBegin(new TMessage(msg.name, TMessageType.EXCEPTION, msg.seqid));
          x.write(oprot);
          oprot.writeMessageEnd();
          oprot.getTransport().flush();
          return Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()));
        } catch (Exception e) {
          return Future.exception(e);
        }
      }

      return fn.apply(iprot, msg.seqid);
    }
  }

  public static class handshake_args implements TBase<handshake_args, handshake_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("handshake_args");

  



  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    ;
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }



  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(handshake_args.class, metaDataMap);
  }


  public handshake_args() {
  }


  /**
   * Performs a deep copy on <i>other</i>.
   */
  public handshake_args(handshake_args other) {
  }

  public handshake_args deepCopy() {
    return new handshake_args(this);
  }

  @Override
  public void clear() {
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof handshake_args)
      return this.equals((handshake_args)that);
    return false;
  }

  public boolean equals(handshake_args that) {
    if (that == null)
      return false;

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    return builder.toHashCode();
  }

  public int compareTo(handshake_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    handshake_args typedOther = (handshake_args)other;

    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("handshake_args(");
    boolean first = true;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class handshake_result implements TBase<handshake_result, handshake_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("handshake_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public ServerInfo success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, ServerInfo.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(handshake_result.class, metaDataMap);
  }


  public handshake_result() {
  }

  public handshake_result(
    ServerInfo success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public handshake_result(handshake_result other) {
    if (other.isSetSuccess()) {
      this.success = new ServerInfo(other.success);
    }
  }

  public handshake_result deepCopy() {
    return new handshake_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public ServerInfo getSuccess() {
    return this.success;
  }

  public handshake_result setSuccess(ServerInfo success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((ServerInfo)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof handshake_result)
      return this.equals((handshake_result)that);
    return false;
  }

  public boolean equals(handshake_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(handshake_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    handshake_result typedOther = (handshake_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new ServerInfo();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("handshake_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class handshakeWithClientInfo_args implements TBase<handshakeWithClientInfo_args, handshakeWithClientInfo_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("handshakeWithClientInfo_args");

  private static final TField CLIENT_INFO_FIELD_DESC = new TField("clientInfo", TType.STRUCT, (short)-1);


  public ClientInfo clientInfo;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    CLIENT_INFO((short)-1, "clientInfo");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // CLIENT_INFO
  	return CLIENT_INFO;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.CLIENT_INFO, new FieldMetaData("clientInfo", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, ClientInfo.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(handshakeWithClientInfo_args.class, metaDataMap);
  }


  public handshakeWithClientInfo_args() {
  }

  public handshakeWithClientInfo_args(
    ClientInfo clientInfo)
  {
    this();
    this.clientInfo = clientInfo;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public handshakeWithClientInfo_args(handshakeWithClientInfo_args other) {
    if (other.isSetClientInfo()) {
      this.clientInfo = new ClientInfo(other.clientInfo);
    }
  }

  public handshakeWithClientInfo_args deepCopy() {
    return new handshakeWithClientInfo_args(this);
  }

  @Override
  public void clear() {
    this.clientInfo = null;
  }

  public ClientInfo getClientInfo() {
    return this.clientInfo;
  }

  public handshakeWithClientInfo_args setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    
    return this;
  }

  public void unsetClientInfo() {
    this.clientInfo = null;
  }

  /** Returns true if field clientInfo is set (has been asigned a value) and false otherwise */
  public boolean isSetClientInfo() {
    return this.clientInfo != null;
  }

  public void setClientInfoIsSet(boolean value) {
    if (!value) {
      this.clientInfo = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case CLIENT_INFO:
      if (value == null) {
        unsetClientInfo();
      } else {
        setClientInfo((ClientInfo)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case CLIENT_INFO:
      return getClientInfo();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case CLIENT_INFO:
      return isSetClientInfo();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof handshakeWithClientInfo_args)
      return this.equals((handshakeWithClientInfo_args)that);
    return false;
  }

  public boolean equals(handshakeWithClientInfo_args that) {
    if (that == null)
      return false;
    boolean this_present_clientInfo = true && this.isSetClientInfo();
    boolean that_present_clientInfo = true && that.isSetClientInfo();
    if (this_present_clientInfo || that_present_clientInfo) {
      if (!(this_present_clientInfo && that_present_clientInfo))
        return false;
      if (!this.clientInfo.equals(that.clientInfo))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_clientInfo = true && (isSetClientInfo());
    builder.append(present_clientInfo);
    if (present_clientInfo)
      builder.append(clientInfo);
    return builder.toHashCode();
  }

  public int compareTo(handshakeWithClientInfo_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    handshakeWithClientInfo_args typedOther = (handshakeWithClientInfo_args)other;

    lastComparison = Boolean.valueOf(isSetClientInfo()).compareTo(typedOther.isSetClientInfo());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetClientInfo()) {
      lastComparison = TBaseHelper.compareTo(this.clientInfo, typedOther.clientInfo);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // CLIENT_INFO
          if (field.type == TType.STRUCT) {
            this.clientInfo = new ClientInfo();
            this.clientInfo.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.clientInfo != null) {
      oprot.writeFieldBegin(CLIENT_INFO_FIELD_DESC);
      this.clientInfo.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("handshakeWithClientInfo_args(");
    boolean first = true;
    sb.append("clientInfo:");
    if (this.clientInfo == null) {
      sb.append("null");
    } else {
      sb.append(this.clientInfo);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class handshakeWithClientInfo_result implements TBase<handshakeWithClientInfo_result, handshakeWithClientInfo_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("handshakeWithClientInfo_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public ServerInfo success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, ServerInfo.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(handshakeWithClientInfo_result.class, metaDataMap);
  }


  public handshakeWithClientInfo_result() {
  }

  public handshakeWithClientInfo_result(
    ServerInfo success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public handshakeWithClientInfo_result(handshakeWithClientInfo_result other) {
    if (other.isSetSuccess()) {
      this.success = new ServerInfo(other.success);
    }
  }

  public handshakeWithClientInfo_result deepCopy() {
    return new handshakeWithClientInfo_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public ServerInfo getSuccess() {
    return this.success;
  }

  public handshakeWithClientInfo_result setSuccess(ServerInfo success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((ServerInfo)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof handshakeWithClientInfo_result)
      return this.equals((handshakeWithClientInfo_result)that);
    return false;
  }

  public boolean equals(handshakeWithClientInfo_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(handshakeWithClientInfo_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    handshakeWithClientInfo_result typedOther = (handshakeWithClientInfo_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new ServerInfo();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("handshakeWithClientInfo_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class heartbeat_args implements TBase<heartbeat_args, heartbeat_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("heartbeat_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-2);


  public String stream;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    CTX((short)-2, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(heartbeat_args.class, metaDataMap);
  }


  public heartbeat_args() {
  }

  public heartbeat_args(
    String stream,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public heartbeat_args(heartbeat_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public heartbeat_args deepCopy() {
    return new heartbeat_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public heartbeat_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public heartbeat_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof heartbeat_args)
      return this.equals((heartbeat_args)that);
    return false;
  }

  public boolean equals(heartbeat_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(heartbeat_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    heartbeat_args typedOther = (heartbeat_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("heartbeat_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class heartbeat_result implements TBase<heartbeat_result, heartbeat_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("heartbeat_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(heartbeat_result.class, metaDataMap);
  }


  public heartbeat_result() {
  }

  public heartbeat_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public heartbeat_result(heartbeat_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public heartbeat_result deepCopy() {
    return new heartbeat_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public heartbeat_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof heartbeat_result)
      return this.equals((heartbeat_result)that);
    return false;
  }

  public boolean equals(heartbeat_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(heartbeat_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    heartbeat_result typedOther = (heartbeat_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("heartbeat_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class heartbeatWithOptions_args implements TBase<heartbeatWithOptions_args, heartbeatWithOptions_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("heartbeatWithOptions_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-2);
  private static final TField OPTIONS_FIELD_DESC = new TField("options", TType.STRUCT, (short)-3);


  public String stream;
  public WriteContext ctx;
  public HeartbeatOptions options;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    CTX((short)-2, "ctx"),
    OPTIONS((short)-3, "options");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // CTX
  	return CTX;
        case -3: // OPTIONS
  	return OPTIONS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    tmpMap.put(_Fields.OPTIONS, new FieldMetaData("options", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, HeartbeatOptions.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(heartbeatWithOptions_args.class, metaDataMap);
  }


  public heartbeatWithOptions_args() {
  }

  public heartbeatWithOptions_args(
    String stream,
    WriteContext ctx,
    HeartbeatOptions options)
  {
    this();
    this.stream = stream;
    this.ctx = ctx;
    this.options = options;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public heartbeatWithOptions_args(heartbeatWithOptions_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
    if (other.isSetOptions()) {
      this.options = new HeartbeatOptions(other.options);
    }
  }

  public heartbeatWithOptions_args deepCopy() {
    return new heartbeatWithOptions_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.ctx = null;
    this.options = null;
  }

  public String getStream() {
    return this.stream;
  }

  public heartbeatWithOptions_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public heartbeatWithOptions_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public HeartbeatOptions getOptions() {
    return this.options;
  }

  public heartbeatWithOptions_args setOptions(HeartbeatOptions options) {
    this.options = options;
    
    return this;
  }

  public void unsetOptions() {
    this.options = null;
  }

  /** Returns true if field options is set (has been asigned a value) and false otherwise */
  public boolean isSetOptions() {
    return this.options != null;
  }

  public void setOptionsIsSet(boolean value) {
    if (!value) {
      this.options = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    case OPTIONS:
      if (value == null) {
        unsetOptions();
      } else {
        setOptions((HeartbeatOptions)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case CTX:
      return getCtx();
    case OPTIONS:
      return getOptions();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case CTX:
      return isSetCtx();
    case OPTIONS:
      return isSetOptions();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof heartbeatWithOptions_args)
      return this.equals((heartbeatWithOptions_args)that);
    return false;
  }

  public boolean equals(heartbeatWithOptions_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }
    boolean this_present_options = true && this.isSetOptions();
    boolean that_present_options = true && that.isSetOptions();
    if (this_present_options || that_present_options) {
      if (!(this_present_options && that_present_options))
        return false;
      if (!this.options.equals(that.options))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    boolean present_options = true && (isSetOptions());
    builder.append(present_options);
    if (present_options)
      builder.append(options);
    return builder.toHashCode();
  }

  public int compareTo(heartbeatWithOptions_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    heartbeatWithOptions_args typedOther = (heartbeatWithOptions_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetOptions()).compareTo(typedOther.isSetOptions());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetOptions()) {
      lastComparison = TBaseHelper.compareTo(this.options, typedOther.options);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -3: // OPTIONS
          if (field.type == TType.STRUCT) {
            this.options = new HeartbeatOptions();
            this.options.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.options != null) {
      oprot.writeFieldBegin(OPTIONS_FIELD_DESC);
      this.options.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("heartbeatWithOptions_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("options:");
    if (this.options == null) {
      sb.append("null");
    } else {
      sb.append(this.options);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class heartbeatWithOptions_result implements TBase<heartbeatWithOptions_result, heartbeatWithOptions_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("heartbeatWithOptions_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(heartbeatWithOptions_result.class, metaDataMap);
  }


  public heartbeatWithOptions_result() {
  }

  public heartbeatWithOptions_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public heartbeatWithOptions_result(heartbeatWithOptions_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public heartbeatWithOptions_result deepCopy() {
    return new heartbeatWithOptions_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public heartbeatWithOptions_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof heartbeatWithOptions_result)
      return this.equals((heartbeatWithOptions_result)that);
    return false;
  }

  public boolean equals(heartbeatWithOptions_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(heartbeatWithOptions_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    heartbeatWithOptions_result typedOther = (heartbeatWithOptions_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("heartbeatWithOptions_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class write_args implements TBase<write_args, write_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("write_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField DATA_FIELD_DESC = new TField("data", TType.STRING, (short)-2);


  public String stream;
  public ByteBuffer data;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    DATA((short)-2, "data");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // DATA
  	return DATA;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.DATA, new FieldMetaData("data", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(write_args.class, metaDataMap);
  }


  public write_args() {
  }

  public write_args(
    String stream,
    ByteBuffer data)
  {
    this();
    this.stream = stream;
    this.data = data;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public write_args(write_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetData()) {
      this.data = TBaseHelper.copyBinary(other.data);
    }
  }

  public write_args deepCopy() {
    return new write_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.data = null;
  }

  public String getStream() {
    return this.stream;
  }

  public write_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public byte[] getData() {
    setData(TBaseHelper.rightSize(data));
    return data.array();
  }

  public ByteBuffer BufferForData() {
    return data;
  }

  public write_args setData(byte[] data) {
    setData(ByteBuffer.wrap(data));
    return this;
  }

  public write_args setData(ByteBuffer data) {
    this.data = data;
    
    return this;
  }

  public void unsetData() {
    this.data = null;
  }

  /** Returns true if field data is set (has been asigned a value) and false otherwise */
  public boolean isSetData() {
    return this.data != null;
  }

  public void setDataIsSet(boolean value) {
    if (!value) {
      this.data = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case DATA:
      if (value == null) {
        unsetData();
      } else {
        setData((ByteBuffer)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case DATA:
      return getData();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case DATA:
      return isSetData();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof write_args)
      return this.equals((write_args)that);
    return false;
  }

  public boolean equals(write_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_data = true && this.isSetData();
    boolean that_present_data = true && that.isSetData();
    if (this_present_data || that_present_data) {
      if (!(this_present_data && that_present_data))
        return false;
      if (!this.data.equals(that.data))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_data = true && (isSetData());
    builder.append(present_data);
    if (present_data)
      builder.append(data);
    return builder.toHashCode();
  }

  public int compareTo(write_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    write_args typedOther = (write_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetData()).compareTo(typedOther.isSetData());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetData()) {
      lastComparison = TBaseHelper.compareTo(this.data, typedOther.data);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // DATA
          if (field.type == TType.STRING) {
            this.data = iprot.readBinary();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.data != null) {
      oprot.writeFieldBegin(DATA_FIELD_DESC);
      oprot.writeBinary(this.data);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("write_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("data:");
    if (this.data == null) {
      sb.append("null");
    } else {
      TBaseHelper.toString(this.data, sb);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class write_result implements TBase<write_result, write_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("write_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(write_result.class, metaDataMap);
  }


  public write_result() {
  }

  public write_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public write_result(write_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public write_result deepCopy() {
    return new write_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public write_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof write_result)
      return this.equals((write_result)that);
    return false;
  }

  public boolean equals(write_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(write_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    write_result typedOther = (write_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("write_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class writeWithContext_args implements TBase<writeWithContext_args, writeWithContext_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("writeWithContext_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField DATA_FIELD_DESC = new TField("data", TType.STRING, (short)-2);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-3);


  public String stream;
  public ByteBuffer data;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    DATA((short)-2, "data"),
    CTX((short)-3, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // DATA
  	return DATA;
        case -3: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.DATA, new FieldMetaData("data", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(writeWithContext_args.class, metaDataMap);
  }


  public writeWithContext_args() {
  }

  public writeWithContext_args(
    String stream,
    ByteBuffer data,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.data = data;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public writeWithContext_args(writeWithContext_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetData()) {
      this.data = TBaseHelper.copyBinary(other.data);
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public writeWithContext_args deepCopy() {
    return new writeWithContext_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.data = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public writeWithContext_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public byte[] getData() {
    setData(TBaseHelper.rightSize(data));
    return data.array();
  }

  public ByteBuffer BufferForData() {
    return data;
  }

  public writeWithContext_args setData(byte[] data) {
    setData(ByteBuffer.wrap(data));
    return this;
  }

  public writeWithContext_args setData(ByteBuffer data) {
    this.data = data;
    
    return this;
  }

  public void unsetData() {
    this.data = null;
  }

  /** Returns true if field data is set (has been asigned a value) and false otherwise */
  public boolean isSetData() {
    return this.data != null;
  }

  public void setDataIsSet(boolean value) {
    if (!value) {
      this.data = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public writeWithContext_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case DATA:
      if (value == null) {
        unsetData();
      } else {
        setData((ByteBuffer)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case DATA:
      return getData();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case DATA:
      return isSetData();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof writeWithContext_args)
      return this.equals((writeWithContext_args)that);
    return false;
  }

  public boolean equals(writeWithContext_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_data = true && this.isSetData();
    boolean that_present_data = true && that.isSetData();
    if (this_present_data || that_present_data) {
      if (!(this_present_data && that_present_data))
        return false;
      if (!this.data.equals(that.data))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_data = true && (isSetData());
    builder.append(present_data);
    if (present_data)
      builder.append(data);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(writeWithContext_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    writeWithContext_args typedOther = (writeWithContext_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetData()).compareTo(typedOther.isSetData());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetData()) {
      lastComparison = TBaseHelper.compareTo(this.data, typedOther.data);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // DATA
          if (field.type == TType.STRING) {
            this.data = iprot.readBinary();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -3: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.data != null) {
      oprot.writeFieldBegin(DATA_FIELD_DESC);
      oprot.writeBinary(this.data);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("writeWithContext_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("data:");
    if (this.data == null) {
      sb.append("null");
    } else {
      TBaseHelper.toString(this.data, sb);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class writeWithContext_result implements TBase<writeWithContext_result, writeWithContext_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("writeWithContext_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(writeWithContext_result.class, metaDataMap);
  }


  public writeWithContext_result() {
  }

  public writeWithContext_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public writeWithContext_result(writeWithContext_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public writeWithContext_result deepCopy() {
    return new writeWithContext_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public writeWithContext_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof writeWithContext_result)
      return this.equals((writeWithContext_result)that);
    return false;
  }

  public boolean equals(writeWithContext_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(writeWithContext_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    writeWithContext_result typedOther = (writeWithContext_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("writeWithContext_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class writeBulkWithContext_args implements TBase<writeBulkWithContext_args, writeBulkWithContext_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("writeBulkWithContext_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField DATA_FIELD_DESC = new TField("data", TType.LIST, (short)-2);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-3);


  public String stream;
  public List<ByteBuffer> data;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    DATA((short)-2, "data"),
    CTX((short)-3, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // DATA
  	return DATA;
        case -3: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.DATA, new FieldMetaData("data", TFieldRequirementType.DEFAULT,
      new ListMetaData(TType.LIST,
                new FieldValueMetaData(TType.STRING))));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(writeBulkWithContext_args.class, metaDataMap);
  }


  public writeBulkWithContext_args() {
  }

  public writeBulkWithContext_args(
    String stream,
    List<ByteBuffer> data,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.data = data;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public writeBulkWithContext_args(writeBulkWithContext_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetData()) {
      List<ByteBuffer> __this__data = new ArrayList<ByteBuffer>();
      for (ByteBuffer other_element : other.data) {
        ByteBuffer temp_binary_element = TBaseHelper.copyBinary(other_element);
        ;
        __this__data.add(temp_binary_element);
      }
      this.data = __this__data;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public writeBulkWithContext_args deepCopy() {
    return new writeBulkWithContext_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.data = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public writeBulkWithContext_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public int getDataSize() {
    return (this.data == null) ? 0 : this.data.size();
  }

  public java.util.Iterator<ByteBuffer> getDataIterator() {
    return (this.data == null) ? null : this.data.iterator();
  }

  public void addToData(ByteBuffer elem) {
    if (this.data == null) {
      this.data = new ArrayList<ByteBuffer>();
    }
    this.data.add(elem);
  }

  public List<ByteBuffer> getData() {
    return this.data;
  }

  public writeBulkWithContext_args setData(List<ByteBuffer> data) {
    this.data = data;
    
    return this;
  }

  public void unsetData() {
    this.data = null;
  }

  /** Returns true if field data is set (has been asigned a value) and false otherwise */
  public boolean isSetData() {
    return this.data != null;
  }

  public void setDataIsSet(boolean value) {
    if (!value) {
      this.data = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public writeBulkWithContext_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case DATA:
      if (value == null) {
        unsetData();
      } else {
        setData((List<ByteBuffer>)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case DATA:
      return getData();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case DATA:
      return isSetData();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof writeBulkWithContext_args)
      return this.equals((writeBulkWithContext_args)that);
    return false;
  }

  public boolean equals(writeBulkWithContext_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_data = true && this.isSetData();
    boolean that_present_data = true && that.isSetData();
    if (this_present_data || that_present_data) {
      if (!(this_present_data && that_present_data))
        return false;
      if (!this.data.equals(that.data))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_data = true && (isSetData());
    builder.append(present_data);
    if (present_data)
      builder.append(data);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(writeBulkWithContext_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    writeBulkWithContext_args typedOther = (writeBulkWithContext_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetData()).compareTo(typedOther.isSetData());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetData()) {
      lastComparison = TBaseHelper.compareTo(this.data, typedOther.data);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // DATA
          if (field.type == TType.LIST) {
            {
            TList _list13 = iprot.readListBegin();
            this.data = new ArrayList<ByteBuffer>(_list13.size);
            for (int _i14 = 0; _i14 < _list13.size; ++_i14)
            {
              ByteBuffer _elem15;
              _elem15 = iprot.readBinary();
              this.data.add(_elem15);
            }
            iprot.readListEnd();
            }
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -3: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.data != null) {
      oprot.writeFieldBegin(DATA_FIELD_DESC);
      {
        oprot.writeListBegin(new TList(TType.STRING, this.data.size()));
        for (ByteBuffer _iter16 : this.data)
        {
          oprot.writeBinary(_iter16);
        }
        oprot.writeListEnd();
      }
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("writeBulkWithContext_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("data:");
    if (this.data == null) {
      sb.append("null");
    } else {
      sb.append(this.data);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class writeBulkWithContext_result implements TBase<writeBulkWithContext_result, writeBulkWithContext_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("writeBulkWithContext_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public BulkWriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, BulkWriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(writeBulkWithContext_result.class, metaDataMap);
  }


  public writeBulkWithContext_result() {
  }

  public writeBulkWithContext_result(
    BulkWriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public writeBulkWithContext_result(writeBulkWithContext_result other) {
    if (other.isSetSuccess()) {
      this.success = new BulkWriteResponse(other.success);
    }
  }

  public writeBulkWithContext_result deepCopy() {
    return new writeBulkWithContext_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public BulkWriteResponse getSuccess() {
    return this.success;
  }

  public writeBulkWithContext_result setSuccess(BulkWriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((BulkWriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof writeBulkWithContext_result)
      return this.equals((writeBulkWithContext_result)that);
    return false;
  }

  public boolean equals(writeBulkWithContext_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(writeBulkWithContext_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    writeBulkWithContext_result typedOther = (writeBulkWithContext_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new BulkWriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("writeBulkWithContext_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class truncate_args implements TBase<truncate_args, truncate_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("truncate_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField DLSN_FIELD_DESC = new TField("dlsn", TType.STRING, (short)-2);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-3);


  public String stream;
  public String dlsn;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    DLSN((short)-2, "dlsn"),
    CTX((short)-3, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // DLSN
  	return DLSN;
        case -3: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.DLSN, new FieldMetaData("dlsn", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(truncate_args.class, metaDataMap);
  }


  public truncate_args() {
  }

  public truncate_args(
    String stream,
    String dlsn,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.dlsn = dlsn;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public truncate_args(truncate_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetDlsn()) {
      this.dlsn = other.dlsn;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public truncate_args deepCopy() {
    return new truncate_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.dlsn = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public truncate_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public String getDlsn() {
    return this.dlsn;
  }

  public truncate_args setDlsn(String dlsn) {
    this.dlsn = dlsn;
    
    return this;
  }

  public void unsetDlsn() {
    this.dlsn = null;
  }

  /** Returns true if field dlsn is set (has been asigned a value) and false otherwise */
  public boolean isSetDlsn() {
    return this.dlsn != null;
  }

  public void setDlsnIsSet(boolean value) {
    if (!value) {
      this.dlsn = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public truncate_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case DLSN:
      if (value == null) {
        unsetDlsn();
      } else {
        setDlsn((String)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case DLSN:
      return getDlsn();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case DLSN:
      return isSetDlsn();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof truncate_args)
      return this.equals((truncate_args)that);
    return false;
  }

  public boolean equals(truncate_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_dlsn = true && this.isSetDlsn();
    boolean that_present_dlsn = true && that.isSetDlsn();
    if (this_present_dlsn || that_present_dlsn) {
      if (!(this_present_dlsn && that_present_dlsn))
        return false;
      if (!this.dlsn.equals(that.dlsn))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_dlsn = true && (isSetDlsn());
    builder.append(present_dlsn);
    if (present_dlsn)
      builder.append(dlsn);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(truncate_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    truncate_args typedOther = (truncate_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetDlsn()).compareTo(typedOther.isSetDlsn());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetDlsn()) {
      lastComparison = TBaseHelper.compareTo(this.dlsn, typedOther.dlsn);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // DLSN
          if (field.type == TType.STRING) {
            this.dlsn = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -3: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.dlsn != null) {
      oprot.writeFieldBegin(DLSN_FIELD_DESC);
      oprot.writeString(this.dlsn);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("truncate_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("dlsn:");
    if (this.dlsn == null) {
      sb.append("null");
    } else {
      sb.append(this.dlsn);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class truncate_result implements TBase<truncate_result, truncate_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("truncate_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(truncate_result.class, metaDataMap);
  }


  public truncate_result() {
  }

  public truncate_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public truncate_result(truncate_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public truncate_result deepCopy() {
    return new truncate_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public truncate_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof truncate_result)
      return this.equals((truncate_result)that);
    return false;
  }

  public boolean equals(truncate_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(truncate_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    truncate_result typedOther = (truncate_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("truncate_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class release_args implements TBase<release_args, release_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("release_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-2);


  public String stream;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    CTX((short)-2, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(release_args.class, metaDataMap);
  }


  public release_args() {
  }

  public release_args(
    String stream,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public release_args(release_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public release_args deepCopy() {
    return new release_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public release_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public release_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof release_args)
      return this.equals((release_args)that);
    return false;
  }

  public boolean equals(release_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(release_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    release_args typedOther = (release_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("release_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class release_result implements TBase<release_result, release_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("release_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(release_result.class, metaDataMap);
  }


  public release_result() {
  }

  public release_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public release_result(release_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public release_result deepCopy() {
    return new release_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public release_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof release_result)
      return this.equals((release_result)that);
    return false;
  }

  public boolean equals(release_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(release_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    release_result typedOther = (release_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("release_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class create_args implements TBase<create_args, create_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("create_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-2);


  public String stream;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    CTX((short)-2, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(create_args.class, metaDataMap);
  }


  public create_args() {
  }

  public create_args(
    String stream,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public create_args(create_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public create_args deepCopy() {
    return new create_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public create_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public create_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof create_args)
      return this.equals((create_args)that);
    return false;
  }

  public boolean equals(create_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(create_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    create_args typedOther = (create_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("create_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class create_result implements TBase<create_result, create_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("create_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(create_result.class, metaDataMap);
  }


  public create_result() {
  }

  public create_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public create_result(create_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public create_result deepCopy() {
    return new create_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public create_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof create_result)
      return this.equals((create_result)that);
    return false;
  }

  public boolean equals(create_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(create_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    create_result typedOther = (create_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("create_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class delete_args implements TBase<delete_args, delete_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("delete_args");

  private static final TField STREAM_FIELD_DESC = new TField("stream", TType.STRING, (short)-1);
  private static final TField CTX_FIELD_DESC = new TField("ctx", TType.STRUCT, (short)-2);


  public String stream;
  public WriteContext ctx;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    STREAM((short)-1, "stream"),
    CTX((short)-2, "ctx");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // STREAM
  	return STREAM;
        case -2: // CTX
  	return CTX;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.STREAM, new FieldMetaData("stream", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.STRING)));
    tmpMap.put(_Fields.CTX, new FieldMetaData("ctx", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteContext.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(delete_args.class, metaDataMap);
  }


  public delete_args() {
  }

  public delete_args(
    String stream,
    WriteContext ctx)
  {
    this();
    this.stream = stream;
    this.ctx = ctx;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public delete_args(delete_args other) {
    if (other.isSetStream()) {
      this.stream = other.stream;
    }
    if (other.isSetCtx()) {
      this.ctx = new WriteContext(other.ctx);
    }
  }

  public delete_args deepCopy() {
    return new delete_args(this);
  }

  @Override
  public void clear() {
    this.stream = null;
    this.ctx = null;
  }

  public String getStream() {
    return this.stream;
  }

  public delete_args setStream(String stream) {
    this.stream = stream;
    
    return this;
  }

  public void unsetStream() {
    this.stream = null;
  }

  /** Returns true if field stream is set (has been asigned a value) and false otherwise */
  public boolean isSetStream() {
    return this.stream != null;
  }

  public void setStreamIsSet(boolean value) {
    if (!value) {
      this.stream = null;
    }
  }

  public WriteContext getCtx() {
    return this.ctx;
  }

  public delete_args setCtx(WriteContext ctx) {
    this.ctx = ctx;
    
    return this;
  }

  public void unsetCtx() {
    this.ctx = null;
  }

  /** Returns true if field ctx is set (has been asigned a value) and false otherwise */
  public boolean isSetCtx() {
    return this.ctx != null;
  }

  public void setCtxIsSet(boolean value) {
    if (!value) {
      this.ctx = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case STREAM:
      if (value == null) {
        unsetStream();
      } else {
        setStream((String)value);
      }
      break;
    case CTX:
      if (value == null) {
        unsetCtx();
      } else {
        setCtx((WriteContext)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case STREAM:
      return getStream();
    case CTX:
      return getCtx();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case STREAM:
      return isSetStream();
    case CTX:
      return isSetCtx();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof delete_args)
      return this.equals((delete_args)that);
    return false;
  }

  public boolean equals(delete_args that) {
    if (that == null)
      return false;
    boolean this_present_stream = true && this.isSetStream();
    boolean that_present_stream = true && that.isSetStream();
    if (this_present_stream || that_present_stream) {
      if (!(this_present_stream && that_present_stream))
        return false;
      if (!this.stream.equals(that.stream))
        return false;
    }
    boolean this_present_ctx = true && this.isSetCtx();
    boolean that_present_ctx = true && that.isSetCtx();
    if (this_present_ctx || that_present_ctx) {
      if (!(this_present_ctx && that_present_ctx))
        return false;
      if (!this.ctx.equals(that.ctx))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_stream = true && (isSetStream());
    builder.append(present_stream);
    if (present_stream)
      builder.append(stream);
    boolean present_ctx = true && (isSetCtx());
    builder.append(present_ctx);
    if (present_ctx)
      builder.append(ctx);
    return builder.toHashCode();
  }

  public int compareTo(delete_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    delete_args typedOther = (delete_args)other;

    lastComparison = Boolean.valueOf(isSetStream()).compareTo(typedOther.isSetStream());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStream()) {
      lastComparison = TBaseHelper.compareTo(this.stream, typedOther.stream);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCtx()).compareTo(typedOther.isSetCtx());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCtx()) {
      lastComparison = TBaseHelper.compareTo(this.ctx, typedOther.ctx);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // STREAM
          if (field.type == TType.STRING) {
            this.stream = iprot.readString();
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        case -2: // CTX
          if (field.type == TType.STRUCT) {
            this.ctx = new WriteContext();
            this.ctx.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.ctx != null) {
      oprot.writeFieldBegin(CTX_FIELD_DESC);
      this.ctx.write(oprot);
      oprot.writeFieldEnd();
    }
    if (this.stream != null) {
      oprot.writeFieldBegin(STREAM_FIELD_DESC);
      oprot.writeString(this.stream);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("delete_args(");
    boolean first = true;
    sb.append("stream:");
    if (this.stream == null) {
      sb.append("null");
    } else {
      sb.append(this.stream);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("ctx:");
    if (this.ctx == null) {
      sb.append("null");
    } else {
      sb.append(this.ctx);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class delete_result implements TBase<delete_result, delete_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("delete_result");

  private static final TField SUCCESS_FIELD_DESC = new TField("success", TType.STRUCT, (short)0);


  public WriteResponse success;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    SUCCESS((short)0, "success");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 0: // SUCCESS
  	return SUCCESS;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", TFieldRequirementType.DEFAULT,
      new StructMetaData(TType.STRUCT, WriteResponse.class)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(delete_result.class, metaDataMap);
  }


  public delete_result() {
  }

  public delete_result(
    WriteResponse success)
  {
    this();
    this.success = success;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public delete_result(delete_result other) {
    if (other.isSetSuccess()) {
      this.success = new WriteResponse(other.success);
    }
  }

  public delete_result deepCopy() {
    return new delete_result(this);
  }

  @Override
  public void clear() {
    this.success = null;
  }

  public WriteResponse getSuccess() {
    return this.success;
  }

  public delete_result setSuccess(WriteResponse success) {
    this.success = success;
    
    return this;
  }

  public void unsetSuccess() {
    this.success = null;
  }

  /** Returns true if field success is set (has been asigned a value) and false otherwise */
  public boolean isSetSuccess() {
    return this.success != null;
  }

  public void setSuccessIsSet(boolean value) {
    if (!value) {
      this.success = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case SUCCESS:
      if (value == null) {
        unsetSuccess();
      } else {
        setSuccess((WriteResponse)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case SUCCESS:
      return getSuccess();
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case SUCCESS:
      return isSetSuccess();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof delete_result)
      return this.equals((delete_result)that);
    return false;
  }

  public boolean equals(delete_result that) {
    if (that == null)
      return false;
    boolean this_present_success = true && this.isSetSuccess();
    boolean that_present_success = true && that.isSetSuccess();
    if (this_present_success || that_present_success) {
      if (!(this_present_success && that_present_success))
        return false;
      if (!this.success.equals(that.success))
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_success = true && (isSetSuccess());
    builder.append(present_success);
    if (present_success)
      builder.append(success);
    return builder.toHashCode();
  }

  public int compareTo(delete_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    delete_result typedOther = (delete_result)other;

    lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetSuccess()) {
      lastComparison = TBaseHelper.compareTo(this.success, typedOther.success);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case 0: // SUCCESS
          if (field.type == TType.STRUCT) {
            this.success = new WriteResponse();
            this.success.read(iprot);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    if (this.isSetSuccess()) {
      oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
      this.success.write(oprot);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("delete_result(");
    boolean first = true;
    sb.append("success:");
    if (this.success == null) {
      sb.append("null");
    } else {
      sb.append(this.success);
    }
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


  public static class setAcceptNewStream_args implements TBase<setAcceptNewStream_args, setAcceptNewStream_args._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("setAcceptNewStream_args");

  private static final TField ENABLED_FIELD_DESC = new TField("enabled", TType.BOOL, (short)-1);


  public boolean enabled;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    ENABLED((short)-1, "enabled");
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case -1: // ENABLED
  	return ENABLED;
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }


  // isset id assignments
  private static final int __ENABLED_ISSET_ID = 0;
  private BitSet __isset_bit_vector = new BitSet(1);

  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.ENABLED, new FieldMetaData("enabled", TFieldRequirementType.DEFAULT,
      new FieldValueMetaData(TType.BOOL)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(setAcceptNewStream_args.class, metaDataMap);
  }


  public setAcceptNewStream_args() {
  }

  public setAcceptNewStream_args(
    boolean enabled)
  {
    this();
    this.enabled = enabled;
    setEnabledIsSet(true);
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public setAcceptNewStream_args(setAcceptNewStream_args other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    this.enabled = other.enabled;
  }

  public setAcceptNewStream_args deepCopy() {
    return new setAcceptNewStream_args(this);
  }

  @Override
  public void clear() {
    setEnabledIsSet(false);
    this.enabled = false;
  }

  public boolean isEnabled() {
    return this.enabled;
  }

  public setAcceptNewStream_args setEnabled(boolean enabled) {
    this.enabled = enabled;
    setEnabledIsSet(true);

    return this;
  }

  public void unsetEnabled() {
  __isset_bit_vector.clear(__ENABLED_ISSET_ID);
  }

  /** Returns true if field enabled is set (has been asigned a value) and false otherwise */
  public boolean isSetEnabled() {
    return __isset_bit_vector.get(__ENABLED_ISSET_ID);
  }

  public void setEnabledIsSet(boolean value) {
    __isset_bit_vector.set(__ENABLED_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case ENABLED:
      if (value == null) {
        unsetEnabled();
      } else {
        setEnabled((Boolean)value);
      }
      break;
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case ENABLED:
      return new Boolean(isEnabled());
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case ENABLED:
      return isSetEnabled();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof setAcceptNewStream_args)
      return this.equals((setAcceptNewStream_args)that);
    return false;
  }

  public boolean equals(setAcceptNewStream_args that) {
    if (that == null)
      return false;
    boolean this_present_enabled = true;
    boolean that_present_enabled = true;
    if (this_present_enabled || that_present_enabled) {
      if (!(this_present_enabled && that_present_enabled))
        return false;
      if (this.enabled != that.enabled)
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    boolean present_enabled = true;
    builder.append(present_enabled);
    if (present_enabled)
      builder.append(enabled);
    return builder.toHashCode();
  }

  public int compareTo(setAcceptNewStream_args other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    setAcceptNewStream_args typedOther = (setAcceptNewStream_args)other;

    lastComparison = Boolean.valueOf(isSetEnabled()).compareTo(typedOther.isSetEnabled());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetEnabled()) {
      lastComparison = TBaseHelper.compareTo(this.enabled, typedOther.enabled);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        case -1: // ENABLED
          if (field.type == TType.BOOL) {
            this.enabled = iprot.readBool();
            setEnabledIsSet(true);
          } else {
            TProtocolUtil.skip(iprot, field.type);
          }
          break;
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();
    
    oprot.writeStructBegin(STRUCT_DESC);
    oprot.writeFieldBegin(ENABLED_FIELD_DESC);
    oprot.writeBool(this.enabled);
    oprot.writeFieldEnd();
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("setAcceptNewStream_args(");
    boolean first = true;
    sb.append("enabled:");
    sb.append(this.enabled);
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}

  public static class setAcceptNewStream_result implements TBase<setAcceptNewStream_result, setAcceptNewStream_result._Fields>, java.io.Serializable, Cloneable {
  private static final TStruct STRUCT_DESC = new TStruct("setAcceptNewStream_result");

  



  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    ;
  
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();
  
    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        default:
  	return null;
      }
    }
  
    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }
  
    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }
  
    private final short _thriftId;
    private final String _fieldName;
  
    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }
  
    public short getThriftFieldId() {
      return _thriftId;
    }
  
    public String getFieldName() {
      return _fieldName;
    }
  }



  public static final Map<_Fields, FieldMetaData> metaDataMap;
  static {
    Map<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    FieldMetaData.addStructMetaDataMap(setAcceptNewStream_result.class, metaDataMap);
  }


  public setAcceptNewStream_result() {
  }


  /**
   * Performs a deep copy on <i>other</i>.
   */
  public setAcceptNewStream_result(setAcceptNewStream_result other) {
  }

  public setAcceptNewStream_result deepCopy() {
    return new setAcceptNewStream_result(this);
  }

  @Override
  public void clear() {
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof setAcceptNewStream_result)
      return this.equals((setAcceptNewStream_result)that);
    return false;
  }

  public boolean equals(setAcceptNewStream_result that) {
    if (that == null)
      return false;

    return true;
  }

  @Override
  public int hashCode() {
    HashCodeBuilder builder = new HashCodeBuilder();
    return builder.toHashCode();
  }

  public int compareTo(setAcceptNewStream_result other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    setAcceptNewStream_result typedOther = (setAcceptNewStream_result)other;

    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }


  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) {
        break;
      }
      switch (field.id) {
        default:
          TProtocolUtil.skip(iprot, field.type);
      }
      iprot.readFieldEnd();
    }
    iprot.readStructEnd();

    // check for required fields of primitive type, which can't be checked in the validate method
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    oprot.writeStructBegin(STRUCT_DESC);
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("setAcceptNewStream_result(");
    boolean first = true;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }
}


}