/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog;

import com.twitter.distributedlog.DLSN;
import com.twitter.distributedlog.LogRecordSet;
import com.twitter.distributedlog.LogRecordWithDLSN;
import com.twitter.distributedlog.io.CompressionCodec;
import com.twitter.distributedlog.io.CompressionUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class EnvelopedRecordSetReader
implements LogRecordSet.Reader {
    private final long logSegmentSeqNo;
    private final long entryId;
    private final long transactionId;
    private final long startSequenceId;
    private int numRecords;
    private final ByteBuffer reader;
    private long slotId;
    private int position;

    EnvelopedRecordSetReader(long logSegmentSeqNo, long entryId, long transactionId, long startSlotId, int startPositionWithinLogSegment, long startSequenceId, InputStream in) throws IOException {
        this.logSegmentSeqNo = logSegmentSeqNo;
        this.entryId = entryId;
        this.transactionId = transactionId;
        this.slotId = startSlotId;
        this.position = startPositionWithinLogSegment;
        this.startSequenceId = startSequenceId;
        DataInputStream src = new DataInputStream(in);
        int metadata = src.readInt();
        int version = metadata & 0xF000;
        if (version != 4096) {
            throw new IOException(String.format("Version mismatch while reading. Received: %d, Required: %d", version, 4096));
        }
        int codecCode = metadata & 3;
        this.numRecords = src.readInt();
        int originDataLen = src.readInt();
        int actualDataLen = src.readInt();
        byte[] compressedData = new byte[actualDataLen];
        src.readFully(compressedData);
        if (1 == codecCode) {
            CompressionCodec codec = CompressionUtils.getCompressionCodec(CompressionCodec.Type.LZ4);
            byte[] decompressedData = codec.decompress(compressedData, 0, actualDataLen, originDataLen, LogRecordSet.NullOpStatsLogger);
            this.reader = ByteBuffer.wrap(decompressedData);
        } else {
            if (originDataLen != actualDataLen) {
                throw new IOException("Inconsistent data length found for a non-compressed record set : original = " + originDataLen + ", actual = " + actualDataLen);
            }
            this.reader = ByteBuffer.wrap(compressedData);
        }
    }

    @Override
    public LogRecordWithDLSN nextRecord() throws IOException {
        if (this.numRecords <= 0) {
            return null;
        }
        int recordLen = this.reader.getInt();
        byte[] recordData = new byte[recordLen];
        this.reader.get(recordData);
        DLSN dlsn = new DLSN(this.logSegmentSeqNo, this.entryId, this.slotId);
        LogRecordWithDLSN record = new LogRecordWithDLSN(dlsn, this.startSequenceId);
        record.setPositionWithinLogSegment(this.position);
        record.setTransactionId(this.transactionId);
        record.setPayload(recordData);
        ++this.slotId;
        ++this.position;
        --this.numRecords;
        return record;
    }
}

