/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog;

import com.twitter.distributedlog.DLSN;
import com.twitter.distributedlog.LogRecordSet;
import com.twitter.distributedlog.exceptions.LogRecordTooLongException;
import com.twitter.distributedlog.exceptions.WriteException;
import com.twitter.distributedlog.io.Buffer;
import com.twitter.distributedlog.io.CompressionCodec;
import com.twitter.distributedlog.io.CompressionUtils;
import com.twitter.util.Promise;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvelopedRecordSetWriter
implements LogRecordSet.Writer {
    static final Logger logger = LoggerFactory.getLogger(EnvelopedRecordSetWriter.class);
    private final Buffer buffer;
    private final DataOutputStream writer;
    private final WritableByteChannel writeChannel;
    private final List<Promise<DLSN>> promiseList;
    private final CompressionCodec.Type codec;
    private final int codecCode;
    private int count = 0;
    private ByteBuffer recordSetBuffer = null;

    EnvelopedRecordSetWriter(int initialBufferSize, CompressionCodec.Type codec) {
        this.buffer = new Buffer(Math.max(initialBufferSize, 16));
        this.promiseList = new LinkedList<Promise<DLSN>>();
        this.codec = codec;
        switch (codec) {
            case LZ4: {
                this.codecCode = 1;
                break;
            }
            default: {
                this.codecCode = 0;
            }
        }
        this.writer = new DataOutputStream(this.buffer);
        try {
            this.writer.writeInt(0x1000 | this.codecCode & 3);
            this.writer.writeInt(0);
            this.writer.writeInt(0);
            this.writer.writeInt(0);
        }
        catch (IOException e) {
            logger.warn("Failed to serialize the header to an enveloped record set", (Throwable)e);
        }
        this.writeChannel = Channels.newChannel(this.writer);
    }

    synchronized List<Promise<DLSN>> getPromiseList() {
        return this.promiseList;
    }

    @Override
    public synchronized void writeRecord(ByteBuffer record, Promise<DLSN> transmitPromise) throws LogRecordTooLongException, WriteException {
        int logRecordSize = record.remaining();
        if (logRecordSize > 1040384) {
            throw new LogRecordTooLongException("Log Record of size " + logRecordSize + " written when only " + 1040384 + " is allowed");
        }
        try {
            this.writer.writeInt(record.remaining());
            this.writeChannel.write(record);
            ++this.count;
            this.promiseList.add(transmitPromise);
        }
        catch (IOException e) {
            logger.error("Failed to append record to record set", (Throwable)e);
            throw new WriteException("", "Failed to append record to record set");
        }
    }

    private synchronized void satisfyPromises(long lssn, long entryId, long startSlotId) {
        long nextSlotId = startSlotId;
        for (Promise<DLSN> promise : this.promiseList) {
            promise.setValue((Object)new DLSN(lssn, entryId, nextSlotId));
            ++nextSlotId;
        }
        this.promiseList.clear();
    }

    private synchronized void cancelPromises(Throwable reason) {
        for (Promise<DLSN> promise : this.promiseList) {
            promise.setException(reason);
        }
        this.promiseList.clear();
    }

    @Override
    public int getNumBytes() {
        return this.buffer.size();
    }

    @Override
    public synchronized int getNumRecords() {
        return this.count;
    }

    @Override
    public synchronized ByteBuffer getBuffer() {
        if (null == this.recordSetBuffer) {
            this.recordSetBuffer = this.createBuffer();
        }
        return this.recordSetBuffer.duplicate();
    }

    ByteBuffer createBuffer() {
        ByteBuffer recordSetBuffer;
        byte[] data = this.buffer.getData();
        int dataOffset = 16;
        int dataLen = this.buffer.size() - 16;
        if (1 != this.codecCode) {
            ByteBuffer recordSetBuffer2 = ByteBuffer.wrap(data, 0, this.buffer.size());
            recordSetBuffer2.putInt(4, this.count);
            recordSetBuffer2.putInt(8, dataLen);
            recordSetBuffer2.putInt(12, dataLen);
            return recordSetBuffer2;
        }
        CompressionCodec compressor = CompressionUtils.getCompressionCodec(this.codec);
        byte[] compressed = compressor.compress(data, dataOffset, dataLen, LogRecordSet.NullOpStatsLogger);
        if (compressed.length > dataLen) {
            byte[] newData = new byte[16 + compressed.length];
            System.arraycopy(data, 0, newData, 0, 16 + dataLen);
            recordSetBuffer = ByteBuffer.wrap(newData);
        } else {
            recordSetBuffer = ByteBuffer.wrap(data);
        }
        recordSetBuffer.position(4);
        recordSetBuffer.putInt(this.count);
        recordSetBuffer.putInt(dataLen);
        recordSetBuffer.putInt(compressed.length);
        recordSetBuffer.put(compressed);
        recordSetBuffer.flip();
        return recordSetBuffer;
    }

    @Override
    public void completeTransmit(long lssn, long entryId, long startSlotId) {
        this.satisfyPromises(lssn, entryId, startSlotId);
    }

    @Override
    public void abortTransmit(Throwable reason) {
        this.cancelPromises(reason);
    }
}

