/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog;

import com.google.common.base.Preconditions;
import com.twitter.distributedlog.DLSN;
import com.twitter.distributedlog.EnvelopedRecordSetReader;
import com.twitter.distributedlog.EnvelopedRecordSetWriter;
import com.twitter.distributedlog.LogRecord;
import com.twitter.distributedlog.LogRecordSetBuffer;
import com.twitter.distributedlog.LogRecordWithDLSN;
import com.twitter.distributedlog.exceptions.LogRecordTooLongException;
import com.twitter.distributedlog.exceptions.WriteException;
import com.twitter.distributedlog.io.CompressionCodec;
import com.twitter.util.Promise;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;

public class LogRecordSet {
    static final OpStatsLogger NullOpStatsLogger = NullStatsLogger.INSTANCE.getOpStatsLogger("");
    public static final int HEADER_LEN = 16;
    static final int VERSION = 4096;
    static final int METADATA_VERSION_MASK = 61440;
    static final int METADATA_COMPRESSION_MASK = 3;
    static final int COMPRESSION_CODEC_NONE = 0;
    static final int COMPRESSION_CODEC_LZ4 = 1;

    public static int numRecords(LogRecord record) throws IOException {
        Preconditions.checkArgument((boolean)record.isRecordSet(), (Object)"record is not a recordset");
        byte[] data = record.getPayload();
        return LogRecordSet.numRecords(data);
    }

    public static int numRecords(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int metadata = buffer.getInt();
        int version = metadata & 0xF000;
        if (version != 4096) {
            throw new IOException(String.format("Version mismatch while reading. Received: %d, Required: %d", version, 4096));
        }
        return buffer.getInt();
    }

    public static Writer newWriter(int initialBufferSize, CompressionCodec.Type codec) {
        return new EnvelopedRecordSetWriter(initialBufferSize, codec);
    }

    public static Reader of(LogRecordWithDLSN record) throws IOException {
        Preconditions.checkArgument((boolean)record.isRecordSet(), (Object)"record is not a recordset");
        byte[] data = record.getPayload();
        DLSN dlsn = record.getDlsn();
        int startPosition = record.getPositionWithinLogSegment();
        long startSequenceId = record.getStartSequenceIdOfCurrentSegment();
        return new EnvelopedRecordSetReader(dlsn.getLogSegmentSequenceNo(), dlsn.getEntryId(), record.getTransactionId(), dlsn.getSlotId(), startPosition, startSequenceId, new ByteArrayInputStream(data));
    }

    public static interface Reader {
        public LogRecordWithDLSN nextRecord() throws IOException;
    }

    public static interface Writer
    extends LogRecordSetBuffer {
        public void writeRecord(ByteBuffer var1, Promise<DLSN> var2) throws LogRecordTooLongException, WriteException;
    }
}

