/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog.exceptions;

import com.twitter.distributedlog.exceptions.OwnershipAcquireFailedException;
import com.twitter.distributedlog.thrift.service.ResponseHeader;
import com.twitter.distributedlog.thrift.service.StatusCode;
import java.io.IOException;

public class DLException
extends IOException {
    private static final long serialVersionUID = -4485775468586114393L;
    protected final StatusCode code;

    protected DLException(StatusCode code) {
        this.code = code;
    }

    protected DLException(StatusCode code, String msg) {
        super(msg);
        this.code = code;
    }

    protected DLException(StatusCode code, Throwable t) {
        super(t);
        this.code = code;
    }

    protected DLException(StatusCode code, String msg, Throwable t) {
        super(msg, t);
        this.code = code;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public static DLException of(ResponseHeader response) {
        switch (response.getCode()) {
            case FOUND: {
                String errMsg = response.isSetErrMsg() ? response.getErrMsg() : "Request is redirected to " + response.getLocation();
                return new OwnershipAcquireFailedException(errMsg, response.getLocation());
            }
            case SUCCESS: {
                throw new IllegalArgumentException("Can't instantiate an exception for success response.");
            }
        }
        String errMsg = response.isSetErrMsg() ? response.getErrMsg() : response.getCode().name();
        return new DLException(response.getCode(), errMsg);
    }
}

