/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog.io;

import com.twitter.distributedlog.io.CompressionCodec;
import com.twitter.distributedlog.io.IdentityCompressionCodec;
import com.twitter.distributedlog.io.LZ4CompressionCodec;

public class CompressionUtils {
    public static final String LZ4 = "lz4";
    public static final String NONE = "none";
    private static CompressionCodec identityCodec = new IdentityCompressionCodec();
    private static CompressionCodec lz4Codec = new LZ4CompressionCodec();

    public static CompressionCodec getCompressionCodec(CompressionCodec.Type type) {
        if (type == CompressionCodec.Type.LZ4) {
            return lz4Codec;
        }
        return identityCodec;
    }

    public static CompressionCodec.Type stringToType(String compressionString) {
        if (compressionString.equals(LZ4)) {
            return CompressionCodec.Type.LZ4;
        }
        if (compressionString.equals(NONE)) {
            return CompressionCodec.Type.NONE;
        }
        return CompressionCodec.Type.UNKNOWN;
    }
}

