/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.twitter.distributedlog.io.CompressionCodec;
import java.util.concurrent.TimeUnit;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.bookkeeper.stats.OpStatsLogger;

public class LZ4CompressionCodec
implements CompressionCodec {
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    private final LZ4FastDecompressor fastDecompressor = LZ4Factory.fastestInstance().fastDecompressor();
    private final LZ4SafeDecompressor safeDecompressor = LZ4Factory.fastestInstance().safeDecompressor();

    @Override
    public byte[] compress(byte[] data, int offset, int length, OpStatsLogger compressionStat) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((offset >= 0 && offset < data.length ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)compressionStat);
        Stopwatch watch = Stopwatch.createStarted();
        byte[] compressed = this.compressor.compress(data, offset, length);
        compressionStat.registerSuccessfulEvent(watch.elapsed(TimeUnit.MICROSECONDS));
        return compressed;
    }

    @Override
    public byte[] decompress(byte[] data, int offset, int length, OpStatsLogger decompressionStat) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((offset >= 0 && offset < data.length ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)decompressionStat);
        Stopwatch watch = Stopwatch.createStarted();
        int outLength = length * 3;
        while (true) {
            try {
                byte[] decompressed = this.safeDecompressor.decompress(data, offset, length, outLength);
                decompressionStat.registerSuccessfulEvent(watch.elapsed(TimeUnit.MICROSECONDS));
                return decompressed;
            }
            catch (LZ4Exception e) {
                outLength *= 2;
                continue;
            }
            break;
        }
    }

    @Override
    public byte[] decompress(byte[] data, int offset, int length, int decompressedSize, OpStatsLogger decompressionStat) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((offset >= 0 && offset < data.length ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((decompressedSize >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)decompressionStat);
        Stopwatch watch = Stopwatch.createStarted();
        byte[] decompressed = this.fastDecompressor.decompress(data, offset, decompressedSize);
        decompressionStat.registerSuccessfulEvent(watch.elapsed(TimeUnit.MICROSECONDS));
        return decompressed;
    }
}

