/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog.thrift.service;

import org.apache.thrift.TEnum;

public enum StatusCode implements TEnum
{
    SUCCESS(200),
    CLIENT_CLOSED(301),
    FOUND(302),
    REQUEST_DENIED(403),
    TOO_LARGE_RECORD(413),
    INTERNAL_SERVER_ERROR(500),
    NOT_IMPLEMENTED(501),
    ALREADY_CLOSED(502),
    SERVICE_UNAVAILABLE(503),
    LOCKING_EXCEPTION(504),
    ZOOKEEPER_ERROR(505),
    METADATA_EXCEPTION(506),
    BK_TRANSMIT_ERROR(507),
    FLUSH_TIMEOUT(508),
    LOG_EMPTY(509),
    LOG_NOT_FOUND(510),
    TRUNCATED_TRANSACTION(511),
    END_OF_STREAM(512),
    TRANSACTION_OUT_OF_ORDER(513),
    WRITE_EXCEPTION(514),
    STREAM_UNAVAILABLE(515),
    WRITE_CANCELLED_EXCEPTION(516),
    OVER_CAPACITY(517),
    STREAM_NOT_READY(518),
    REGION_UNAVAILABLE(519),
    INVALID_ENVELOPED_ENTRY(520),
    UNSUPPORTED_METADATA_VERSION(521),
    LOG_EXISTS(522),
    CHECKSUM_FAILED(523),
    TOO_MANY_STREAMS(524),
    UNEXPECTED(600),
    INTERRUPTED(601),
    INVALID_STREAM_NAME(602),
    ILLEGAL_STATE(603),
    RETRYABLE_READ(1000),
    LOG_READ_ERROR(1001),
    READ_CANCELLED_EXCEPTION(1002);

    private final int value;

    private StatusCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static StatusCode findByValue(int value) {
        switch (value) {
            case 200: {
                return SUCCESS;
            }
            case 301: {
                return CLIENT_CLOSED;
            }
            case 302: {
                return FOUND;
            }
            case 403: {
                return REQUEST_DENIED;
            }
            case 413: {
                return TOO_LARGE_RECORD;
            }
            case 500: {
                return INTERNAL_SERVER_ERROR;
            }
            case 501: {
                return NOT_IMPLEMENTED;
            }
            case 502: {
                return ALREADY_CLOSED;
            }
            case 503: {
                return SERVICE_UNAVAILABLE;
            }
            case 504: {
                return LOCKING_EXCEPTION;
            }
            case 505: {
                return ZOOKEEPER_ERROR;
            }
            case 506: {
                return METADATA_EXCEPTION;
            }
            case 507: {
                return BK_TRANSMIT_ERROR;
            }
            case 508: {
                return FLUSH_TIMEOUT;
            }
            case 509: {
                return LOG_EMPTY;
            }
            case 510: {
                return LOG_NOT_FOUND;
            }
            case 511: {
                return TRUNCATED_TRANSACTION;
            }
            case 512: {
                return END_OF_STREAM;
            }
            case 513: {
                return TRANSACTION_OUT_OF_ORDER;
            }
            case 514: {
                return WRITE_EXCEPTION;
            }
            case 515: {
                return STREAM_UNAVAILABLE;
            }
            case 516: {
                return WRITE_CANCELLED_EXCEPTION;
            }
            case 517: {
                return OVER_CAPACITY;
            }
            case 518: {
                return STREAM_NOT_READY;
            }
            case 519: {
                return REGION_UNAVAILABLE;
            }
            case 520: {
                return INVALID_ENVELOPED_ENTRY;
            }
            case 521: {
                return UNSUPPORTED_METADATA_VERSION;
            }
            case 522: {
                return LOG_EXISTS;
            }
            case 523: {
                return CHECKSUM_FAILED;
            }
            case 524: {
                return TOO_MANY_STREAMS;
            }
            case 600: {
                return UNEXPECTED;
            }
            case 601: {
                return INTERRUPTED;
            }
            case 602: {
                return INVALID_STREAM_NAME;
            }
            case 603: {
                return ILLEGAL_STATE;
            }
            case 1000: {
                return RETRYABLE_READ;
            }
            case 1001: {
                return LOG_READ_ERROR;
            }
            case 1002: {
                return READ_CANCELLED_EXCEPTION;
            }
        }
        return null;
    }
}

