/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.distributedlog.util;

import com.twitter.distributedlog.DLSN;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolUtils.class);
    private static final ThreadLocal<CRC32> requestCRC = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long writeOpCRC32(String stream, byte[] payload) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes());
            crc.update(payload);
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long truncateOpCRC32(String stream, DLSN dlsn) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes());
            crc.update(dlsn.serializeBytes());
            long result = crc.getValue();
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long streamOpCRC32(String stream) {
        CRC32 crc = requestCRC.get();
        try {
            crc.update(stream.getBytes());
            long result = crc.getValue();
            Long l = crc.getValue();
            return l;
        }
        finally {
            crc.reset();
        }
    }
}

