/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLoader
extends LzoBaseLoadFunc {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLoader.class);
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    public static final String NESTED_LOAD_KEY = "elephantbird.jsonloader.nestedLoad";
    private static final Options validOptions_ = new Options();
    private static final CommandLineParser parser_ = new GnuParser();
    private final CommandLine configuredOptions_;
    private final JSONParser jsonParser = new JSONParser();
    private String inputFormatClassName;
    private boolean isNestedLoadEnabled = false;

    private static void populateValidOptions() {
        validOptions_.addOption("nestedLoad", false, "Enables loading of nested JSON structures");
        validOptions_.addOption("inputFormat", true, "The input format class name used by this loader instance");
    }

    public JsonLoader() {
        this("");
    }

    public JsonLoader(String optString) {
        JsonLoader.populateValidOptions();
        String[] optsArr = optString.split(" ");
        try {
            this.configuredOptions_ = parser_.parse(validOptions_, optsArr);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[-nestedLoad] [-inputFormat]", validOptions_);
            throw new RuntimeException(e);
        }
        this.isNestedLoadEnabled = this.configuredOptions_.hasOption("nestedLoad");
        this.inputFormatClassName = this.configuredOptions_.getOptionValue("inputFormat") != null ? this.configuredOptions_.getOptionValue("inputFormat") : TextInputFormat.class.getName();
    }

    public void setInputFormatClassName(String inputFormatClassName) {
        this.inputFormatClassName = inputFormatClassName;
    }

    public Tuple getNext() throws IOException {
        if (this.reader == null) {
            return null;
        }
        if ("true".equals(this.jobConf.get(NESTED_LOAD_KEY))) {
            this.isNestedLoadEnabled = true;
        }
        try {
            while (this.reader.nextKeyValue()) {
                Text value = (Text)this.reader.getCurrentValue();
                this.incrCounter(JsonLoaderCounters.LinesRead, 1L);
                Tuple t = this.parseStringToTuple(value.toString());
                if (t == null) continue;
                this.incrCounter(JsonLoaderCounters.LinesJsonDecoded, 1L);
                return t;
            }
            return null;
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, (Throwable)e);
        }
    }

    public InputFormat getInputFormat() throws IOException {
        try {
            return (FileInputFormat)PigContext.resolveClassName((String)this.inputFormatClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("Failed creating input format " + this.inputFormatClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed creating input format " + this.inputFormatClassName, e);
        }
    }

    protected Tuple parseStringToTuple(String line) {
        try {
            JSONObject jsonObj = (JSONObject)this.jsonParser.parse(line);
            if (jsonObj != null) {
                return tupleFactory.newTuple(this.walkJson(jsonObj));
            }
            LOG.warn("Could not json-decode string: " + line);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
        catch (org.json.simple.parser.ParseException e) {
            LOG.warn("Could not json-decode string: " + line, (Throwable)e);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
        catch (NumberFormatException e) {
            LOG.warn("Very big number exceeds the scale of long: " + line, (Throwable)e);
            this.incrCounter(JsonLoaderCounters.LinesParseErrorBadNumber, 1L);
            return null;
        }
        catch (ClassCastException e) {
            LOG.warn("Could not convert to Json Object: " + line, (Throwable)e);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
    }

    private Object wrap(Object value) {
        if (this.isNestedLoadEnabled && value instanceof JSONObject) {
            return this.walkJson((JSONObject)value);
        }
        if (this.isNestedLoadEnabled && value instanceof JSONArray) {
            JSONArray a = (JSONArray)value;
            NonSpillableDataBag mapValue = new NonSpillableDataBag(a.size());
            for (int i = 0; i < a.size(); ++i) {
                Tuple t = tupleFactory.newTuple(this.wrap(a.get(i)));
                mapValue.add(t);
            }
            return mapValue;
        }
        return value != null ? value.toString() : null;
    }

    private Map<String, Object> walkJson(JSONObject jsonObj) {
        HashMap v = Maps.newHashMap();
        for (Object key : jsonObj.keySet()) {
            v.put(key.toString(), this.wrap(jsonObj.get(key)));
        }
        return v;
    }

    private static enum JsonLoaderCounters {
        LinesRead,
        LinesJsonDecoded,
        LinesParseError,
        LinesParseErrorBadNumber;

    }
}

