/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.input.LzoTextInputFormat;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoBaseRegexLoader
extends LzoBaseLoadFunc {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBaseRegexLoader.class);
    protected static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final byte RECORD_DELIMITER = 10;

    public LzoBaseRegexLoader() {
        LOG.info("LzoBaseRegexLoader created.");
    }

    public abstract Pattern getPattern();

    public Tuple getNext() throws IOException {
        if (this.reader == null) {
            return null;
        }
        Pattern pattern = this.getPattern();
        Matcher matcher = pattern.matcher("");
        Tuple t = null;
        try {
            Object lineObj;
            while (this.reader.nextKeyValue() && (lineObj = this.reader.getCurrentValue()) != null) {
                String line = lineObj.toString();
                if ((matcher = matcher.reset(line)).find()) {
                    this.incrCounter(LzoBaseRegexLoaderCounters.MatchedRegexLines, 1L);
                    t = tupleFactory_.newTuple(matcher.groupCount());
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        if (matcher.group(i) != null) {
                            t.set(i - 1, (Object)matcher.group(i));
                            continue;
                        }
                        t.set(i - 1, (Object)"");
                    }
                    break;
                }
                this.incrCounter(LzoBaseRegexLoaderCounters.UnmatchedRegexLines, 1L);
                LOG.debug("No match for line " + line);
            }
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, (Throwable)e);
        }
        return t;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public InputFormat getInputFormat() {
        return new LzoTextInputFormat();
    }

    protected static enum LzoBaseRegexLoaderCounters {
        MatchedRegexLines,
        UnmatchedRegexLines;

    }
}

