/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.pig.load.ThriftPigLoader;
import com.twitter.elephantbird.pig.util.AbstractLazyTuple;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftToPig<M extends TBase<?, ?>> {
    public static final Logger LOG = LoggerFactory.getLogger(ThriftToPig.class);
    static final String USE_ENUM_ID_CONF_KEY = "elephantbird.pig.thrift.load.enum.as.int";
    private static Boolean useEnumId = false;
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private TStructDescriptor structDesc;

    public static <M extends TBase<?, ?>> ThriftToPig<M> newInstance(Class<M> tClass) {
        return new ThriftToPig<M>(tClass);
    }

    public static <M extends TBase<?, ?>> ThriftToPig<M> newInstance(TypeRef<M> typeRef) {
        return new ThriftToPig<M>(typeRef.getRawClass());
    }

    public ThriftToPig(Class<M> tClass) {
        this.structDesc = TStructDescriptor.getInstance(tClass);
    }

    public TStructDescriptor getTStructDescriptor() {
        return this.structDesc;
    }

    public Tuple getPigTuple(M thriftObj) {
        return ThriftToPig.toTuple(this.structDesc, thriftObj);
    }

    public Tuple getLazyTuple(M thriftObj) {
        return new LazyTuple(this.structDesc, (TBase<?, ?>)thriftObj);
    }

    public static void setConversionProperties(Configuration conf) {
        if (conf != null) {
            useEnumId = conf.getBoolean(USE_ENUM_ID_CONF_KEY, false);
            LOG.debug("useEnumId is set to " + useEnumId);
        }
    }

    private static <T extends TBase> Tuple toTuple(TStructDescriptor tDesc, T tObj) {
        int size = tDesc.getFields().size();
        Tuple tuple = tupleFactory.newTuple(size);
        for (int i = 0; i < size; ++i) {
            TStructDescriptor.Field field = tDesc.getFieldAt(i);
            Object value = tDesc.getFieldValue(i, tObj);
            try {
                tuple.set(i, ThriftToPig.toPigObject(field, value, false));
                continue;
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
        return tuple;
    }

    public static Object toPigObject(TStructDescriptor.Field field, Object value, boolean lazy) {
        if (value == null) {
            return null;
        }
        switch (field.getType()) {
            case 2: {
                return (Boolean)value != false ? 1 : 0;
            }
            case 3: {
                return (int)((Byte)value).byteValue();
            }
            case 6: {
                return (int)((Short)value).shortValue();
            }
            case 11: {
                return ThriftToPig.stringTypeToPig(value);
            }
            case 12: {
                if (lazy) {
                    return new LazyTuple(field.gettStructDescriptor(), (TBase)value);
                }
                return ThriftToPig.toTuple(field.gettStructDescriptor(), (TBase)value);
            }
            case 13: {
                return ThriftToPig.toPigMap(field, (Map)value, lazy);
            }
            case 14: {
                return ThriftToPig.toPigBag(field.getSetElemField(), (Collection)value, lazy);
            }
            case 15: {
                return ThriftToPig.toPigBag(field.getListElemField(), (Collection)value, lazy);
            }
            case 16: {
                if (useEnumId.booleanValue()) {
                    return field.getEnumValueOf(value.toString()).getValue();
                }
                return value.toString();
            }
        }
        return value;
    }

    private static Object stringTypeToPig(Object value) {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof byte[]) {
            byte[] buf = (byte[])value;
            return new DataByteArray(Arrays.copyOf(buf, buf.length));
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer bin = (ByteBuffer)value;
            byte[] buf = new byte[bin.remaining()];
            bin.mark();
            bin.get(buf);
            bin.reset();
            return new DataByteArray(buf);
        }
        return null;
    }

    private static Map<String, Object> toPigMap(TStructDescriptor.Field field, Map<Object, Object> map, boolean lazy) {
        HashMap<String, Object> out = new HashMap<String, Object>(map.size());
        TStructDescriptor.Field valueField = field.getMapValueField();
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            String key = e.getKey() == null ? null : e.getKey().toString();
            Object prev = out.put(key, ThriftToPig.toPigObject(valueField, e.getValue(), lazy));
            if (prev == null) continue;
            String msg = "Duplicate keys while converting to String while  processing map " + field.getName() + " (key type : " + field.getMapKeyField().getType() + " value type : " + field.getMapValueField().getType() + ")";
            LOG.warn(msg);
            throw new RuntimeException(msg);
        }
        return out;
    }

    private static DataBag toPigBag(TStructDescriptor.Field field, Collection<Object> values, boolean lazy) {
        ArrayList tuples = Lists.newArrayListWithExpectedSize((int)values.size());
        for (Object value : values) {
            Object pValue = ThriftToPig.toPigObject(field, value, lazy);
            if (pValue instanceof Tuple) {
                tuples.add((Tuple)pValue);
                continue;
            }
            tuples.add(tupleFactory.newTuple(pValue));
        }
        return new NonSpillableDataBag((List)tuples);
    }

    public static Schema toSchema(Class<? extends TBase<?, ?>> tClass) {
        return ThriftToPig.toSchema(TStructDescriptor.getInstance(tClass));
    }

    public Schema toSchema() {
        return ThriftToPig.toSchema(this.structDesc);
    }

    public static Schema toSchema(TStructDescriptor tDesc) {
        Schema schema = new Schema();
        try {
            for (TStructDescriptor.Field field : tDesc.getFields()) {
                schema.add(ThriftToPig.singleFieldToFieldSchema(field.getName(), field));
            }
        }
        catch (FrontendException t) {
            throw new RuntimeException(t);
        }
        return schema;
    }

    private static Schema.FieldSchema singleFieldToFieldSchema(String fieldName, TStructDescriptor.Field field) throws FrontendException {
        switch (field.getType()) {
            case 12: {
                return new Schema.FieldSchema(fieldName, ThriftToPig.toSchema(field.gettStructDescriptor()), 110);
            }
            case 15: {
                return new Schema.FieldSchema(fieldName, ThriftToPig.singleFieldToTupleSchema(fieldName + "_tuple", field.getListElemField()), 120);
            }
            case 14: {
                return new Schema.FieldSchema(fieldName, ThriftToPig.singleFieldToTupleSchema(fieldName + "_tuple", field.getSetElemField()), 120);
            }
            case 13: {
                if (field.getMapKeyField().getType() != 11 && field.getMapKeyField().getType() != 16) {
                    LOG.warn("Using a map with non-string key for field " + field.getName() + ". while converting to PIG Tuple, toString() is used for the key." + " It could result in incorrect maps.");
                }
                return new Schema.FieldSchema(fieldName, new Schema(ThriftToPig.singleFieldToFieldSchema(null, field.getMapValueField())), 100);
            }
        }
        return new Schema.FieldSchema(fieldName, null, ThriftToPig.getPigDataType(field));
    }

    private static Schema wrapInTupleIfPig9(Schema schema) throws FrontendException {
        if (PigUtil.Pig9orNewer) {
            return new Schema(new Schema.FieldSchema("t", schema, 110));
        }
        return schema;
    }

    private static Schema singleFieldToTupleSchema(String fieldName, TStructDescriptor.Field field) throws FrontendException {
        switch (field.getType()) {
            case 12: {
                return ThriftToPig.wrapInTupleIfPig9(ThriftToPig.toSchema(field.gettStructDescriptor()));
            }
            case 13: 
            case 14: 
            case 15: {
                return ThriftToPig.wrapInTupleIfPig9(new Schema(ThriftToPig.singleFieldToFieldSchema(fieldName, field)));
            }
        }
        return ThriftToPig.wrapInTupleIfPig9(new Schema(new Schema.FieldSchema(fieldName, null, ThriftToPig.getPigDataType(field))));
    }

    private static byte getPigDataType(TStructDescriptor.Field field) {
        switch (field.getType()) {
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return 10;
            }
            case 16: {
                if (useEnumId.booleanValue()) {
                    return 10;
                }
                return 55;
            }
            case 10: {
                return 15;
            }
            case 4: {
                return 25;
            }
            case 11: {
                return field.isBuffer() ? (byte)50 : 55;
            }
        }
        throw new IllegalArgumentException("Unexpected type where a simple type is expected : " + field.getType());
    }

    public static String toPigScript(Class<? extends TBase<?, ?>> thriftClass, Class<? extends LoadFunc> pigLoader) {
        StringBuilder sb = new StringBuilder();
        StringBuilder prefix = new StringBuilder("       --  ");
        sb.append("raw_data = load '$INPUT_FILES' using ").append(pigLoader.getName()).append("('").append(thriftClass.getName()).append("');\n").append((CharSequence)prefix).append("as ");
        prefix.append("   ");
        try {
            ThriftToPig.stringifySchema(sb, ThriftToPig.toSchema(thriftClass), (byte)110, prefix);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static void stringifySchema(StringBuilder sb, Schema schema, byte type, StringBuilder prefix) throws FrontendException {
        if (type == 110) {
            sb.append("(");
        } else if (type == 120) {
            sb.append("{");
        }
        prefix.append("  ");
        sb.append("\n").append((CharSequence)prefix);
        if (schema == null) {
            sb.append("null");
        } else {
            boolean isFirst = true;
            for (int i = 0; i < schema.size(); ++i) {
                if (!isFirst) {
                    sb.append(",\n").append((CharSequence)prefix);
                } else {
                    isFirst = false;
                }
                Schema.FieldSchema fs = schema.getField(i);
                if (fs == null) {
                    sb.append("null");
                    continue;
                }
                if (fs.alias != null) {
                    sb.append(fs.alias);
                    sb.append(": ");
                }
                if (DataType.isAtomic((byte)fs.type)) {
                    sb.append(DataType.findTypeName((byte)fs.type));
                    continue;
                }
                if (fs.type == 110 || fs.type == 120) {
                    if (schema != fs.schema) {
                        ThriftToPig.stringifySchema(sb, fs.schema, fs.type, prefix);
                        continue;
                    }
                    throw new AssertionError((Object)"Schema refers to itself as inner schema");
                }
                if (fs.type == 100) {
                    sb.append(DataType.findTypeName((byte)fs.type) + "[");
                    if (fs.schema != null) {
                        ThriftToPig.stringifySchema(sb, fs.schema, fs.type, prefix);
                    }
                    sb.append("]");
                    continue;
                }
                sb.append(DataType.findTypeName((byte)fs.type));
            }
        }
        prefix.setLength(prefix.length() - 2);
        sb.append("\n").append((CharSequence)prefix);
        if (type == 110) {
            sb.append(")");
        } else if (type == 120) {
            sb.append("}");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            Class tClass = ThriftUtils.getTypeRef((String)args[0]).getRawClass();
            System.out.println(args[0] + " : " + ThriftToPig.toSchema(tClass).toString());
            System.out.println(ThriftToPig.toPigScript(tClass, ThriftPigLoader.class));
        }
    }

    private static class LazyTuple
    extends AbstractLazyTuple {
        private TBase<?, ?> tObject;
        private TStructDescriptor desc;

        LazyTuple(TStructDescriptor desc, TBase<?, ?> tObject) {
            this.initRealTuple(desc.getFields().size());
            this.tObject = tObject;
            this.desc = desc;
        }

        @Override
        protected Object getObjectAt(int index) {
            TStructDescriptor.Field field = this.desc.getFieldAt(index);
            return ThriftToPig.toPigObject(field, this.desc.getFieldValue(index, this.tObject), true);
        }
    }
}

