/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.headers;

import com.twitter.finagle.http.headers.Rfc7230HeaderValidation;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$CR$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$LF$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$NonFold$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$ObsFoldDetected$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$ValidationSuccess$;
import java.util.BitSet;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class Rfc7230HeaderValidation$ {
    public static final Rfc7230HeaderValidation$ MODULE$;
    private final Regex ObsFoldRegex;
    private final BitSet validHeaderNameCharSet;
    private final BitSet validHeaderValueCharSet;

    static {
        new Rfc7230HeaderValidation$();
    }

    private Iterable<Object> validHeaderNameChars() {
        return (Iterable)((List)((List)((List)new StringOps(Predef$.MODULE$.augmentString("!#$%&'*+-.^_`|~")).toList().$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(char x$1) {
                return x$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private Iterable<Object> validHeaderValueChars() {
        return (Iterable)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(33), 126).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(128), 255), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString("\r\n \t")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(char x$2) {
                return x$2;
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private BitSet toBitSet(Iterable<Object> valid) {
        void var2_2;
        BitSet bitSet = new BitSet();
        valid.foreach((Function1)new Serializable(bitSet){
            public static final long serialVersionUID = 0L;
            private final BitSet bitSet$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bitSet$1.set(x$1);
            }
            {
                this.bitSet$1 = bitSet$1;
            }
        });
        return var2_2;
    }

    private boolean validHeaderNameChar(char c) {
        return this.validHeaderNameCharSet.get(c);
    }

    private boolean validHeaderValueChar(char c) {
        return this.validHeaderValueCharSet.get(c);
    }

    public String replaceObsFold(CharSequence value) {
        return this.ObsFoldRegex.replaceAllIn(value, " ");
    }

    /*
     * WARNING - void declaration
     */
    public Rfc7230HeaderValidation.NameValidationResult validateName(CharSequence name) {
        Rfc7230HeaderValidation.NameValidationResult nameValidationResult;
        if (name == null) {
            throw new NullPointerException("Header names cannot be null");
        }
        if (name.length() == 0) {
            nameValidationResult = new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.NameValidationException("Header name cannot be empty"));
        } else {
            for (int i = 0; i < name.length(); ++i) {
                void var3_3;
                char c = name.charAt(i);
                if (this.validHeaderNameChar(c)) {
                    continue;
                }
                return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.NameValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': name cannot contain the prohibited character '0x", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, Integer.toHexString((int)var3_3)}))).append((Object)BoxesRunTime.boxToCharacter((char)var3_3)).toString()));
            }
            nameValidationResult = Rfc7230HeaderValidation$ValidationSuccess$.MODULE$;
        }
        return nameValidationResult;
    }

    /*
     * WARNING - void declaration
     */
    public Rfc7230HeaderValidation.ValueValidationResult validateValue(CharSequence name, CharSequence value) {
        Product product;
        if (value == null) {
            throw new NullPointerException("Header values cannot be null");
        }
        Product state = Rfc7230HeaderValidation$NonFold$.MODULE$;
        boolean foldDetected = false;
        for (int i = 0; i < value.length(); ++i) {
            void var6_6;
            char c = value.charAt(i);
            if (this.validHeaderValueChar(c)) {
                BoxedUnit boxedUnit;
                Rfc7230HeaderValidation$NonFold$ rfc7230HeaderValidation$NonFold$ = state;
                if (Rfc7230HeaderValidation$NonFold$.MODULE$.equals(rfc7230HeaderValidation$NonFold$)) {
                    BoxedUnit boxedUnit2;
                    if (c == '\r') {
                        state = Rfc7230HeaderValidation$CR$.MODULE$;
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (c == '\n') {
                        state = Rfc7230HeaderValidation$LF$.MODULE$;
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (Rfc7230HeaderValidation$CR$.MODULE$.equals(rfc7230HeaderValidation$NonFold$)) {
                    if (c == '\n') {
                        state = Rfc7230HeaderValidation$LF$.MODULE$;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': only '\\\\n' is allowed after '\\\\r' in value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))));
                }
                if (Rfc7230HeaderValidation$LF$.MODULE$.equals(rfc7230HeaderValidation$NonFold$)) {
                    if (c == '\t' || c == ' ') {
                        foldDetected = true;
                        state = Rfc7230HeaderValidation$NonFold$.MODULE$;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': only ' ' and '\\\\t' are allowed after '\\\\n' in value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))));
                }
                throw new MatchError((Object)rfc7230HeaderValidation$NonFold$);
            }
            return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': value contains a prohibited character '0x", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, Integer.toHexString((int)var6_6), BoxesRunTime.boxToCharacter((char)var6_6)}))));
        }
        Rfc7230HeaderValidation$NonFold$ rfc7230HeaderValidation$NonFold$ = state;
        Rfc7230HeaderValidation$NonFold$ rfc7230HeaderValidation$NonFold$2 = Rfc7230HeaderValidation$NonFold$.MODULE$;
        if (!(rfc7230HeaderValidation$NonFold$ != null ? !rfc7230HeaderValidation$NonFold$.equals(rfc7230HeaderValidation$NonFold$2) : rfc7230HeaderValidation$NonFold$2 != null)) {
            product = foldDetected ? Rfc7230HeaderValidation$ObsFoldDetected$.MODULE$ : Rfc7230HeaderValidation$ValidationSuccess$.MODULE$;
        } else {
            Product product2 = state;
            Rfc7230HeaderValidation$CR$ rfc7230HeaderValidation$CR$ = Rfc7230HeaderValidation$CR$.MODULE$;
            String string = !(product2 != null ? !product2.equals(rfc7230HeaderValidation$CR$) : rfc7230HeaderValidation$CR$ != null) ? "\\r" : "\\n";
            product = new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header '", "': value must not end with '\\\\r' or '\\\\n'. Observed: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))).append((Object)string).toString()));
        }
        return product;
    }

    private Rfc7230HeaderValidation$() {
        MODULE$ = this;
        this.ObsFoldRegex = new StringOps(Predef$.MODULE$.augmentString("\r?\n[\t ]+")).r();
        this.validHeaderNameCharSet = this.toBitSet(this.validHeaderNameChars());
        this.validHeaderValueCharSet = this.toBitSet(this.validHeaderValueChars());
    }
}

