/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.CookieMap;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.finagle.http.util.StringUtil$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.BufInputStream;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011-d!B\u0001\u0003\u0003\u0003Y!aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tA\u0001\u001b;ua*\u0011QAB\u0001\bM&t\u0017m\u001a7f\u0015\t9\u0001\"A\u0004uo&$H/\u001a:\u000b\u0003%\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001\u0003\u0004\u0019\u0001\u0001\u0006K!G\u0001\t?\u000e|g\u000e^3oiB\u0011!$H\u0007\u00027)\u0011ADB\u0001\u0003S>L!AH\u000e\u0003\u0007\t+h\r\u0003\u0004!\u0001\u0001\u0006K!I\u0001\t?Z,'o]5p]B\u0011aCI\u0005\u0003G\t\u0011qAV3sg&|g\u000e\u0003\u0004&\u0001\u0001\u0006KAJ\u0001\t?\u000eDWO\\6fIB\u0011QbJ\u0005\u0003Q9\u0011qAQ8pY\u0016\fg\u000eC\u0003+\u0001\u0019\u00051&\u0001\u0004sK\u0006$WM]\u000b\u0002YA\u0019!$L\r\n\u00059Z\"A\u0002*fC\u0012,'\u000fC\u00031\u0001\u0019\u0005\u0011'\u0001\u0004xe&$XM]\u000b\u0002eA\u0019!dM\r\n\u0005QZ\"AB,sSR,'\u000fC\u00037\u0001\u0019\u0005q'A\u0005jgJ+\u0017/^3tiV\ta\u0005C\u0003:\u0001\u0011\u0005q'\u0001\u0006jgJ+7\u000f]8og\u0016DQa\u000f\u0001\u0005\u0002q\nqaY8oi\u0016tG/F\u0001\u001a\u0011\u0015q\u0004\u0001\"\u0001@\u0003-\u0019wN\u001c;f]R|F%Z9\u0015\u0005\u0001\u001b\u0005CA\u0007B\u0013\t\u0011eB\u0001\u0003V]&$\b\"B\u001e>\u0001\u0004I\u0002fA\u001fF!B\u0019QB\u0012%\n\u0005\u001ds!A\u0002;ie><8\u000f\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003+%cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]F\"a$\u0015/v!\t\u0011\u0016L\u0004\u0002T/B\u0011AKD\u0007\u0002+*\u0011aKC\u0001\u0007yI|w\u000e\u001e \n\u0005as\u0011A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001\u0017\b2\u000b\rj\u0016\r\u001d2\u0016\u0005y{V#A)\u0005\u000b\u0001T!\u0019A3\u0003\u0003QK!AY2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\t!g\"\u0001\u0004uQJ|wo]\t\u0003M&\u0004\"!D4\n\u0005!t!a\u0002(pi\"Lgn\u001a\t\u0003U6t!!D6\n\u00051t\u0011a\u00029bG.\fw-Z\u0005\u0003]>\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u00051t\u0011'B\u0012reN$gBA\u0007s\u0013\t!g\"\r\u0003#\u001b9!(!B:dC2\f\u0017G\u0001\u0014I\u0011\u0015Y\u0004\u0001\"\u0002x)\tA\u00180D\u0001\u0001\u0011\u0015Yd\u000f1\u0001\u001aQ\r1Xi_\u0019\u0005=Ecx0M\u0003$;\u0006l(-M\u0003$cJtH-\r\u0003#\u001b9!\u0018G\u0001\u0014I\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tqA^3sg&|g.F\u0001\"\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\t1B^3sg&|gn\u0018\u0013fcR\u0019\u0001)!\u0004\t\u000f\u0005\r\u0011q\u0001a\u0001C!9\u00111\u0001\u0001\u0005\u0006\u0005EAc\u0001=\u0002\u0014!9\u00111AA\b\u0001\u0004\t\u0003BBA\f\u0001\u0011\u0005q'A\u0005jg\u000eCWO\\6fI\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011AC:fi\u000eCWO\\6fIR\u0019\u0001)a\b\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001M\u000591\r[;oW\u0016$\u0007bBA\u0013\u0001\u0019\u0005\u0011qE\u0001\nQ\u0016\fG-\u001a:NCB,\"!!\u000b\u0011\u0007Y\tY#C\u0002\u0002.\t\u0011\u0011\u0002S3bI\u0016\u0014X*\u00199\t\u0015\u0005E\u0002\u0001#b\u0001\n\u0003\t\u0019$A\u0004d_>\\\u0017.Z:\u0016\u0005\u0005U\u0002c\u0001\f\u00028%\u0019\u0011\u0011\b\u0002\u0003\u0013\r{wn[5f\u001b\u0006\u0004\bbBA\u001f\u0001\u0011\u0005\u0011qH\u0001\u000bO\u0016$8i\\8lS\u0016\u001cHCAA!!\u0019\t\u0019%!\u0013\u0002N5\u0011\u0011Q\t\u0006\u0004\u0003\u000fb\u0015\u0001B;uS2LA!a\u0013\u0002F\tA\u0011\n^3sCR|'\u000fE\u0002\u0017\u0003\u001fJ1!!\u0015\u0003\u0005\u0019\u0019un\\6jK\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013!C1eI\u000e{wn[5f)\r\u0001\u0015\u0011\f\u0005\t\u00037\n\u0019\u00061\u0001\u0002N\u000511m\\8lS\u0016Dq!a\u0018\u0001\t\u0003\t\t'\u0001\u0007sK6|g/Z\"p_.LW\rF\u0002A\u0003GBq!!\u001a\u0002^\u0001\u0007\u0011+\u0001\u0003oC6,\u0007bBA5\u0001\u0011\u0005\u00111N\u0001\u0007C\u000e\u001cW\r\u001d;\u0016\u0005\u00055\u0004#BA8\u0003k\nfbAA9W:\u0019A+a\u001d\n\u0003=I1!a\u001ep\u0005\r\u0019V-\u001d\u0005\b\u0003w\u0002A\u0011AA?\u0003)\t7mY3qi~#S-\u001d\u000b\u0004\u0001\u0006}\u0004bBAA\u0003s\u0002\r!U\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003w\u0002A\u0011AAC)\r\u0001\u0015q\u0011\u0005\t\u0003\u0013\u000b\u0019\t1\u0001\u0002\f\u00061a/\u00197vKN\u0004R!a\u001c\u0002\u000eFK1!a$p\u0005!IE/\u001a:bE2,\u0007bBAJ\u0001\u0011\u0005\u00111N\u0001\u0011C\u000e\u001cW\r\u001d;NK\u0012L\u0017\rV=qKNDq!a&\u0001\t\u0003\tI*A\u0003bY2|w/\u0006\u0002\u0002\u001cB!Q\"!(R\u0013\r\tyJ\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\u0006I\u0011\r\u001c7po~#S-\u001d\u000b\u0004\u0001\u0006\u001d\u0006bBAA\u0003C\u0003\r!\u0015\u0005\b\u0003G\u0003A\u0011AAV)\r\u0001\u0015Q\u0016\u0005\t\u0003\u0013\u000bI\u000b1\u0001\u00020B1\u0011qNAG\u0003c\u00032AFAZ\u0013\r\t)L\u0001\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000f\u0005e\u0006\u0001\"\u0001\u0002\u001a\u0006i\u0011-\u001e;i_JL'0\u0019;j_:Dq!!0\u0001\t\u0003\ty,A\tbkRDwN]5{CRLwN\\0%KF$2\u0001QAa\u0011\u001d\t\t)a/A\u0002ECq!!2\u0001\t\u0003\tI*\u0001\u0007dC\u000eDWmQ8oiJ|G\u000eC\u0004\u0002J\u0002!\t!a3\u0002!\r\f7\r[3D_:$(o\u001c7`I\u0015\fHc\u0001!\u0002N\"9\u0011\u0011QAd\u0001\u0004\t\u0006bBAe\u0001\u0011\u0005\u0011\u0011\u001b\u000b\u0004\u0001\u0006M\u0007\u0002CAk\u0003\u001f\u0004\r!a6\u0002\r5\f\u00070Q4f!\u0011\tI.!8\u000e\u0005\u0005m'bAA$\r%!\u0011q\\An\u0005!!UO]1uS>t\u0007bBAr\u0001\u0011\u0005\u0011\u0011T\u0001\bG\"\f'o]3u\u0011\u001d\t9\u000f\u0001C\u0001\u0003S\f1b\u00195beN,Go\u0018\u0013fcR\u0019\u0001)a;\t\u000f\u0005\u0005\u0015Q\u001da\u0001#\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\u0018!D2p]R,g\u000e\u001e'f]\u001e$\b.\u0006\u0002\u0002tB)Q\"!(\u0002vB\u0019Q\"a>\n\u0007\u0005ehB\u0001\u0003M_:<\u0007bBA\u007f\u0001\u0011\u0015\u0011q`\u0001\u0014G>tG/\u001a8u\u0019\u0016tw\r\u001e5Pe\u0016c7/\u001a\u000b\u0005\u0003k\u0014\t\u0001\u0003\u0005\u0003\u0004\u0005m\b\u0019AA{\u0003\u001d!WMZ1vYRDqAa\u0002\u0001\t\u0003\u0011I!A\td_:$XM\u001c;MK:<G\u000f[0%KF$2\u0001\u0011B\u0006\u0011!\t\tI!\u0002A\u0002\u0005U\bbBAx\u0001\u0011\u0015!q\u0002\u000b\u0004q\nE\u0001\u0002CAA\u0005\u001b\u0001\r!!>\t\u000f\tU\u0001\u0001\"\u0001\u0002\u001a\u0006Y1m\u001c8uK:$H+\u001f9f\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\tqbY8oi\u0016tG\u000fV=qK~#S-\u001d\u000b\u0004\u0001\nu\u0001bBAA\u0005/\u0001\r!\u0015\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u00039\u0019X\r^\"p]R,g\u000e\u001e+za\u0016$R\u0001\u0011B\u0013\u0005SAqAa\n\u0003 \u0001\u0007\u0011+A\u0005nK\u0012L\u0017\rV=qK\"I\u00111\u001dB\u0010!\u0003\u0005\r!\u0015\u0005\b\u0005[\u0001A\u0011\u0001B\u0018\u0003I\u0019X\r^\"p]R,g\u000e\u001e+za\u0016T5o\u001c8\u0015\u0003\u0001CqAa\r\u0001\t\u0003\tI*\u0001\u0003eCR,\u0007b\u0002B\u001c\u0001\u0011\u0005!\u0011H\u0001\tI\u0006$Xm\u0018\u0013fcR\u0019\u0001Ia\u000f\t\u000f\u0005\u0005%Q\u0007a\u0001#\"9!q\u0007\u0001\u0005\u0002\t}Bc\u0001!\u0003B!A\u0011\u0011\u0011B\u001f\u0001\u0004\u0011\u0019\u0005\u0005\u0003\u0002D\t\u0015\u0013\u0002\u0002B$\u0003\u000b\u0012A\u0001R1uK\"9!1\n\u0001\u0005\u0002\u0005e\u0015aB3ya&\u0014Xm\u001d\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0003-)\u0007\u0010]5sKN|F%Z9\u0015\u0007\u0001\u0013\u0019\u0006C\u0004\u0002\u0002\n5\u0003\u0019A)\t\u000f\t=\u0003\u0001\"\u0001\u0003XQ\u0019\u0001I!\u0017\t\u0011\u0005\u0005%Q\u000ba\u0001\u0005\u0007BqA!\u0018\u0001\t\u0003\tI*\u0001\u0003i_N$\bb\u0002B1\u0001\u0011\u0005!1M\u0001\tQ>\u001cHo\u0018\u0013fcR\u0019\u0001I!\u001a\t\u000f\u0005\u0005%q\fa\u0001#\"9!Q\f\u0001\u0005\u0006\t%Dc\u0001=\u0003l!9\u0011\u0011\u0011B4\u0001\u0004\t\u0006b\u0002B8\u0001\u0011\u0005\u0011\u0011T\u0001\rY\u0006\u001cH/T8eS\u001aLW\r\u001a\u0005\b\u0005g\u0002A\u0011\u0001B;\u0003Aa\u0017m\u001d;N_\u0012Lg-[3e?\u0012*\u0017\u000fF\u0002A\u0005oBq!!!\u0003r\u0001\u0007\u0011\u000bC\u0004\u0003t\u0001!\tAa\u001f\u0015\u0007\u0001\u0013i\b\u0003\u0005\u0002\u0002\ne\u0004\u0019\u0001B\"\u0011\u001d\u0011\t\t\u0001C\u0001\u00033\u000b\u0001\u0002\\8dCRLwN\u001c\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u00031awnY1uS>tw\fJ3r)\r\u0001%\u0011\u0012\u0005\b\u0003\u0003\u0013\u0019\t1\u0001R\u0011\u001d\u00119\u0003\u0001C\u0001\u00033CqAa$\u0001\t\u0003\u0011\t*A\u0007nK\u0012L\u0017\rV=qK~#S-\u001d\u000b\u0004\u0001\nM\u0005bBAA\u0005\u001b\u0003\r!\u0015\u0005\b\u0005/\u0003A\u0011AAM\u0003\u001d\u0011XMZ3sKJDqAa'\u0001\t\u0003\u0011i*A\u0006sK\u001a,'/\u001a:`I\u0015\fHc\u0001!\u0003 \"9\u0011\u0011\u0011BM\u0001\u0004\t\u0006b\u0002BR\u0001\u0011\u0005\u0011\u0011T\u0001\u000be\u0016$(/_!gi\u0016\u0014\bb\u0002BT\u0001\u0011\u0005!\u0011V\u0001\u000fe\u0016$(/_!gi\u0016\u0014x\fJ3r)\r\u0001%1\u0016\u0005\b\u0003\u0003\u0013)\u000b1\u0001R\u0011\u001d\u00119\u000b\u0001C\u0001\u0005_#2\u0001\u0011BY\u0011!\t\tI!,A\u0002\u0005U\bb\u0002B[\u0001\u0011\u0005\u0011\u0011T\u0001\u0007g\u0016\u0014h/\u001a:\t\u000f\te\u0006\u0001\"\u0001\u0003<\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0007\u0001\u0013i\fC\u0004\u0002\u0002\n]\u0006\u0019A)\t\u000f\t\u0005\u0007\u0001\"\u0001\u0002\u001a\u0006IQo]3s\u0003\u001e,g\u000e\u001e\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u00035)8/\u001a:BO\u0016tGo\u0018\u0013fcR\u0019\u0001I!3\t\u000f\u0005\u0005%1\u0019a\u0001#\"9!Q\u001a\u0001\u0005\u0002\u0005e\u0015aD<xo\u0006+H\u000f[3oi&\u001c\u0017\r^3\t\u000f\tE\u0007\u0001\"\u0001\u0003T\u0006\u0019ro^<BkRDWM\u001c;jG\u0006$Xm\u0018\u0013fcR\u0019\u0001I!6\t\u000f\u0005\u0005%q\u001aa\u0001#\"9!\u0011\u001c\u0001\u0005\u0002\u0005e\u0015!\u0004=G_J<\u0018M\u001d3fI\u001a{'\u000fC\u0004\u0003^\u0002!\tAa8\u0002#a4uN]<be\u0012,GMR8s?\u0012*\u0017\u000fF\u0002A\u0005CDq!!!\u0003\\\u0002\u0007\u0011\u000b\u0003\u0004\u0003f\u0002!\taN\u0001\u0011SNDV\u000e\u001c%uiB\u0014V-];fgRDqA!;\u0001\t\u000b\u0011Y/\u0001\u0004mK:<G\u000f[\u000b\u0003\u0005[\u00042!\u0004Bx\u0013\r\u0011\tP\u0004\u0002\u0004\u0013:$\bb\u0002B{\u0001\u0011\u0015!q_\u0001\nO\u0016$H*\u001a8hi\"$\"A!<\t\r\tm\b\u0001\"\u0001_\u00035\u0019wN\u001c;f]R\u001cFO]5oO\"9!q \u0001\u0005\u0002\r\u0005\u0011\u0001E4fi\u000e{g\u000e^3oiN#(/\u001b8h)\u0005\t\u0006bBB\u0003\u0001\u0011\u00051qA\u0001\u0012G>tG/\u001a8u'R\u0014\u0018N\\4`I\u0015\fHc\u0001!\u0004\n!9\u0011\u0011QB\u0002\u0001\u0004\t\u0006bBB\u0007\u0001\u0011\u00151qB\u0001\u0011g\u0016$8i\u001c8uK:$8\u000b\u001e:j]\u001e$2\u0001QB\t\u0011\u001d\t\tia\u0003A\u0002ECqa!\u0006\u0001\t\u0003\u00199\"A\bxSRD\u0017J\u001c9viN#(/Z1n+\u0011\u0019Iba\b\u0015\t\rm1\u0011\u0006\t\u0005\u0007;\u0019y\u0002\u0004\u0001\u0005\u000f\u0001\u001c\u0019B1\u0001\u0004\"E\u0019ama\t\u0011\u00075\u0019)#C\u0002\u0004(9\u00111!\u00118z\u0011!\u0019Yca\u0005A\u0002\r5\u0012!\u00014\u0011\u000f5\u0019yca\r\u0004\u001c%\u00191\u0011\u0007\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BB\u001b\u0007si!aa\u000e\u000b\u0005qa\u0015\u0002BB\u001e\u0007o\u00111\"\u00138qkR\u001cFO]3b[\"91q\b\u0001\u0005\u0006\r\u0005\u0013AD4fi&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003\u0007gAqa!\u0012\u0001\t\u000b\u00199%\u0001\u0006xSRD'+Z1eKJ,Ba!\u0013\u0004NQ!11JB(!\u0011\u0019ib!\u0014\u0005\u000f\u0001\u001c\u0019E1\u0001\u0004\"!A11FB\"\u0001\u0004\u0019\t\u0006E\u0004\u000e\u0007_\u0019\u0019fa\u0013\u0011\t\rU2QK\u0005\u0004]\r]\u0002bBB-\u0001\u0011\u001511L\u0001\nO\u0016$(+Z1eKJ$\"aa\u0015\t\u000f\r}\u0003\u0001\"\u0002\u0004b\u0005)qO]5uKR\u0019\u0001ia\u0019\t\u000f\r\u00154Q\fa\u0001#\u000611\u000f\u001e:j]\u001eDSa!\u0018F\u0007S\u001a\u0013\u0001\u0013\u0005\b\u0007?\u0002AQAB7)\r\u00015q\u000e\u0005\b\u0007c\u001aY\u00071\u0001\u001a\u0003\r\u0011WO\u001a\u0015\u0006\u0007W*5\u0011\u000e\u0005\b\u0007?\u0002AQAB<)\r\u00015\u0011\u0010\u0005\t\u0007w\u001a)\b1\u0001\u0004~\u0005)!-\u001f;fgB)Qba \u0004\u0004&\u00191\u0011\u0011\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\u0019))C\u0002\u0004\b:\u0011AAQ=uK\"*1QO#\u0004j!91Q\u0012\u0001\u0005\u0006\r=\u0015\u0001E<ji\"|U\u000f\u001e9viN#(/Z1n+\u0011\u0019\tj!&\u0015\t\rM5q\u0013\t\u0005\u0007;\u0019)\nB\u0004a\u0007\u0017\u0013\ra!\t\t\u0011\r-21\u0012a\u0001\u00073\u0003r!DB\u0018\u00077\u001b\u0019\n\u0005\u0003\u00046\ru\u0015\u0002BBP\u0007o\u0011AbT;uaV$8\u000b\u001e:fC6DSaa#F\u0007SBqa!*\u0001\t\u000b\u00199+\u0001\u0006xSRDwK]5uKJ,Ba!+\u0004.R!11VBX!\u0011\u0019ib!,\u0005\u000f\u0001\u001c\u0019K1\u0001\u0004\"!A11FBR\u0001\u0004\u0019\t\fE\u0004\u000e\u0007_\u0019\u0019la+\u0011\t\rU2QW\u0005\u0004i\r]\u0002&BBR\u000b\u000e%\u0004bBB^\u0001\u0011\u0015!qF\u0001\rG2,\u0017M]\"p]R,g\u000e\u001e\u0005\b\u0007\u007f\u0003A\u0011ABa\u0003\u0015\u0019Gn\\:f)\t\u0019\u0019\rE\u0003\u0002Z\u000e\u0015\u0007)\u0003\u0003\u0004H\u0006m'A\u0002$viV\u0014X\rC\u0004\u0004L\u0002!)a!4\u0002\u0013-,W\r]!mSZ,Gc\u0001=\u0004P\"911ZBe\u0001\u00041\u0003BBBf\u0001\u0011\u0015q\u0007C\u0005\u0004V\u0002\t\n\u0011\"\u0001\u0004X\u0006A2/\u001a;D_:$XM\u001c;UsB,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\re'fA)\u0004\\.\u00121Q\u001c\t\u0005\u0007?\u001cI/\u0004\u0002\u0004b*!11]Bs\u0003%)hn\u00195fG.,GMC\u0002\u0004h:\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yo!9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u0004p\nA\ta!=\u0002\u000f5+7o]1hKB\u0019aca=\u0007\r\u0005\u0011\u0001\u0012AB{'\r\u0019\u0019\u0010\u0004\u0005\b'\rMH\u0011AB})\t\u0019\tPB\u0004\u0004~\u000eMhaa@\u0003\u001f\t+hmT;uaV$8\u000b\u001e:fC6\u001cBaa?\u0005\u0002A!1Q\u0007C\u0002\u0013\u0011!)aa\u000e\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\"YA\u0011BB~\u0005\u0003\u0005\u000b\u0011\u0002Bw\u0003-Ig.\u001b;jC2\u001c\u0016N_3\t\u000fM\u0019Y\u0010\"\u0001\u0005\u000eQ!Aq\u0002C\n!\u0011!\tba?\u000e\u0005\rM\b\u0002\u0003C\u0005\t\u0017\u0001\rA!<\t\u000f\u0011]11 C\u0001y\u0005i1m\u001c8uK:$8/Q:Ck\u001aD\u0011\u0002b\u0007\u0004t\n\u0007I\u0011\u00010\u0002\u0017\rC\u0017M]:fiV#h\r\u000f\u0005\t\t?\u0019\u0019\u0010)A\u0005#\u0006a1\t[1sg\u0016$X\u000b\u001e49A!IA1EBz\u0005\u0004%\tAX\u0001\u0010\u0007>tG/\u001a8u)f\u0004XMS:p]\"AAqEBzA\u0003%\u0011+\u0001\tD_:$XM\u001c;UsB,'j]8oA!IA1FBz\u0005\u0004%\tAX\u0001\u0015\u0007>tG/\u001a8u)f\u0004XMS:p]B\u000bGo\u00195\t\u0011\u0011=21\u001fQ\u0001\nE\u000bQcQ8oi\u0016tG\u000fV=qK*\u001bxN\u001c)bi\u000eD\u0007\u0005C\u0005\u00054\rM(\u0019!C\u0001=\u0006)2i\u001c8uK:$H+\u001f9f\u0015\u00064\u0018m]2sSB$\b\u0002\u0003C\u001c\u0007g\u0004\u000b\u0011B)\u0002-\r{g\u000e^3oiRK\b/\u001a&bm\u0006\u001c8M]5qi\u0002B\u0011\u0002b\u000f\u0004t\n\u0007I\u0011\u00010\u0002%\r{g\u000e^3oiRK\b/Z,xo\u001a{'/\u001c\u0005\t\t\u007f\u0019\u0019\u0010)A\u0005#\u0006\u00192i\u001c8uK:$H+\u001f9f/^<hi\u001c:nA!QA1IBz\u0005\u0004%I\u0001\"\u0012\u0002\u001d!#H\u000f\u001d#bi\u00164uN]7biV\u0011Aq\t\t\u0005\t\u0013\"\u0019&\u0004\u0002\u0005L)!AQ\nC(\u0003\u00191wN]7bi*\u0019A\u0011\u000b'\u0002\tQLW.Z\u0005\u0005\t+\"YEA\tECR,G+[7f\r>\u0014X.\u0019;uKJD\u0011\u0002\"\u0017\u0004t\u0002\u0006I\u0001b\u0012\u0002\u001f!#H\u000f\u001d#bi\u00164uN]7bi\u0002B\u0001\u0002\"\u0018\u0004t\u0012\u0005AqL\u0001\u000fQR$\b\u000fR1uK\u001a{'/\\1u)\r\tF\u0011\r\u0005\t\u0005g!Y\u00061\u0001\u0003D!AAQLBz\t\u0003!)\u0007F\u0002R\tOB\u0001\u0002\"\u001b\u0005d\u0001\u0007\u0011Q_\u0001\u0007[&dG.[:")
public abstract class Message {
    private CookieMap cookies;
    private Buf _content = Buf$.MODULE$.Empty();
    private Version _version = Version$.MODULE$.Http11();
    private boolean _chunked = false;
    private volatile boolean bitmap$0;

    public static String httpDateFormat(long l) {
        return Message$.MODULE$.httpDateFormat(l);
    }

    public static String httpDateFormat(Date date) {
        return Message$.MODULE$.httpDateFormat(date);
    }

    public static String ContentTypeWwwForm() {
        return Message$.MODULE$.ContentTypeWwwForm();
    }

    public static String ContentTypeJavascript() {
        return Message$.MODULE$.ContentTypeJavascript();
    }

    public static String ContentTypeJsonPatch() {
        return Message$.MODULE$.ContentTypeJsonPatch();
    }

    public static String ContentTypeJson() {
        return Message$.MODULE$.ContentTypeJson();
    }

    public static String CharsetUtf8() {
        return Message$.MODULE$.CharsetUtf8();
    }

    public abstract com.twitter.io.Reader<Buf> reader();

    public abstract com.twitter.io.Writer<Buf> writer();

    public abstract boolean isRequest();

    public boolean isResponse() {
        return !this.isRequest();
    }

    public Buf content() {
        return this._content;
    }

    public void content_$eq(Buf content) throws IllegalStateException {
        if (!content.isEmpty() && this.isChunked()) {
            throw new IllegalStateException("Cannot set content on Chunked message");
        }
        this._content = content;
    }

    public final Message content(Buf content) throws IllegalStateException {
        this.content_$eq(content);
        return this;
    }

    public Version version() {
        return this._version;
    }

    public void version_$eq(Version version) {
        this._version = version;
    }

    public final Message version(Version version) {
        this.version_$eq(version);
        return this;
    }

    public boolean isChunked() {
        return this._chunked;
    }

    public void setChunked(boolean chunked) {
        block0: {
            this._chunked = chunked;
            if (!chunked) break block0;
            this.clearContent();
        }
    }

    public abstract HeaderMap headerMap();

    private CookieMap cookies$lzycompute() {
        Message message = this;
        synchronized (message) {
            if (!this.bitmap$0) {
                this.cookies = new CookieMap(this);
                this.bitmap$0 = true;
            }
        }
        return this.cookies;
    }

    public CookieMap cookies() {
        return !this.bitmap$0 ? this.cookies$lzycompute() : this.cookies;
    }

    public Iterator<Cookie> getCookies() {
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.cookies().valuesIterator()).asJava();
    }

    public void addCookie(Cookie cookie) {
        this.cookies().$plus$eq(cookie);
    }

    public void removeCookie(String name) {
        this.cookies().$minus$eq(name);
    }

    public Seq<String> accept() {
        Seq seq;
        Option<String> option = this.headerMap().get("Accept");
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            seq = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$accept$2(x$2))));
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public void accept_$eq(String value) {
        this.headerMap().set("Accept", value);
    }

    public void accept_$eq(Iterable<String> values) {
        this.accept_$eq(values.mkString(", "));
    }

    public Seq<String> acceptMediaTypes() {
        return (Seq)this.accept().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split(";", 2))).headOption().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim().toLowerCase()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$acceptMediaTypes$3(x$5)))), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> allow() {
        return this.headerMap().get("Allow");
    }

    public void allow_$eq(String value) {
        this.headerMap().set("Allow", value);
    }

    public void allow_$eq(Iterable<Method> values) {
        this.allow_$eq(values.mkString(",").toUpperCase());
    }

    public Option<String> authorization() {
        return this.headerMap().get("Authorization");
    }

    public void authorization_$eq(String value) {
        this.headerMap().set("Authorization", value);
    }

    public Option<String> cacheControl() {
        return this.headerMap().get("Cache-Control");
    }

    public void cacheControl_$eq(String value) {
        this.headerMap().set("Cache-Control", value);
    }

    public void cacheControl_$eq(Duration maxAge) {
        this.cacheControl_$eq(new java.lang.StringBuilder(25).append("max-age=").append(((Object)BoxesRunTime.boxToInteger((int)maxAge.inSeconds())).toString()).append(", must-revalidate").toString());
    }

    public Option<String> charset() {
        None$ none$;
        Object object = new Object();
        try {
            this.contentType().foreach((Function1 & Serializable & scala.Serializable)contentType -> {
                Message.$anonfun$charset$1(object, contentType);
                return BoxedUnit.UNIT;
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public void charset_$eq(String value) {
        String contentType = (String)this.contentType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        if (parts.isEmpty()) {
            this.contentType_$eq(new java.lang.StringBuilder(9).append(";charset=").append(value).toString());
            return;
        }
        StringBuilder builder = new StringBuilder((String)parts.apply(0));
        if (!parts.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$charset_$eq$2(x$6)))) {
            builder.append(";charset=");
            builder.append(value);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), parts.length()).foreach((Function1 & Serializable & scala.Serializable)i -> Message.$anonfun$charset_$eq$3(parts, builder, BoxesRunTime.unboxToInt((Object)i)));
        } else {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), parts.length()).foreach((Function1 & Serializable & scala.Serializable)i -> Message.$anonfun$charset_$eq$4(value, parts, builder, BoxesRunTime.unboxToInt((Object)i)));
        }
        this.contentType_$eq(builder.toString());
    }

    public Option<Object> contentLength() {
        return this.headerMap().get("Content-Length").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)Message.$anonfun$contentLength$1(x$7)));
    }

    public final long contentLengthOrElse(long l) {
        long l2;
        Option<Object> option = this.contentLength();
        if (option instanceof Some) {
            long len;
            Some some = (Some)option;
            l2 = len = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l2 = l;
        } else {
            throw new MatchError(option);
        }
        return l2;
    }

    public void contentLength_$eq(long value) {
        this.headerMap().setUnsafe("Content-Length", ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public final Message contentLength(long value) {
        this.contentLength_$eq(value);
        return this;
    }

    public Option<String> contentType() {
        return this.headerMap().get("Content-Type");
    }

    public void contentType_$eq(String value) {
        this.headerMap().set("Content-Type", value);
    }

    public void setContentType(String mediaType, String charset) {
        this.headerMap().set("Content-Type", new java.lang.StringBuilder(9).append(mediaType).append(";charset=").append(charset).toString());
    }

    public String setContentType$default$2() {
        return "utf-8";
    }

    public void setContentTypeJson() {
        this.headerMap().setUnsafe("Content-Type", Message$.MODULE$.ContentTypeJson());
    }

    public Option<String> date() {
        return this.headerMap().get("Date");
    }

    public void date_$eq(String value) {
        this.headerMap().set("Date", value);
    }

    public void date_$eq(Date value) {
        this.date_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> expires() {
        return this.headerMap().get("Expires");
    }

    public void expires_$eq(String value) {
        this.headerMap().set("Expires", value);
    }

    public void expires_$eq(Date value) {
        this.expires_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> host() {
        return this.headerMap().get("Host");
    }

    public void host_$eq(String value) {
        this.headerMap().set("Host", value);
    }

    public final Message host(String value) {
        this.host_$eq(value);
        return this;
    }

    public Option<String> lastModified() {
        return this.headerMap().get("Last-Modified");
    }

    public void lastModified_$eq(String value) {
        this.headerMap().set("Last-Modified", value);
    }

    public void lastModified_$eq(Date value) {
        this.lastModified_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> location() {
        return this.headerMap().get("Location");
    }

    public void location_$eq(String value) {
        this.headerMap().set("Location", value);
    }

    public Option<String> mediaType() {
        return this.contentType().flatMap((Function1 & Serializable & scala.Serializable)contentType -> {
            String string;
            int n = contentType.indexOf(";");
            switch (n) {
                case -1: {
                    string = contentType;
                    break;
                }
                default: {
                    string = contentType.substring(0, n);
                    break;
                }
            }
            String beforeSemi = string;
            String mediaType = beforeSemi.trim();
            return new StringOps(Predef$.MODULE$.augmentString(mediaType)).nonEmpty() ? new Some((Object)mediaType.toLowerCase()) : None$.MODULE$;
        });
    }

    public void mediaType_$eq(String value) {
        Option<String> option = this.contentType();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String contentType = (String)some.value();
            IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';', 2);
            if (parts.length() == 2) {
                this.contentType_$eq(new java.lang.StringBuilder(1).append(value).append(";").append(parts.apply(1)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.contentType_$eq(value);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.contentType_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public Option<String> referer() {
        return this.headerMap().get("Referer");
    }

    public void referer_$eq(String value) {
        this.headerMap().set("Referer", value);
    }

    public Option<String> retryAfter() {
        return this.headerMap().get("Retry-After");
    }

    public void retryAfter_$eq(String value) {
        this.headerMap().set("Retry-After", value);
    }

    public void retryAfter_$eq(long value) {
        this.retryAfter_$eq(((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public Option<String> server() {
        return this.headerMap().get("Server");
    }

    public void server_$eq(String value) {
        this.headerMap().set("Server", value);
    }

    public Option<String> userAgent() {
        return this.headerMap().get("User-Agent");
    }

    public void userAgent_$eq(String value) {
        this.headerMap().set("User-Agent", value);
    }

    public Option<String> wwwAuthenticate() {
        return this.headerMap().get("Www-Authenticate");
    }

    public void wwwAuthenticate_$eq(String value) {
        this.headerMap().set("Www-Authenticate", value);
    }

    public Option<String> xForwardedFor() {
        return this.headerMap().get("X-Forwarded-For");
    }

    public void xForwardedFor_$eq(String value) {
        this.headerMap().set("X-Forwarded-For", value);
    }

    public boolean isXmlHttpRequest() {
        return this.headerMap().get("X-Requested-With").exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$isXmlHttpRequest$1(x$8)));
    }

    public final int length() {
        return this.content().length();
    }

    public final int getLength() {
        return this.length();
    }

    public String contentString() {
        Charset charset;
        try {
            charset = Charset.forName((String)this.charset().getOrElse((Function0 & Serializable & scala.Serializable)() -> "UTF-8"));
        }
        catch (Throwable throwable) {
            charset = StandardCharsets.UTF_8;
        }
        Charset encoding = charset;
        return Buf$.MODULE$.decodeString(this.content(), encoding);
    }

    public String getContentString() {
        return this.contentString();
    }

    public void contentString_$eq(String value) {
        String string = value;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.clearContent();
        } else {
            this.content_$eq(Buf.Utf8$.MODULE$.apply(value));
        }
    }

    public final void setContentString(String value) {
        this.contentString_$eq(value);
    }

    public <T> T withInputStream(Function1<InputStream, T> f) {
        Object object;
        try (InputStream inputStream = this.getInputStream();){
            object = f.apply((Object)inputStream);
        }
        return (T)object;
    }

    public final InputStream getInputStream() {
        return new BufInputStream(this.content());
    }

    public final <T> T withReader(Function1<Reader, T> f) {
        return this.withInputStream((Function1 & Serializable & scala.Serializable)inputStream -> {
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return f.apply((Object)reader);
        });
    }

    public final Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public final void write(String string) throws IllegalStateException {
        this.write(Buf.Utf8$.MODULE$.apply(string));
    }

    public final void write(Buf buf) throws IllegalStateException {
        if (this.isChunked()) {
            throw new IllegalStateException("Cannot write buffers to a chunked message!");
        }
        this.content_$eq(this.content().concat(buf));
    }

    public final void write(byte[] bytes) throws IllegalStateException {
        this.write(Buf.ByteArray$.Shared$.MODULE$.apply(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withOutputStream(Function1<OutputStream, T> f) throws IllegalStateException {
        void v0;
        try (BufOutputStream outputStream = new BufOutputStream(1024);){
            void var3_3;
            Object result = f.apply((Object)outputStream);
            this.write(outputStream.contentsAsBuf());
            v0 = var3_3;
        }
        return v0;
    }

    public final <T> T withWriter(Function1<Writer, T> f) throws IllegalStateException {
        return this.withOutputStream((Function1 & Serializable & scala.Serializable)outputStream -> {
            Object object;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
                object = f.apply((Object)writer);
            }
            return object;
        });
    }

    public final void clearContent() {
        this.content_$eq(Buf$.MODULE$.Empty());
    }

    public Future<BoxedUnit> close() {
        return this.writer().close();
    }

    public final Message keepAlive(boolean keepAlive) {
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http10();
        Version version3 = version;
        Object object = !(version2 != null ? !((Object)version2).equals(version3) : version3 != null) ? (keepAlive ? this.headerMap().setUnsafe("Connection", "keep-alive") : this.headerMap().remove("Connection")) : (keepAlive ? this.headerMap().remove("Connection") : this.headerMap().setUnsafe("Connection", "close"));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean keepAlive() {
        String value;
        boolean bl = false;
        Some some = null;
        Option<String> option = this.headerMap().get("Connection");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String value2 = (String)some.value();
            if (value2.equalsIgnoreCase("close")) {
                return false;
            }
        }
        if (bl && (value = (String)some.value()).equalsIgnoreCase("keep-alive")) {
            return true;
        }
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http11();
        if (version != null) {
            if (!((Object)version).equals(version2)) return false;
            return true;
        }
        if (version2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$accept$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$acceptMediaTypes$3(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$charset$1(Object nonLocalReturnKey1$1, String contentType) {
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), parts.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String part = ((String)parts.apply(i)).trim();
            if (part.startsWith("charset=")) {
                int equalsIndex = part.indexOf(61);
                String charset = part.substring(equalsIndex + 1);
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)charset));
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$charset_$eq$2(String x$6) {
        return x$6.trim().startsWith("charset=");
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$3(IndexedSeq parts$2, StringBuilder builder$1, int i) {
        builder$1.append(";");
        return builder$1.append((String)parts$2.apply(i));
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$4(String value$1, IndexedSeq parts$2, StringBuilder builder$1, int i) {
        StringBuilder stringBuilder;
        String part = (String)parts$2.apply(i);
        if (part.trim().startsWith("charset=")) {
            builder$1.append(";charset=");
            stringBuilder = builder$1.append(value$1);
        } else {
            builder$1.append(";");
            stringBuilder = builder$1.append(part);
        }
        return stringBuilder;
    }

    public static final /* synthetic */ long $anonfun$contentLength$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$isXmlHttpRequest$1(String x$8) {
        return x$8.toLowerCase().contains("xmlhttprequest");
    }

    public static final class BufOutputStream
    extends ByteArrayOutputStream {
        public Buf contentsAsBuf() {
            return Buf.ByteArray$.Owned$.MODULE$.apply(this.buf, 0, this.count);
        }

        public BufOutputStream(int initialSize) {
            super(initialSize);
        }
    }
}

