/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.cookie;

import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.cookie.SameSite;
import com.twitter.finagle.http.cookie.SameSite$Lax$;
import com.twitter.finagle.http.cookie.SameSite$None$;
import com.twitter.finagle.http.cookie.SameSite$Strict$;
import com.twitter.finagle.http.cookie.SameSite$Unset$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.LoadedStatsReceiver$;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import io.netty.handler.codec.http.CookieDecoder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class SameSiteCodec$ {
    public static SameSiteCodec$ MODULE$;
    private final Logger log;
    private final Class<CookieDecoder> cookieDecoderClass;
    private final Counter initFailureCounter;
    private final Option<Method> _extractKeyValuePairs;

    static {
        new SameSiteCodec$();
    }

    private Logger log() {
        return this.log;
    }

    private Class<CookieDecoder> cookieDecoderClass() {
        return this.cookieDecoderClass;
    }

    private Counter initFailureCounter() {
        return this.initFailureCounter;
    }

    private Option<Method> _extractKeyValuePairs() {
        return this._extractKeyValuePairs;
    }

    private void extractKeyValuePairs(String header, List<String> names, List<String> values) {
        Option<Method> option = this._extractKeyValuePairs();
        if (option instanceof Some) {
            Some some = (Some)option;
            Method method = (Method)some.value();
            method.invoke(null, header, names, values);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public String encodeSameSite(Cookie cookie, String encoded) {
        SameSite sameSite = cookie.sameSite();
        String string = SameSite$Lax$.MODULE$.equals(sameSite) ? new StringBuilder(14).append(encoded).append("; SameSite=Lax").toString() : (SameSite$Strict$.MODULE$.equals(sameSite) ? new StringBuilder(17).append(encoded).append("; SameSite=Strict").toString() : (SameSite$None$.MODULE$.equals(sameSite) ? new StringBuilder(15).append(encoded).append("; SameSite=None").toString() : encoded));
        return string;
    }

    public Cookie decodeSameSite(String header, Cookie cookie) {
        Cookie cookie2;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        try {
            this.extractKeyValuePairs(header, names, values);
        }
        catch (Throwable t) {
            this.log().warning(t, "Failed to extract attributes from header.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.initFailureCounter().incr();
            return cookie;
        }
        int len = names.size();
        int pos = -1;
        for (int index = 0; index < len && pos == -1; ++index) {
            if (!names.get(index).equalsIgnoreCase("samesite")) continue;
            pos = index;
        }
        if (pos <= -1) {
            cookie2 = cookie;
        } else {
            SameSite$Lax$ sameSite = values.get(pos).equalsIgnoreCase("lax") ? SameSite$Lax$.MODULE$ : (values.get(pos).equalsIgnoreCase("strict") ? SameSite$Strict$.MODULE$ : (values.get(pos).equalsIgnoreCase("none") ? SameSite$None$.MODULE$ : SameSite$Unset$.MODULE$));
            cookie2 = cookie.sameSite(sameSite);
        }
        return cookie2;
    }

    private final Option liftedTree1$1() {
        None$ none$;
        try {
            Method method = this.cookieDecoderClass().getDeclaredMethod("extractKeyValuePairs", String.class, List.class, List.class);
            method.setAccessible(true);
            none$ = new Some((Object)method);
        }
        catch (Throwable t) {
            this.log().error(t, "Failed to initialize `_extractKeyValuePairs`.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private SameSiteCodec$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply();
        this.cookieDecoderClass = CookieDecoder.class;
        this.initFailureCounter = LoadedStatsReceiver$.MODULE$.scope("http").scope("cookie").counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samesite_failures"}));
        this._extractKeyValuePairs = this.liftedTree1$1();
    }
}

