/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec.context;

import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message;
import com.twitter.finagle.http.codec.context.HttpBackupRequest$;
import com.twitter.finagle.http.codec.context.HttpContext;
import com.twitter.finagle.http.codec.context.HttpDeadline$;
import com.twitter.finagle.http.codec.context.HttpRetries$;
import com.twitter.finagle.http.codec.context.LoadableHttpContext;
import com.twitter.finagle.util.LoadService$;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class HttpContext$ {
    public static HttpContext$ MODULE$;
    private final Logger log;
    private final String Prefix;
    private final HttpContext[] knownContextTypes;
    private final HttpContext[] loadedContextTypes;
    private final HttpContext[] allContextTypes;

    static {
        new HttpContext$();
    }

    private Logger log() {
        return this.log;
    }

    public String Prefix() {
        return this.Prefix;
    }

    public void removeDeadline(Message msg) {
        msg.headerMap().remove(HttpDeadline$.MODULE$.headerKey());
    }

    public <R> R read(Message msg, Function0<R> fn) {
        Nil$ ctxValues = Nil$.MODULE$;
        for (int i = 0; i < this.allContextTypes.length; ++i) {
            BoxedUnit boxedUnit;
            HttpContext contextType = this.allContextTypes[i];
            Option<String> option = msg.headerMap().get(contextType.headerKey());
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                String header = (String)some.value();
                Try<Object> try_ = contextType.fromHeader(header);
                if (try_ instanceof Return) {
                    Return return_ = (Return)try_;
                    Object ctxVal = return_.r();
                    Context.KeyValuePair keyValuePair = new Context.KeyValuePair((Context)Contexts$.MODULE$.broadcast(), contextType.key(), ctxVal);
                    ctxValues = ctxValues.$colon$colon((Object)keyValuePair);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (try_ instanceof Throw) {
                    BoxedUnit boxedUnit3;
                    if (this.log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        this.log().debug(new StringBuilder(42).append("could not unmarshal ").append(contextType.key()).append(" from the header value").toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    boxedUnit2 = boxedUnit3;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError(option);
        }
        return (R)Contexts$.MODULE$.broadcast().let((Iterable)ctxValues, fn);
    }

    public void write(Message msg) {
        int i;
        for (i = 0; i < this.knownContextTypes.length; ++i) {
            HttpContext contextType = this.knownContextTypes[i];
            this.writeToHeader(contextType, msg.headerMap(), true);
        }
        for (i = 0; i < this.loadedContextTypes.length; ++i) {
            HttpContext contextType = this.loadedContextTypes[i];
            this.writeToHeader(contextType, msg.headerMap(), false);
        }
    }

    private void writeToHeader(HttpContext contextType, HeaderMap headerMap, boolean isSafe) {
        Option option = Contexts$.MODULE$.broadcast().get(contextType.key());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Object ctxVal = some.value();
            if (isSafe) {
                headerMap.setUnsafe(contextType.headerKey(), contextType.toHeader(ctxVal));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                try {
                    headerMap.set(contextType.headerKey(), contextType.toHeader(ctxVal));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit2;
                    Throwable throwable2 = throwable;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option2.isEmpty()) {
                        if (this.log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                            this.log().debug(new StringBuilder(28).append("unable to add ").append(contextType.key()).append(" to the header").toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private HttpContext$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(this.getClass().getName());
        this.Prefix = "Finagle-Ctx-";
        this.knownContextTypes = (HttpContext[])((Object[])new HttpContext[]{HttpDeadline$.MODULE$, HttpRetries$.MODULE$, HttpBackupRequest$.MODULE$});
        ArrayBuffer loaded = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Set ctxKeys = Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.knownContextTypes)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.headerKey(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet());
        LoadService$.MODULE$.apply(ClassTag$.MODULE$.apply(LoadableHttpContext.class)).foreach((Function1 & Serializable & scala.Serializable)httpCtx -> {
            ArrayBuffer arrayBuffer;
            if (ctxKeys.contains((Object)httpCtx.headerKey())) {
                MODULE$.log().warning(new StringBuilder(43).append("skipping duplicate http header context key ").append(httpCtx.headerKey()).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                ctxKeys.$plus$eq((Object)httpCtx.headerKey());
                arrayBuffer = loaded.$plus$eq(httpCtx);
            }
            return arrayBuffer;
        });
        this.loadedContextTypes = (HttpContext[])loaded.toArray(ClassTag$.MODULE$.apply(HttpContext.class));
        this.allContextTypes = (HttpContext[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.knownContextTypes)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.loadedContextTypes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HttpContext.class)));
    }
}

