/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.filter.HttpNackFilter;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.io.Buf;
import scala.MatchError;
import scala.Option;
import scala.Some;

public final class HttpNackFilter$ {
    public static HttpNackFilter$ MODULE$;
    private final Stack.Role role;
    private final String RetryableNackHeader;
    private final String NonRetryableNackHeader;
    private final String RetryableRequestHeader;
    private final Status ResponseStatus;
    private final Buf com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody;
    private final Buf com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody;
    private final long com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags;
    private final long com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags;

    static {
        new HttpNackFilter$();
    }

    public Stack.Role role() {
        return this.role;
    }

    public String RetryableNackHeader() {
        return this.RetryableNackHeader;
    }

    public String NonRetryableNackHeader() {
        return this.NonRetryableNackHeader;
    }

    public String RetryableRequestHeader() {
        return this.RetryableRequestHeader;
    }

    public Status ResponseStatus() {
        return this.ResponseStatus;
    }

    public Buf com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody() {
        return this.com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody;
    }

    public Buf com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody() {
        return this.com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody;
    }

    public long com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags() {
        return this.com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags;
    }

    public long com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags() {
        return this.com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags;
    }

    private boolean containsRetryAfter0(Response rep) {
        Some some;
        String string;
        Option<String> option = rep.headerMap().get("Retry-After");
        boolean bl = option instanceof Some && "0".equals(string = (String)(some = (Some)option).value());
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRetryableNack(Response rep) {
        Status status = rep.status();
        Status status2 = this.ResponseStatus();
        if (status == null) {
            if (status2 != null) {
                return false;
            }
        } else if (!((Object)status).equals(status2)) return false;
        if (rep.headerMap().contains(this.RetryableNackHeader())) return true;
        if (!this.containsRetryAfter0(rep)) return false;
        return true;
    }

    public boolean isNonRetryableNack(Response rep) {
        Status status = rep.status();
        Status status2 = this.ResponseStatus();
        return !(status != null ? !((Object)status).equals(status2) : status2 != null) && rep.headerMap().contains(this.NonRetryableNackHeader());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNack(Response rep) {
        Status status = rep.status();
        Status status2 = this.ResponseStatus();
        if (status == null) {
            if (status2 != null) {
                return false;
            }
        } else if (!((Object)status).equals(status2)) return false;
        if (rep.headerMap().contains(this.RetryableNackHeader())) return true;
        if (!rep.headerMap().contains(this.NonRetryableNackHeader())) return false;
        return true;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return new Stack.Module1<Stats, ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(Stats _stats, ServiceFactory<Request, Response> next) {
                StatsReceiver stats;
                Stats stats2 = _stats;
                if (stats2 == null) {
                    throw new MatchError((Object)stats2);
                }
                StatsReceiver statsReceiver = stats = stats2.statsReceiver();
                StatsReceiver stats3 = statsReceiver;
                return new HttpNackFilter(stats3).andThen(next);
            }
            {
                this.role = HttpNackFilter$.MODULE$.role();
                this.description = "Convert rejected requests to 503s, respecting retryability";
            }
        };
    }

    public SimpleFilter<Request, Response> newFilter(StatsReceiver statsReceiver) {
        return new HttpNackFilter(statsReceiver);
    }

    public boolean com$twitter$finagle$http$filter$HttpNackFilter$$retryableRequest(Request req) {
        return !req.isChunked() && (req.content().isEmpty() || req.headerMap().contains(this.RetryableRequestHeader()));
    }

    private HttpNackFilter$() {
        MODULE$ = this;
        this.role = new Stack.Role("HttpNack");
        this.RetryableNackHeader = "finagle-http-nack";
        this.NonRetryableNackHeader = "finagle-http-nonretryable-nack";
        this.RetryableRequestHeader = "finagle-http-retryable-request";
        this.ResponseStatus = Status$.MODULE$.ServiceUnavailable();
        this.com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackBody = Buf.Utf8$.MODULE$.apply("Request was not processed by the server due to an error and is safe to retry");
        this.com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackBody = Buf.Utf8$.MODULE$.apply("Request was not processed by the server and should not be retried");
        this.com$twitter$finagle$http$filter$HttpNackFilter$$NonRetryableNackFlags = FailureFlags$.MODULE$.Rejected() | FailureFlags$.MODULE$.NonRetryable();
        this.com$twitter$finagle$http$filter$HttpNackFilter$$RetryableNackFlags = FailureFlags$.MODULE$.Rejected() | FailureFlags$.MODULE$.Retryable();
    }
}

