/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.Chunk;
import com.twitter.finagle.http.Chunk$;
import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.CookieMap;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.finagle.http.util.StringUtil$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.BufInputStream;
import com.twitter.io.Reader$;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\reh!\u00020`\u0003\u0003A\u0007\"B8\u0001\t\u0003\u0001\bBB:\u0001A\u0003&A\u000f\u0003\u0004\u007f\u0001\u0001\u0006Ka \u0005\t\u0003\u000f\u0001\u0001\u0015)\u0003\u0002\n!9\u0011\u0011\u0003\u0001\u0007\u0002\u0005M\u0001bBA\u0011\u0001\u0019\u0005\u00111\u0005\u0005\u000b\u0003W\u0001\u0001R1A\u0005\u0006\u00055\u0002BCA\u0019\u0001!\u0015\r\u0011\"\u0002\u00024!9\u0011q\u0007\u0001\u0007\u0002\u0005e\u0002bBA\u001e\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!!\u0010\u0001\t\u000b\t\t\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"9\u00111\u0019\u0001\u0005\u0006\u00055\u0007bBAi\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\tY\u000e\u0001D\u0001\u0003;Dq!!:\u0001\r\u0003\ti\u000e\u0003\u0006\u0002h\u0002A)\u0019!C\u0001\u0003SDq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005C\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011\t\u0005\u0001C\u0001\u00053AqAa\u0011\u0001\t\u0003\u0011)\u0005C\u0004\u0003D\u0001!\tA!\u0013\t\u000f\te\u0003\u0001\"\u0001\u0003\u001a!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B1\u0001\u0011\u0005!1\r\u0005\b\u0005[\u0002AQ\u0001B8\u0011\u001d\u0011)\b\u0001C\u0001\u0005oBqA!\u0019\u0001\t\u000b\u0011Y\bC\u0004\u0003\u0000\u0001!\tA!\u0007\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\"9!q\u0011\u0001\u0005\u0002\t%\u0005\"\u0003BI\u0001E\u0005I\u0011\u0001BJ\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WCqA!,\u0001\t\u0003\u0011I\u0002C\u0004\u00030\u0002!\tA!-\t\u000f\t=\u0006\u0001\"\u0001\u00036\"9!q\u0018\u0001\u0005\u0002\te\u0001b\u0002Ba\u0001\u0011\u0005!1\u0019\u0005\b\u0005\u0003\u0004A\u0011\u0001Bd\u0011\u001d\u0011Y\r\u0001C\u0001\u00053AqA!4\u0001\t\u0003\u0011y\rC\u0004\u0003N\u0002!\tAa5\t\u000f\t5\u0005\u0001\"\u0001\u0003\u001a!9!q\u001b\u0001\u0005\u0002\te\u0007b\u0002Bo\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0005?\u0004AQ\u0001Bq\u0011\u001d\u0011I\u000f\u0001C\u0003\u0005WDqA!<\u0001\t\u0003\t\t\tC\u0004\u0003p\u0002!\tA!=\t\u000f\tM\b\u0001\"\u0001\u0003v\"9!\u0011 \u0001\u0005\u0006\tm\bb\u0002B\u0000\u0001\u0011\u00051\u0011\u0001\u0005\b\u0007O\u0001AQAB\u0015\u0011\u001d\u0019Y\u0003\u0001C\u0003\u0007[Aqa!\u0010\u0001\t\u000b\u0019y\u0004C\u0004\u0004B\u0001!)aa\u0011\t\u000f\r\u0005\u0003\u0001\"\u0002\u0004N!91\u0011\t\u0001\u0005\u0006\rU\u0003bBB5\u0001\u0011\u001511\u000e\u0005\b\u0007\u007f\u0002AQABA\u0011\u001d\u0019\u0019\n\u0001C\u0003\u0005WCqa!&\u0001\t\u0003\u00199\nC\u0004\u0004 \u0002!)a!)\t\u000f\r}\u0005\u0001\"\u0002\u0002:\u001d91QU0\t\u0002\r\u001dfA\u00020`\u0011\u0003\u0019I\u000b\u0003\u0004p\u0015\u0012\u000511\u0016\u0004\u0007\u0007[Seaa,\t\u0015\r]FJ!A!\u0002\u0013\u0011\u0019\u000f\u0003\u0004p\u0019\u0012\u00051\u0011\u0018\u0005\b\u0007\u0003dE\u0011AA \u0011%\u0019\u0019M\u0013b\u0001\n\u0003\t\t\t\u0003\u0005\u0004F*\u0003\u000b\u0011BA4\u0011%\u00199M\u0013b\u0001\n\u0003\t\t\t\u0003\u0005\u0004J*\u0003\u000b\u0011BA4\u0011%\u0019YM\u0013b\u0001\n\u0003\t\t\t\u0003\u0005\u0004N*\u0003\u000b\u0011BA4\u0011%\u0019yM\u0013b\u0001\n\u0003\t\t\t\u0003\u0005\u0004R*\u0003\u000b\u0011BA4\u0011%\u0019\u0019N\u0013b\u0001\n\u0003\t\t\t\u0003\u0005\u0004V*\u0003\u000b\u0011BA4\u0011%\u00199N\u0013b\u0001\n\u0013\u0019I\u000e\u0003\u0005\u0004l*\u0003\u000b\u0011BBn\u0011\u001d\u0019iO\u0013C\u0001\u0007_Dqa!<K\t\u0003\u0019\u0019PA\u0004NKN\u001c\u0018mZ3\u000b\u0005\u0001\f\u0017\u0001\u00025uiBT!AY2\u0002\u000f\u0019Lg.Y4mK*\u0011A-Z\u0001\bi^LG\u000f^3s\u0015\u00051\u0017aA2p[\u000e\u00011C\u0001\u0001j!\tQW.D\u0001l\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018l\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u001d\t\u0003e\u0002i\u0011aX\u0001\t?\u000e|g\u000e^3oiB\u0011Q\u000f_\u0007\u0002m*\u0011qoY\u0001\u0003S>L!!\u001f<\u0003\u0007\t+h\r\u000b\u0002\u0003wB\u0011!\u000e`\u0005\u0003{.\u0014\u0001B^8mCRLG.Z\u0001\t?Z,'o]5p]B\u0019!/!\u0001\n\u0007\u0005\rqLA\u0004WKJ\u001c\u0018n\u001c8)\u0005\rY\u0018\u0001C0dQVt7.\u001a3\u0011\u0007)\fY!C\u0002\u0002\u000e-\u0014qAQ8pY\u0016\fg\u000e\u000b\u0002\u0005w\u0006Y1\r[;oWJ+\u0017\rZ3s+\t\t)\u0002E\u0003v\u0003/\tY\"C\u0002\u0002\u001aY\u0014aAU3bI\u0016\u0014\bc\u0001:\u0002\u001e%\u0019\u0011qD0\u0003\u000b\rCWO\\6\u0002\u0017\rDWO\\6Xe&$XM]\u000b\u0003\u0003K\u0001R!^A\u0014\u00037I1!!\u000bw\u0005\u00199&/\u001b;fe\u00061!/Z1eKJ,\"!a\f\u0011\tU\f9\u0002^\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005U\u0002\u0003B;\u0002(Q\f\u0011\"[:SKF,Xm\u001d;\u0016\u0005\u0005%\u0011AC5t%\u0016\u001c\bo\u001c8tK\u000691m\u001c8uK:$X#\u0001;\u0002\u0017\r|g\u000e^3oi~#S-\u001d\u000b\u0005\u0003\u000b\nY\u0005E\u0002k\u0003\u000fJ1!!\u0013l\u0005\u0011)f.\u001b;\t\r\u0005uB\u00021\u0001uQ\u0015a\u0011qJA3!\u0015Q\u0017\u0011KA+\u0013\r\t\u0019f\u001b\u0002\u0007i\"\u0014xn^:\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!A.\u00198h\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA2\u00033\u0012Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g.M\u0004\u001f\u0003O\ni(a,\u0011\t\u0005%\u0014q\u000f\b\u0005\u0003W\n\u0019\bE\u0002\u0002n-l!!a\u001c\u000b\u0007\u0005Et-\u0001\u0004=e>|GOP\u0005\u0004\u0003kZ\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twMC\u0002\u0002v-\f\u0014bIA@\u0003\u000f\u000b)+!#\u0016\t\u0005\u0005\u00151Q\u000b\u0003\u0003O\"q!!\"h\u0005\u0004\tyIA\u0001U\u0013\u0011\tI)a#\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tii[\u0001\u0007i\"\u0014xn^:\u0012\t\u0005E\u0015q\u0013\t\u0004U\u0006M\u0015bAAKW\n9aj\u001c;iS:<\u0007\u0003BAM\u0003?s1A[AN\u0013\r\tij[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t+a)\u0003\u0013QC'o\\<bE2,'bAAOWFJ1%a*\u0002*\u0006-\u0016Q\u0012\b\u0004U\u0006%\u0016bAAGWF*!E[6\u0002.\n)1oY1mCF\u001aa%!\u0016\u0015\t\u0005M\u0016QW\u0007\u0002\u0001!1\u0011QH\u0007A\u0002QDS!DA(\u0003s\u000btAHA4\u0003w\u000b\t-M\u0005$\u0003\u007f\n9)!0\u0002\nFJ1%a*\u0002*\u0006}\u0016QR\u0019\u0006E)\\\u0017QV\u0019\u0004M\u0005U\u0013a\u0002<feNLwN\\\u000b\u0002\u007f\u0006Ya/\u001a:tS>tw\fJ3r)\u0011\t)%a3\t\r\u0005\rw\u00021\u0001\u0000)\u0011\t\u0019,a4\t\r\u0005\r\u0007\u00031\u0001\u0000\u0003%I7o\u00115v].,G-\u0001\u0006tKR\u001c\u0005.\u001e8lK\u0012$B!!\u0012\u0002X\"9\u0011\u0011\u001c\nA\u0002\u0005%\u0011aB2ik:\\W\rZ\u0001\nQ\u0016\fG-\u001a:NCB,\"!a8\u0011\u0007I\f\t/C\u0002\u0002d~\u0013\u0011\u0002S3bI\u0016\u0014X*\u00199\u0002\u0011Q\u0014\u0018-\u001b7feN\fqaY8pW&,7/\u0006\u0002\u0002lB\u0019!/!<\n\u0007\u0005=xLA\u0005D_>\\\u0017.Z'ba\u0006Qq-\u001a;D_>\\\u0017.Z:\u0015\u0005\u0005U\bCBA|\u0003{\u0014\t!\u0004\u0002\u0002z*!\u00111`A/\u0003\u0011)H/\u001b7\n\t\u0005}\u0018\u0011 \u0002\t\u0013R,'/\u0019;peB\u0019!Oa\u0001\n\u0007\t\u0015qL\u0001\u0004D_>\\\u0017.Z\u0001\nC\u0012$7i\\8lS\u0016$B!!\u0012\u0003\f!9!QB\fA\u0002\t\u0005\u0011AB2p_.LW-\u0001\u0007sK6|g/Z\"p_.LW\r\u0006\u0003\u0002F\tM\u0001b\u0002B\u000b1\u0001\u0007\u0011qM\u0001\u0005]\u0006lW-A\u0003bY2|w/\u0006\u0002\u0003\u001cA)!N!\b\u0002h%\u0019!qD6\u0003\r=\u0003H/[8o\u0003%\tG\u000e\\8x?\u0012*\u0017\u000f\u0006\u0003\u0002F\t\u0015\u0002b\u0002B\u00145\u0001\u0007\u0011qM\u0001\u0006m\u0006dW/\u001a\u000b\u0005\u0003\u000b\u0012Y\u0003C\u0004\u0003.m\u0001\rAa\f\u0002\rY\fG.^3t!\u0019\u0011\tDa\u000e\u0003<9!!1GAN\u001d\u0011\tiG!\u000e\n\u00031LAA!\u000f\u0002$\nA\u0011\n^3sC\ndW\rE\u0002s\u0005{I1Aa\u0010`\u0005\u0019iU\r\u001e5pI\u0006a1-Y2iK\u000e{g\u000e\u001e:pY\u0006\u00012-Y2iK\u000e{g\u000e\u001e:pY~#S-\u001d\u000b\u0005\u0003\u000b\u00129\u0005C\u0004\u0003(u\u0001\r!a\u001a\u0015\t\u0005\u0015#1\n\u0005\b\u0005\u001br\u0002\u0019\u0001B(\u0003\u0019i\u0017\r_!hKB!!\u0011\u000bB+\u001b\t\u0011\u0019FC\u0002\u0002|\u000eLAAa\u0016\u0003T\tAA)\u001e:bi&|g.A\u0004dQ\u0006\u00148/\u001a;\u0002\u0017\rD\u0017M]:fi~#S-\u001d\u000b\u0005\u0003\u000b\u0012y\u0006C\u0004\u0003(\u0001\u0002\r!a\u001a\u0002\u001b\r|g\u000e^3oi2+gn\u001a;i+\t\u0011)\u0007E\u0003k\u0005;\u00119\u0007E\u0002k\u0005SJ1Aa\u001bl\u0005\u0011auN\\4\u0002'\r|g\u000e^3oi2+gn\u001a;i\u001fJ,En]3\u0015\t\t\u001d$\u0011\u000f\u0005\b\u0005g\u0012\u0003\u0019\u0001B4\u0003\u001d!WMZ1vYR\f\u0011cY8oi\u0016tG\u000fT3oORDw\fJ3r)\u0011\t)E!\u001f\t\u000f\t\u001d2\u00051\u0001\u0003hQ!\u00111\u0017B?\u0011\u001d\u00119\u0003\na\u0001\u0005O\n1bY8oi\u0016tG\u000fV=qK\u0006y1m\u001c8uK:$H+\u001f9f?\u0012*\u0017\u000f\u0006\u0003\u0002F\t\u0015\u0005b\u0002B\u0014M\u0001\u0007\u0011qM\u0001\u000fg\u0016$8i\u001c8uK:$H+\u001f9f)\u0019\t)Ea#\u0003\u0010\"9!QR\u0014A\u0002\u0005\u001d\u0014!C7fI&\fG+\u001f9f\u0011%\u0011If\nI\u0001\u0002\u0004\t9'\u0001\rtKR\u001cuN\u001c;f]R$\u0016\u0010]3%I\u00164\u0017-\u001e7uII*\"A!&+\t\u0005\u001d$qS\u0016\u0003\u00053\u0003BAa'\u0003&6\u0011!Q\u0014\u0006\u0005\u0005?\u0013\t+A\u0005v]\u000eDWmY6fI*\u0019!1U6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003(\nu%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00112/\u001a;D_:$XM\u001c;UsB,'j]8o)\t\t)%\u0001\u0003eCR,\u0017\u0001\u00033bi\u0016|F%Z9\u0015\t\u0005\u0015#1\u0017\u0005\b\u0005OY\u0003\u0019AA4)\u0011\t)Ea.\t\u000f\t\u001dB\u00061\u0001\u0003:B!\u0011q\u001fB^\u0013\u0011\u0011i,!?\u0003\t\u0011\u000bG/Z\u0001\bKb\u0004\u0018N]3t\u0003-)\u0007\u0010]5sKN|F%Z9\u0015\t\u0005\u0015#Q\u0019\u0005\b\u0005Oq\u0003\u0019AA4)\u0011\t)E!3\t\u000f\t\u001dr\u00061\u0001\u0003:\u0006aA.Y:u\u001b>$\u0017NZ5fI\u0006\u0001B.Y:u\u001b>$\u0017NZ5fI~#S-\u001d\u000b\u0005\u0003\u000b\u0012\t\u000eC\u0004\u0003(E\u0002\r!a\u001a\u0015\t\u0005\u0015#Q\u001b\u0005\b\u0005O\u0011\u0004\u0019\u0001B]\u00035iW\rZ5b)f\u0004Xm\u0018\u0013fcR!\u0011Q\tBn\u0011\u001d\u00119\u0003\u000ea\u0001\u0003O\n\u0001#[:Y[2DE\u000f\u001e9SKF,Xm\u001d;\u0002\r1,gn\u001a;i+\t\u0011\u0019\u000fE\u0002k\u0005KL1Aa:l\u0005\rIe\u000e^\u0001\nO\u0016$H*\u001a8hi\"$\"Aa9\u0002\u001b\r|g\u000e^3oiN#(/\u001b8h\u0003A9W\r^\"p]R,g\u000e^*ue&tw\r\u0006\u0002\u0002h\u0005\t2m\u001c8uK:$8\u000b\u001e:j]\u001e|F%Z9\u0015\t\u0005\u0015#q\u001f\u0005\b\u0005OQ\u0004\u0019AA4\u0003A\u0019X\r^\"p]R,g\u000e^*ue&tw\r\u0006\u0003\u0002F\tu\bb\u0002B\u0014w\u0001\u0007\u0011qM\u0001\u0010o&$\b.\u00138qkR\u001cFO]3b[V!11AB\u0005)\u0011\u0019)aa\u0005\u0011\t\r\u001d1\u0011\u0002\u0007\u0001\t\u001d\t)\t\u0010b\u0001\u0007\u0017\tB!!%\u0004\u000eA\u0019!na\u0004\n\u0007\rE1NA\u0002B]fDqa!\u0006=\u0001\u0004\u00199\"A\u0001g!\u001dQ7\u0011DB\u000f\u0007\u000bI1aa\u0007l\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0004 \r\rRBAB\u0011\u0015\r9\u0018QL\u0005\u0005\u0007K\u0019\tCA\u0006J]B,Ho\u0015;sK\u0006l\u0017AD4fi&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003\u0007;\t!b^5uQJ+\u0017\rZ3s+\u0011\u0019yca\r\u0015\t\rE2Q\u0007\t\u0005\u0007\u000f\u0019\u0019\u0004B\u0004\u0002\u0006z\u0012\raa\u0003\t\u000f\rUa\b1\u0001\u00048A9!n!\u0007\u0004:\rE\u0002\u0003BB\u0010\u0007wIA!!\u0007\u0004\"\u0005Iq-\u001a;SK\u0006$WM\u001d\u000b\u0003\u0007s\tQa\u001e:ji\u0016$B!!\u0012\u0004F!91q\t!A\u0002\u0005\u001d\u0014AB:ue&tw\rK\u0003A\u0003\u001f\u001aYe\t\u0002\u0002VQ!\u0011QIB(\u0011\u0019\u0019\t&\u0011a\u0001i\u0006\u0019!-\u001e4)\u000b\u0005\u000byea\u0013\u0015\t\u0005\u00153q\u000b\u0005\b\u00073\u0012\u0005\u0019AB.\u0003\u0015\u0011\u0017\u0010^3t!\u0015Q7QLB1\u0013\r\u0019yf\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004U\u000e\r\u0014bAB3W\n!!)\u001f;fQ\u0015\u0011\u0015qJB&\u0003A9\u0018\u000e\u001e5PkR\u0004X\u000f^*ue\u0016\fW.\u0006\u0003\u0004n\rED\u0003BB8\u0007g\u0002Baa\u0002\u0004r\u00119\u0011QQ\"C\u0002\r-\u0001bBB\u000b\u0007\u0002\u00071Q\u000f\t\bU\u000ee1qOB8!\u0011\u0019yb!\u001f\n\t\rm4\u0011\u0005\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0015\u0006\u0007\u0006=31J\u0001\u000bo&$\bn\u0016:ji\u0016\u0014X\u0003BBB\u0007\u000f#Ba!\"\u0004\nB!1qABD\t\u001d\t)\t\u0012b\u0001\u0007\u0017Aqa!\u0006E\u0001\u0004\u0019Y\tE\u0004k\u00073\u0019ii!\"\u0011\t\r}1qR\u0005\u0005\u0003S\u0019\t\u0003K\u0003E\u0003\u001f\u001aY%\u0001\u0007dY\u0016\f'oQ8oi\u0016tG/A\u0003dY>\u001cX\r\u0006\u0002\u0004\u001aB1!\u0011KBN\u0003\u000bJAa!(\u0003T\t1a)\u001e;ve\u0016\f\u0011b[3fa\u0006c\u0017N^3\u0015\t\u0005M61\u0015\u0005\b\u0007?;\u0005\u0019AA\u0005\u0003\u001diUm]:bO\u0016\u0004\"A\u001d&\u0014\u0005)KGCABT\u0005=\u0011UOZ(viB,Ho\u0015;sK\u0006l7c\u0001'\u00042B!1qDBZ\u0013\u0011\u0019)l!\t\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\u0006Y\u0011N\\5uS\u0006d7+\u001b>f)\u0011\u0019Yla0\u0011\u0007\ruF*D\u0001K\u0011\u001d\u00199L\u0014a\u0001\u0005G\fQbY8oi\u0016tGo]!t\u0005V4\u0017aC\"iCJ\u001cX\r^+uMb\nAb\u00115beN,G/\u0016;gq\u0001\nqbQ8oi\u0016tG\u000fV=qK*\u001bxN\\\u0001\u0011\u0007>tG/\u001a8u)f\u0004XMS:p]\u0002\nAcQ8oi\u0016tG\u000fV=qK*\u001bxN\u001c)bi\u000eD\u0017!F\"p]R,g\u000e\u001e+za\u0016T5o\u001c8QCR\u001c\u0007\u000eI\u0001\u0016\u0007>tG/\u001a8u)f\u0004XMS1wCN\u001c'/\u001b9u\u0003Y\u0019uN\u001c;f]R$\u0016\u0010]3KCZ\f7o\u0019:jaR\u0004\u0013AE\"p]R,g\u000e\u001e+za\u0016<vo\u001e$pe6\f1cQ8oi\u0016tG\u000fV=qK^;xOR8s[\u0002\na\u0002\u0013;ua\u0012\u000bG/\u001a$pe6\fG/\u0006\u0002\u0004\\B!1Q\\Bt\u001b\t\u0019yN\u0003\u0003\u0004b\u000e\r\u0018A\u00024pe6\fGO\u0003\u0003\u0004f\u0006u\u0013\u0001\u0002;j[\u0016LAa!;\u0004`\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\u0002\u001f!#H\u000f\u001d#bi\u00164uN]7bi\u0002\na\u0002\u001b;ua\u0012\u000bG/\u001a$pe6\fG\u000f\u0006\u0003\u0002h\rE\bb\u0002BW9\u0002\u0007!\u0011\u0018\u000b\u0005\u0003O\u001a)\u0010C\u0004\u0004xv\u0003\rAa\u001a\u0002\r5LG\u000e\\5t\u0001")
public abstract class Message {
    private com.twitter.io.Reader<Buf> reader;
    private com.twitter.io.Writer<Buf> writer;
    private CookieMap cookies;
    private volatile Buf _content = Buf$.MODULE$.Empty();
    private volatile Version _version = Version$.MODULE$.Http11();
    private volatile boolean _chunked = false;
    private volatile byte bitmap$0;

    public static String httpDateFormat(long l) {
        return Message$.MODULE$.httpDateFormat(l);
    }

    public static String httpDateFormat(Date date) {
        return Message$.MODULE$.httpDateFormat(date);
    }

    public static String ContentTypeWwwForm() {
        return Message$.MODULE$.ContentTypeWwwForm();
    }

    public static String ContentTypeJavascript() {
        return Message$.MODULE$.ContentTypeJavascript();
    }

    public static String ContentTypeJsonPatch() {
        return Message$.MODULE$.ContentTypeJsonPatch();
    }

    public static String ContentTypeJson() {
        return Message$.MODULE$.ContentTypeJson();
    }

    public static String CharsetUtf8() {
        return Message$.MODULE$.CharsetUtf8();
    }

    public abstract com.twitter.io.Reader<Chunk> chunkReader();

    public abstract com.twitter.io.Writer<Chunk> chunkWriter();

    private com.twitter.io.Reader<Buf> reader$lzycompute() {
        Message message = this;
        synchronized (message) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reader = this.chunkReader().flatMap((Function1 & Serializable & scala.Serializable)chunk -> chunk.isLast() && chunk.content().isEmpty() ? Reader$.MODULE$.empty() : Reader$.MODULE$.value((Object)chunk.content()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reader;
    }

    public final com.twitter.io.Reader<Buf> reader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reader$lzycompute() : this.reader;
    }

    private com.twitter.io.Writer<Buf> writer$lzycompute() {
        Message message = this;
        synchronized (message) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.writer = this.chunkWriter().contramap((Function1 & Serializable & scala.Serializable)content -> Chunk$.MODULE$.apply((Buf)content));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.writer;
    }

    public final com.twitter.io.Writer<Buf> writer() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.writer$lzycompute() : this.writer;
    }

    public abstract boolean isRequest();

    public boolean isResponse() {
        return !this.isRequest();
    }

    public Buf content() {
        return this._content;
    }

    public void content_$eq(Buf content) throws IllegalStateException {
        if (!content.isEmpty() && this.isChunked()) {
            throw new IllegalStateException("Cannot set content on Chunked message");
        }
        this._content = content;
    }

    public final Message content(Buf content) throws IllegalStateException {
        this.content_$eq(content);
        return this;
    }

    public Version version() {
        return this._version;
    }

    public void version_$eq(Version version) {
        this._version = version;
    }

    public final Message version(Version version) {
        this.version_$eq(version);
        return this;
    }

    public boolean isChunked() {
        return this._chunked;
    }

    public void setChunked(boolean chunked) {
        block0: {
            this._chunked = chunked;
            if (!chunked) break block0;
            this.clearContent();
        }
    }

    public abstract HeaderMap headerMap();

    public abstract HeaderMap trailers();

    private CookieMap cookies$lzycompute() {
        Message message = this;
        synchronized (message) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.cookies = new CookieMap(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.cookies;
    }

    public CookieMap cookies() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.cookies$lzycompute() : this.cookies;
    }

    public Iterator<Cookie> getCookies() {
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.cookies().valuesIterator()).asJava();
    }

    public void addCookie(Cookie cookie) {
        this.cookies().$plus$eq(cookie);
    }

    public void removeCookie(String name) {
        this.cookies().$minus$eq(name);
    }

    public Option<String> allow() {
        return this.headerMap().get("Allow");
    }

    public void allow_$eq(String value) {
        this.headerMap().set("Allow", value);
    }

    public void allow_$eq(Iterable<Method> values) {
        this.allow_$eq(values.mkString(",").toUpperCase());
    }

    public Option<String> cacheControl() {
        return this.headerMap().get("Cache-Control");
    }

    public void cacheControl_$eq(String value) {
        this.headerMap().set("Cache-Control", value);
    }

    public void cacheControl_$eq(Duration maxAge) {
        this.cacheControl_$eq(new java.lang.StringBuilder(25).append("max-age=").append(((Object)BoxesRunTime.boxToInteger((int)maxAge.inSeconds())).toString()).append(", must-revalidate").toString());
    }

    public Option<String> charset() {
        String cType = this.headerMap().getOrNull("Content-Type");
        if (cType == null) {
            return None$.MODULE$;
        }
        int charsetIdx = cType.indexOf("charset=");
        if (charsetIdx == -1) {
            return None$.MODULE$;
        }
        int valueIdx = charsetIdx + "charset=".length();
        int semicolonIdx = cType.indexOf(59, valueIdx);
        int endIdx = semicolonIdx == -1 ? cType.length() : semicolonIdx;
        return new Some((Object)cType.substring(valueIdx, endIdx).trim());
    }

    public void charset_$eq(String value) {
        String contentType = (String)this.contentType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        if (parts.isEmpty()) {
            this.contentType_$eq(new java.lang.StringBuilder(9).append(";charset=").append(value).toString());
            return;
        }
        StringBuilder builder = new StringBuilder((String)parts.apply(0));
        if (!parts.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$charset_$eq$2(x$1)))) {
            builder.append(";charset=");
            builder.append(value);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), parts.length()).foreach((Function1 & Serializable & scala.Serializable)i -> Message.$anonfun$charset_$eq$3(builder, parts, BoxesRunTime.unboxToInt((Object)i)));
        } else {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), parts.length()).foreach((Function1 & Serializable & scala.Serializable)i -> Message.$anonfun$charset_$eq$4(parts, builder, value, BoxesRunTime.unboxToInt((Object)i)));
        }
        this.contentType_$eq(builder.toString());
    }

    public Option<Object> contentLength() {
        return this.headerMap().get("Content-Length").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)Message.$anonfun$contentLength$1(x$2)));
    }

    public final long contentLengthOrElse(long l) {
        long l2;
        Option<Object> option = this.contentLength();
        if (option instanceof Some) {
            long len;
            Some some = (Some)option;
            l2 = len = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l2 = l;
        } else {
            throw new MatchError(option);
        }
        return l2;
    }

    public void contentLength_$eq(long value) {
        this.headerMap().setUnsafe("Content-Length", ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public final Message contentLength(long value) {
        this.contentLength_$eq(value);
        return this;
    }

    public Option<String> contentType() {
        return this.headerMap().get("Content-Type");
    }

    public void contentType_$eq(String value) {
        this.headerMap().set("Content-Type", value);
    }

    public void setContentType(String mediaType, String charset) {
        this.headerMap().set("Content-Type", new java.lang.StringBuilder(9).append(mediaType).append(";charset=").append(charset).toString());
    }

    public String setContentType$default$2() {
        return "utf-8";
    }

    public void setContentTypeJson() {
        this.headerMap().setUnsafe("Content-Type", Message$.MODULE$.ContentTypeJson());
    }

    public Option<String> date() {
        return this.headerMap().get("Date");
    }

    public void date_$eq(String value) {
        this.headerMap().set("Date", value);
    }

    public void date_$eq(Date value) {
        this.date_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> expires() {
        return this.headerMap().get("Expires");
    }

    public void expires_$eq(String value) {
        this.headerMap().set("Expires", value);
    }

    public void expires_$eq(Date value) {
        this.expires_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> lastModified() {
        return this.headerMap().get("Last-Modified");
    }

    public void lastModified_$eq(String value) {
        this.headerMap().set("Last-Modified", value);
    }

    public void lastModified_$eq(Date value) {
        this.lastModified_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> mediaType() {
        return this.contentType().flatMap((Function1 & Serializable & scala.Serializable)contentType -> {
            String string;
            int n = contentType.indexOf(";");
            switch (n) {
                case -1: {
                    string = contentType;
                    break;
                }
                default: {
                    string = contentType.substring(0, n);
                    break;
                }
            }
            String beforeSemi = string;
            String mediaType = beforeSemi.trim();
            return new StringOps(Predef$.MODULE$.augmentString(mediaType)).nonEmpty() ? new Some((Object)mediaType.toLowerCase()) : None$.MODULE$;
        });
    }

    public void mediaType_$eq(String value) {
        Option<String> option = this.contentType();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String contentType = (String)some.value();
            IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';', 2);
            if (parts.length() == 2) {
                this.contentType_$eq(new java.lang.StringBuilder(1).append(value).append(";").append(parts.apply(1)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.contentType_$eq(value);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.contentType_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public boolean isXmlHttpRequest() {
        return this.headerMap().get("X-Requested-With").exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$isXmlHttpRequest$1(x$3)));
    }

    public final int length() {
        return this.content().length();
    }

    public final int getLength() {
        return this.length();
    }

    public String contentString() {
        Charset charset;
        try {
            charset = Charset.forName((String)this.charset().getOrElse((Function0 & Serializable & scala.Serializable)() -> "UTF-8"));
        }
        catch (Throwable throwable) {
            charset = StandardCharsets.UTF_8;
        }
        Charset encoding = charset;
        return Buf$.MODULE$.decodeString(this.content(), encoding);
    }

    public String getContentString() {
        return this.contentString();
    }

    public void contentString_$eq(String value) {
        String string = value;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.clearContent();
        } else {
            this.content_$eq(Buf.Utf8$.MODULE$.apply(value));
        }
    }

    public final void setContentString(String value) {
        this.contentString_$eq(value);
    }

    public <T> T withInputStream(Function1<InputStream, T> f) {
        Object object;
        try (InputStream inputStream = this.getInputStream();){
            object = f.apply((Object)inputStream);
        }
        return (T)object;
    }

    public final InputStream getInputStream() {
        return new BufInputStream(this.content());
    }

    public final <T> T withReader(Function1<Reader, T> f) {
        return this.withInputStream((Function1 & Serializable & scala.Serializable)inputStream -> {
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return f.apply((Object)reader);
        });
    }

    public final Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public final void write(String string) throws IllegalStateException {
        this.write(Buf.Utf8$.MODULE$.apply(string));
    }

    public final void write(Buf buf) throws IllegalStateException {
        if (this.isChunked()) {
            throw new IllegalStateException("Cannot write buffers to a chunked message!");
        }
        this.content_$eq(this.content().concat(buf));
    }

    public final void write(byte[] bytes) throws IllegalStateException {
        this.write(Buf.ByteArray$.Shared$.MODULE$.apply(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withOutputStream(Function1<OutputStream, T> f) throws IllegalStateException {
        void v0;
        try (BufOutputStream outputStream = new BufOutputStream(1024);){
            void var3_3;
            Object result = f.apply((Object)outputStream);
            this.write(outputStream.contentsAsBuf());
            v0 = var3_3;
        }
        return v0;
    }

    public final <T> T withWriter(Function1<Writer, T> f) throws IllegalStateException {
        return this.withOutputStream((Function1 & Serializable & scala.Serializable)outputStream -> {
            Object object;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
                object = f.apply((Object)writer);
            }
            return object;
        });
    }

    public final void clearContent() {
        this.content_$eq(Buf$.MODULE$.Empty());
    }

    public Future<BoxedUnit> close() {
        return this.writer().close();
    }

    public final Message keepAlive(boolean keepAlive) {
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http10();
        Version version3 = version;
        Object object = !(version2 != null ? !((Object)version2).equals(version3) : version3 != null) ? (keepAlive ? this.headerMap().setUnsafe("Connection", "keep-alive") : this.headerMap().remove("Connection")) : (keepAlive ? this.headerMap().remove("Connection") : this.headerMap().setUnsafe("Connection", "close"));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean keepAlive() {
        String value;
        boolean bl = false;
        Some some = null;
        Option<String> option = this.headerMap().get("Connection");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String value2 = (String)some.value();
            if (value2.equalsIgnoreCase("close")) {
                return false;
            }
        }
        if (bl && (value = (String)some.value()).equalsIgnoreCase("keep-alive")) {
            return true;
        }
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http11();
        if (version != null) {
            if (!((Object)version).equals(version2)) return false;
            return true;
        }
        if (version2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$charset_$eq$2(String x$1) {
        return x$1.trim().startsWith("charset=");
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$3(StringBuilder builder$1, IndexedSeq parts$1, int i) {
        builder$1.append(";");
        return builder$1.append((String)parts$1.apply(i));
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$4(IndexedSeq parts$1, StringBuilder builder$1, String value$1, int i) {
        StringBuilder stringBuilder;
        String part = (String)parts$1.apply(i);
        if (part.trim().startsWith("charset=")) {
            builder$1.append(";charset=");
            stringBuilder = builder$1.append(value$1);
        } else {
            builder$1.append(";");
            stringBuilder = builder$1.append(part);
        }
        return stringBuilder;
    }

    public static final /* synthetic */ long $anonfun$contentLength$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$isXmlHttpRequest$1(String x$3) {
        return x$3.toLowerCase().contains("xmlhttprequest");
    }

    public static final class BufOutputStream
    extends ByteArrayOutputStream {
        public Buf contentsAsBuf() {
            return Buf.ByteArray$.Owned$.MODULE$.apply(this.buf, 0, this.count);
        }

        public BufOutputStream(int initialSize) {
            super(initialSize);
        }
    }
}

