/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.headers.DefaultHeaderMap$;
import com.twitter.finagle.http.headers.EmptyHeaderMap;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$ObsFoldDetected$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$ValidationSuccess$;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.TwitterDateFormat$;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class HeaderMap$ {
    public static HeaderMap$ MODULE$;
    private final Logger logger;
    private final HeaderMap Empty;
    private final ThreadLocal<SimpleDateFormat> formatter;
    private final Regex ObsFoldRegex;

    static {
        new HeaderMap$();
    }

    public HeaderMap Empty() {
        return this.Empty;
    }

    public HeaderMap apply(Seq<Tuple2<String, String>> headers) {
        return DefaultHeaderMap$.MODULE$.apply(headers);
    }

    public HeaderMap newHeaderMap() {
        return this.apply((Seq<Tuple2<String, String>>)Nil$.MODULE$);
    }

    public int hashChar(char c) {
        return c >= 65 && c <= 90 ? c + 32 : c;
    }

    public String com$twitter$finagle$http$HeaderMap$$format(Date date) {
        return date == null ? null : ((DateFormat)this.formatter.get()).format(date);
    }

    public Regex ObsFoldRegex() {
        return this.ObsFoldRegex;
    }

    public void validateName(String name) {
        Rfc7230HeaderValidation.NameValidationResult nameValidationResult = Rfc7230HeaderValidation$.MODULE$.validateName(name);
        if (!Rfc7230HeaderValidation$ValidationSuccess$.MODULE$.equals(nameValidationResult)) {
            if (nameValidationResult instanceof Rfc7230HeaderValidation.ValidationFailure) {
                Rfc7230HeaderValidation.ValidationFailure validationFailure = (Rfc7230HeaderValidation.ValidationFailure)nameValidationResult;
                Rfc7230HeaderValidation.HeaderValidationException ex = validationFailure.ex();
                throw ex;
            }
            throw new MatchError((Object)nameValidationResult);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public String foldReplacingValidateValue(String name, String value) {
        String string;
        Rfc7230HeaderValidation.ValueValidationResult valueValidationResult = Rfc7230HeaderValidation$.MODULE$.validateValue(name, value);
        if (Rfc7230HeaderValidation$ValidationSuccess$.MODULE$.equals(valueValidationResult)) {
            string = value;
        } else {
            if (valueValidationResult instanceof Rfc7230HeaderValidation.ValidationFailure) {
                Rfc7230HeaderValidation.ValidationFailure validationFailure = (Rfc7230HeaderValidation.ValidationFailure)valueValidationResult;
                Rfc7230HeaderValidation.HeaderValidationException ex = validationFailure.ex();
                throw ex;
            }
            if (Rfc7230HeaderValidation$ObsFoldDetected$.MODULE$.equals(valueValidationResult)) {
                this.logger.debug("`obs-fold` sequence replaced.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                string = Rfc7230HeaderValidation$.MODULE$.replaceObsFold(value);
            } else {
                throw new MatchError((Object)valueValidationResult);
            }
        }
        return string;
    }

    private HeaderMap$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.get(HeaderMap.class);
        this.Empty = new EmptyHeaderMap();
        this.formatter = new ThreadLocal<SimpleDateFormat>(){

            /*
             * WARNING - void declaration
             */
            public SimpleDateFormat initialValue() {
                void var1_1;
                SimpleDateFormat f = TwitterDateFormat$.MODULE$.apply("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
                f.setTimeZone(TimeZone.getTimeZone("GMT"));
                return var1_1;
            }
        };
        this.ObsFoldRegex = new StringOps(Predef$.MODULE$.augmentString("\r?\n[\t ]+")).r();
    }
}

