/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.netty4;

import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.Cookie$;
import com.twitter.finagle.http.CookieCodec;
import com.twitter.finagle.http.CookieMap$;
import com.twitter.finagle.http.cookie.SameSite;
import com.twitter.finagle.http.cookie.SameSiteCodec$;
import com.twitter.util.Duration;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.Serializable;
import java.util.BitSet;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Netty4CookieCodec$
extends CookieCodec {
    public static Netty4CookieCodec$ MODULE$;
    private final ClientCookieEncoder clientEncoder;
    private final ServerCookieEncoder serverEncoder;
    private final ClientCookieDecoder clientDecoder;
    private final ServerCookieDecoder serverDecoder;
    private final BitSet ShouldWrapCharsBitSet;
    private final Function1<Cookie, io.netty.handler.codec.http.cookie.Cookie> cookieToNetty;
    private final Function1<io.netty.handler.codec.http.cookie.Cookie, Cookie> cookieToFinagle;

    static {
        new Netty4CookieCodec$();
    }

    @Override
    public String encodeClient(Iterable<Cookie> cookies) {
        return cookies.isEmpty() ? "" : this.clientEncoder.encode((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)cookies.map(this.cookieToNetty(), Iterable$.MODULE$.canBuildFrom())).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encodeServer(Cookie cookie) {
        void var2_2;
        String encoded = this.serverEncoder.encode((io.netty.handler.codec.http.cookie.Cookie)this.cookieToNetty().apply((Object)cookie));
        return CookieMap$.MODULE$.includeSameSite() ? SameSiteCodec$.MODULE$.encodeSameSite(cookie, encoded) : var2_2;
    }

    @Override
    public Option<Iterable<Cookie>> decodeClient(String header) {
        None$ none$;
        io.netty.handler.codec.http.cookie.Cookie cookie = this.clientDecoder.decode(header);
        if (cookie != null) {
            Cookie decoded = (Cookie)this.cookieToFinagle().apply((Object)cookie);
            Cookie finagleCookie = CookieMap$.MODULE$.includeSameSite() ? SameSiteCodec$.MODULE$.decodeSameSite(header, decoded) : decoded;
            none$ = new Some((Object)new .colon.colon((Object)finagleCookie, (List)Nil$.MODULE$));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<Iterable<Cookie>> decodeServer(String header) {
        Buffer cookies = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.serverDecoder.decodeAll(header)).asScala()).map(this.cookieToFinagle(), Buffer$.MODULE$.canBuildFrom());
        return !cookies.isEmpty() ? new Some((Object)cookies) : None$.MODULE$;
    }

    private boolean shouldWrap(Cookie cookie) {
        return Cookie$.MODULE$.stringContains(cookie.value(), this.ShouldWrapCharsBitSet);
    }

    public Function1<Cookie, io.netty.handler.codec.http.cookie.Cookie> cookieToNetty() {
        return this.cookieToNetty;
    }

    public Function1<io.netty.handler.codec.http.cookie.Cookie, Cookie> cookieToFinagle() {
        return this.cookieToFinagle;
    }

    /*
     * WARNING - void declaration
     */
    private Netty4CookieCodec$() {
        void var1_1;
        MODULE$ = this;
        this.clientEncoder = ClientCookieEncoder.STRICT;
        this.serverEncoder = ServerCookieEncoder.STRICT;
        this.clientDecoder = ClientCookieDecoder.STRICT;
        this.serverDecoder = ServerCookieDecoder.STRICT;
        BitSet bs = new BitSet();
        new StringOps(Predef$.MODULE$.augmentString("()/:<?@[]=>{}")).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            bs.set(BoxesRunTime.unboxToChar((Object)x$1));
            return BoxedUnit.UNIT;
        });
        this.ShouldWrapCharsBitSet = var1_1;
        this.cookieToNetty = (Function1 & Serializable & scala.Serializable)c -> {
            void var1_1;
            block1: {
                DefaultCookie nc = new DefaultCookie(c.name(), c.value());
                nc.setDomain(c.domain());
                nc.setPath(c.path());
                if (c.maxAge().inSeconds() != Cookie$.MODULE$.DefaultMaxAge().inSeconds()) {
                    nc.setMaxAge((long)c.maxAge().inSeconds());
                }
                nc.setSecure(c.secure());
                nc.setHttpOnly(c.httpOnly());
                if (!MODULE$.shouldWrap((Cookie)c)) break block1;
                nc.setWrap(true);
            }
            return var1_1;
        };
        this.cookieToFinagle = (Function1 & Serializable & scala.Serializable)nc -> {
            void var1_9;
            String x$1 = nc.name();
            String x$2 = nc.value();
            Option x$3 = Option$.MODULE$.apply((Object)nc.domain());
            Option x$4 = Option$.MODULE$.apply((Object)nc.path());
            boolean x$5 = nc.isSecure();
            boolean x$6 = nc.isHttpOnly();
            Option<Duration> x$7 = Cookie$.MODULE$.$lessinit$greater$default$5();
            SameSite x$8 = Cookie$.MODULE$.$lessinit$greater$default$8();
            Cookie cookie = new Cookie(x$1, x$2, (Option<String>)x$3, (Option<String>)x$4, x$7, x$5, x$6, x$8);
            return nc.maxAge() != Long.MIN_VALUE ? cookie.maxAge((Option<Duration>)new Some((Object)DurationOps.RichDuration$.MODULE$.seconds$extension(DurationOps$.MODULE$.RichDuration(nc.maxAge())))) : var1_9;
        };
    }
}

