/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.Chunk;
import com.twitter.finagle.http.Chunk$;
import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.CookieMap;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.finagle.http.util.StringUtil$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.BufInputStream;
import com.twitter.io.Reader$;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0011EeA\u0002<x\u0003\u0003\t\t\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u0011\u0005]\u0001\u0001)Q\u0005\u00033A\u0001\"!\f\u0001A\u0003&\u0011q\u0006\u0005\t\u0003o\u0001\u0001\u0015)\u0003\u0002:!9\u0011\u0011\t\u0001\u0007\u0002\u0005\r\u0003bBA)\u0001\u0019\u0005\u00111\u000b\u0005\u000b\u00037\u0002\u0001R1A\u0005\u0006\u0005u\u0003BCA1\u0001!\u0015\r\u0011\"\u0002\u0002d!9\u0011q\r\u0001\u0007\u0002\u0005%\u0004bBA6\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!\u001c\u0001\t\u000b\t\t\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9\u00111\u001f\u0001\u0005\u0006\u0005u\bb\u0002B\u0001\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011Y\u0001\u0001D\u0001\u0005\u001bAqA!\u0006\u0001\r\u0003\u0011i\u0001\u0003\u0006\u0003\u0018\u0001A)\u0019!C\u0001\u00053AqA!\t\u0001\t\u0003\u0011\u0019\u0003C\u0004\u00038\u0001!\tA!\u000f\t\u000f\t}\u0002\u0001\"\u0001\u0003B!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005/\u0002A\u0011\u0001B0\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005\u0013BqA!\u001c\u0001\t\u0003\u0011y\u0007C\u0004\u0003x\u0001!\tA!\u001f\t\u000f\t]\u0004\u0001\"\u0001\u0003~!9!\u0011\u0012\u0001\u0005\u0002\t=\u0004b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u0005#\u0003A\u0011\u0001B8\u0011\u001d\u0011\u0019\n\u0001C\u0001\u0005+CqAa%\u0001\t\u0003\u0011I\nC\u0004\u0003*\u0002!\tAa\u001c\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"9!\u0011\u0017\u0001\u0005\u0002\tM\u0006b\u0002B_\u0001\u0011\u0015!q\u0018\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u001d\u0011\t\f\u0001C\u0003\u0005\u0017DqAa4\u0001\t\u0003\u0011y\u0007C\u0004\u0003R\u0002!\tAa5\t\u000f\t]\u0007\u0001\"\u0001\u0003Z\"I!\u0011\u001d\u0001\u0012\u0002\u0013\u0005!1\u001d\u0005\b\u0005s\u0004A\u0011\u0001B~\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005_BqAa@\u0001\t\u0003\u0019\t\u0001C\u0004\u0003\u0000\u0002!\ta!\u0002\t\u000f\r=\u0001\u0001\"\u0001\u0003p!91\u0011\u0003\u0001\u0005\u0002\rM\u0001bBB\t\u0001\u0011\u00051q\u0003\u0005\b\u00077\u0001A\u0011\u0001B8\u0011\u001d\u0019i\u0002\u0001C\u0001\u0007?Aqaa\u0007\u0001\t\u000b\u0019\u0019\u0003C\u0004\u0004(\u0001!\tAa\u001c\t\u000f\r%\u0002\u0001\"\u0001\u0004,!91\u0011\u0006\u0001\u0005\u0002\r=\u0002bBB\u001a\u0001\u0011\u0005!q\u000e\u0005\b\u0007k\u0001A\u0011AB\u001c\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005_Bqaa\u000f\u0001\t\u0003\u0019i\u0004C\u0004\u0004B\u0001!\tAa\u001c\t\u000f\r\r\u0003\u0001\"\u0001\u0004F!91\u0011\n\u0001\u0005\u0002\t=\u0004bBB&\u0001\u0011\u00051Q\n\u0005\b\u0007\u0017\u0002A\u0011AB)\u0011\u001d\u0019)\u0006\u0001C\u0001\u0005_Bqaa\u0016\u0001\t\u0003\u0019I\u0006C\u0004\u0004^\u0001!\tAa\u001c\t\u000f\r}\u0003\u0001\"\u0001\u0004b!91Q\r\u0001\u0005\u0002\t=\u0004bBB4\u0001\u0011\u00051\u0011\u000e\u0005\b\u0007[\u0002A\u0011\u0001B8\u0011\u001d\u0019y\u0007\u0001C\u0001\u0007cBqa!\u001e\u0001\t\u0003\tI\u0007C\u0004\u0004x\u0001!)a!\u001f\t\u000f\r\u0005\u0005\u0001\"\u0002\u0004\u0004\"91Q\u0011\u0001\u0005\u0002\u0005E\u0006bBBD\u0001\u0011\u00051\u0011\u0012\u0005\b\u0007\u0017\u0003A\u0011ABG\u0011\u001d\u0019\t\n\u0001C\u0003\u0007'Cqaa&\u0001\t\u0003\u0019I\nC\u0004\u0004@\u0002!)a!1\t\u000f\r\r\u0007\u0001\"\u0002\u0004F\"91Q\u001b\u0001\u0005\u0006\r]\u0007bBBm\u0001\u0011\u001511\u001c\u0005\b\u00073\u0004AQABs\u0011\u001d\u0019I\u000e\u0001C\u0003\u0007[Dq\u0001\"\u0001\u0001\t\u000b!\u0019\u0001C\u0004\u0005\u0018\u0001!)\u0001\"\u0007\t\u000f\u0011-\u0002\u0001\"\u0002\u0003|\"9AQ\u0006\u0001\u0005\u0002\u0011=\u0002b\u0002C\u001c\u0001\u0011\u0015A\u0011\b\u0005\b\to\u0001AQAA5\u000f\u001d!id\u001eE\u0001\t\u007f1aA^<\t\u0002\u0011\u0005\u0003bBA\bE\u0012\u0005A1\t\u0004\u0007\t\u000b\u0012g\u0001b\u0012\t\u0015\u0011=CM!A!\u0002\u0013\u0019Y\bC\u0004\u0002\u0010\u0011$\t\u0001\"\u0015\t\u000f\u0011eC\r\"\u0001\u0002p!IA1\f2C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\t;\u0012\u0007\u0015!\u0003\u0002\u0018\"IAq\f2C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\tC\u0012\u0007\u0015!\u0003\u0002\u0018\"IA1\r2C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\tK\u0012\u0007\u0015!\u0003\u0002\u0018\"IAq\r2C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\tS\u0012\u0007\u0015!\u0003\u0002\u0018\"IA1\u000e2C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\t[\u0012\u0007\u0015!\u0003\u0002\u0018\"IAq\u000e2C\u0002\u0013%A\u0011\u000f\u0005\t\t\u0007\u0013\u0007\u0015!\u0003\u0005t!9AQ\u00112\u0005\u0002\u0011\u001d\u0005b\u0002CCE\u0012\u0005A1\u0012\u0002\b\u001b\u0016\u001c8/Y4f\u0015\tA\u00180\u0001\u0003iiR\u0004(B\u0001>|\u0003\u001d1\u0017N\\1hY\u0016T!\u0001`?\u0002\u000fQ<\u0018\u000e\u001e;fe*\ta0A\u0002d_6\u001c\u0001aE\u0002\u0001\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0003\u0003\u0013\tQa]2bY\u0006LA!!\u0004\u0002\b\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtDCAA\n!\r\t)\u0002A\u0007\u0002o\u0006AqlY8oi\u0016tG\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyb_\u0001\u0003S>LA!a\t\u0002\u001e\t\u0019!)\u001e4)\u0007\t\t9\u0003\u0005\u0003\u0002\u0006\u0005%\u0012\u0002BA\u0016\u0003\u000f\u0011\u0001B^8mCRLG.Z\u0001\t?Z,'o]5p]B!\u0011QCA\u0019\u0013\r\t\u0019d\u001e\u0002\b-\u0016\u00148/[8oQ\r\u0019\u0011qE\u0001\t?\u000eDWO\\6fIB!\u0011QAA\u001e\u0013\u0011\ti$a\u0002\u0003\u000f\t{w\u000e\\3b]\"\u001aA!a\n\u0002\u0017\rDWO\\6SK\u0006$WM]\u000b\u0003\u0003\u000b\u0002b!a\u0007\u0002H\u0005-\u0013\u0002BA%\u0003;\u0011aAU3bI\u0016\u0014\b\u0003BA\u000b\u0003\u001bJ1!a\u0014x\u0005\u0015\u0019\u0005.\u001e8l\u0003-\u0019\u0007.\u001e8l/JLG/\u001a:\u0016\u0005\u0005U\u0003CBA\u000e\u0003/\nY%\u0003\u0003\u0002Z\u0005u!AB,sSR,'/\u0001\u0004sK\u0006$WM]\u000b\u0003\u0003?\u0002b!a\u0007\u0002H\u0005e\u0011AB<sSR,'/\u0006\u0002\u0002fA1\u00111DA,\u00033\t\u0011\"[:SKF,Xm\u001d;\u0016\u0005\u0005e\u0012AC5t%\u0016\u001c\bo\u001c8tK\u000691m\u001c8uK:$XCAA\r\u0003-\u0019wN\u001c;f]R|F%Z9\u0015\t\u0005U\u00141\u0010\t\u0005\u0003\u000b\t9(\u0003\u0003\u0002z\u0005\u001d!\u0001B+oSRDq!!\u001c\r\u0001\u0004\tI\u0002K\u0003\r\u0003\u007f\n)\n\u0005\u0004\u0002\u0006\u0005\u0005\u0015QQ\u0005\u0005\u0003\u0007\u000b9A\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006LA!a%\u0002\n\n)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002\u0018\u00065\u0016q\u001c\t\u0005\u00033\u000b9K\u0004\u0003\u0002\u001c\u0006\r\u0006\u0003BAO\u0003\u000fi!!a(\u000b\u0007\u0005\u0005v0\u0001\u0004=e>|GOP\u0005\u0005\u0003K\u000b9!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\u000bYK\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003K\u000b9!M\u0005$\u0003_\u000b9,!6\u0002:V!\u0011\u0011WAZ+\t\t9\nB\u0004\u00026~\u0014\r!a0\u0003\u0003QKA!!/\u0002<\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIERA!!0\u0002\b\u00051A\u000f\u001b:poN\fB!!1\u0002HB!\u0011QAAb\u0013\u0011\t)-a\u0002\u0003\u000f9{G\u000f[5oOB!\u0011\u0011ZAh\u001d\u0011\t)!a3\n\t\u00055\u0017qA\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t.a5\u0003\u0013QC'o\\<bE2,'\u0002BAg\u0003\u000f\t\u0014bIAl\u00033\fY.!0\u000f\t\u0005\u0015\u0011\u0011\\\u0005\u0005\u0003{\u000b9!M\u0004#\u0003\u000b\t9!!8\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n)\t\u0006\u0003\u0002d\u0006\u0015X\"\u0001\u0001\t\u000f\u00055T\u00021\u0001\u0002\u001a!*Q\"a \u0002jF:a$a&\u0002l\u0006E\u0018'C\u0012\u00020\u0006]\u0016Q^A]c%\u0019\u0013q[Am\u0003_\fi,M\u0004#\u0003\u000b\t9!!82\u0007\u0019\n))A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0005\u0005=\u0012a\u0003<feNLwN\\0%KF$B!!\u001e\u0002|\"9\u00111_\bA\u0002\u0005=B\u0003BAr\u0003\u007fDq!a=\u0011\u0001\u0004\ty#A\u0005jg\u000eCWO\\6fI\u0006Q1/\u001a;DQVt7.\u001a3\u0015\t\u0005U$q\u0001\u0005\b\u0005\u0013\u0011\u0002\u0019AA\u001d\u0003\u001d\u0019\u0007.\u001e8lK\u0012\f\u0011\u0002[3bI\u0016\u0014X*\u00199\u0016\u0005\t=\u0001\u0003BA\u000b\u0005#I1Aa\u0005x\u0005%AU-\u00193fe6\u000b\u0007/\u0001\u0005ue\u0006LG.\u001a:t\u0003\u001d\u0019wn\\6jKN,\"Aa\u0007\u0011\t\u0005U!QD\u0005\u0004\u0005?9(!C\"p_.LW-T1q\u0003)9W\r^\"p_.LWm\u001d\u000b\u0003\u0005K\u0001bAa\n\u0003.\tERB\u0001B\u0015\u0015\u0011\u0011Y#!$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005_\u0011IC\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t)Ba\r\n\u0007\tUrO\u0001\u0004D_>\\\u0017.Z\u0001\nC\u0012$7i\\8lS\u0016$B!!\u001e\u0003<!9!QH\fA\u0002\tE\u0012AB2p_.LW-\u0001\u0007sK6|g/Z\"p_.LW\r\u0006\u0003\u0002v\t\r\u0003b\u0002B#1\u0001\u0007\u0011qS\u0001\u0005]\u0006lW-\u0001\u0004bG\u000e,\u0007\u000f^\u000b\u0003\u0005\u0017\u0002bA!\u0014\u0003T\u0005]e\u0002\u0002B(\u0003\u0017tA!!(\u0003R%\u0011\u0011\u0011B\u0005\u0005\u0005+\n\u0019NA\u0002TKF\f!\"Y2dKB$x\fJ3r)\u0011\t)Ha\u0017\t\u000f\tu#\u00041\u0001\u0002\u0018\u0006)a/\u00197vKR!\u0011Q\u000fB1\u0011\u001d\u0011\u0019g\u0007a\u0001\u0005K\naA^1mk\u0016\u001c\bC\u0002B'\u0005O\n9*\u0003\u0003\u0003j\u0005M'\u0001C%uKJ\f'\r\\3\u0002!\u0005\u001c7-\u001a9u\u001b\u0016$\u0017.\u0019+za\u0016\u001c\u0018!B1mY><XC\u0001B9!\u0019\t)Aa\u001d\u0002\u0018&!!QOA\u0004\u0005\u0019y\u0005\u000f^5p]\u0006I\u0011\r\u001c7po~#S-\u001d\u000b\u0005\u0003k\u0012Y\bC\u0004\u0003^y\u0001\r!a&\u0015\t\u0005U$q\u0010\u0005\b\u0005Gz\u0002\u0019\u0001BA!\u0019\u0011iEa\u001a\u0003\u0004B!\u0011Q\u0003BC\u0013\r\u00119i\u001e\u0002\u0007\u001b\u0016$\bn\u001c3\u0002\u001b\u0005,H\u000f[8sSj\fG/[8o\u0003E\tW\u000f\u001e5pe&T\u0018\r^5p]~#S-\u001d\u000b\u0005\u0003k\u0012y\tC\u0004\u0003^\u0005\u0002\r!a&\u0002\u0019\r\f7\r[3D_:$(o\u001c7\u0002!\r\f7\r[3D_:$(o\u001c7`I\u0015\fH\u0003BA;\u0005/CqA!\u0018$\u0001\u0004\t9\n\u0006\u0003\u0002v\tm\u0005b\u0002BOI\u0001\u0007!qT\u0001\u0007[\u0006D\u0018iZ3\u0011\t\t\u0005&QU\u0007\u0003\u0005GS1Aa\u000b|\u0013\u0011\u00119Ka)\u0003\u0011\u0011+(/\u0019;j_:\fqa\u00195beN,G/A\u0006dQ\u0006\u00148/\u001a;`I\u0015\fH\u0003BA;\u0005_CqA!\u0018'\u0001\u0004\t9*A\u0007d_:$XM\u001c;MK:<G\u000f[\u000b\u0003\u0005k\u0003b!!\u0002\u0003t\t]\u0006\u0003BA\u0003\u0005sKAAa/\u0002\b\t!Aj\u001c8h\u0003M\u0019wN\u001c;f]RdUM\\4uQ>\u0013X\t\\:f)\u0011\u00119L!1\t\u000f\t\r\u0007\u00061\u0001\u00038\u00069A-\u001a4bk2$\u0018!E2p]R,g\u000e\u001e'f]\u001e$\bn\u0018\u0013fcR!\u0011Q\u000fBe\u0011\u001d\u0011i&\u000ba\u0001\u0005o#B!a9\u0003N\"9!Q\f\u0016A\u0002\t]\u0016aC2p]R,g\u000e\u001e+za\u0016\fqbY8oi\u0016tG\u000fV=qK~#S-\u001d\u000b\u0005\u0003k\u0012)\u000eC\u0004\u0003^1\u0002\r!a&\u0002\u001dM,GoQ8oi\u0016tG\u000fV=qKR1\u0011Q\u000fBn\u0005?DqA!8.\u0001\u0004\t9*A\u0005nK\u0012L\u0017\rV=qK\"I!\u0011V\u0017\u0011\u0002\u0003\u0007\u0011qS\u0001\u0019g\u0016$8i\u001c8uK:$H+\u001f9fI\u0011,g-Y;mi\u0012\u0012TC\u0001BsU\u0011\t9Ja:,\u0005\t%\b\u0003\u0002Bv\u0005kl!A!<\u000b\t\t=(\u0011_\u0001\nk:\u001c\u0007.Z2lK\u0012TAAa=\u0002\b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t](Q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE:fi\u000e{g\u000e^3oiRK\b/\u001a&t_:$\"!!\u001e\u0002\t\u0011\fG/Z\u0001\tI\u0006$Xm\u0018\u0013fcR!\u0011QOB\u0002\u0011\u001d\u0011i&\ra\u0001\u0003/#B!!\u001e\u0004\b!9!Q\f\u001aA\u0002\r%\u0001\u0003\u0002B\u0014\u0007\u0017IAa!\u0004\u0003*\t!A)\u0019;f\u0003\u001d)\u0007\u0010]5sKN\f1\"\u001a=qSJ,7o\u0018\u0013fcR!\u0011QOB\u000b\u0011\u001d\u0011i\u0006\u000ea\u0001\u0003/#B!!\u001e\u0004\u001a!9!QL\u001bA\u0002\r%\u0011\u0001\u00025pgR\f\u0001\u0002[8ti~#S-\u001d\u000b\u0005\u0003k\u001a\t\u0003C\u0004\u0003^]\u0002\r!a&\u0015\t\u0005\r8Q\u0005\u0005\b\u0005;B\u0004\u0019AAL\u00031a\u0017m\u001d;N_\u0012Lg-[3e\u0003Aa\u0017m\u001d;N_\u0012Lg-[3e?\u0012*\u0017\u000f\u0006\u0003\u0002v\r5\u0002b\u0002B/u\u0001\u0007\u0011q\u0013\u000b\u0005\u0003k\u001a\t\u0004C\u0004\u0003^m\u0002\ra!\u0003\u0002\u00111|7-\u0019;j_:\fA\u0002\\8dCRLwN\\0%KF$B!!\u001e\u0004:!9!QL\u001fA\u0002\u0005]\u0015!D7fI&\fG+\u001f9f?\u0012*\u0017\u000f\u0006\u0003\u0002v\r}\u0002b\u0002B/\u007f\u0001\u0007\u0011qS\u0001\be\u00164WM]3s\u0003-\u0011XMZ3sKJ|F%Z9\u0015\t\u0005U4q\t\u0005\b\u0005;\n\u0005\u0019AAL\u0003)\u0011X\r\u001e:z\u0003\u001a$XM]\u0001\u000fe\u0016$(/_!gi\u0016\u0014x\fJ3r)\u0011\t)ha\u0014\t\u000f\tu3\t1\u0001\u0002\u0018R!\u0011QOB*\u0011\u001d\u0011i\u0006\u0012a\u0001\u0005o\u000baa]3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR!\u0011QOB.\u0011\u001d\u0011iF\u0012a\u0001\u0003/\u000b\u0011\"^:fe\u0006;WM\u001c;\u0002\u001bU\u001cXM]!hK:$x\fJ3r)\u0011\t)ha\u0019\t\u000f\tu\u0003\n1\u0001\u0002\u0018\u0006yqo^<BkRDWM\u001c;jG\u0006$X-A\nxo^\fU\u000f\u001e5f]RL7-\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002v\r-\u0004b\u0002B/\u0015\u0002\u0007\u0011qS\u0001\u000eq\u001a{'o^1sI\u0016$gi\u001c:\u0002#a4uN]<be\u0012,GMR8s?\u0012*\u0017\u000f\u0006\u0003\u0002v\rM\u0004b\u0002B/\u0019\u0002\u0007\u0011qS\u0001\u0011SNDV\u000e\u001c%uiB\u0014V-];fgR\fa\u0001\\3oORDWCAB>!\u0011\t)a! \n\t\r}\u0014q\u0001\u0002\u0004\u0013:$\u0018!C4fi2+gn\u001a;i)\t\u0019Y(A\u0007d_:$XM\u001c;TiJLgnZ\u0001\u0011O\u0016$8i\u001c8uK:$8\u000b\u001e:j]\u001e$\"!a&\u0002#\r|g\u000e^3oiN#(/\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002v\r=\u0005b\u0002B/%\u0002\u0007\u0011qS\u0001\u0011g\u0016$8i\u001c8uK:$8\u000b\u001e:j]\u001e$B!!\u001e\u0004\u0016\"9!QL*A\u0002\u0005]\u0015aD<ji\"Le\u000e];u'R\u0014X-Y7\u0016\t\rm5\u0011\u0015\u000b\u0005\u0007;\u001bY\u000b\u0005\u0003\u0004 \u000e\u0005F\u0002\u0001\u0003\b\u0003k#&\u0019ABR#\u0011\t\tm!*\u0011\t\u0005\u00151qU\u0005\u0005\u0007S\u000b9AA\u0002B]fDqa!,U\u0001\u0004\u0019y+A\u0001g!!\t)a!-\u00046\u000eu\u0015\u0002BBZ\u0003\u000f\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\r]61X\u0007\u0003\u0007sSA!a\b\u0002\u000e&!1QXB]\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u001d\u001d,G/\u00138qkR\u001cFO]3b[R\u00111QW\u0001\u000bo&$\bNU3bI\u0016\u0014X\u0003BBd\u0007\u0017$Ba!3\u0004NB!1qTBf\t\u001d\t)L\u0016b\u0001\u0007GCqa!,W\u0001\u0004\u0019y\r\u0005\u0005\u0002\u0006\rE6\u0011[Be!\u0011\u00199la5\n\t\u0005%3\u0011X\u0001\nO\u0016$(+Z1eKJ$\"a!5\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005U4Q\u001c\u0005\b\u0007?D\u0006\u0019AAL\u0003\u0019\u0019HO]5oO\"*\u0001,a \u0004d\u000e\u0012\u0011Q\u0011\u000b\u0005\u0003k\u001a9\u000fC\u0004\u0004jf\u0003\r!!\u0007\u0002\u0007\t,h\rK\u0003Z\u0003\u007f\u001a\u0019\u000f\u0006\u0003\u0002v\r=\bbBBy5\u0002\u000711_\u0001\u0006Ef$Xm\u001d\t\u0007\u0003\u000b\u0019)p!?\n\t\r]\u0018q\u0001\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u000b\u0019Y0\u0003\u0003\u0004~\u0006\u001d!\u0001\u0002\"zi\u0016DSAWA@\u0007G\f\u0001c^5uQ>+H\u000f];u'R\u0014X-Y7\u0016\t\u0011\u0015A\u0011\u0002\u000b\u0005\t\u000f!Y\u0001\u0005\u0003\u0004 \u0012%AaBA[7\n\u000711\u0015\u0005\b\u0007[[\u0006\u0019\u0001C\u0007!!\t)a!-\u0005\u0010\u0011\u001d\u0001\u0003BB\\\t#IA\u0001b\u0005\u0004:\naq*\u001e;qkR\u001cFO]3b[\"*1,a \u0004d\u0006Qq/\u001b;i/JLG/\u001a:\u0016\t\u0011mAq\u0004\u000b\u0005\t;!\t\u0003\u0005\u0003\u0004 \u0012}AaBA[9\n\u000711\u0015\u0005\b\u0007[c\u0006\u0019\u0001C\u0012!!\t)a!-\u0005&\u0011u\u0001\u0003BB\\\tOIA!!\u0017\u0004:\"*A,a \u0004d\u0006a1\r\\3be\u000e{g\u000e^3oi\u0006)1\r\\8tKR\u0011A\u0011\u0007\t\u0007\u0005C#\u0019$!\u001e\n\t\u0011U\"1\u0015\u0002\u0007\rV$XO]3\u0002\u0013-,W\r]!mSZ,G\u0003BAr\twAq\u0001b\u000e`\u0001\u0004\tI$A\u0004NKN\u001c\u0018mZ3\u0011\u0007\u0005U!mE\u0002c\u0003\u0007!\"\u0001b\u0010\u0003\u001f\t+hmT;uaV$8\u000b\u001e:fC6\u001c2\u0001\u001aC%!\u0011\u00199\fb\u0013\n\t\u001153\u0011\u0018\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0003-Ig.\u001b;jC2\u001c\u0016N_3\u0015\t\u0011MCq\u000b\t\u0004\t+\"W\"\u00012\t\u000f\u0011=c\r1\u0001\u0004|\u0005i1m\u001c8uK:$8/Q:Ck\u001a\f1b\u00115beN,G/\u0016;gq\u0005a1\t[1sg\u0016$X\u000b\u001e49A\u0005y1i\u001c8uK:$H+\u001f9f\u0015N|g.\u0001\tD_:$XM\u001c;UsB,'j]8oA\u0005!2i\u001c8uK:$H+\u001f9f\u0015N|g\u000eU1uG\"\fQcQ8oi\u0016tG\u000fV=qK*\u001bxN\u001c)bi\u000eD\u0007%A\u000bD_:$XM\u001c;UsB,'*\u0019<bg\u000e\u0014\u0018\u000e\u001d;\u0002-\r{g\u000e^3oiRK\b/\u001a&bm\u0006\u001c8M]5qi\u0002\n!cQ8oi\u0016tG\u000fV=qK^;xOR8s[\u0006\u00192i\u001c8uK:$H+\u001f9f/^<hi\u001c:nA\u0005q\u0001\n\u001e;q\t\u0006$XMR8s[\u0006$XC\u0001C:!\u0011!)\bb \u000e\u0005\u0011]$\u0002\u0002C=\tw\naAZ8s[\u0006$(\u0002\u0002C?\u0003\u001b\u000bA\u0001^5nK&!A\u0011\u0011C<\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0010\u0011R$\b\u000fR1uK\u001a{'/\\1uA\u0005q\u0001\u000e\u001e;q\t\u0006$XMR8s[\u0006$H\u0003BAL\t\u0013CqA!@u\u0001\u0004\u0019I\u0001\u0006\u0003\u0002\u0018\u00125\u0005b\u0002CHk\u0002\u0007!qW\u0001\u0007[&dG.[:")
public abstract class Message {
    private com.twitter.io.Reader<Buf> reader;
    private com.twitter.io.Writer<Buf> writer;
    private CookieMap cookies;
    private volatile Buf _content = Buf$.MODULE$.Empty();
    private volatile Version _version = Version$.MODULE$.Http11();
    private volatile boolean _chunked = false;
    private volatile byte bitmap$0;

    public static String httpDateFormat(long millis) {
        return Message$.MODULE$.httpDateFormat(millis);
    }

    public static String httpDateFormat(Date date) {
        return Message$.MODULE$.httpDateFormat(date);
    }

    public static String ContentTypeWwwForm() {
        return Message$.MODULE$.ContentTypeWwwForm();
    }

    public static String ContentTypeJavascript() {
        return Message$.MODULE$.ContentTypeJavascript();
    }

    public static String ContentTypeJsonPatch() {
        return Message$.MODULE$.ContentTypeJsonPatch();
    }

    public static String ContentTypeJson() {
        return Message$.MODULE$.ContentTypeJson();
    }

    public static String CharsetUtf8() {
        return Message$.MODULE$.CharsetUtf8();
    }

    public abstract com.twitter.io.Reader<Chunk> chunkReader();

    public abstract com.twitter.io.Writer<Chunk> chunkWriter();

    private com.twitter.io.Reader<Buf> reader$lzycompute() {
        Message message = this;
        synchronized (message) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reader = this.chunkReader().flatMap((Function1 & Serializable)chunk -> chunk.isLast() && chunk.content().isEmpty() ? Reader$.MODULE$.empty() : Reader$.MODULE$.value((Object)chunk.content()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reader;
    }

    public final com.twitter.io.Reader<Buf> reader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reader$lzycompute() : this.reader;
    }

    private com.twitter.io.Writer<Buf> writer$lzycompute() {
        Message message = this;
        synchronized (message) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.writer = this.chunkWriter().contramap((Function1 & Serializable)content -> Chunk$.MODULE$.apply((Buf)content));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.writer;
    }

    public final com.twitter.io.Writer<Buf> writer() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.writer$lzycompute() : this.writer;
    }

    public abstract boolean isRequest();

    public boolean isResponse() {
        return !this.isRequest();
    }

    public Buf content() {
        return this._content;
    }

    public void content_$eq(Buf content) throws IllegalStateException {
        if (!content.isEmpty() && this.isChunked()) {
            throw new IllegalStateException("Cannot set content on Chunked message");
        }
        this._content = content;
    }

    public final Message content(Buf content) throws IllegalStateException {
        this.content_$eq(content);
        return this;
    }

    public Version version() {
        return this._version;
    }

    public void version_$eq(Version version) {
        this._version = version;
    }

    public final Message version(Version version) {
        this.version_$eq(version);
        return this;
    }

    public boolean isChunked() {
        return this._chunked;
    }

    public void setChunked(boolean chunked) {
        block0: {
            this._chunked = chunked;
            if (!chunked) break block0;
            this.clearContent();
        }
    }

    public abstract HeaderMap headerMap();

    public abstract HeaderMap trailers();

    private CookieMap cookies$lzycompute() {
        Message message = this;
        synchronized (message) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.cookies = new CookieMap(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.cookies;
    }

    public CookieMap cookies() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.cookies$lzycompute() : this.cookies;
    }

    public Iterator<Cookie> getCookies() {
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.cookies().valuesIterator()).asJava();
    }

    public void addCookie(Cookie cookie) {
        this.cookies().$plus$eq(cookie);
    }

    public void removeCookie(String name) {
        this.cookies().$minus$eq(name);
    }

    public Seq<String> accept() {
        Seq seq;
        Option<String> option = this.headerMap().get("Accept");
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])s.split(",")), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))));
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public void accept_$eq(String value) {
        this.headerMap().set("Accept", value);
    }

    public void accept_$eq(Iterable<String> values) {
        this.accept_$eq(values.mkString(", "));
    }

    public Seq<String> acceptMediaTypes() {
        return (Seq)this.accept().flatMap((Function1 & Serializable)x$3 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$3.split(";", 2))).map((Function1 & Serializable)x$4 -> x$4.trim().toLowerCase()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5)))));
    }

    public Option<String> allow() {
        return this.headerMap().get("Allow");
    }

    public void allow_$eq(String value) {
        this.headerMap().set("Allow", value);
    }

    public void allow_$eq(Iterable<Method> values) {
        this.allow_$eq(values.mkString(",").toUpperCase());
    }

    public Option<String> authorization() {
        return this.headerMap().get("Authorization");
    }

    public void authorization_$eq(String value) {
        this.headerMap().set("Authorization", value);
    }

    public Option<String> cacheControl() {
        return this.headerMap().get("Cache-Control");
    }

    public void cacheControl_$eq(String value) {
        this.headerMap().set("Cache-Control", value);
    }

    public void cacheControl_$eq(Duration maxAge) {
        this.cacheControl_$eq(new java.lang.StringBuilder(25).append("max-age=").append(Integer.toString(maxAge.inSeconds())).append(", must-revalidate").toString());
    }

    public Option<String> charset() {
        String cType = this.headerMap().getOrNull("Content-Type");
        if (cType == null) {
            return None$.MODULE$;
        }
        int charsetIdx = cType.indexOf("charset=");
        if (charsetIdx == -1) {
            return None$.MODULE$;
        }
        int valueIdx = charsetIdx + "charset=".length();
        int semicolonIdx = cType.indexOf(59, valueIdx);
        int endIdx = semicolonIdx == -1 ? cType.length() : semicolonIdx;
        return new Some((Object)cType.substring(valueIdx, endIdx).trim());
    }

    public void charset_$eq(String value) {
        String contentType = (String)this.contentType().getOrElse((Function0 & Serializable)() -> "");
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        if (parts.isEmpty()) {
            this.contentType_$eq(new java.lang.StringBuilder(9).append(";charset=").append(value).toString());
            return;
        }
        StringBuilder builder = new StringBuilder((String)parts.apply(0));
        if (!parts.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$charset_$eq$2(x$6)))) {
            builder.append(";charset=");
            builder.append(value);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), parts.length()).foreach((Function1 & Serializable)i -> Message.$anonfun$charset_$eq$3(builder, parts, BoxesRunTime.unboxToInt((Object)i)));
        } else {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), parts.length()).foreach((Function1 & Serializable)i -> Message.$anonfun$charset_$eq$4(parts, builder, value, BoxesRunTime.unboxToInt((Object)i)));
        }
        this.contentType_$eq(builder.toString());
    }

    public Option<Object> contentLength() {
        return this.headerMap().get("Content-Length").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7))));
    }

    public final long contentLengthOrElse(long l) {
        long l2;
        Option<Object> option = this.contentLength();
        if (option instanceof Some) {
            long len;
            Some some = (Some)option;
            l2 = len = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l2 = l;
        } else {
            throw new MatchError(option);
        }
        return l2;
    }

    public void contentLength_$eq(long value) {
        this.headerMap().setUnsafe("Content-Length", Long.toString(value));
    }

    public final Message contentLength(long value) {
        this.contentLength_$eq(value);
        return this;
    }

    public Option<String> contentType() {
        return this.headerMap().get("Content-Type");
    }

    public void contentType_$eq(String value) {
        this.headerMap().set("Content-Type", value);
    }

    public void setContentType(String mediaType, String charset) {
        this.headerMap().set("Content-Type", new java.lang.StringBuilder(9).append(mediaType).append(";charset=").append(charset).toString());
    }

    public String setContentType$default$2() {
        return "utf-8";
    }

    public void setContentTypeJson() {
        this.headerMap().setUnsafe("Content-Type", Message$.MODULE$.ContentTypeJson());
    }

    public Option<String> date() {
        return this.headerMap().get("Date");
    }

    public void date_$eq(String value) {
        this.headerMap().set("Date", value);
    }

    public void date_$eq(Date value) {
        this.date_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> expires() {
        return this.headerMap().get("Expires");
    }

    public void expires_$eq(String value) {
        this.headerMap().set("Expires", value);
    }

    public void expires_$eq(Date value) {
        this.expires_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> host() {
        return this.headerMap().get("Host");
    }

    public void host_$eq(String value) {
        this.headerMap().set("Host", value);
    }

    public final Message host(String value) {
        this.host_$eq(value);
        return this;
    }

    public Option<String> lastModified() {
        return this.headerMap().get("Last-Modified");
    }

    public void lastModified_$eq(String value) {
        this.headerMap().set("Last-Modified", value);
    }

    public void lastModified_$eq(Date value) {
        this.lastModified_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> location() {
        return this.headerMap().get("Location");
    }

    public void location_$eq(String value) {
        this.headerMap().set("Location", value);
    }

    public Option<String> mediaType() {
        return this.contentType().flatMap((Function1 & Serializable)contentType -> {
            String string;
            int n = contentType.indexOf(";");
            switch (n) {
                case -1: {
                    string = contentType;
                    break;
                }
                default: {
                    string = contentType.substring(0, n);
                    break;
                }
            }
            String beforeSemi = string;
            String mediaType = beforeSemi.trim();
            return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mediaType)) ? new Some((Object)mediaType.toLowerCase()) : None$.MODULE$;
        });
    }

    public void mediaType_$eq(String value) {
        Option<String> option = this.contentType();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String contentType = (String)some.value();
            IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';', 2);
            if (parts.length() == 2) {
                this.contentType_$eq(new java.lang.StringBuilder(1).append(value).append(";").append(parts.apply(1)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.contentType_$eq(value);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.contentType_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public Option<String> referer() {
        return this.headerMap().get("Referer");
    }

    public void referer_$eq(String value) {
        this.headerMap().set("Referer", value);
    }

    public Option<String> retryAfter() {
        return this.headerMap().get("Retry-After");
    }

    public void retryAfter_$eq(String value) {
        this.headerMap().set("Retry-After", value);
    }

    public void retryAfter_$eq(long value) {
        this.retryAfter_$eq(Long.toString(value));
    }

    public Option<String> server() {
        return this.headerMap().get("Server");
    }

    public void server_$eq(String value) {
        this.headerMap().set("Server", value);
    }

    public Option<String> userAgent() {
        return this.headerMap().get("User-Agent");
    }

    public void userAgent_$eq(String value) {
        this.headerMap().set("User-Agent", value);
    }

    public Option<String> wwwAuthenticate() {
        return this.headerMap().get("Www-Authenticate");
    }

    public void wwwAuthenticate_$eq(String value) {
        this.headerMap().set("Www-Authenticate", value);
    }

    public Option<String> xForwardedFor() {
        return this.headerMap().get("X-Forwarded-For");
    }

    public void xForwardedFor_$eq(String value) {
        this.headerMap().set("X-Forwarded-For", value);
    }

    public boolean isXmlHttpRequest() {
        return this.headerMap().get("X-Requested-With").exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$isXmlHttpRequest$1(x$8)));
    }

    public final int length() {
        return this.content().length();
    }

    public final int getLength() {
        return this.length();
    }

    public String contentString() {
        Charset charset;
        try {
            charset = Charset.forName((String)this.charset().getOrElse((Function0 & Serializable)() -> "UTF-8"));
        }
        catch (Throwable throwable) {
            charset = StandardCharsets.UTF_8;
        }
        Charset encoding = charset;
        return Buf$.MODULE$.decodeString(this.content(), encoding);
    }

    public String getContentString() {
        return this.contentString();
    }

    public void contentString_$eq(String value) {
        String string = value;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.clearContent();
        } else {
            this.content_$eq(Buf.Utf8$.MODULE$.apply(value));
        }
    }

    public final void setContentString(String value) {
        this.contentString_$eq(value);
    }

    public <T> T withInputStream(Function1<InputStream, T> f) {
        Object object;
        try (InputStream inputStream = this.getInputStream();){
            object = f.apply((Object)inputStream);
        }
        return (T)object;
    }

    public final InputStream getInputStream() {
        return new BufInputStream(this.content());
    }

    public final <T> T withReader(Function1<Reader, T> f) {
        return this.withInputStream((Function1 & Serializable)inputStream -> {
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return f.apply((Object)reader);
        });
    }

    public final Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public final void write(String string) throws IllegalStateException {
        this.write(Buf.Utf8$.MODULE$.apply(string));
    }

    public final void write(Buf buf) throws IllegalStateException {
        if (this.isChunked()) {
            throw new IllegalStateException("Cannot write buffers to a chunked message!");
        }
        this.content_$eq(this.content().concat(buf));
    }

    public final void write(byte[] bytes) throws IllegalStateException {
        this.write(Buf.ByteArray$.Shared$.MODULE$.apply(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withOutputStream(Function1<OutputStream, T> f) throws IllegalStateException {
        void v0;
        try (BufOutputStream outputStream = new BufOutputStream(1024);){
            void var3_3;
            Object result = f.apply((Object)outputStream);
            this.write(outputStream.contentsAsBuf());
            v0 = var3_3;
        }
        return v0;
    }

    public final <T> T withWriter(Function1<Writer, T> f) throws IllegalStateException {
        return this.withOutputStream((Function1 & Serializable)outputStream -> {
            Object object;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
                object = f.apply((Object)writer);
            }
            return object;
        });
    }

    public final void clearContent() {
        this.content_$eq(Buf$.MODULE$.Empty());
    }

    public Future<BoxedUnit> close() {
        return this.writer().close();
    }

    public final Message keepAlive(boolean keepAlive) {
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http10();
        Version version3 = version;
        Object object = !(version2 != null ? !((Object)version2).equals(version3) : version3 != null) ? (keepAlive ? this.headerMap().setUnsafe("Connection", "keep-alive") : this.headerMap().remove("Connection")) : (keepAlive ? this.headerMap().remove("Connection") : this.headerMap().setUnsafe("Connection", "close"));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean keepAlive() {
        String value;
        boolean bl = false;
        Some some = null;
        Option<String> option = this.headerMap().get("Connection");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String value2 = (String)some.value();
            if (value2.equalsIgnoreCase("close")) {
                return false;
            }
        }
        if (bl && (value = (String)some.value()).equalsIgnoreCase("keep-alive")) {
            return true;
        }
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http11();
        if (version != null) {
            if (!((Object)version).equals(version2)) return false;
            return true;
        }
        if (version2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$charset_$eq$2(String x$6) {
        return x$6.trim().startsWith("charset=");
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$3(StringBuilder builder$1, IndexedSeq parts$1, int i) {
        builder$1.append(";");
        return builder$1.append((String)parts$1.apply(i));
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$4(IndexedSeq parts$1, StringBuilder builder$1, String value$1, int i) {
        StringBuilder stringBuilder;
        String part = (String)parts$1.apply(i);
        if (part.trim().startsWith("charset=")) {
            builder$1.append(";charset=");
            stringBuilder = builder$1.append(value$1);
        } else {
            builder$1.append(";");
            stringBuilder = builder$1.append(part);
        }
        return stringBuilder;
    }

    public static final /* synthetic */ boolean $anonfun$isXmlHttpRequest$1(String x$8) {
        return x$8.toLowerCase().contains("xmlhttprequest");
    }

    private static final class BufOutputStream
    extends ByteArrayOutputStream {
        public Buf contentsAsBuf() {
            return Buf.ByteArray$.Owned$.MODULE$.apply(this.buf, 0, this.count);
        }

        public BufOutputStream(int initialSize) {
            super(initialSize);
        }
    }
}

