/**
 * Generated by Scrooge
 *   version: 19.4.0
 *   rev: 44ffb0b8b14ed01267aa8408120a0783f0ccf898
 *   built at: 20190418-112835
 */
package com.twitter.finagle.exception.thriftscala

import com.twitter.scrooge._
import com.twitter.finagle.{
  service => ctfs,
  Filter => finagle$Filter,
  Service => finagle$Service,
  thrift => _,
  _
}
import com.twitter.finagle.stats.{Counter, StatsReceiver}
import com.twitter.finagle.thrift.{
  Protocols,
  RichClientParam,
  RichServerParam,
  ServerToReqRep,
  ThriftClientRequest,
  ToThriftService
}
import com.twitter.util.{Future, Return, Throw, Throwables}
import com.twitter.io.Buf
import org.apache.thrift.protocol._
import org.apache.thrift.TApplicationException
import scala.collection.mutable.Builder
import scala.collection.immutable.{Map => immutable$Map, Set => immutable$Set}
import scala.language.higherKinds


@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
trait Scribe[+MM[_]] extends _root_.com.twitter.finagle.thrift.ThriftService {
  
  def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()): MM[com.twitter.finagle.exception.thriftscala.ResultCode]

  /**
   * Used to close the underlying `Service`.
   * Not a user-defined API.
   */
  def asClosable: _root_.com.twitter.util.Closable = _root_.com.twitter.util.Closable.nop
}


object Scribe extends _root_.com.twitter.finagle.thrift.GeneratedThriftService { self =>

  val annotations: immutable$Map[String, String] = immutable$Map.empty

  val methods: immutable$Set[ThriftMethod] = immutable$Set(
    self.Log
  )

  trait ServicePerEndpoint
    extends ToThriftService
    with _root_.com.twitter.finagle.thrift.service.Filterable[ServicePerEndpoint] {
    def log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]

    def withLog(log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]): ServicePerEndpoint = this

    /**
     * Prepends the given type-agnostic `Filter` to all of the `Services`
     * and returns a copy of the `ServicePerEndpoint` now including the filter.
     */
    def filtered(filter: _root_.com.twitter.finagle.Filter.TypeAgnostic): ServicePerEndpoint = this

    /**
     * Converts the `ServicePerEndpoint` to a `GeneratedThriftService`.
     * @see _root_.com.twitter.scrooge.ToThriftService
     */
    def toThriftService: _root_.com.twitter.finagle.thrift.ThriftService = MethodPerEndpoint(this)

    /**
     * Used to close the underlying `Service`.
     * Not a user-defined API.
     */
    def asClosable: _root_.com.twitter.util.Closable = _root_.com.twitter.util.Closable.nop
  }

  trait ReqRepServicePerEndpoint
    extends ToThriftService
    with _root_.com.twitter.finagle.thrift.service.Filterable[ReqRepServicePerEndpoint] {
    def log : _root_.com.twitter.finagle.Service[com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]

    def withLog(log : _root_.com.twitter.finagle.Service[com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]): ReqRepServicePerEndpoint = this

    /**
     * Prepends the given type-agnostic `Filter` to all of the `Services`
     * and returns a copy of the `ServicePerEndpoint` now including the filter.
     */
    def filtered(filter: com.twitter.finagle.Filter.TypeAgnostic): ReqRepServicePerEndpoint = this

    /**
     * Converts the `ServicePerEndpoint` to a `GeneratedThriftService`.
     * @see _root_.com.twitter.scrooge.ToThriftService
     */
    def toThriftService: _root_.com.twitter.finagle.thrift.ThriftService = ReqRepMethodPerEndpoint(this)

    /**
     * Used to close the underlying `Service`.
     * Not a user-defined API.
     */
    def asClosable: _root_.com.twitter.util.Closable = _root_.com.twitter.util.Closable.nop
  }

  @deprecated("Use ServicePerEndpoint", "2017-11-07")
  trait BaseServiceIface extends ToThriftService {
    def log : com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]

    def toThriftService: _root_.com.twitter.finagle.thrift.ThriftService = new MethodIface(this)
  }

  object ServicePerEndpoint {

    def apply(
      log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
    ): ServicePerEndpoint = new ServicePerEndpointImpl(log)

    private final class ServicePerEndpointImpl(
      override val log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
    ) extends ServicePerEndpoint {

      override def withLog(
        log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
      ): ServicePerEndpoint =
        new ServicePerEndpointImpl(log)

      override def filtered(filter: _root_.com.twitter.finagle.Filter.TypeAgnostic): ServicePerEndpoint =
        new ServicePerEndpointImpl(
          log = filter.toFilter.andThen(log)
        )

      override def asClosable: _root_.com.twitter.util.Closable =
        _root_.com.twitter.util.Closable.all(
          this.log
        )
    }
  }

  object ReqRepServicePerEndpoint {

    def apply(
      log :  _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]
    ): ReqRepServicePerEndpoint =
      new ReqRepServicePerEndpointImpl(log)

    private final class ReqRepServicePerEndpointImpl(
      override val log : _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]
    ) extends ReqRepServicePerEndpoint {

      override def withLog(
        log : _root_.com.twitter.finagle.Service[com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]
      ): ReqRepServicePerEndpoint =
        new ReqRepServicePerEndpointImpl(log)

      override def filtered(filter: com.twitter.finagle.Filter.TypeAgnostic): ReqRepServicePerEndpoint =
        new ReqRepServicePerEndpointImpl(
          log = filter.toFilter.andThen(log)
        )

      override def asClosable: _root_.com.twitter.util.Closable =
        _root_.com.twitter.util.Closable.all(
          this.log
        )
    }
  }

  def unsafeBuildFromMethods(methods: immutable$Map[ThriftMethod,  _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[_], _root_.com.twitter.scrooge.Response[_]]]): ReqRepServicePerEndpoint = {
    val log = methods.get(self.Log) match {
      case Some(impl) => impl.asInstanceOf[self.Log.ReqRepServicePerEndpointServiceType]
      case _ => throw new IllegalArgumentException(s"No implementation found for method Log in ${methods.keySet}")
    }

    ReqRepServicePerEndpoint(log)
  }

  @deprecated("Use ServicePerEndpoint", "2017-11-07")
  case class ServiceIface(
    log : com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
  ) extends BaseServiceIface
    with _root_.com.twitter.finagle.thrift.service.Filterable[ServiceIface] {

    /**
     * Prepends the given type-agnostic `Filter` to all of the `Services`
     * and returns a copy of the `ServiceIface` now including the filter.
     */
    def filtered(filter: com.twitter.finagle.Filter.TypeAgnostic): ServiceIface =
      copy(
        log = filter.toFilter.andThen(log)
      )
  }

  implicit object ServicePerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.ServicePerEndpointBuilder[ServicePerEndpoint] {
      def servicePerEndpoint(
        thriftService: _root_.com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
        clientParam: RichClientParam
      ): ServicePerEndpoint =
        ServicePerEndpoint(
          log = _root_.com.twitter.finagle.thrift.service.ThriftServicePerEndpoint(
            self.Log,
            thriftService,
            clientParam
          )
        )
  }

  implicit object ReqRepServicePerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.ReqRepServicePerEndpointBuilder[ReqRepServicePerEndpoint] {
      def servicePerEndpoint(
        thriftService: _root_.com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
        clientParam: RichClientParam
      ): ReqRepServicePerEndpoint =
        ReqRepServicePerEndpoint(
          log = _root_.com.twitter.finagle.thrift.service.ThriftReqRepServicePerEndpoint(self.Log, thriftService, clientParam)
        )
  }

  @deprecated("Use ServicePerEndpointBuilder", "2017-11-07")
  implicit object ServiceIfaceBuilder
    extends com.twitter.finagle.thrift.ServiceIfaceBuilder[ServiceIface] {
      def newServiceIface(
        binaryService: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
        clientParam: RichClientParam
      ): ServiceIface =
        ServiceIface(
          log = _root_.com.twitter.finagle.thrift.service.ThriftServicePerEndpoint(
            self.Log,
            binaryService,
            clientParam
          )
        )
  }

  object Log extends ThriftMethod {
    
    object Args extends ValidatingThriftStructCodec3[Args] {
      val NoPassthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty[Short, TFieldBlob]
      val Struct: TStruct = new TStruct("log_args")
      val MessagesField: TField = new TField("messages", TType.LIST, 1)
      val MessagesFieldManifest: Manifest[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]] = implicitly[Manifest[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]]]
    
      /**
       * Field information in declaration order.
       */
      lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
        new ThriftStructFieldInfo(
          MessagesField,
          false,
          false,
          MessagesFieldManifest,
          _root_.scala.None,
          _root_.scala.Some(implicitly[Manifest[com.twitter.finagle.exception.thriftscala.LogEntry]]),
          immutable$Map.empty[String, String],
          immutable$Map.empty[String, String],
          None
        )
      )
    
      lazy val structAnnotations: immutable$Map[String, String] =
        immutable$Map.empty[String, String]
    
      /**
       * Checks that all required fields are non-null.
       */
      def validate(_item: Args): Unit = {
      }
    
      /**
       * Checks that the struct is a valid as a new instance. If there are any missing required or
       * construction required fields, return a non-empty list.
       */
      def validateNewInstance(item: Args): scala.Seq[com.twitter.scrooge.validation.Issue] = {
        val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]
    
        buf ++= validateField(item.messages)
        buf.toList
      }
    
      def withoutPassthroughFields(original: Args): Args =
        new Args(
          messages =
            {
              val field = original.messages
              field.map { field =>
                com.twitter.finagle.exception.thriftscala.LogEntry.withoutPassthroughFields(field)
              }
            }
        )
    
      override def encode(_item: Args, _oproto: TProtocol): Unit = {
        _item.write(_oproto)
      }
    
    
      override def decode(_iprot: TProtocol): Args = {
        var messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()
        var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
        var _done = false
    
        _iprot.readStructBegin()
        while (!_done) {
          val _field = _iprot.readFieldBegin()
          if (_field.`type` == TType.STOP) {
            _done = true
          } else {
            _field.id match {
              case 1 =>
                _field.`type` match {
                  case TType.LIST =>
                    messages = readMessagesValue(_iprot)
                  case _actualType =>
                    val _expectedType = TType.LIST
                    throw new TProtocolException(
                      "Received wrong type for field 'messages' (expected=%s, actual=%s).".format(
                        ttypeToString(_expectedType),
                        ttypeToString(_actualType)
                      )
                    )
                }
              case _ =>
                if (_passthroughFields == null)
                  _passthroughFields = immutable$Map.newBuilder[Short, TFieldBlob]
                _passthroughFields += (_field.id -> TFieldBlob.read(_field, _iprot))
            }
            _iprot.readFieldEnd()
          }
        }
        _iprot.readStructEnd()
    
        new Args(
          messages,
          if (_passthroughFields == null)
            NoPassthroughFields
          else
            _passthroughFields.result()
        )
      }
    
      def apply(
        messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()
      ): Args =
        new Args(
          messages
        )
    
      def unapply(_item: Args): _root_.scala.Option[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]] = _root_.scala.Some(_item.messages)
    
    
      @inline private[thriftscala] def readMessagesValue(_iprot: TProtocol): _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = {
        val _list = _iprot.readListBegin()
        if (_list.size == 0) {
          _iprot.readListEnd()
          Nil
        } else {
          val _rv = new _root_.scala.collection.mutable.ArrayBuffer[com.twitter.finagle.exception.thriftscala.LogEntry](_list.size)
          var _i = 0
          while (_i < _list.size) {
            _rv += {
              com.twitter.finagle.exception.thriftscala.LogEntry.decode(_iprot)
            }
            _i += 1
          }
          _iprot.readListEnd()
          _rv
        }
      }
    
      @inline private def writeMessagesField(messages_item: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry], _oprot: TProtocol): Unit = {
        _oprot.writeFieldBegin(MessagesField)
        writeMessagesValue(messages_item, _oprot)
        _oprot.writeFieldEnd()
      }
    
      @inline private def writeMessagesValue(messages_item: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry], _oprot: TProtocol): Unit = {
        _oprot.writeListBegin(new TList(TType.STRUCT, messages_item.size))
        messages_item match {
          case _: IndexedSeq[_] =>
            var _i = 0
            val _size = messages_item.size
            while (_i < _size) {
              val messages_item_element = messages_item(_i)
              messages_item_element.write(_oprot)
              _i += 1
            }
          case _ =>
            messages_item.foreach { messages_item_element =>
              messages_item_element.write(_oprot)
            }
        }
        _oprot.writeListEnd()
      }
    
    
    }
    
    class Args(
        val messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry],
        val _passthroughFields: immutable$Map[Short, TFieldBlob])
      extends ThriftStruct
      with _root_.scala.Product1[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]]
      with ValidatingThriftStruct[Args]
      with java.io.Serializable
    {
      import Args._
    
      def this(
        messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()
      ) = this(
        messages,
        Map.empty
      )
    
      def _1: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = messages
    
    
    
      override def write(_oprot: TProtocol): Unit = {
        Args.validate(this)
        _oprot.writeStructBegin(Struct)
        if (messages ne null) writeMessagesField(messages, _oprot)
        if (_passthroughFields.nonEmpty) {
          _passthroughFields.values.foreach { _.write(_oprot) }
        }
        _oprot.writeFieldStop()
        _oprot.writeStructEnd()
      }
    
      def copy(
        messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = this.messages,
        _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
      ): Args =
        new Args(
          messages,
          _passthroughFields
        )
    
      override def canEqual(other: Any): Boolean = other.isInstanceOf[Args]
    
      private def _equals(x: Args, y: Args): Boolean =
          x.productArity == y.productArity &&
          x.productIterator.sameElements(y.productIterator) &&
          x._passthroughFields == y._passthroughFields
    
      override def equals(other: Any): Boolean =
        canEqual(other) &&
          _equals(this, other.asInstanceOf[Args])
    
      override def hashCode: Int = {
        _root_.scala.runtime.ScalaRunTime._hashCode(this)
      }
    
      override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)
    
    
      override def productArity: Int = 1
    
      override def productElement(n: Int): Any = n match {
        case 0 => this.messages
        case _ => throw new IndexOutOfBoundsException(n.toString)
      }
    
      override def productPrefix: String = "Args"
    
      def _codec: ValidatingThriftStructCodec3[Args] = Args
    }

    type SuccessType = com.twitter.finagle.exception.thriftscala.ResultCode
    
    object Result extends ValidatingThriftStructCodec3[Result] {
      val NoPassthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty[Short, TFieldBlob]
      val Struct: TStruct = new TStruct("log_result")
      val SuccessField: TField = new TField("success", TType.ENUM, 0)
      val SuccessFieldI32: TField = new TField("success", TType.I32, 0)
      val SuccessFieldManifest: Manifest[com.twitter.finagle.exception.thriftscala.ResultCode] = implicitly[Manifest[com.twitter.finagle.exception.thriftscala.ResultCode]]
    
      /**
       * Field information in declaration order.
       */
      lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
        new ThriftStructFieldInfo(
          SuccessField,
          true,
          false,
          SuccessFieldManifest,
          _root_.scala.None,
          _root_.scala.None,
          immutable$Map.empty[String, String],
          immutable$Map.empty[String, String],
          None
        )
      )
    
      lazy val structAnnotations: immutable$Map[String, String] =
        immutable$Map.empty[String, String]
    
      /**
       * Checks that all required fields are non-null.
       */
      def validate(_item: Result): Unit = {
      }
    
      /**
       * Checks that the struct is a valid as a new instance. If there are any missing required or
       * construction required fields, return a non-empty list.
       */
      def validateNewInstance(item: Result): scala.Seq[com.twitter.scrooge.validation.Issue] = {
        val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]
    
        buf ++= validateField(item.success)
        buf.toList
      }
    
      def withoutPassthroughFields(original: Result): Result =
        new Result(
          success =
            {
              val field = original.success
              field.map { field =>
                field
              }
            }
        )
    
      override def encode(_item: Result, _oproto: TProtocol): Unit = {
        _item.write(_oproto)
      }
    
    
      override def decode(_iprot: TProtocol): Result = {
        var success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
        var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
        var _done = false
    
        _iprot.readStructBegin()
        while (!_done) {
          val _field = _iprot.readFieldBegin()
          if (_field.`type` == TType.STOP) {
            _done = true
          } else {
            _field.id match {
              case 0 =>
                _field.`type` match {
                  case TType.I32 | TType.ENUM =>
                    success = _root_.scala.Some(readSuccessValue(_iprot))
                  case _actualType =>
                    val _expectedType = TType.ENUM
                    throw new TProtocolException(
                      "Received wrong type for field 'success' (expected=%s, actual=%s).".format(
                        ttypeToString(_expectedType),
                        ttypeToString(_actualType)
                      )
                    )
                }
              case _ =>
                if (_passthroughFields == null)
                  _passthroughFields = immutable$Map.newBuilder[Short, TFieldBlob]
                _passthroughFields += (_field.id -> TFieldBlob.read(_field, _iprot))
            }
            _iprot.readFieldEnd()
          }
        }
        _iprot.readStructEnd()
    
        new Result(
          success,
          if (_passthroughFields == null)
            NoPassthroughFields
          else
            _passthroughFields.result()
        )
      }
    
      def apply(
        success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
      ): Result =
        new Result(
          success
        )
    
      def unapply(_item: Result): _root_.scala.Option[_root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode]] = _root_.scala.Some(_item.success)
    
    
      @inline private[thriftscala] def readSuccessValue(_iprot: TProtocol): com.twitter.finagle.exception.thriftscala.ResultCode = {
        com.twitter.finagle.exception.thriftscala.ResultCode.getOrUnknown(_iprot.readI32())
      }
    
      @inline private def writeSuccessField(success_item: com.twitter.finagle.exception.thriftscala.ResultCode, _oprot: TProtocol): Unit = {
        _oprot.writeFieldBegin(SuccessFieldI32)
        writeSuccessValue(success_item, _oprot)
        _oprot.writeFieldEnd()
      }
    
      @inline private def writeSuccessValue(success_item: com.twitter.finagle.exception.thriftscala.ResultCode, _oprot: TProtocol): Unit = {
        _oprot.writeI32(success_item.value)
      }
    
    
    }
    
    class Result(
        val success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode],
        val _passthroughFields: immutable$Map[Short, TFieldBlob])
      extends ThriftResponse[com.twitter.finagle.exception.thriftscala.ResultCode] with ThriftStruct
      with _root_.scala.Product1[Option[com.twitter.finagle.exception.thriftscala.ResultCode]]
      with ValidatingThriftStruct[Result]
      with java.io.Serializable
    {
      import Result._
    
      def this(
        success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
      ) = this(
        success,
        Map.empty
      )
    
      def _1: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = success
    
      def successField: Option[com.twitter.finagle.exception.thriftscala.ResultCode] = success
      def exceptionFields: Iterable[Option[com.twitter.scrooge.ThriftException]] = Seq()
    
    
      override def write(_oprot: TProtocol): Unit = {
        Result.validate(this)
        _oprot.writeStructBegin(Struct)
        if (success.isDefined) writeSuccessField(success.get, _oprot)
        if (_passthroughFields.nonEmpty) {
          _passthroughFields.values.foreach { _.write(_oprot) }
        }
        _oprot.writeFieldStop()
        _oprot.writeStructEnd()
      }
    
      def copy(
        success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = this.success,
        _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
      ): Result =
        new Result(
          success,
          _passthroughFields
        )
    
      override def canEqual(other: Any): Boolean = other.isInstanceOf[Result]
    
      private def _equals(x: Result, y: Result): Boolean =
          x.productArity == y.productArity &&
          x.productIterator.sameElements(y.productIterator) &&
          x._passthroughFields == y._passthroughFields
    
      override def equals(other: Any): Boolean =
        canEqual(other) &&
          _equals(this, other.asInstanceOf[Result])
    
      override def hashCode: Int = {
        _root_.scala.runtime.ScalaRunTime._hashCode(this)
      }
    
      override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)
    
    
      override def productArity: Int = 1
    
      override def productElement(n: Int): Any = n match {
        case 0 => this.success
        case _ => throw new IndexOutOfBoundsException(n.toString)
      }
    
      override def productPrefix: String = "Result"
    
      def _codec: ValidatingThriftStructCodec3[Result] = Result
    }

    val annotations: immutable$Map[String, String] = immutable$Map.empty

    type FunctionType = Function1[Args,Future[com.twitter.finagle.exception.thriftscala.ResultCode]]
    type ReqRepFunctionType = Function1[_root_.com.twitter.scrooge.Request[Args],Future[_root_.com.twitter.scrooge.Response[com.twitter.finagle.exception.thriftscala.ResultCode]]]

    type ServiceIfaceServiceType = _root_.com.twitter.finagle.Service[Args, SuccessType]
    type ServicePerEndpointServiceType = _root_.com.twitter.finagle.Service[Args, SuccessType]
    type ReqRepServicePerEndpointServiceType = _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[Args], _root_.com.twitter.scrooge.Response[SuccessType]]

    def toServiceIfaceService(f: FunctionType): ServiceIfaceServiceType =
      _root_.com.twitter.finagle.Service.mk { args: Args =>
        f(args)
      }

    def toServicePerEndpointService(f: FunctionType): ServicePerEndpointServiceType =
      _root_.com.twitter.finagle.Service.mk { args: Args =>
        f(args)
      }

    def toReqRepServicePerEndpointService(f: ReqRepFunctionType): ReqRepServicePerEndpointServiceType =
      _root_.com.twitter.finagle.Service.mk[_root_.com.twitter.scrooge.Request[Args], _root_.com.twitter.scrooge.Response[SuccessType]] { request: _root_.com.twitter.scrooge.Request[Args] =>
        f(request)
      }


    val name: String = "Log"
    val serviceName: String = "Scribe"
    val argsCodec: Args.type = Args
    val responseCodec: Result.type = Result
    val oneway: Boolean = false
  }

  // Compatibility aliases.
  val log$args: Log.Args.type = Log.Args
  type log$args = Log.Args

  val log$result: Log.Result.type = Log.Result
  type log$result = Log.Result


  trait MethodPerEndpoint
    extends Scribe[Future] {
    
    def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()): Future[com.twitter.finagle.exception.thriftscala.ResultCode]
  }

  object MethodPerEndpoint {

    def apply(servicePerEndpoint: ServicePerEndpoint): MethodPerEndpoint = {
      new MethodPerEndpointImpl(servicePerEndpoint) {}
    }

    /**
     * Use `MethodPerEndpoint.apply()` instead of this constructor.
     */
    class MethodPerEndpointImpl protected (servicePerEndpoint: ServicePerEndpoint)
      extends MethodPerEndpoint {
        def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()): Future[com.twitter.finagle.exception.thriftscala.ResultCode] =
          servicePerEndpoint.log(self.Log.Args(messages))

        override def asClosable: _root_.com.twitter.util.Closable =
          servicePerEndpoint.asClosable
    }
  }

  object ReqRepMethodPerEndpoint {

    def apply(servicePerEndpoint: ReqRepServicePerEndpoint): MethodPerEndpoint =
      new ReqRepMethodPerEndpointImpl(servicePerEndpoint) { }

    /**
     * Use `ReqRepMethodPerEndpoint.apply()` instead of this constructor.
     */
    class ReqRepMethodPerEndpointImpl protected (servicePerEndpoint: ReqRepServicePerEndpoint)
      extends MethodPerEndpoint {

        def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()): Future[com.twitter.finagle.exception.thriftscala.ResultCode] = {
          val requestCtx = _root_.com.twitter.finagle.context.Contexts.local.getOrElse(_root_.com.twitter.finagle.thrift.Headers.Request.Key, () => _root_.com.twitter.finagle.thrift.Headers.Request.newValues)
          val scroogeRequest = _root_.com.twitter.scrooge.Request(requestCtx.values, self.Log.Args(messages))
          servicePerEndpoint.log(scroogeRequest).transform(_root_.com.twitter.finagle.thrift.service.ThriftReqRepServicePerEndpoint.transformResult(_))
        }

        override def asClosable: _root_.com.twitter.util.Closable =
          servicePerEndpoint.asClosable
    }
  }

  @deprecated("Use MethodPerEndpoint", "2017-11-07")
  class MethodIface(serviceIface: BaseServiceIface)
    extends FutureIface {
    def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()): Future[com.twitter.finagle.exception.thriftscala.ResultCode] =
      serviceIface.log(self.Log.Args(messages))
  }

  implicit object MethodPerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.MethodPerEndpointBuilder[ServicePerEndpoint, MethodPerEndpoint] {
    def methodPerEndpoint(servicePerEndpoint: ServicePerEndpoint): MethodPerEndpoint =
      MethodPerEndpoint(servicePerEndpoint)
  }

  @deprecated("Use MethodPerEndpointBuilder", "2018-01-12")
  implicit object ThriftServiceBuilder
    extends _root_.com.twitter.finagle.thrift.service.ThriftServiceBuilder[ServicePerEndpoint, Scribe[Future]] {
    def build(servicePerEndpoint: ServicePerEndpoint): MethodPerEndpoint =
      MethodPerEndpoint(servicePerEndpoint)
  }

  implicit object ReqRepMethodPerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.ReqRepMethodPerEndpointBuilder[ReqRepServicePerEndpoint, MethodPerEndpoint] {
    def methodPerEndpoint(servicePerEndpoint: ReqRepServicePerEndpoint): MethodPerEndpoint =
      ReqRepMethodPerEndpoint(servicePerEndpoint)
  }

  @deprecated("Use ReqRepMethodPerEndpointBuilder", "2018-01-12")
  implicit object ReqRepThriftServiceBuilder
    extends _root_.com.twitter.finagle.thrift.service.ReqRepThriftServiceBuilder[ReqRepServicePerEndpoint, Scribe[Future]] {
    def build(servicePerEndpoint: ReqRepServicePerEndpoint): MethodPerEndpoint =
      ReqRepMethodPerEndpoint(servicePerEndpoint)
  }

  @deprecated("Use MethodPerEndpointBuilder", "2017-11-07")
  implicit object MethodIfaceBuilder
    extends com.twitter.finagle.thrift.MethodIfaceBuilder[ServiceIface, Scribe[Future]] {
    def newMethodIface(serviceIface: ServiceIface): MethodIface =
      new MethodIface(serviceIface)
  }

  @deprecated("Use MethodPerEndpoint", "2017-11-07")
  trait FutureIface
    extends Scribe[Future] {
    
    def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]()): Future[com.twitter.finagle.exception.thriftscala.ResultCode]
  }

  class FinagledClient(
      service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
      clientParam: RichClientParam)
    extends Scribe$FinagleClient(service, clientParam)
    with FutureIface
    with MethodPerEndpoint {

    @deprecated("Use com.twitter.finagle.thrift.RichClientParam", "2017-08-16")
    def this(
      service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
      protocolFactory: org.apache.thrift.protocol.TProtocolFactory = Protocols.binaryFactory(),
      serviceName: String = "Scribe",
      stats: com.twitter.finagle.stats.StatsReceiver = com.twitter.finagle.stats.NullStatsReceiver,
      responseClassifier: ctfs.ResponseClassifier = ctfs.ResponseClassifier.Default
    ) = this(
      service,
      RichClientParam(
        protocolFactory,
        serviceName,
        clientStats = stats,
        responseClassifier = responseClassifier
      )
    )

    @deprecated("Use com.twitter.finagle.thrift.RichClientParam", "2017-08-16")
    def this(
      service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
      protocolFactory: org.apache.thrift.protocol.TProtocolFactory,
      serviceName: String,
      stats: com.twitter.finagle.stats.StatsReceiver
    ) = this(
      service,
      RichClientParam(
        protocolFactory,
        serviceName,
        clientStats = stats
      )
    )
  }

  class FinagledService(
      iface: Scribe[Future],
      serverParam: RichServerParam)
    extends Scribe$FinagleService(iface, serverParam) {

    @deprecated("Use com.twitter.finagle.thrift.RichServerParam", "2017-08-16")
    def this(
      iface: Scribe[Future],
      protocolFactory: org.apache.thrift.protocol.TProtocolFactory,
      serviceName: String = "Scribe"
    ) = this(iface, RichServerParam(protocolFactory, serviceName))
  }

  class Filter(serverParam: RichServerParam) {
    private[this] def protocolFactory: TProtocolFactory = serverParam.restrictedProtocolFactory

    private[this] def serviceName: String = serverParam.serviceName
    private[this] def responseClassifier: ctfs.ResponseClassifier = serverParam.responseClassifier
    private[this] def stats: StatsReceiver = serverParam.serverStats
    private[this] def perEndpointStats: Boolean = serverParam.perEndpointStats && !stats.isNull
    private[this] def maxReusableBufferSize: Int = serverParam.maxThriftBufferSize

    private[this] val tlReusableBuffer: TReusableBuffer = TReusableBuffer(maxThriftBufferSize = maxReusableBufferSize)

    private[thriftscala] def exception(name: String, seqid: Int, code: Int, message: String): Buf = {
      val x = new TApplicationException(code, message)
      val memoryBuffer = tlReusableBuffer.get()
      try {
        val oprot = protocolFactory.getProtocol(memoryBuffer)

        oprot.writeMessageBegin(new TMessage(name, TMessageType.EXCEPTION, seqid))
        x.write(oprot)
        oprot.writeMessageEnd()
        oprot.getTransport().flush()

        // make a copy of the array of bytes to construct a new buffer because memoryBuffer is reusable
        Buf.ByteArray.Shared(memoryBuffer.getArray(), 0, memoryBuffer.length())
      } finally {
        tlReusableBuffer.reset()
      }
    }

    private def reply(name: String, seqid: Int, result: ThriftStruct): Buf = {
      val memoryBuffer = tlReusableBuffer.get()
      try {
        val oprot = protocolFactory.getProtocol(memoryBuffer)
        val start = System.nanoTime
        oprot.writeMessageBegin(new TMessage(name, TMessageType.REPLY, seqid))
        result.write(oprot)
        oprot.writeMessageEnd()
        _root_.com.twitter.finagle.tracing.Trace.recordBinary("srv/response_serialization_ns", System.nanoTime - start)
        oprot.getTransport().flush()

        // make a copy of the array of bytes to construct a new buffer because memoryBuffer is reusable
        Buf.ByteArray.Shared(memoryBuffer.getArray(), 0, memoryBuffer.length())
      } finally {
        tlReusableBuffer.reset()
      }
    }

    private object ThriftMethodStats {
      def apply(stats: StatsReceiver): ThriftMethodStats =
        ThriftMethodStats(
          stats.counter("requests"),
          stats.counter("success"),
          stats.counter("failures"),
          stats.scope("failures")
        )
    }

    private case class ThriftMethodStats(
      requestsCounter: Counter,
      successCounter: Counter,
      failuresCounter: Counter,
      failuresScope: StatsReceiver
    )

    private def missingResult(name: String): TApplicationException = {
      new TApplicationException(
        TApplicationException.MISSING_RESULT,
        name + " failed: unknown result"
      )
    }

    private def setServiceName(ex: Throwable): Throwable =
      if (this.serviceName == "") ex
      else {
        ex match {
          case se: _root_.com.twitter.finagle.SourcedException =>
            se.serviceName = this.serviceName
            se
          case _ => ex
        }
      }

    private def recordRequest(method: ThriftMethod): Unit = {
      if (perEndpointStats) {
        val methodStats = ThriftMethodStats((if (serviceName != "") stats.scope(serviceName) else stats).scope(method.name))
        methodStats.requestsCounter.incr()
      }
    }

    private def recordResponse(reqRep: ctfs.ReqRep, method: ThriftMethod): Unit = {
      ServerToReqRep.setCtx(reqRep)
      if (perEndpointStats) {
        val methodStats = ThriftMethodStats((if (serviceName != "") stats.scope(serviceName) else stats).scope(method.name))
        val responseClass = responseClassifier.applyOrElse(reqRep, ctfs.ResponseClassifier.Default)
        responseClass match {
          case ctfs.ResponseClass.Successful(_) =>
            methodStats.successCounter.incr()
          case ctfs.ResponseClass.Failed(_) =>
            methodStats.failuresCounter.incr()
            reqRep.response match {
              case Throw(ex) =>
                methodStats.failuresScope.counter(Throwables.mkString(ex): _*).incr()
              case _ =>
            }
        }
      }
    }

    final protected def perMethodStatsFilter(
      method: ThriftMethod
    ): finagle$Filter[(TProtocol, Int), Array[Byte], (TProtocol, Int), RichResponse[method.Args, method.Result]] = {
      new finagle$Filter[(TProtocol, Int), Array[Byte], (TProtocol, Int), RichResponse[method.Args, method.Result]] {
        def apply(
          req: (TProtocol, Int),
          service: finagle$Service[(TProtocol, Int), RichResponse[method.Args, method.Result]]
        ): Future[Array[Byte]] = {
          recordRequest(method)
          service(req).transform {
            case Return(value) =>
              value match {
                case SuccessfulResponse(args, _, result) =>
                  recordResponse(ctfs.ReqRep(args, _root_.com.twitter.util.Return(result.successField.get)), method)
                case ProtocolExceptionResponse(args, _, exp) =>
                  recordResponse(ctfs.ReqRep(args, _root_.com.twitter.util.Throw(exp)), method)
                case ThriftExceptionResponse(args, _, ex) =>
                  val rep = ex match {
                    case exp: ThriftException => setServiceName(exp)
                    case _ => missingResult(serviceName)
                  }
                  recordResponse(ctfs.ReqRep(args, _root_.com.twitter.util.Throw(rep)), method)
              }
              Future.value(Buf.ByteArray.Owned.extract(value.response))
            case t @ Throw(_) =>
              recordResponse(ctfs.ReqRep(req, t), method)
              Future.const(t.cast[Array[Byte]])
          }
        }
      }
    }
    // ---- end boilerplate.

    val log: finagle$Filter[(TProtocol, Int), Array[Byte], Log.Args, Log.SuccessType] = {
      val statsFilter: finagle$Filter[(TProtocol, Int), Array[Byte], (TProtocol, Int), RichResponse[Log.Args, Log.Result]] = perMethodStatsFilter(Log)
    
      val protocolExnFilter = new SimpleFilter[(TProtocol, Int), RichResponse[Log.Args, Log.Result]] {
        def apply(
          request: (TProtocol, Int),
          service: _root_.com.twitter.finagle.Service[(TProtocol, Int), RichResponse[Log.Args, Log.Result]]
        ): Future[RichResponse[Log.Args, Log.Result]] = {
          val iprot = request._1
          val seqid = request._2
          val res = service(request)
          res.transform {
            case _root_.com.twitter.util.Throw(e: TProtocolException) =>
              iprot.readMessageEnd()
              Future.value(
                ProtocolExceptionResponse(
                  null,
                  exception("Log", seqid, TApplicationException.PROTOCOL_ERROR, e.getMessage),
                  new TApplicationException(TApplicationException.PROTOCOL_ERROR, e.getMessage)))
            case _ =>
              res
          }
        }
      }
    
      val serdeFilter = new finagle$Filter[(TProtocol, Int), RichResponse[Log.Args, Log.Result], Log.Args, Log.SuccessType] {
        def apply(
          request: (TProtocol, Int),
          service: _root_.com.twitter.finagle.Service[Log.Args, Log.SuccessType]
        ): Future[RichResponse[Log.Args, Log.Result]] = {
          val iprot = request._1
          val seqid = request._2
          val start = System.nanoTime
          val args = Log.Args.decode(iprot)
          iprot.readMessageEnd()
          _root_.com.twitter.finagle.tracing.Trace.recordBinary("srv/request_deserialization_ns", System.nanoTime - start)
          val res = _root_.com.twitter.finagle.context.Contexts.local.let(
            _root_.com.twitter.finagle.thrift.MethodMetadata.Key,
            _root_.com.twitter.finagle.thrift.MethodMetadata(Log)) {
            service(args)
          }
          res.transform {
            case _root_.com.twitter.util.Return(value) =>
              val methodResult = Log.Result(success = Some(value))
              Future.value(
                SuccessfulResponse(
                  args,
                  reply("Log", seqid, methodResult),
                  methodResult))
            case t @ _root_.com.twitter.util.Throw(_) =>
              Future.const(t.cast[RichResponse[Log.Args, Log.Result]])
          }
        }
      }
    
      statsFilter.andThen(protocolExnFilter).andThen(serdeFilter)
    }
  }

}
