/**
 * Generated by Scrooge
 *   version: 20.6.0
 *   rev: 7d3cb2c5e35a83205a5617dd26b0dcb8c141fc10
 *   built at: 20200624-004342
 */
package com.twitter.finagle.exception.thriftscala

import com.twitter.finagle.{service => ctfs}
import com.twitter.finagle.stats.{NullStatsReceiver, StatsReceiver}
import com.twitter.finagle.thrift.{Protocols, RichClientParam, ThriftClientRequest}
import com.twitter.util.Future
import org.apache.thrift.TApplicationException
import org.apache.thrift.protocol._


@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
class Scribe$FinagleClient(
    val service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
    val clientParam: RichClientParam)
  extends Scribe[Future] {

  @deprecated("Use com.twitter.finagle.thrift.RichClientParam", "2017-08-16")
  def this(
    service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
    protocolFactory: TProtocolFactory = Protocols.binaryFactory(),
    serviceName: String = "Scribe",
    stats: StatsReceiver = NullStatsReceiver,
    responseClassifier: ctfs.ResponseClassifier = ctfs.ResponseClassifier.Default
  ) = this(
    service,
    RichClientParam(
      protocolFactory,
      serviceName,
      clientStats = stats,
      responseClassifier = responseClassifier
    )
  )

  import Scribe._

  def serviceName: String = clientParam.serviceName

  override def asClosable: _root_.com.twitter.util.Closable = service

  private[this] def protocolFactory: TProtocolFactory = clientParam.restrictedProtocolFactory

  private[this] val tlReusableBuffer: _root_.com.twitter.scrooge.TReusableBuffer =
    clientParam.createThriftReusableBuffer()

  protected def encodeRequest(name: String, args: _root_.com.twitter.scrooge.ThriftStruct): ThriftClientRequest = {
    val memoryBuffer = tlReusableBuffer.get()
    try {
      val oprot = protocolFactory.getProtocol(memoryBuffer)

      oprot.writeMessageBegin(new TMessage(name, TMessageType.CALL, 0))
      args.write(oprot)
      oprot.writeMessageEnd()
      oprot.getTransport.flush()
      val bytes = _root_.java.util.Arrays.copyOfRange(
        memoryBuffer.getArray(),
        0,
        memoryBuffer.length()
      )
      new ThriftClientRequest(bytes, false)
    } finally {
      tlReusableBuffer.reset()
    }
  }

  protected def decodeResponse[T <: _root_.com.twitter.scrooge.ThriftStruct](
    resBytes: Array[Byte],
    codec: _root_.com.twitter.scrooge.ThriftStructCodec[T]
  ): T = {
    val iprot = protocolFactory.getProtocol(
      new org.apache.thrift.transport.TMemoryInputTransport(resBytes)
    )
    val msg = iprot.readMessageBegin()
    try {
      if (msg.`type` == TMessageType.EXCEPTION) {
        val exception = TApplicationException.readFrom(iprot)
        setServiceName(exception)
        throw exception
      } else {
        codec.decode(iprot)
      }
    } finally {
      iprot.readMessageEnd()
    }
  }

  protected def setServiceName(ex: Throwable): Throwable = {
    _root_.com.twitter.finagle.SourcedException.setServiceName(ex, serviceName)
  }

  // ----- end boilerplate.

  private[this] def stats: StatsReceiver = clientParam.clientStats
  private[this] def responseClassifier: ctfs.ResponseClassifier = clientParam.responseClassifier

  private[this] val scopedStats: StatsReceiver = if (serviceName != "") stats.scope(serviceName) else stats
  private[this] object __stats_log {
    val RequestsCounter: _root_.com.twitter.finagle.stats.Counter = scopedStats.scope("Log").counter("requests")
    val SuccessCounter: _root_.com.twitter.finagle.stats.Counter = scopedStats.scope("Log").counter("success")
    val FailuresCounter: _root_.com.twitter.finagle.stats.Counter = scopedStats.scope("Log").counter("failures")
    val FailuresScope: StatsReceiver = scopedStats.scope("Log").scope("failures")
  }
  val LogScribeReplyDeserializer: Array[Byte] => _root_.com.twitter.util.Try[com.twitter.finagle.exception.thriftscala.ResultCode] = {
    response: Array[Byte] => {
      val result: Log.Result = decodeResponse(response, Log.Result)
      val firstException = result.firstException()
      if (firstException.isDefined) {
        _root_.com.twitter.util.Throw(setServiceName(firstException.get))
      } else if (result.successField.isDefined) {
        _root_.com.twitter.util.Return(result.successField.get)
      } else {
        _root_.com.twitter.util.Throw(_root_.com.twitter.scrooge.internal.ApplicationExceptions.missingResult("Log"))
      }
    }
  }
  
  def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): Future[com.twitter.finagle.exception.thriftscala.ResultCode] = {
    __stats_log.RequestsCounter.incr()
    val inputArgs = Log.Args(messages)
  
    val serdeCtx = new _root_.com.twitter.finagle.thrift.ClientDeserializeCtx[com.twitter.finagle.exception.thriftscala.ResultCode](inputArgs, LogScribeReplyDeserializer)
    _root_.com.twitter.finagle.context.Contexts.local.let(
      _root_.com.twitter.finagle.thrift.ClientDeserializeCtx.Key,
      serdeCtx,
      _root_.com.twitter.finagle.thrift.Headers.Request.Key,
      _root_.com.twitter.finagle.thrift.Headers.Request.newValues
    ) {
      serdeCtx.rpcName("Log")
      val start = System.nanoTime
      val serialized = encodeRequest("Log", inputArgs)
      serdeCtx.serializationTime(System.nanoTime - start)
      this.service(serialized).flatMap { response =>
        Future.const(serdeCtx.deserialize(response))
      }.respond { response =>
        val classified = responseClassifier.applyOrElse(
          ctfs.ReqRep(inputArgs, response),
          ctfs.ResponseClassifier.Default)
        if (classified.isInstanceOf[ctfs.ResponseClass.Successful]) {
          __stats_log.SuccessCounter.incr()
        } else if (classified.isInstanceOf[ctfs.ResponseClass.Failed]) {
          __stats_log.FailuresCounter.incr()
          if (response.isThrow) {
            setServiceName(response.throwable)
            __stats_log.FailuresScope.counter(
              _root_.com.twitter.util.Throwables.mkString(response.throwable): _*).incr()
          }
        } // Last ResponseClass is Ignorable, which we do not need to record
      }
    }
  }
}
