/**
 * Generated by Scrooge
 *   version: 20.8.0
 *   rev: e516820dfd23d028975ce3c5c36b85c8bab37b9a
 *   built at: 20200811-183624
 */
package com.twitter.finagle.exception.thriftscala

import com.twitter.scrooge._
import com.twitter.finagle.{
  service => ctfs,
  Filter => finagle$Filter,
  Service => finagle$Service,
  thrift => _,
  _
}
import com.twitter.finagle.stats.{Counter, StatsReceiver}
import com.twitter.finagle.thrift.{
  Protocols,
  RichClientParam,
  RichServerParam,
  ServerToReqRep,
  ThriftClientRequest,
  ToThriftService
}
import com.twitter.util.{Future, Return, Throw, Throwables}
import com.twitter.io.Buf
import org.apache.thrift.protocol._
import org.apache.thrift.TApplicationException
import scala.collection.mutable.Builder
import scala.collection.immutable.{Map => immutable$Map, Set => immutable$Set}
import scala.language.higherKinds
import scala.reflect.{ClassTag, classTag}


@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
trait Scribe[+MM[_]] extends _root_.com.twitter.finagle.thrift.ThriftService {
  
  def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): MM[com.twitter.finagle.exception.thriftscala.ResultCode]

  /**
   * Used to close the underlying `Service`.
   * Not a user-defined API.
   */
  def asClosable: _root_.com.twitter.util.Closable = _root_.com.twitter.util.Closable.nop
}


object Scribe extends _root_.com.twitter.finagle.thrift.GeneratedThriftService { self =>

  val annotations: immutable$Map[String, String] = immutable$Map.empty

  val methods: immutable$Set[ThriftMethod] = immutable$Set(
    self.Log
  )

  trait ServicePerEndpoint
    extends ToThriftService
    with _root_.com.twitter.finagle.thrift.service.Filterable[ServicePerEndpoint] {
    def log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]

    def withLog(log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]): ServicePerEndpoint = this

    /**
     * Prepends the given type-agnostic `Filter` to all of the `Services`
     * and returns a copy of the `ServicePerEndpoint` now including the filter.
     */
    def filtered(filter: _root_.com.twitter.finagle.Filter.TypeAgnostic): ServicePerEndpoint =
      ServicePerEndpoint.apply(log).filtered(filter)

    /**
     * Converts the `ServicePerEndpoint` to a `GeneratedThriftService`.
     * @see _root_.com.twitter.scrooge.ToThriftService
     */
    def toThriftService: _root_.com.twitter.finagle.thrift.ThriftService = MethodPerEndpoint(this)

    /**
     * Used to close the underlying `Service`.
     * Not a user-defined API.
     */
    def asClosable: _root_.com.twitter.util.Closable = _root_.com.twitter.util.Closable.nop
  }

  trait ReqRepServicePerEndpoint
    extends ToThriftService
    with _root_.com.twitter.finagle.thrift.service.Filterable[ReqRepServicePerEndpoint] {
    def log : _root_.com.twitter.finagle.Service[com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]

    def withLog(log : _root_.com.twitter.finagle.Service[com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]): ReqRepServicePerEndpoint = this

    /**
     * Prepends the given type-agnostic `Filter` to all of the `Services`
     * and returns a copy of the `ServicePerEndpoint` now including the filter.
     */
    def filtered(filter: com.twitter.finagle.Filter.TypeAgnostic): ReqRepServicePerEndpoint =
      ReqRepServicePerEndpoint.apply(log).filtered(filter)

    /**
     * Converts the `ServicePerEndpoint` to a `GeneratedThriftService`.
     * @see _root_.com.twitter.scrooge.ToThriftService
     */
    def toThriftService: _root_.com.twitter.finagle.thrift.ThriftService = ReqRepMethodPerEndpoint(this)

    /**
     * Used to close the underlying `Service`.
     * Not a user-defined API.
     */
    def asClosable: _root_.com.twitter.util.Closable = _root_.com.twitter.util.Closable.nop
  }

  @deprecated("Use ServicePerEndpoint", "2017-11-07")
  trait BaseServiceIface extends ToThriftService {
    def log : com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]

    def toThriftService: _root_.com.twitter.finagle.thrift.ThriftService = new MethodIface(this)
  }

  object ServicePerEndpoint {

    def apply(
      log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
    ): ServicePerEndpoint = new ServicePerEndpointImpl(log)

    private final class ServicePerEndpointImpl(
      override val log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
    ) extends ServicePerEndpoint {

      override def withLog(
        log : _root_.com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
      ): ServicePerEndpoint =
        new ServicePerEndpointImpl(log)

      override def filtered(filter: _root_.com.twitter.finagle.Filter.TypeAgnostic): ServicePerEndpoint =
        new ServicePerEndpointImpl(
          log = filter.toFilter.andThen(log)
        )

      override def asClosable: _root_.com.twitter.util.Closable =
        _root_.com.twitter.util.Closable.all(
          this.log
        )
    }
  }

  object ReqRepServicePerEndpoint {

    def apply(
      log :  _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]
    ): ReqRepServicePerEndpoint =
      new ReqRepServicePerEndpointImpl(log)

    private final class ReqRepServicePerEndpointImpl(
      override val log : _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]
    ) extends ReqRepServicePerEndpoint {

      override def withLog(
        log : _root_.com.twitter.finagle.Service[com.twitter.scrooge.Request[self.Log.Args], _root_.com.twitter.scrooge.Response[self.Log.SuccessType]]
      ): ReqRepServicePerEndpoint =
        new ReqRepServicePerEndpointImpl(log)

      override def filtered(filter: com.twitter.finagle.Filter.TypeAgnostic): ReqRepServicePerEndpoint =
        new ReqRepServicePerEndpointImpl(
          log = filter.toFilter.andThen(log)
        )

      override def asClosable: _root_.com.twitter.util.Closable =
        _root_.com.twitter.util.Closable.all(
          this.log
        )
    }
  }

  def unsafeBuildFromMethods(methods: immutable$Map[ThriftMethod,  _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[_], _root_.com.twitter.scrooge.Response[_]]]): ReqRepServicePerEndpoint = {
    val log = {
      val logOpt = methods.get(self.Log)
      if (logOpt.isEmpty) throw new IllegalArgumentException(_root_.java.lang.String.format("No implementation found for method Log in %s", methods.keySet))
      logOpt.get.asInstanceOf[self.Log.ReqRepServicePerEndpointServiceType]
    }

    ReqRepServicePerEndpoint(log)
  }

  @deprecated("Use ServicePerEndpoint", "2017-11-07")
  case class ServiceIface(
    log : com.twitter.finagle.Service[self.Log.Args, self.Log.SuccessType]
  ) extends BaseServiceIface
    with _root_.com.twitter.finagle.thrift.service.Filterable[ServiceIface] {

    /**
     * Prepends the given type-agnostic `Filter` to all of the `Services`
     * and returns a copy of the `ServiceIface` now including the filter.
     */
    def filtered(filter: com.twitter.finagle.Filter.TypeAgnostic): ServiceIface =
      copy(
        log = filter.toFilter.andThen(log)
      )
  }

  implicit object ServicePerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.ServicePerEndpointBuilder[ServicePerEndpoint] {
      def servicePerEndpoint(
        thriftService: _root_.com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
        clientParam: RichClientParam
      ): ServicePerEndpoint =
        ServicePerEndpoint(
          log = _root_.com.twitter.finagle.thrift.service.ThriftServicePerEndpoint(
            self.Log,
            thriftService,
            clientParam
          )
        )
  }

  implicit object ReqRepServicePerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.ReqRepServicePerEndpointBuilder[ReqRepServicePerEndpoint] {
      def servicePerEndpoint(
        thriftService: _root_.com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
        clientParam: RichClientParam
      ): ReqRepServicePerEndpoint =
        ReqRepServicePerEndpoint(
          log = _root_.com.twitter.finagle.thrift.service.ThriftReqRepServicePerEndpoint(self.Log, thriftService, clientParam)
        )
  }

  @deprecated("Use ServicePerEndpointBuilder", "2017-11-07")
  implicit object ServiceIfaceBuilder
    extends com.twitter.finagle.thrift.ServiceIfaceBuilder[ServiceIface] {
      def newServiceIface(
        binaryService: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
        clientParam: RichClientParam
      ): ServiceIface =
        ServiceIface(
          log = _root_.com.twitter.finagle.thrift.service.ThriftServicePerEndpoint(
            self.Log,
            binaryService,
            clientParam
          )
        )
  }

  object Log extends ThriftMethod {
    
    object Args extends ValidatingThriftStructCodec3[Args] with StructBuilderFactory[Args] {
      val NoPassthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty[Short, TFieldBlob]
      val Struct: TStruct = new TStruct("log_args")
      val MessagesField: TField = new TField("messages", TType.LIST, 1)
      val MessagesFieldManifest: Manifest[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]] = manifest[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]]
    
      /**
       * Field information in declaration order.
       */
      lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
        new ThriftStructFieldInfo(
          MessagesField,
          false,
          false,
          MessagesFieldManifest,
          _root_.scala.None,
          _root_.scala.Some(manifest[com.twitter.finagle.exception.thriftscala.LogEntry]),
          immutable$Map.empty[String, String],
          immutable$Map.empty[String, String],
          None,
          _root_.scala.Option(_root_.scala.collection.immutable.Nil)
        )
      )
    
    
      val structAnnotations: immutable$Map[String, String] =
        immutable$Map.empty[String, String]
    
      private val fieldTypes: IndexedSeq[ClassTag[_]] = IndexedSeq[ClassTag[_]](
        classTag[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]].asInstanceOf[ClassTag[_]]
      )
    
      private[this] val structFields: Seq[ThriftStructField[Args]] = Seq[ThriftStructField[Args]](
        new ThriftStructField[Args](
          MessagesField,
          _root_.scala.Some(MessagesFieldManifest),
          classOf[Args]) {
            def getValue[R](struct: Args): R = struct.messages.asInstanceOf[R]
        }
      )
    
      override lazy val metaData: ThriftStructMetaData[Args] =
        ThriftStructMetaData(this, structFields, fieldInfos, Nil, structAnnotations)
    
      /**
       * Checks that all required fields are non-null.
       */
      def validate(_item: Args): Unit = {
      }
    
      /**
       * Checks that the struct is a valid as a new instance. If there are any missing required or
       * construction required fields, return a non-empty list.
       */
      def validateNewInstance(item: Args): scala.Seq[com.twitter.scrooge.validation.Issue] = {
        val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]
    
        buf ++= validateField(item.messages)
        buf.toList
      }
    
      def withoutPassthroughFields(original: Args): Args =
        new Args(
          messages =
            {
              val field = original.messages
              field.map { field =>
                com.twitter.finagle.exception.thriftscala.LogEntry.withoutPassthroughFields(field)
              }
            }
        )
    
      lazy val unsafeEmpty: Args = {
        val messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil
    
        new Args(
          messages,
          NoPassthroughFields
        )
      }
    
      def newBuilder(): StructBuilder[Args] = new ArgsStructBuilder(_root_.scala.None, fieldTypes)
    
      override def encode(_item: Args, _oproto: TProtocol): Unit = {
        _item.write(_oproto)
      }
    
    
      override def decode(_iprot: TProtocol): Args = {
        var messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil
        var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
        var _done = false
    
        _iprot.readStructBegin()
        do {
          val _field = _iprot.readFieldBegin()
          val _fieldType = _field.`type`
          if (_fieldType == TType.STOP) {
            _done = true
          } else {
            _field.id match {
              case 1 =>
                if (_fieldType == TType.LIST) {
                  messages = readMessagesValue(_iprot)
                } else {
                  _root_.com.twitter.scrooge.internal.ApplicationExceptions.throwWrongFieldTypeException(
                    "Received wrong type for field 'messages' (expected=%s, actual=%s).",
                    TType.LIST,
                    _fieldType
                  )
                }
              case _ =>
                if (_passthroughFields eq null)
                  _passthroughFields = immutable$Map.newBuilder[Short, TFieldBlob]
                _passthroughFields += _root_.scala.Tuple2(_field.id, TFieldBlob.read(_field, _iprot))
            }
            _iprot.readFieldEnd()
          }
        } while (!_done)
        _iprot.readStructEnd()
    
        new Args(
          messages,
          if (_passthroughFields eq null)
            NoPassthroughFields
          else
            _passthroughFields.result()
        )
      }
    
      def apply(
        messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil
      ): Args =
        new Args(
          messages
        )
    
      def unapply(_item: Args): _root_.scala.Option[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]] = _root_.scala.Some(_item.messages)
    
    
      @inline private[thriftscala] def readMessagesValue(_iprot: TProtocol): _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = {
        val _list = _iprot.readListBegin()
        if (_list.size == 0) {
          _iprot.readListEnd()
          Nil
        } else {
          val _rv = new _root_.scala.collection.mutable.ArrayBuffer[com.twitter.finagle.exception.thriftscala.LogEntry](_list.size)
          var _i = 0
          do {
            _rv += {
              com.twitter.finagle.exception.thriftscala.LogEntry.decode(_iprot)
            }
            _i += 1
          } while (_i < _list.size)
          _iprot.readListEnd()
          _rv
        }
      }
    
      @inline private def writeMessagesField(messages_item: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry], _oprot: TProtocol): Unit = {
        _oprot.writeFieldBegin(MessagesField)
        writeMessagesValue(messages_item, _oprot)
        _oprot.writeFieldEnd()
      }
    
      @inline private def writeMessagesValue(messages_item: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry], _oprot: TProtocol): Unit = {
        _oprot.writeListBegin(new TList(TType.STRUCT, messages_item.size))
        if (messages_item.isInstanceOf[IndexedSeq[_]]) {
          var _i = 0
          val _size = messages_item.size
          while (_i < _size) {
            val messages_item_element = messages_item(_i)
            messages_item_element.write(_oprot)
            _i += 1
          }
        } else {
          messages_item.foreach { messages_item_element =>
            messages_item_element.write(_oprot)
          }
        }
        _oprot.writeListEnd()
      }
    
    
    }
    
    class Args(
        val messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry],
        val _passthroughFields: immutable$Map[Short, TFieldBlob])
      extends ThriftStruct
      with _root_.scala.Product1[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]]
      with ValidatingThriftStruct[Args]
      with java.io.Serializable
    {
      import Args._
    
      def this(
        messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil
      ) = this(
        messages,
        immutable$Map.empty
      )
    
      def _1: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = messages
    
    
    
      override def write(_oprot: TProtocol): Unit = {
        Args.validate(this)
        _oprot.writeStructBegin(Struct)
        if (messages ne null) writeMessagesField(messages, _oprot)
        if (_passthroughFields.nonEmpty) {
          _passthroughFields.values.foreach { _.write(_oprot) }
        }
        _oprot.writeFieldStop()
        _oprot.writeStructEnd()
      }
    
      def copy(
        messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = this.messages,
        _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
      ): Args =
        new Args(
          messages,
          _passthroughFields
        )
    
      override def canEqual(other: Any): Boolean = other.isInstanceOf[Args]
    
      private[this] def _equals(other: Args): Boolean =
          this.productArity == other.productArity &&
          this.productIterator.sameElements(other.productIterator) &&
          this._passthroughFields == other._passthroughFields
    
      override def equals(other: Any): Boolean =
        canEqual(other) && _equals(other.asInstanceOf[Args])
    
      override def hashCode: Int = {
        _root_.scala.runtime.ScalaRunTime._hashCode(this)
      }
    
      override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)
    
      override def productPrefix: String = "Args"
    
      def _codec: ValidatingThriftStructCodec3[Args] = Args
    
      def newBuilder(): StructBuilder[Args] = new ArgsStructBuilder(_root_.scala.Some(this), fieldTypes)
    }
    
    private[thriftscala] class ArgsStructBuilder(instance: _root_.scala.Option[Args], fieldTypes: IndexedSeq[ClassTag[_]])
        extends StructBuilder[Args](fieldTypes) {
    
      def build(): Args = {
        val _fieldArray = fieldArray // shadow variable
        if (instance.isDefined) {
          val instanceValue = instance.get
          Args(
            if (_fieldArray(0) == null) instanceValue.messages else _fieldArray(0).asInstanceOf[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]]
          )
        } else {
          if (genericArrayOps(_fieldArray).contains(null)) throw new InvalidFieldsException(structBuildError("Args"))
          Args(
            _fieldArray(0).asInstanceOf[_root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry]]
          )
        }
      }
    }

    type SuccessType = com.twitter.finagle.exception.thriftscala.ResultCode
    
    object Result extends ValidatingThriftStructCodec3[Result] with StructBuilderFactory[Result] {
      val NoPassthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty[Short, TFieldBlob]
      val Struct: TStruct = new TStruct("log_result")
      val SuccessField: TField = new TField("success", TType.ENUM, 0)
      val SuccessFieldI32: TField = new TField("success", TType.I32, 0)
      val SuccessFieldManifest: Manifest[com.twitter.finagle.exception.thriftscala.ResultCode] = manifest[com.twitter.finagle.exception.thriftscala.ResultCode]
    
      /**
       * Field information in declaration order.
       */
      lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
        new ThriftStructFieldInfo(
          SuccessField,
          true,
          false,
          SuccessFieldManifest,
          _root_.scala.None,
          _root_.scala.None,
          immutable$Map.empty[String, String],
          immutable$Map.empty[String, String],
          None,
          _root_.scala.Option(com.twitter.finagle.exception.thriftscala.ResultCode.unsafeEmpty)
        )
      )
    
    
      val structAnnotations: immutable$Map[String, String] =
        immutable$Map.empty[String, String]
    
      private val fieldTypes: IndexedSeq[ClassTag[_]] = IndexedSeq[ClassTag[_]](
        classTag[_root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode]].asInstanceOf[ClassTag[_]]
      )
    
      private[this] val structFields: Seq[ThriftStructField[Result]] = Seq[ThriftStructField[Result]](
        new ThriftStructField[Result](
          SuccessField,
          _root_.scala.Some(SuccessFieldManifest),
          classOf[Result]) {
            def getValue[R](struct: Result): R = struct.success.asInstanceOf[R]
        }
      )
    
      override lazy val metaData: ThriftStructMetaData[Result] =
        ThriftStructMetaData(this, structFields, fieldInfos, Nil, structAnnotations)
    
      /**
       * Checks that all required fields are non-null.
       */
      def validate(_item: Result): Unit = {
      }
    
      /**
       * Checks that the struct is a valid as a new instance. If there are any missing required or
       * construction required fields, return a non-empty list.
       */
      def validateNewInstance(item: Result): scala.Seq[com.twitter.scrooge.validation.Issue] = {
        val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]
    
        buf ++= validateField(item.success)
        buf.toList
      }
    
      def withoutPassthroughFields(original: Result): Result =
        new Result(
          success = original.success
        )
    
      lazy val unsafeEmpty: Result = {
        val success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
    
        new Result(
          success,
          NoPassthroughFields
        )
      }
    
      def newBuilder(): StructBuilder[Result] = new ResultStructBuilder(_root_.scala.None, fieldTypes)
    
      override def encode(_item: Result, _oproto: TProtocol): Unit = {
        _item.write(_oproto)
      }
    
    
      override def decode(_iprot: TProtocol): Result = {
        var success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
        var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
        var _done = false
    
        _iprot.readStructBegin()
        do {
          val _field = _iprot.readFieldBegin()
          val _fieldType = _field.`type`
          if (_fieldType == TType.STOP) {
            _done = true
          } else {
            _field.id match {
              case 0 =>
                if (_fieldType == TType.I32 || _fieldType == TType.ENUM) {
                  success = _root_.scala.Some(readSuccessValue(_iprot))
                } else {
                  _root_.com.twitter.scrooge.internal.ApplicationExceptions.throwWrongFieldTypeException(
                    "Received wrong type for field 'success' (expected=%s, actual=%s).",
                    TType.ENUM,
                    _fieldType
                  )
                }
              case _ =>
                if (_passthroughFields eq null)
                  _passthroughFields = immutable$Map.newBuilder[Short, TFieldBlob]
                _passthroughFields += _root_.scala.Tuple2(_field.id, TFieldBlob.read(_field, _iprot))
            }
            _iprot.readFieldEnd()
          }
        } while (!_done)
        _iprot.readStructEnd()
    
        new Result(
          success,
          if (_passthroughFields eq null)
            NoPassthroughFields
          else
            _passthroughFields.result()
        )
      }
    
      def apply(
        success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
      ): Result =
        new Result(
          success
        )
    
      def unapply(_item: Result): _root_.scala.Option[_root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode]] = _root_.scala.Some(_item.success)
    
    
      @inline private[thriftscala] def readSuccessValue(_iprot: TProtocol): com.twitter.finagle.exception.thriftscala.ResultCode = {
        com.twitter.finagle.exception.thriftscala.ResultCode.getOrUnknown(_iprot.readI32())
      }
    
      @inline private def writeSuccessField(success_item: com.twitter.finagle.exception.thriftscala.ResultCode, _oprot: TProtocol): Unit = {
        _oprot.writeFieldBegin(SuccessFieldI32)
        writeSuccessValue(success_item, _oprot)
        _oprot.writeFieldEnd()
      }
    
      @inline private def writeSuccessValue(success_item: com.twitter.finagle.exception.thriftscala.ResultCode, _oprot: TProtocol): Unit = {
        _oprot.writeI32(success_item.value)
      }
    
    
    }
    
    class Result(
        val success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode],
        val _passthroughFields: immutable$Map[Short, TFieldBlob])
      extends ThriftResponse[com.twitter.finagle.exception.thriftscala.ResultCode] with ThriftStruct
      with _root_.scala.Product1[Option[com.twitter.finagle.exception.thriftscala.ResultCode]]
      with ValidatingThriftStruct[Result]
      with java.io.Serializable
    {
      import Result._
    
      def this(
        success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = _root_.scala.None
      ) = this(
        success,
        immutable$Map.empty
      )
    
      def _1: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = success
    
      def successField: Option[com.twitter.finagle.exception.thriftscala.ResultCode] = success
      def exceptionFields: Iterable[Option[com.twitter.scrooge.ThriftException]] = Nil
    
    
      override def write(_oprot: TProtocol): Unit = {
        Result.validate(this)
        _oprot.writeStructBegin(Struct)
        if (success.isDefined) writeSuccessField(success.get, _oprot)
        if (_passthroughFields.nonEmpty) {
          _passthroughFields.values.foreach { _.write(_oprot) }
        }
        _oprot.writeFieldStop()
        _oprot.writeStructEnd()
      }
    
      def copy(
        success: _root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode] = this.success,
        _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
      ): Result =
        new Result(
          success,
          _passthroughFields
        )
    
      override def canEqual(other: Any): Boolean = other.isInstanceOf[Result]
    
      private[this] def _equals(other: Result): Boolean =
          this.productArity == other.productArity &&
          this.productIterator.sameElements(other.productIterator) &&
          this._passthroughFields == other._passthroughFields
    
      override def equals(other: Any): Boolean =
        canEqual(other) && _equals(other.asInstanceOf[Result])
    
      override def hashCode: Int = {
        _root_.scala.runtime.ScalaRunTime._hashCode(this)
      }
    
      override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)
    
      override def productPrefix: String = "Result"
    
      def _codec: ValidatingThriftStructCodec3[Result] = Result
    
      def newBuilder(): StructBuilder[Result] = new ResultStructBuilder(_root_.scala.Some(this), fieldTypes)
    }
    
    private[thriftscala] class ResultStructBuilder(instance: _root_.scala.Option[Result], fieldTypes: IndexedSeq[ClassTag[_]])
        extends StructBuilder[Result](fieldTypes) {
    
      def build(): Result = {
        val _fieldArray = fieldArray // shadow variable
        if (instance.isDefined) {
          val instanceValue = instance.get
          Result(
            if (_fieldArray(0) == null) instanceValue.success else _fieldArray(0).asInstanceOf[_root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode]]
          )
        } else {
          if (genericArrayOps(_fieldArray).contains(null)) throw new InvalidFieldsException(structBuildError("Result"))
          Result(
            _fieldArray(0).asInstanceOf[_root_.scala.Option[com.twitter.finagle.exception.thriftscala.ResultCode]]
          )
        }
      }
    }

    val annotations: immutable$Map[String, String] = immutable$Map.empty

    type FunctionType = Function1[Args,Future[com.twitter.finagle.exception.thriftscala.ResultCode]]
    type ReqRepFunctionType = Function1[_root_.com.twitter.scrooge.Request[Args],Future[_root_.com.twitter.scrooge.Response[com.twitter.finagle.exception.thriftscala.ResultCode]]]

    type ServicePerEndpointServiceType = _root_.com.twitter.finagle.Service[Args, SuccessType]
    type ReqRepServicePerEndpointServiceType = _root_.com.twitter.finagle.Service[_root_.com.twitter.scrooge.Request[Args], _root_.com.twitter.scrooge.Response[SuccessType]]

    def toServicePerEndpointService(f: FunctionType): ServicePerEndpointServiceType =
      _root_.com.twitter.finagle.Service.mk { args: Args =>
        f(args)
      }

    def toReqRepServicePerEndpointService(f: ReqRepFunctionType): ReqRepServicePerEndpointServiceType =
      _root_.com.twitter.finagle.Service.mk[_root_.com.twitter.scrooge.Request[Args], _root_.com.twitter.scrooge.Response[SuccessType]] { request: _root_.com.twitter.scrooge.Request[Args] =>
        f(request)
      }


    val name: String = "Log"
    val serviceName: String = "Scribe"
    val argsCodec: Args.type = Args
    val responseCodec: Result.type = Result
    val oneway: Boolean = false
  }

  // Compatibility aliases.
  val log$args: Log.Args.type = Log.Args
  type log$args = Log.Args

  val log$result: Log.Result.type = Log.Result
  type log$result = Log.Result


  trait MethodPerEndpoint
    extends Scribe[Future] {
    
    def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): Future[com.twitter.finagle.exception.thriftscala.ResultCode]
  }

  object MethodPerEndpoint {

    def apply(servicePerEndpoint: ServicePerEndpoint): MethodPerEndpoint = {
      new MethodPerEndpointImpl(servicePerEndpoint) {}
    }

    /**
     * Use `MethodPerEndpoint.apply()` instead of this constructor.
     */
    class MethodPerEndpointImpl protected (servicePerEndpoint: ServicePerEndpoint)
      extends MethodPerEndpoint {
        def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): Future[com.twitter.finagle.exception.thriftscala.ResultCode] =
          servicePerEndpoint.log(self.Log.Args(messages))

        override def asClosable: _root_.com.twitter.util.Closable =
          servicePerEndpoint.asClosable
    }
  }

  object ReqRepMethodPerEndpoint {

    def apply(servicePerEndpoint: ReqRepServicePerEndpoint): MethodPerEndpoint =
      new ReqRepMethodPerEndpointImpl(servicePerEndpoint) { }

    /**
     * Use `ReqRepMethodPerEndpoint.apply()` instead of this constructor.
     */
    class ReqRepMethodPerEndpointImpl protected (servicePerEndpoint: ReqRepServicePerEndpoint)
      extends MethodPerEndpoint {

        def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): Future[com.twitter.finagle.exception.thriftscala.ResultCode] = {
          val requestCtx = _root_.com.twitter.finagle.context.Contexts.local.getOrElse(_root_.com.twitter.finagle.thrift.Headers.Request.Key, () => _root_.com.twitter.finagle.thrift.Headers.Request.newValues)
          val scroogeRequest = _root_.com.twitter.scrooge.Request(requestCtx.values, self.Log.Args(messages))
          servicePerEndpoint.log(scroogeRequest).transform(_root_.com.twitter.finagle.thrift.service.ThriftReqRepServicePerEndpoint.transformResult)
        }

        override def asClosable: _root_.com.twitter.util.Closable =
          servicePerEndpoint.asClosable
    }
  }

  @deprecated("Use MethodPerEndpoint", "2017-11-07")
  class MethodIface(serviceIface: BaseServiceIface)
    extends FutureIface {
    def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): Future[com.twitter.finagle.exception.thriftscala.ResultCode] =
      serviceIface.log(self.Log.Args(messages))
  }

  implicit object MethodPerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.MethodPerEndpointBuilder[ServicePerEndpoint, MethodPerEndpoint] {
    def methodPerEndpoint(servicePerEndpoint: ServicePerEndpoint): MethodPerEndpoint =
      MethodPerEndpoint(servicePerEndpoint)
  }

  @deprecated("Use MethodPerEndpointBuilder", "2018-01-12")
  implicit object ThriftServiceBuilder
    extends _root_.com.twitter.finagle.thrift.service.ThriftServiceBuilder[ServicePerEndpoint, Scribe[Future]] {
    def build(servicePerEndpoint: ServicePerEndpoint): MethodPerEndpoint =
      MethodPerEndpoint(servicePerEndpoint)
  }

  implicit object ReqRepMethodPerEndpointBuilder
    extends _root_.com.twitter.finagle.thrift.service.ReqRepMethodPerEndpointBuilder[ReqRepServicePerEndpoint, MethodPerEndpoint] {
    def methodPerEndpoint(servicePerEndpoint: ReqRepServicePerEndpoint): MethodPerEndpoint =
      ReqRepMethodPerEndpoint(servicePerEndpoint)
  }

  @deprecated("Use MethodPerEndpointBuilder", "2017-11-07")
  implicit object MethodIfaceBuilder
    extends com.twitter.finagle.thrift.MethodIfaceBuilder[ServiceIface, Scribe[Future]] {
    def newMethodIface(serviceIface: ServiceIface): MethodIface =
      new MethodIface(serviceIface)
  }

  @deprecated("Use MethodPerEndpoint", "2017-11-07")
  trait FutureIface
    extends Scribe[Future] {
    
    def log(messages: _root_.scala.collection.Seq[com.twitter.finagle.exception.thriftscala.LogEntry] = _root_.scala.collection.immutable.Nil): Future[com.twitter.finagle.exception.thriftscala.ResultCode]
  }

  class FinagledClient(
      service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
      clientParam: RichClientParam)
    extends Scribe$FinagleClient(service, clientParam)
    with FutureIface
    with MethodPerEndpoint {

    @deprecated("Use com.twitter.finagle.thrift.RichClientParam", "2017-08-16")
    def this(
      service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
      protocolFactory: org.apache.thrift.protocol.TProtocolFactory = Protocols.binaryFactory(),
      serviceName: String = "Scribe",
      stats: com.twitter.finagle.stats.StatsReceiver = com.twitter.finagle.stats.NullStatsReceiver,
      responseClassifier: ctfs.ResponseClassifier = ctfs.ResponseClassifier.Default
    ) = this(
      service,
      RichClientParam(
        protocolFactory,
        serviceName,
        clientStats = stats,
        responseClassifier = responseClassifier
      )
    )

    @deprecated("Use com.twitter.finagle.thrift.RichClientParam", "2017-08-16")
    def this(
      service: com.twitter.finagle.Service[ThriftClientRequest, Array[Byte]],
      protocolFactory: org.apache.thrift.protocol.TProtocolFactory,
      serviceName: String,
      stats: com.twitter.finagle.stats.StatsReceiver
    ) = this(
      service,
      RichClientParam(
        protocolFactory,
        serviceName,
        clientStats = stats
      )
    )
  }

  class FinagledService(
      iface: Scribe[Future],
      serverParam: RichServerParam)
    extends Scribe$FinagleService(iface, serverParam) {

    @deprecated("Use com.twitter.finagle.thrift.RichServerParam", "2017-08-16")
    def this(
      iface: Scribe[Future],
      protocolFactory: org.apache.thrift.protocol.TProtocolFactory,
      serviceName: String = "Scribe"
    ) = this(iface, RichServerParam(protocolFactory, serviceName))
  }

  class Filter(serverParam: RichServerParam) {
    private[this] def protocolFactory: TProtocolFactory = serverParam.restrictedProtocolFactory

    private[this] def serviceName: String = serverParam.serviceName
    private[this] def responseClassifier: ctfs.ResponseClassifier = serverParam.responseClassifier
    private[this] def stats: StatsReceiver = serverParam.serverStats
    private[this] def perEndpointStats: Boolean = serverParam.perEndpointStats && !stats.isNull

    private[this] val tlReusableBuffer: TReusableBuffer = TReusableBuffer(maxThriftBufferSize = serverParam.maxThriftBufferSize)

    private[thriftscala] def exception(name: String, seqid: Int, code: Int, message: String): Buf = {
      val x = new TApplicationException(code, message)
      val memoryBuffer = tlReusableBuffer.get()
      try {
        val oprot = protocolFactory.getProtocol(memoryBuffer)

        oprot.writeMessageBegin(new TMessage(name, TMessageType.EXCEPTION, seqid))
        x.write(oprot)
        oprot.writeMessageEnd()
        oprot.getTransport.flush()

        // make a copy of the array of bytes to construct a new buffer because memoryBuffer is reusable
        Buf.ByteArray.Shared(memoryBuffer.getArray(), 0, memoryBuffer.length())
      } finally {
        tlReusableBuffer.reset()
      }
    }

    private[this] def reply(name: String, seqid: Int, result: ThriftStruct): Buf = {
      val memoryBuffer = tlReusableBuffer.get()
      try {
        val oprot = protocolFactory.getProtocol(memoryBuffer)
        val start = System.nanoTime
        oprot.writeMessageBegin(new TMessage(name, TMessageType.REPLY, seqid))
        result.write(oprot)
        oprot.writeMessageEnd()
        val trace = _root_.com.twitter.finagle.tracing.Trace()
        if (trace.isActivelyTracing) {
          trace.recordBinary("srv/response_serialization_ns", System.nanoTime - start)
        }
        oprot.getTransport.flush()

        // make a copy of the array of bytes to construct a new buffer because memoryBuffer is reusable
        Buf.ByteArray.Shared(memoryBuffer.getArray(), 0, memoryBuffer.length())
      } finally {
        tlReusableBuffer.reset()
      }
    }

    private[this] def recordResponse(reqRep: ctfs.ReqRep, methodStats: _root_.com.twitter.finagle.thrift.ThriftMethodStats): Unit = {
      ServerToReqRep.setCtx(reqRep)
      val classified = responseClassifier.applyOrElse(reqRep, ctfs.ResponseClassifier.Default)
      if (classified.isInstanceOf[ctfs.ResponseClass.Successful]) {
        methodStats.successCounter.incr()
      } else if (classified.isInstanceOf[ctfs.ResponseClass.Failed]) {
        methodStats.failuresCounter.incr()
        if (reqRep.response.isThrow) {
          methodStats.failuresScope.counter(Throwables.mkString(reqRep.response.throwable): _*).incr()
        }
      } // Last ResponseClass is Ignorable, which we do not need to record
    }

    final protected def perMethodStatsFilter(
      method: ThriftMethod
    ): finagle$Filter[(TProtocol, Int), Array[Byte], (TProtocol, Int), RichResponse[method.Args, method.Result]] = {
      val methodStats = if (perEndpointStats) {
        _root_.com.twitter.finagle.thrift.ThriftMethodStats((if (serviceName != "") stats.scope(serviceName) else stats).scope(method.name))
      } else {
        _root_.com.twitter.finagle.thrift.ThriftMethodStats.Null
      }

      new finagle$Filter[(TProtocol, Int), Array[Byte], (TProtocol, Int), RichResponse[method.Args, method.Result]] {
        def apply(
          req: (TProtocol, Int),
          service: finagle$Service[(TProtocol, Int), RichResponse[method.Args, method.Result]]
        ): Future[Array[Byte]] = {
          methodStats.requestsCounter.incr()
          service(req).transform { response =>
            if (response.isReturn) {
              val value = response.apply()
              if (value.isInstanceOf[SuccessfulResponse[method.Args, method.Result]]) {
                val succResp = value.asInstanceOf[SuccessfulResponse[method.Args, method.Result]]
                recordResponse(ctfs.ReqRep(succResp.input, _root_.com.twitter.util.Return(succResp.result.successField.get)), methodStats)
              } else if (value.isInstanceOf[ProtocolExceptionResponse[method.Args, method.Result]]) {
                val protExResp = value.asInstanceOf[ProtocolExceptionResponse[method.Args, method.Result]]
                recordResponse(ctfs.ReqRep(protExResp.input, _root_.com.twitter.util.Throw(protExResp.exception)), methodStats)
              } else if (value.isInstanceOf[ThriftExceptionResponse[method.Args, method.Result]]) {
                val thriftExResp = value.asInstanceOf[ThriftExceptionResponse[method.Args, method.Result]]
                val rep: Throwable = if (thriftExResp.ex.isInstanceOf[ThriftException]) {
                  _root_.com.twitter.finagle.SourcedException.setServiceName(thriftExResp.ex, serviceName)
                } else {
                  _root_.com.twitter.scrooge.internal.ApplicationExceptions.missingResult(serviceName)
                }
                recordResponse(ctfs.ReqRep(thriftExResp.input, _root_.com.twitter.util.Throw(rep)), methodStats)
              }
              Future.value(Buf.ByteArray.Owned.extract(value.response))
            } else { // Throw[_]
              recordResponse(ctfs.ReqRep(req, response), methodStats)
              Future.const(response.asInstanceOf[Throw[Array[Byte]]])
            }
          }
        }
      }
    }
    // ---- end boilerplate.

    val log: finagle$Filter[(TProtocol, Int), Array[Byte], Log.Args, Log.SuccessType] = {
      val statsFilter: finagle$Filter[(TProtocol, Int), Array[Byte], (TProtocol, Int), RichResponse[Log.Args, Log.Result]] = perMethodStatsFilter(Log)
    
      val protocolExnFilter = new SimpleFilter[(TProtocol, Int), RichResponse[Log.Args, Log.Result]] {
        def apply(
          request: (TProtocol, Int),
          service: _root_.com.twitter.finagle.Service[(TProtocol, Int), RichResponse[Log.Args, Log.Result]]
        ): Future[RichResponse[Log.Args, Log.Result]] = {
          val iprot = request._1
          val seqid = request._2
          val res = service(request)
          res.transform(resTry => {
            if (resTry.isThrow && resTry.throwable.isInstanceOf[TProtocolException]) {
              val underlyingException = resTry.throwable
              iprot.readMessageEnd()
              Future.value(
                ProtocolExceptionResponse(
                  null,
                  exception("Log", seqid, TApplicationException.PROTOCOL_ERROR, underlyingException.getMessage),
                  new TApplicationException(TApplicationException.PROTOCOL_ERROR, underlyingException.getMessage)))
            } else {
              res
            }
          })
        }
      }
    
      val serdeFilter = new finagle$Filter[(TProtocol, Int), RichResponse[Log.Args, Log.Result], Log.Args, Log.SuccessType] {
        def apply(
          request: (TProtocol, Int),
          service: _root_.com.twitter.finagle.Service[Log.Args, Log.SuccessType]
        ): Future[RichResponse[Log.Args, Log.Result]] = {
          val iprot = request._1
          val seqid = request._2
          val start = System.nanoTime
          val args = Log.Args.decode(iprot)
          iprot.readMessageEnd()
          val trace = _root_.com.twitter.finagle.tracing.Trace()
          if (trace.isActivelyTracing) {
            trace.recordBinary("srv/request_deserialization_ns", System.nanoTime - start)
          }
          _root_.com.twitter.finagle.context.Contexts.local.let(
            _root_.com.twitter.finagle.thrift.MethodMetadata.Key,
            _root_.com.twitter.finagle.thrift.MethodMetadata(Log)) {
            service(args)
          }.transform(resTry => {
            if (resTry.isReturn) {
              val methodResult = Log.Result(success = Some(resTry.apply()))
              Future.value(
                SuccessfulResponse(
                  args,
                  reply("Log", seqid, methodResult),
                  methodResult))
            } else { // Throw[_]
                Future.const(resTry.asInstanceOf[Throw[RichResponse[Log.Args, Log.Result]]])
            }
          })
        }
      }
      statsFilter.andThen(protocolExnFilter).andThen(serdeFilter)
    }
  }

}
