/**
 * Generated by Scrooge
 *   version: 4.20.0
 *   rev: cb187fa846aef7d49488991c1e2333f01b1763d9
 *   built at: 20170906-131117
 */
package com.twitter.finagle.exception.thriftscala

import com.twitter.finagle.{SimpleFilter, Thrift, Filter => finagle$Filter, Service => finagle$Service}
import com.twitter.finagle.stats.{Counter, NullStatsReceiver, StatsReceiver}
import com.twitter.scrooge.{TReusableBuffer, ThriftMethod, ThriftStruct}
import com.twitter.util.{Future, Return, Throw, Throwables}
import java.nio.ByteBuffer
import java.util.Arrays
import org.apache.thrift.protocol._
import org.apache.thrift.TApplicationException
import org.apache.thrift.transport.TMemoryInputTransport
import scala.collection.mutable.{
  ArrayBuffer => mutable$ArrayBuffer, HashMap => mutable$HashMap}
import scala.collection.{Map, Set}

import scala.language.higherKinds


@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
class Scribe$FinagleService(
  iface: Scribe[Future],
  protocolFactory: TProtocolFactory,
  stats: StatsReceiver,
  maxThriftBufferSize: Int,
  serviceName: String
) extends com.twitter.finagle.Service[Array[Byte], Array[Byte]] {
  import Scribe._

  def this(
    iface: Scribe[Future],
    protocolFactory: TProtocolFactory,
    stats: StatsReceiver,
    maxThriftBufferSize: Int
  ) = this(iface, protocolFactory, stats, maxThriftBufferSize, "Scribe")

  def this(
    iface: Scribe[Future],
    protocolFactory: TProtocolFactory
  ) = this(iface, protocolFactory, NullStatsReceiver, Thrift.maxThriftBufferSize)

  private[this] val tlReusableBuffer = TReusableBuffer()

  protected val serviceMap = new mutable$HashMap[String, finagle$Service[(TProtocol, Int), Array[Byte]]]()

  protected def addService(name: String, service: finagle$Service[(TProtocol, Int), Array[Byte]]): Unit = {
    serviceMap(name) = service
  }

  protected def exception(name: String, seqid: Int, code: Int, message: String): Future[Array[Byte]] = {
    try {
      val x = new TApplicationException(code, message)
      val memoryBuffer = tlReusableBuffer.get()
      try {
        val oprot = protocolFactory.getProtocol(memoryBuffer)

        oprot.writeMessageBegin(new TMessage(name, TMessageType.EXCEPTION, seqid))
        x.write(oprot)
        oprot.writeMessageEnd()
        oprot.getTransport().flush()
        Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()))
      } finally {
        tlReusableBuffer.reset()
      }
    } catch {
      case e: Exception => Future.exception(e)
    }
  }

  protected def reply(name: String, seqid: Int, result: ThriftStruct): Future[Array[Byte]] = {
    try {
      val memoryBuffer = tlReusableBuffer.get()
      try {
        val oprot = protocolFactory.getProtocol(memoryBuffer)

        oprot.writeMessageBegin(new TMessage(name, TMessageType.REPLY, seqid))
        result.write(oprot)
        oprot.writeMessageEnd()

        Future.value(Arrays.copyOfRange(memoryBuffer.getArray(), 0, memoryBuffer.length()))
      } finally {
        tlReusableBuffer.reset()
      }
    } catch {
      case e: Exception => Future.exception(e)
    }
  }

  final def apply(request: Array[Byte]): Future[Array[Byte]] = {
    val inputTransport = new TMemoryInputTransport(request)
    val iprot = protocolFactory.getProtocol(inputTransport)

    try {
      val msg = iprot.readMessageBegin()
      val service = serviceMap.get(msg.name)
      service match {
        case _root_.scala.Some(svc) =>
          svc(iprot, msg.seqid)
        case _ =>
          TProtocolUtil.skip(iprot, TType.STRUCT)
          exception(msg.name, msg.seqid, TApplicationException.UNKNOWN_METHOD,
            "Invalid method name: '" + msg.name + "'")
      }
    } catch {
      case e: Exception => Future.exception(e)
    }
  }

  private object ThriftMethodStats {
    def apply(stats: StatsReceiver): ThriftMethodStats =
      ThriftMethodStats(
        stats.counter("requests"),
        stats.counter("success"),
        stats.counter("failures"),
        stats.scope("failures")
      )
  }

  private case class ThriftMethodStats(
    requestsCounter: Counter,
    successCounter: Counter,
    failuresCounter: Counter,
    failuresScope: StatsReceiver
  )

  protected def perMethodStatsFilter(
    method: ThriftMethod,
    stats: StatsReceiver
  ): SimpleFilter[method.Args, method.SuccessType] = {
    val methodStats = ThriftMethodStats((if (serviceName != "") stats.scope(serviceName) else stats).scope(method.name))
    new SimpleFilter[method.Args, method.SuccessType] {
      def apply(
        args: method.Args,
        service: finagle$Service[method.Args, method.SuccessType]
      ): Future[method.SuccessType] = {
        methodStats.requestsCounter.incr()
        service(args).respond {
          case Return(_) =>
            methodStats.successCounter.incr()
          case Throw(ex) =>
            methodStats.failuresCounter.incr()
            methodStats.failuresScope.counter(Throwables.mkString(ex): _*).incr()
        }
      }
    }
  }
  // ---- end boilerplate.

  addService("Log", {
    val statsFilter = perMethodStatsFilter(Log, stats)
  
    val methodService = new finagle$Service[Log.Args, Log.SuccessType] {
      def apply(args: Log.Args): Future[Log.SuccessType] = {
        iface.log(args.messages)
      }
    }
  
    val protocolExnFilter = new SimpleFilter[(TProtocol, Int), Array[Byte]] {
      def apply(
        request: (TProtocol, Int),
        service: finagle$Service[(TProtocol, Int), Array[Byte]]
      ): Future[Array[Byte]] = {
        val (iprot, seqid) = request
        service(request).rescue {
          case e: TProtocolException => {
            iprot.readMessageEnd()
            exception("Log", seqid, TApplicationException.PROTOCOL_ERROR, e.getMessage)
          }
          case e: Exception => Future.exception(e)
        }
      }
    }
  
    val serdeFilter = new finagle$Filter[(TProtocol, Int), Array[Byte], Log.Args, Log.SuccessType] {
      override def apply(
        request: (TProtocol, Int),
        service: finagle$Service[Log.Args, Log.SuccessType]
      ): Future[Array[Byte]] = {
        val (iprot, seqid) = request
        val args = Log.Args.decode(iprot)
        iprot.readMessageEnd()
        val res = service(args)
        res.flatMap { value =>
          reply("Log", seqid, Log.Result(success = Some(value)))
        }.rescue {
          case e => Future.exception(e)
        }
      }
    }
  
    protocolExnFilter.andThen(serdeFilter).andThen(statsFilter).andThen(methodService)
  })
}
