/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport.server;

import com.twitter.finagle.http2.transport.server.H2ServerFilter$;
import com.twitter.finagle.http2.transport.server.H2ServerFilter$$anonfun$1$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import com.twitter.util.TimerTask;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0003\r9\u0011a\u0002\u0013\u001aTKJ4XM\u001d$jYR,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT!!\u0002\u0004\u0002\u0013Q\u0014\u0018M\\:q_J$(BA\u0004\t\u0003\u0015AG\u000f\u001e93\u0015\tI!\"A\u0004gS:\fw\r\\3\u000b\u0005-a\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0014\u0005\u0001y\u0001C\u0001\t\u0018\u001b\u0005\t\"B\u0001\n\u0014\u0003\u001d\u0019\u0007.\u00198oK2T!\u0001F\u000b\u0002\u000b9,G\u000f^=\u000b\u0003Y\t!![8\n\u0005a\t\"\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015!\u0018.\\3s\u0007\u0001\u0001\"!\b\u0011\u000e\u0003yQ!a\b\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003Cy\u0011Q\u0001V5nKJDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtDCA\u0013(!\t1\u0003!D\u0001\u0003\u0011\u0015Q\"\u00051\u0001\u001d\u0011\u0019I\u0003\u0001)Q\u0005U\u0005i1\r\\8tK\u0012+\u0017\r\u001a7j]\u0016\u0004\"!H\u0016\n\u00051r\"\u0001\u0002+j[\u0016D#\u0001\u000b\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u0011Y|G.\u0019;jY\u0016DQ!\u000e\u0001\u0005\u0002Y\n1b]3u\t\u0016\fG\r\\5oKR\u0011qG\u000f\t\u0003_aJ!!\u000f\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006wQ\u0002\rAK\u0001\tI\u0016\fG\r\\5oK\")Q\b\u0001C!}\u0005Y1\r[1o]\u0016d'+Z1e)\r9t\b\u0012\u0005\u0006\u0001r\u0002\r!Q\u0001\u0004GRD\bC\u0001\tC\u0013\t\u0019\u0015CA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000b\u0015c\u0004\u0019\u0001$\u0002\u00075\u001cx\r\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\r=\u0013'.Z2u\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\u0015\u0019Gn\\:f)\r9\u0014K\u0015\u0005\u0006\u0001:\u0003\r!\u0011\u0005\u0006':\u0003\r\u0001V\u0001\baJ|W.[:f!\t\u0001R+\u0003\u0002W#\tq1\t[1o]\u0016d\u0007K]8nSN,wA\u0002-\u0003\u0011\u00031\u0011,\u0001\bIeM+'O^3s\r&dG/\u001a:\u0011\u0005\u0019RfAB\u0001\u0003\u0011\u000311l\u0005\u0002[9B\u0011q&X\u0005\u0003=B\u0012a!\u00118z%\u00164\u0007\"B\u0012[\t\u0003\u0001G#A-\t\u000f\tT&\u0019!C\u0005G\u00061An\\4hKJ,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O*\tq\u0001\\8hO&tw-\u0003\u0002jM\n1Aj\\4hKJDaa\u001b.!\u0002\u0013!\u0017a\u00027pO\u001e,'\u000f\t\u0005\b[j\u0013\r\u0011\"\u0001o\u0003-A\u0015M\u001c3mKJt\u0015-\\3\u0016\u0003=\u0004\"\u0001]:\u000f\u0005=\n\u0018B\u0001:1\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0004\u0004BB<[A\u0003%q.\u0001\u0007IC:$G.\u001a:OC6,\u0007\u0005")
public final class H2ServerFilter
extends ChannelDuplexHandler {
    private final Timer timer;
    private volatile Time closeDeadline;

    public static String HandlerName() {
        return H2ServerFilter$.MODULE$.HandlerName();
    }

    public void setDeadline(Time deadline) {
        this.closeDeadline = deadline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2Frame) {
            Http2Frame http2Frame = (Http2Frame)object;
            ReferenceCountUtil.release((Object)http2Frame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.channelRead(ctx, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        if (connectionHandler == null) {
            String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found H2ServerFilter in a pipeline without a Http2ConnectionHandler. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pipeline: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.pipeline()}))).toString();
            IllegalStateException ex = new IllegalStateException(message);
            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().error((Throwable)ex, message, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close(promise);
        } else {
            Time deadline = this.closeDeadline;
            Time now = Time$.MODULE$.now();
            if (deadline.$less$eq((Object)now)) {
                connectionHandler.gracefulShutdownTimeoutMillis(0L);
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deadline already passed (", " <= ", "). Closing now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadline, now})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                super.close(ctx, promise);
            } else {
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing h2 session with deadline ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadline})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DefaultHttp2GoAwayFrame goawayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
                goawayFrame.setExtraStreamIds(Integer.MAX_VALUE);
                AtomicBoolean promiseOnce = new AtomicBoolean();
                ctx.writeAndFlush((Object)goawayFrame).addListener((GenericFutureListener)new ChannelFutureListener(this, ctx, promise, promiseOnce){
                    private final ChannelHandlerContext ctx$1;
                    private final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;

                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess() && this.promiseOnce$1.compareAndSet(false, true)) {
                            this.ctx$1.close(this.promise$1);
                        }
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                    }
                });
                TimerTask closeTask = this.timer.schedule(deadline, (Function0)new Serializable(this, ctx, promise, promiseOnce){
                    public static final long serialVersionUID = 0L;
                    public final ChannelHandlerContext ctx$1;
                    public final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        if (this.promiseOnce$1.compareAndSet(false, true)) {
                            this.ctx$1.channel().eventLoop().execute(new Runnable(this){
                                private final /* synthetic */ $anonfun$1 $outer;

                                public void run() {
                                    H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().info("Graceful draining period lapsed. Sending final GOAWAY and closing the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                    this.$outer.ctx$1.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener((GenericFutureListener)new ChannelFutureListener(this){
                                        private final /* synthetic */ $anonfun$1$$anon$4 $outer;

                                        public void operationComplete(ChannelFuture future) {
                                            this.$outer.com$twitter$finagle$http2$transport$server$H2ServerFilter$$anonfun$$anon$$$outer().ctx$1.close(this.$outer.com$twitter$finagle$http2$transport$server$H2ServerFilter$$anonfun$$anon$$$outer().promise$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$1 com$twitter$finagle$http2$transport$server$H2ServerFilter$$anonfun$$anon$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                    }
                });
                ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(this, promise, promiseOnce, closeTask){
                    private final ChannelPromise promise$1;
                    private final AtomicBoolean promiseOnce$1;
                    private final TimerTask closeTask$1;

                    public void operationComplete(ChannelFuture future) {
                        this.closeTask$1.cancel();
                        if (this.promiseOnce$1.compareAndSet(false, true)) {
                            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().info("Channel closed, session terminated.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            this.promise$1.setSuccess();
                        }
                    }
                    {
                        this.promise$1 = promise$1;
                        this.promiseOnce$1 = promiseOnce$1;
                        this.closeTask$1 = closeTask$1;
                    }
                });
            }
        }
    }

    public H2ServerFilter(Timer timer) {
        this.timer = timer;
        this.closeDeadline = Time$.MODULE$.Bottom();
    }
}

