/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2;

import com.twitter.finagle.Stack;
import com.twitter.finagle.http2.ExceptionTrackingFrameListener;
import com.twitter.finagle.http2.LoggerPerFrameTypeLogger;
import com.twitter.finagle.http2.MultiplexCodecBuilder$ClosePushedStreamsInitializer$;
import com.twitter.finagle.http2.Settings$;
import com.twitter.finagle.http2.param.EncoderIgnoreMaxHeaderListSize;
import com.twitter.finagle.http2.param.EncoderIgnoreMaxHeaderListSize$;
import com.twitter.finagle.http2.param.FrameLoggerNamePrefix;
import com.twitter.finagle.http2.param.FrameLoggerNamePrefix$;
import com.twitter.finagle.http2.param.FrameLogging;
import com.twitter.finagle.http2.param.FrameLogging$;
import com.twitter.finagle.http2.param.HeaderSensitivity;
import com.twitter.finagle.http2.param.HeaderSensitivity$;
import com.twitter.finagle.http2.trackH2SessionExceptions$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.StatsReceiver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class MultiplexCodecBuilder$ {
    public static MultiplexCodecBuilder$ MODULE$;

    static {
        new MultiplexCodecBuilder$();
    }

    public void addStreamsGauge(StatsReceiver statsReceiver, Http2MultiplexCodec http2MultiplexCodec, Channel channel) {
        Gauge streams = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streams"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> http2MultiplexCodec.connection().numActiveStreams());
        channel.attr(AttributeKey.valueOf((String)"streams_gauge")).set((Object)streams);
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(streams){
            private final Gauge streams$1;

            public void operationComplete(ChannelFuture f) {
                this.streams$1.remove();
            }
            {
                this.streams$1 = streams$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Http2MultiplexCodec serverMultiplexCodec(Stack.Params params, ChannelHandler inboundInitializer) {
        void var3_3;
        block0: {
            Http2MultiplexCodec codec = this.newMultiplexCodec(params, inboundInitializer, true).build();
            if (!BoxesRunTime.unboxToBoolean((Object)trackH2SessionExceptions$.MODULE$.apply())) break block0;
            Http2FrameListener oldListener = codec.decoder().frameListener();
            StatsReceiver statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
            codec.decoder().frameListener((Http2FrameListener)new ExceptionTrackingFrameListener(statsReceiver, oldListener));
        }
        return var3_3;
    }

    public Http2MultiplexCodec clientMultiplexCodec(Stack.Params params, Option<ChannelHandler> upgradeHandler) {
        BoxedUnit boxedUnit;
        Http2MultiplexCodecBuilder builder = this.newMultiplexCodec(params, (ChannelHandler)MultiplexCodecBuilder$ClosePushedStreamsInitializer$.MODULE$, false);
        Option<ChannelHandler> option = upgradeHandler;
        if (option instanceof Some) {
            Some some = (Some)option;
            ChannelHandler handler = (ChannelHandler)some.value();
            boxedUnit = builder.withUpgradeStreamHandler(handler);
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return builder.build();
    }

    private Http2MultiplexCodecBuilder newMultiplexCodec(Stack.Params params, ChannelHandler inboundInitializer, boolean isServer) {
        Http2Settings initialSettings = Settings$.MODULE$.fromParams(params, isServer);
        Http2MultiplexCodecBuilder builder = isServer ? Http2MultiplexCodecBuilder.forServer((ChannelHandler)inboundInitializer) : Http2MultiplexCodecBuilder.forClient((ChannelHandler)inboundInitializer);
        builder.initialSettings(initialSettings).encoderIgnoreMaxHeaderListSize(((EncoderIgnoreMaxHeaderListSize)params.apply(EncoderIgnoreMaxHeaderListSize$.MODULE$.param())).ignoreMaxHeaderListSize()).headerSensitivityDetector(this.detector(params));
        Object object = ((FrameLogging)params.apply(FrameLogging$.MODULE$.param())).enabled() ? builder.frameLogger((Http2FrameLogger)new LoggerPerFrameTypeLogger(((FrameLoggerNamePrefix)params.apply(FrameLoggerNamePrefix$.MODULE$.param())).loggerNamePrefix())) : BoxedUnit.UNIT;
        return builder;
    }

    private Http2HeadersEncoder.SensitivityDetector detector(Stack.Params params) {
        return new Http2HeadersEncoder.SensitivityDetector(params){
            private final Function2<CharSequence, CharSequence, Object> sensitivityDetector;

            public boolean isSensitive(CharSequence name, CharSequence value) {
                return BoxesRunTime.unboxToBoolean((Object)this.sensitivityDetector.apply((Object)name, (Object)value));
            }
            {
                this.sensitivityDetector = ((HeaderSensitivity)params$1.apply(HeaderSensitivity$.MODULE$.param())).sensitivityDetector();
            }
        };
    }

    private MultiplexCodecBuilder$() {
        MODULE$ = this;
    }
}

