/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.exp.transport;

import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.http2.exp.transport.ClientServiceImpl;
import com.twitter.finagle.http2.exp.transport.DeferredCloseSession;
import com.twitter.finagle.http2.exp.transport.H2Pool;
import com.twitter.finagle.http2.exp.transport.H2Pool$OnH2SessionParam$;
import com.twitter.finagle.http2.exp.transport.SingleDispatchTransport;
import com.twitter.finagle.http2.exp.transport.TlsTransporter$;
import com.twitter.finagle.http2.transport.ClientSession;
import com.twitter.finagle.netty4.ConnectionBuilder;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.io.Serializable;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055d!\u0002\u000b\u0016\u0001e\t\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u0007+\u0002\u0001\u000b\u0011\u0002,\t\rq\u0003\u0001\u0015!\u0003^\u0011\u0019\u0001\u0007\u0001)A\u0005C\")\u0001\u000e\u0001C\u0001S\")!\u000f\u0001C\u0001g\"1!\u0010\u0001Q\u0005\nmD\u0001\"!\u000b\u0001A\u0013%\u00111F\u0004\b\u0003_)\u0002\u0012AA\u0019\r\u0019!R\u0003#\u0001\u00024!1a*\u0004C\u0001\u0003kA\u0011\"a\u000e\u000e\u0005\u0004%I!!\u000f\t\u0011\u0005\u0015S\u0002)A\u0005\u0003wAq!a\u0012\u000e\t\u0003\tI\u0005C\u0004\u0002T5!I!!\u0016\t\u000f\u0005\u0015T\u0002\"\u0003\u0002h\tqA\u000b\\:Ue\u0006t7\u000f]8si\u0016\u0014(B\u0001\f\u0018\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\u00193\u0005\u0019Q\r\u001f9\u000b\u0005iY\u0012!\u00025uiB\u0014$B\u0001\u000f\u001e\u0003\u001d1\u0017N\\1hY\u0016T!AH\u0010\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0001%A\u0002d_6\u001c2\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB)\u0011\u0006\f\u0018/c5\t!F\u0003\u0002,7\u000511\r\\5f]RL!!\f\u0016\u0003\u0017Q\u0013\u0018M\\:q_J$XM\u001d\t\u0003G=J!\u0001\r\u0013\u0003\u0007\u0005s\u0017\u0010\u0005\u00023i5\t1G\u0003\u0002\u00177%\u0011Qg\r\u0002\u0011)J\fgn\u001d9peR\u001cuN\u001c;fqR\f\u0011cY8o]\u0016\u001cG/[8o\u0005VLG\u000eZ3s\u0007\u0001\u0001\"!\u000f\u001f\u000e\u0003iR!aO\u000e\u0002\r9,G\u000f^=5\u0013\ti$HA\tD_:tWm\u0019;j_:\u0014U/\u001b7eKJ\f\u0001\"\\8eS\u001aLWM\u001d\t\u0005G\u0001\u0013%)\u0003\u0002BI\tIa)\u001e8di&|g.\r\t\u0005e\rsc&\u0003\u0002Eg\tIAK]1ogB|'\u000f^\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005\u001d[eB\u0001%J\u001b\u0005Y\u0012B\u0001&\u001c\u0003\u0015\u0019F/Y2l\u0013\taUJ\u0001\u0004QCJ\fWn\u001d\u0006\u0003\u0015n\ta\u0001P5oSRtD\u0003\u0002)S'R\u0003\"!\u0015\u0001\u000e\u0003UAQA\u000e\u0003A\u0002aBQA\u0010\u0003A\u0002}BQ!\u0012\u0003A\u0002\u0019\u000bQb\u001d;biN\u0014VmY3jm\u0016\u0014\bCA,[\u001b\u0005A&BA-\u001c\u0003\u0015\u0019H/\u0019;t\u0013\tY\u0006LA\u0007Ti\u0006$8OU3dK&4XM]\u0001\u000fkB<'/\u00193f\u0007>,h\u000e^3s!\t9f,\u0003\u0002`1\n91i\\;oi\u0016\u0014\u0018aC8o\u0011J\u001aVm]:j_:\u0004\"AY3\u000f\u0005E\u001b\u0017B\u00013\u0016\u0003\u0019A%\u0007U8pY&\u0011am\u001a\u0002\f\u001f:D%gU3tg&|gN\u0003\u0002e+\u0005i!/Z7pi\u0016\fE\r\u001a:fgN,\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\f1A\\3u\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d7\u0003\u001bM{7m[3u\u0003\u0012$'/Z:t\u0003\u0015\t\u0007\u000f\u001d7z)\u0005!\bcA;y\u00056\taO\u0003\u0002x;\u0005!Q\u000f^5m\u0013\tIhO\u0001\u0004GkR,(/Z\u0001\n_:\u001cuN\u001c8fGR$B\u0001\u001e?\u0002\u0010!)QP\u0003a\u0001}\u000691\r[1o]\u0016d\u0007cA@\u0002\f5\u0011\u0011\u0011\u0001\u0006\u0004{\u0006\r!\u0002BA\u0003\u0003\u000f\tQA\\3uifT!!!\u0003\u0002\u0005%|\u0017\u0002BA\u0007\u0003\u0003\u0011qa\u00115b]:,G\u000eC\u0004\u0002\u0012)\u0001\r!a\u0005\u0002\u0011A\u0014x\u000e^8d_2\u0004B!!\u0006\u0002$9!\u0011qCA\u0010!\r\tI\u0002J\u0007\u0003\u00037Q1!!\b8\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0005\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#a\n\u0003\rM#(/\u001b8h\u0015\r\t\t\u0003J\u0001\u0010Q\u0006tG\r\\3IeU\u0003xM]1eKR\u0019A/!\f\t\u000bu\\\u0001\u0019\u0001@\u0002\u001dQc7\u000f\u0016:b]N\u0004xN\u001d;feB\u0011\u0011+D\n\u0003\u001b\t\"\"!!\r\u0002\u001f\u0011+g-Y;miB\u0013x\u000e^8d_2,\"!a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011o\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0012qH\u0001\u0011\t\u00164\u0017-\u001e7u!J|Go\\2pY\u0002\nA!\\1lKR9\u0001&a\u0013\u0002P\u0005E\u0003BBA'#\u0001\u0007!.\u0001\u0003bI\u0012\u0014\b\"\u0002 \u0012\u0001\u0004y\u0004\"B#\u0012\u0001\u00041\u0015AF2p]\u001aLw-\u001e:f\u0011R$\bO\r)ja\u0016d\u0017N\\3\u0015\r\u0005]\u0013\u0011MA2!\u0011\tI&!\u0018\u000e\u0005\u0005m#B\u0001\f\u001a\u0013\u0011\ty&a\u0017\u0003\u001b\rc\u0017.\u001a8u'\u0016\u001c8/[8o\u0011\u0015i(\u00031\u0001\u007f\u0011\u0015)%\u00031\u0001G\u0003Y\u0019wN\u001c4jOV\u0014X\r\u0013;uaF\u0002\u0016\u000e]3mS:,G#\u0002\"\u0002j\u0005-\u0004\"B?\u0014\u0001\u0004q\b\"B#\u0014\u0001\u00041\u0005")
public class TlsTransporter
implements Transporter<Object, Object, TransportContext> {
    private final ConnectionBuilder connectionBuilder;
    private final Function1<Transport<Object, Object>, Transport<Object, Object>> modifier;
    private final Stack.Params params;
    private final StatsReceiver statsReceiver;
    private final Counter upgradeCounter;
    private final H2Pool.OnH2Session onH2Session;

    public static Transporter<Object, Object, TransportContext> make(SocketAddress socketAddress, Function1<Transport<Object, Object>, Transport<Object, Object>> function1, Stack.Params params) {
        return TlsTransporter$.MODULE$.make(socketAddress, function1, params);
    }

    public SocketAddress remoteAddress() {
        return this.connectionBuilder.remoteAddress();
    }

    public Future<Transport<Object, Object>> apply() {
        return this.connectionBuilder.build((Function1 & Serializable & scala.Serializable)channel -> {
            SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
            String proto = sslHandler.applicationProtocol();
            return this.onConnect((Channel)channel, proto == null ? TlsTransporter$.MODULE$.com$twitter$finagle$http2$exp$transport$TlsTransporter$$DefaultProtocol() : proto);
        });
    }

    private Future<Transport<Object, Object>> onConnect(Channel channel, String protocol) {
        Future future;
        String string = protocol;
        if ("h2".equals(string)) {
            future = this.handleH2Upgrade(channel);
        } else if ("http/1.1".equals(string)) {
            future = Future$.MODULE$.value(TlsTransporter$.MODULE$.com$twitter$finagle$http2$exp$transport$TlsTransporter$$configureHttp1Pipeline(channel, this.params));
        } else {
            channel.close();
            throw new IllegalStateException(new StringBuilder(18).append("unknown protocol: ").append(protocol).toString());
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<Transport<Object, Object>> handleH2Upgrade(Channel channel) {
        void var3_3;
        this.upgradeCounter.incr();
        ClientSession session = TlsTransporter$.MODULE$.com$twitter$finagle$http2$exp$transport$TlsTransporter$$configureHttp2Pipeline(channel, this.params);
        Future childTransport = session.newChildTransport().map((Function1 & Serializable & scala.Serializable)x$1 -> new SingleDispatchTransport((Transport<Object, Object>)x$1));
        childTransport.respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TlsTransporter.$anonfun$handleH2Upgrade$2(this, session, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$handleH2Upgrade$2(TlsTransporter $this, ClientSession session$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Return) {
            Return return_ = (Return)try_;
            SingleDispatchTransport t = (SingleDispatchTransport)((Object)return_.r());
            DeferredCloseSession dSession = new DeferredCloseSession(session$1, (Future<BoxedUnit>)t.onClose().unit());
            $this.onH2Session.apply(new ClientServiceImpl(dSession, $this.statsReceiver, $this.modifier));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            session$1.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public TlsTransporter(ConnectionBuilder connectionBuilder, Function1<Transport<Object, Object>, Transport<Object, Object>> modifier, Stack.Params params) {
        H2Pool.OnH2Session s;
        this.connectionBuilder = connectionBuilder;
        this.modifier = modifier;
        this.params = params;
        this.statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.upgradeCounter = this.statsReceiver.scope("upgrade").counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"success"}));
        Option<H2Pool.OnH2Session> option = ((H2Pool.OnH2SessionParam)params.apply(H2Pool$OnH2SessionParam$.MODULE$.param())).onH2Session();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(23).append("params are missing the ").append(H2Pool.OnH2Session.class.getSimpleName()).toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        H2Pool.OnH2Session onH2Session = s = (H2Pool.OnH2Session)some.value();
        this.onH2Session = onH2Session;
    }
}

