/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.H2Filter$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import com.twitter.util.TimerTask;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\b\u0011\u0005IQ\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b5\u0002A\u0011\u0001\u0018\t\rI\u0002\u0001\u0015)\u00034\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u00151\u0007\u0001\"\u0011h\u000f\u0019q\u0007\u0003#\u0001\u0013_\u001a1q\u0002\u0005E\u0001%ADQ!L\u0005\u0005\u0002QDq!^\u0005C\u0002\u0013%a\u000f\u0003\u0004~\u0013\u0001\u0006Ia\u001e\u0005\b}&\u0011\r\u0011\"\u0001\u0000\u0011!\t\t\"\u0003Q\u0001\n\u0005\u0005!\u0001\u0003%3\r&dG/\u001a:\u000b\u0005E\u0011\u0012!\u0003;sC:\u001c\bo\u001c:u\u0015\t\u0019B#A\u0003iiR\u0004(G\u0003\u0002\u0016-\u00059a-\u001b8bO2,'BA\f\u0019\u0003\u001d!x/\u001b;uKJT\u0011!G\u0001\u0004G>l7C\u0001\u0001\u001c!\ta2%D\u0001\u001e\u0015\tqr$A\u0004dQ\u0006tg.\u001a7\u000b\u0005\u0001\n\u0013!\u00028fiRL(\"\u0001\u0012\u0002\u0005%|\u0017B\u0001\u0013\u001e\u0005Q\u0019\u0005.\u00198oK2$U\u000f\u001d7fq\"\u000bg\u000e\u001a7fe\u0006)A/[7fe\u000e\u0001\u0001C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0017\u0003\u0011)H/\u001b7\n\u00051J#!\u0002+j[\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00020cA\u0011\u0001\u0007A\u0007\u0002!!)QE\u0001a\u0001O\u0005i1\r\\8tK\u0012+\u0017\r\u001a7j]\u0016\u0004\"\u0001\u000b\u001b\n\u0005UJ#\u0001\u0002+j[\u0016D#aA\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u0011Y|G.\u0019;jY\u0016\f1b]3u\t\u0016\fG\r\\5oKR\u0011qH\u0011\t\u0003q\u0001K!!Q\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0007\u0012\u0001\raM\u0001\tI\u0016\fG\r\\5oK\u0006Y1\r[1o]\u0016d'+Z1e)\rydi\u0013\u0005\u0006\u000f\u0016\u0001\r\u0001S\u0001\u0004GRD\bC\u0001\u000fJ\u0013\tQUDA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000b1+\u0001\u0019A'\u0002\u00075\u001cx\r\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!A.\u00198h\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\r=\u0013'.Z2u\u0003=)\u0007pY3qi&|gnQ1vO\"$HcA X1\")qI\u0002a\u0001\u0011\")\u0011L\u0002a\u00015\u0006)1-Y;tKB\u00111l\u0019\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014B\u00012:\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0013QC'o\\<bE2,'B\u00012:\u0003\u0015\u0019Gn\\:f)\ry\u0004.\u001b\u0005\u0006\u000f\u001e\u0001\r\u0001\u0013\u0005\u0006U\u001e\u0001\ra[\u0001\baJ|W.[:f!\taB.\u0003\u0002n;\tq1\t[1o]\u0016d\u0007K]8nSN,\u0017\u0001\u0003%3\r&dG/\u001a:\u0011\u0005AJ1CA\u0005r!\tA$/\u0003\u0002ts\t1\u0011I\\=SK\u001a$\u0012a\\\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A\u001f\f\u0002\u000f1|wmZ5oO&\u0011A0\u001f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Y\u0001*\u00198eY\u0016\u0014h*Y7f+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u000f\u0001\"!X\u001d\n\u0007\u0005%\u0011(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013I\u0014\u0001\u0004%b]\u0012dWM\u001d(b[\u0016\u0004\u0003")
public final class H2Filter
extends ChannelDuplexHandler {
    private final Timer timer;
    private volatile Time closeDeadline;

    public static String HandlerName() {
        return H2Filter$.MODULE$.HandlerName();
    }

    public void setDeadline(Time deadline) {
        this.closeDeadline = deadline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2Frame) {
            Http2Frame http2Frame = (Http2Frame)object;
            ReferenceCountUtil.release((Object)http2Frame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.channelRead(ctx, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        if (connectionHandler == null) {
            String message = new StringBuilder(63).append("Found H2Filter in a pipeline without a Http2ConnectionHandler. ").append(new StringBuilder(10).append("Pipeline: ").append(ctx.pipeline()).toString()).toString();
            IllegalStateException ex = new IllegalStateException(message);
            H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().error((Throwable)ex, message, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close(promise);
        } else {
            Time deadline = this.closeDeadline;
            Time now = Time$.MODULE$.now();
            if (deadline.$less$eq((Object)now)) {
                connectionHandler.gracefulShutdownTimeoutMillis(0L);
                H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().debug(new StringBuilder(44).append("Deadline already passed (").append(deadline).append(" <= ").append(now).append("). Closing now.").toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                super.close(ctx, promise);
            } else {
                H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().info(new StringBuilder(33).append("Closing h2 session with deadline ").append(deadline).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DefaultHttp2GoAwayFrame goawayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
                goawayFrame.setExtraStreamIds(Integer.MAX_VALUE);
                AtomicBoolean promiseOnce = new AtomicBoolean();
                ctx.writeAndFlush((Object)goawayFrame).addListener((GenericFutureListener)new ChannelFutureListener(null, promiseOnce, ctx, promise){
                    private final AtomicBoolean promiseOnce$1;
                    private final ChannelHandlerContext ctx$1;
                    private final ChannelPromise promise$1;

                    public void operationComplete(ChannelFuture future) {
                        block0: {
                            if (future.isSuccess() || !this.promiseOnce$1.compareAndSet(false, true)) break block0;
                            this.ctx$1.close(this.promise$1);
                        }
                    }
                    {
                        this.promiseOnce$1 = promiseOnce$1;
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                    }
                });
                TimerTask closeTask = this.timer.schedule(deadline, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        if (!promiseOnce.compareAndSet(false, true)) break block0;
                        ctx.channel().eventLoop().execute(new Runnable(null, ctx, promise){
                            public final ChannelHandlerContext ctx$1;
                            public final ChannelPromise promise$1;

                            public void run() {
                                H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().info("Graceful draining period lapsed. Sending final GOAWAY and closing the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                this.ctx$1.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener((GenericFutureListener)new ChannelFutureListener(this){
                                    private final /* synthetic */ $anon$2 $outer;

                                    public void operationComplete(ChannelFuture future) {
                                        this.$outer.ctx$1.close(this.$outer.promise$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.ctx$1 = ctx$1;
                                this.promise$1 = promise$1;
                            }
                        });
                    }
                });
                ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(null, closeTask, promiseOnce, promise){
                    private final TimerTask closeTask$1;
                    private final AtomicBoolean promiseOnce$1;
                    private final ChannelPromise promise$1;

                    public void operationComplete(ChannelFuture future) {
                        block0: {
                            this.closeTask$1.cancel();
                            if (!this.promiseOnce$1.compareAndSet(false, true)) break block0;
                            H2Filter$.MODULE$.com$twitter$finagle$http2$transport$H2Filter$$logger().info("Channel closed, session terminated.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            this.promise$1.setSuccess();
                        }
                    }
                    {
                        this.closeTask$1 = closeTask$1;
                        this.promiseOnce$1 = promiseOnce$1;
                        this.promise$1 = promise$1;
                    }
                });
            }
        }
    }

    public H2Filter(Timer timer) {
        this.timer = timer;
        this.closeDeadline = Time$.MODULE$.Bottom();
    }
}

