/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.StreamMessage;
import com.twitter.finagle.http2.transport.StreamMessage$Ping$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0006\r\u000591\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u000b%\u0002A\u0011\u0001\u0016\t\u000f9\u0002!\u0019!C\u0005_!1a\u0007\u0001Q\u0001\nABQa\u000e\u0001\u0005BaBQA\u0015\u0001\u0005BMCQA\u0015\u0001\u0005B\u0001DQ\u0001\u001d\u0001\u0005BEDQ!\u001f\u0001\u0005BiDq!a\u0001\u0001\t\u0003\n)AA\u000bIiR\u0004(g\u00117jK:$Hi\\<oOJ\fG-\u001a:\u000b\u00055q\u0011!\u0003;sC:\u001c\bo\u001c:u\u0015\ty\u0001#A\u0003iiR\u0004(G\u0003\u0002\u0012%\u00059a-\u001b8bO2,'BA\n\u0015\u0003\u001d!x/\u001b;uKJT\u0011!F\u0001\u0004G>l7C\u0001\u0001\u0018!\tA\"%D\u0001\u001a\u0015\ty!D\u0003\u0002\u001c9\u0005)1m\u001c3fG*\u0011QDH\u0001\bQ\u0006tG\r\\3s\u0015\ty\u0002%A\u0003oKR$\u0018PC\u0001\"\u0003\tIw.\u0003\u0002$3\t\t\u0002\n\u001e;qe\u00153XM\u001c;BI\u0006\u0004H/\u001a:\u0002\u0015\r|gN\\3di&|gn\u0001\u0001\u0011\u0005a9\u0013B\u0001\u0015\u001a\u0005=AE\u000f\u001e93\u0007>tg.Z2uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002,[A\u0011A\u0006A\u0007\u0002\u0019!)AE\u0001a\u0001M\u0005\u0019\u0002*Z1eKJ$vn\u001c'be\u001e,')\u001f;fgV\t\u0001\u0007\u0005\u00022i5\t!G\u0003\u00024=\u00051!-\u001e4gKJL!!\u000e\u001a\u0003\u000f\tKH/\u001a\"vM\u0006!\u0002*Z1eKJ$vn\u001c'be\u001e,')\u001f;fg\u0002\n!b\u001c8ECR\f'+Z1e)\u0019IthR%L\u001bB\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t\u0019\u0011J\u001c;\t\u000b\u0001+\u0001\u0019A!\u0002\u0007\r$\b\u0010\u0005\u0002C\u000b6\t1I\u0003\u0002E=\u000591\r[1o]\u0016d\u0017B\u0001$D\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ\u0001S\u0003A\u0002e\n\u0001b\u001d;sK\u0006l\u0017\n\u001a\u0005\u0006\u0015\u0016\u0001\r\u0001M\u0001\u0005I\u0006$\u0018\rC\u0003M\u000b\u0001\u0007\u0011(A\u0004qC\u0012$\u0017N\\4\t\u000b9+\u0001\u0019A(\u0002\u0017\u0015tGm\u00144TiJ,\u0017-\u001c\t\u0003uAK!!U\u001e\u0003\u000f\t{w\u000e\\3b]\u0006iqN\u001c%fC\u0012,'o\u001d*fC\u0012$b\u0001V,Y3z{\u0006C\u0001\u001eV\u0013\t16H\u0001\u0003V]&$\b\"\u0002!\u0007\u0001\u0004\t\u0005\"\u0002%\u0007\u0001\u0004I\u0004\"\u0002.\u0007\u0001\u0004Y\u0016a\u00025fC\u0012,'o\u001d\t\u00031qK!!X\r\u0003\u0019!#H\u000f\u001d\u001aIK\u0006$WM]:\t\u000b13\u0001\u0019A\u001d\t\u000b93\u0001\u0019A(\u0015\u0013Q\u000b'mY3hY:|\u0007\"\u0002!\b\u0001\u0004\t\u0005\"\u0002%\b\u0001\u0004I\u0004\"\u00023\b\u0001\u0004Y\u0016A\u00038fo\"+\u0017\rZ3sg\")am\u0002a\u0001s\u0005\u00012\u000f\u001e:fC6$U\r]3oI\u0016t7-\u001f\u0005\u0006Q\u001e\u0001\r![\u0001\u0007o\u0016Lw\r\u001b;\u0011\u0005iR\u0017BA6<\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0015iw\u00011\u0001P\u0003%)\u0007p\u00197vg&4X\rC\u0003M\u000f\u0001\u0007\u0011\bC\u0003O\u000f\u0001\u0007q*A\bp]J\u001bHo\u0015;sK\u0006l'+Z1e)\u0011!&o\u001d;\t\u000b\u0001C\u0001\u0019A!\t\u000b!C\u0001\u0019A\u001d\t\u000bUD\u0001\u0019\u0001<\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,\u0007C\u0001\u001ex\u0013\tA8H\u0001\u0003M_:<\u0017\u0001D8o\u000f>\fu/Y=SK\u0006$G#\u0002+|yz|\b\"\u0002!\n\u0001\u0004\t\u0005\"B?\n\u0001\u0004I\u0014\u0001\u00047bgR\u001cFO]3b[&#\u0007\"B;\n\u0001\u00041\bBBA\u0001\u0013\u0001\u0007\u0001'A\u0003eK\n,x-A\u0007p]BKgnZ!dWJ+\u0017\r\u001a\u000b\u0006)\u0006\u001d\u0011\u0011\u0002\u0005\u0006\u0001*\u0001\r!\u0011\u0005\u0006\u0015*\u0001\rA\u001e")
public final class Http2ClientDowngrader
extends Http2EventAdapter {
    private final Http2Connection connection;
    private final ByteBuf HeaderTooLargeBytes;

    private ByteBuf HeaderTooLargeBytes() {
        return this.HeaderTooLargeBytes;
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int length = data.readableBytes();
        data.retain();
        DefaultLastHttpContent msg = endOfStream ? new DefaultLastHttpContent(data) : new DefaultHttpContent(data);
        ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
        return length + padding;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        if (HttpResponseStatus.CONTINUE.codeAsText().contentEquals(headers.status())) {
            FullHttpResponse msg = HttpConversionUtil.toFullHttpResponse((int)streamId, (Http2Headers)headers, (ByteBufAllocator)ctx.alloc(), (boolean)false);
            ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
        } else if (endOfStream) {
            if (this.connection.stream(streamId).isTrailersReceived()) {
                DefaultLastHttpContent msg = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
                HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)headers, (HttpHeaders)msg.trailingHeaders(), (HttpVersion)HttpVersion.HTTP_1_1, (boolean)true, (boolean)false);
                ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
            } else {
                FullHttpResponse msg = HttpConversionUtil.toFullHttpResponse((int)streamId, (Http2Headers)headers, (ByteBufAllocator)ctx.alloc(), (boolean)false);
                ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
            }
        } else {
            HttpResponseStatus status = HttpConversionUtil.parseStatus((CharSequence)headers.status());
            DefaultHttpResponse msg = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status, false);
            HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)headers, (HttpHeaders)msg.headers(), (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)false);
            ctx.fireChannelRead((Object)new StreamMessage.Message((HttpObject)msg, streamId));
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers newHeaders, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(ctx, streamId, newHeaders, padding, endOfStream);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        ctx.fireChannelRead((Object)new StreamMessage.Rst(streamId, errorCode));
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debug) {
        ByteBuf sliced;
        int idx = debug.readerIndex();
        ByteBuf byteBuf = sliced = debug.slice(idx, package$.MODULE$.min(idx + this.HeaderTooLargeBytes().readableBytes(), idx + debug.readableBytes()));
        ByteBuf byteBuf2 = this.HeaderTooLargeBytes();
        HttpResponseStatus status = !(byteBuf != null ? !byteBuf.equals(byteBuf2) : byteBuf2 != null) ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST;
        DefaultFullHttpResponse rep = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        ctx.fireChannelRead((Object)new StreamMessage.GoAway((HttpObject)rep, lastStreamId, errorCode));
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
        ctx.fireChannelRead((Object)StreamMessage$Ping$.MODULE$);
    }

    public Http2ClientDowngrader(Http2Connection connection) {
        this.connection = connection;
        this.HeaderTooLargeBytes = Unpooled.copiedBuffer((CharSequence)"Header size exceeded max allowed bytes", (Charset)StandardCharsets.UTF_8);
    }
}

