/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.ClientDiscardedRequestException;
import com.twitter.finagle.http2.transport.ClientDiscardedRequestException$;
import com.twitter.finagle.http2.transport.Http2StreamMessageHandler$;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ubA\u0002\u000b\u0016\u0003\u00039r\u0004C\u0003+\u0001\u0011%A\u0006\u0003\u00040\u0001\u0001\u0006K\u0001\r\u0005\u0007s\u0001\u0001\u000b\u0015\u0002\u001e\t\u000bu\u0002a\u0011\u0003 \t\u000bM\u0003A\u0011\t+\t\u000b\u0015\u0004A\u0011\t4\b\r%,\u0002\u0012A\fk\r\u0019!R\u0003#\u0001\u0018W\")!\u0006\u0003C\u0001_\"9\u0001\u000f\u0003b\u0001\n\u0013\t\bB\u0002=\tA\u0003%!\u000fC\u0003z\u0011\u0011\u0005!P\u0002\u0003~\u0011\u0019q\b\"\u0002\u0016\u000e\t\u0003y\bBB\u001f\u000e\t#\t)A\u0002\u0004\u0002\u000e!1\u0011q\u0002\u0005\u0007UA!\t!!\u0005\t\ru\u0002B\u0011CA\u000b\u0011!\ti\u0002\u0003Q\u0005\n\u0005}!!\u0007%uiB\u00144\u000b\u001e:fC6lUm]:bO\u0016D\u0015M\u001c3mKJT!AF\f\u0002\u0013Q\u0014\u0018M\\:q_J$(B\u0001\r\u001a\u0003\u0015AG\u000f\u001e93\u0015\tQ2$A\u0004gS:\fw\r\\3\u000b\u0005qi\u0012a\u0002;xSR$XM\u001d\u0006\u0002=\u0005\u00191m\\7\u0014\u0005\u0001\u0001\u0003CA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u001d\u0019\u0007.\u00198oK2T!!\n\u0014\u0002\u000b9,G\u000f^=\u000b\u0003\u001d\n!![8\n\u0005%\u0012#\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'/\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005)\u0012A\u0004:fg\u0016$XI\u001d:pe\u000e{G-\u001a\t\u0004cQ2T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r=\u0003H/[8o!\t\tt'\u0003\u00029e\t!Aj\u001c8h\u0003]y'm]3sm\u0016$g)\u001b:ti\"#H\u000f](cU\u0016\u001cG\u000f\u0005\u00022w%\u0011AH\r\u0002\b\u0005>|G.Z1o\u0003-A\u0017M\u001c3mKJ+7/\u001a;\u0015\t}\u0012uI\u0015\t\u0003c\u0001K!!\u0011\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0007\u0012\u0001\r\u0001R\u0001\u0004GRD\bCA\u0011F\u0013\t1%EA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000b!#\u0001\u0019A%\u0002\u0007I\u001cH\u000f\u0005\u0002K!6\t1J\u0003\u0002\u0019\u0019*\u0011QJT\u0001\u0006G>$Wm\u0019\u0006\u0003\u001f\u0012\nq\u0001[1oI2,'/\u0003\u0002R\u0017\ny\u0001\n\u001e;qeI+7/\u001a;Ge\u0006lW\rC\u0003:\t\u0001\u0007!(A\u0003xe&$X\r\u0006\u0003@+Z\u0003\u0007\"B\"\u0006\u0001\u0004!\u0005\"B,\u0006\u0001\u0004A\u0016aA7tOB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&AB(cU\u0016\u001cG\u000fC\u0003b\u000b\u0001\u0007!-A\u0001q!\t\t3-\u0003\u0002eE\tq1\t[1o]\u0016d\u0007K]8nSN,\u0017aC2iC:tW\r\u001c*fC\u0012$2aP4i\u0011\u0015\u0019e\u00011\u0001E\u0011\u00159f\u00011\u0001Y\u0003eAE\u000f\u001e93'R\u0014X-Y7NKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\u00059B1C\u0001\u0005m!\t\tT.\u0003\u0002oe\t1\u0011I\\=SK\u001a$\u0012A[\u0001\u0007Y><w-\u001a:\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!^\u000e\u0002\u000f1|wmZ5oO&\u0011q\u000f\u001e\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005)\u0011\r\u001d9msR\u0011Qf\u001f\u0005\u0006y2\u0001\rAO\u0001\tSN\u001cVM\u001d<fe\ny2+\u001a:wKJDE\u000f\u001e93'R\u0014X-Y7NKN\u001c\u0018mZ3IC:$G.\u001a:\u0014\u00055iCCAA\u0001!\r\t\u0019!D\u0007\u0002\u0011Q9q(a\u0002\u0002\n\u0005-\u0001\"B\"\u0010\u0001\u0004!\u0005\"\u0002%\u0010\u0001\u0004I\u0005\"B\u001d\u0010\u0001\u0004Q$aH\"mS\u0016tG\u000f\u0013;uaJ\u001aFO]3b[6+7o]1hK\"\u000bg\u000e\u001a7feN\u0011\u0001#\f\u000b\u0003\u0003'\u00012!a\u0001\u0011)\u001dy\u0014qCA\r\u00037AQa\u0011\nA\u0002\u0011CQ\u0001\u0013\nA\u0002%CQ!\u000f\nA\u0002i\naB]:u)>,\u0005pY3qi&|g\u000e\u0006\u0004\u0002\"\u0005%\u00121\u0006\t\u0005\u0003G\t)#D\u0001\u0018\u0013\r\t9c\u0006\u0002\r%N$X\t_2faRLwN\u001c\u0005\u0006\u0011N\u0001\r!\u0013\u0005\b\u0003[\u0019\u0002\u0019AA\u0018\u00035\u0011X-\\8uK\u0006#GM]3tgB!\u0011\u0007NA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c9\u0006\u0019a.\u001a;\n\t\u0005m\u0012Q\u0007\u0002\u000e'>\u001c7.\u001a;BI\u0012\u0014Xm]:")
public abstract class Http2StreamMessageHandler
extends ChannelDuplexHandler {
    private Option<Object> resetErrorCode = None$.MODULE$;
    private boolean observedFirstHttpObject = false;

    public static Http2StreamMessageHandler apply(boolean bl) {
        return Http2StreamMessageHandler$.MODULE$.apply(bl);
    }

    public abstract void handleReset(ChannelHandlerContext var1, Http2ResetFrame var2, boolean var3);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Option<Object> option = this.resetErrorCode;
        if (None$.MODULE$.equals(option)) {
            super.write(ctx, msg, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long code = BoxesRunTime.unboxToLong((Object)some.value());
            ReferenceCountUtil.release((Object)msg);
            p.tryFailure((Throwable)new ClientDiscardedRequestException(code, ClientDiscardedRequestException$.MODULE$.$lessinit$greater$default$2()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2WindowUpdateFrame) {
            Http2WindowUpdateFrame http2WindowUpdateFrame = (Http2WindowUpdateFrame)object;
            ReferenceCountUtil.release((Object)http2WindowUpdateFrame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Http2ResetFrame) {
            Http2ResetFrame http2ResetFrame = (Http2ResetFrame)object;
            this.resetErrorCode = new Some((Object)BoxesRunTime.boxToLong((long)http2ResetFrame.errorCode()));
            this.handleReset(ctx, http2ResetFrame, this.observedFirstHttpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof HttpObject) {
            HttpObject httpObject = (HttpObject)object;
            this.observedFirstHttpObject = true;
            super.channelRead(ctx, (Object)httpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ReferenceCountUtil.release((Object)object);
            String msg2 = new StringBuilder(29).append("Unexpected pipeline message: ").append(object.getClass().getName()).toString();
            IllegalArgumentException ex = new IllegalArgumentException(msg2);
            Http2StreamMessageHandler$.MODULE$.com$twitter$finagle$http2$transport$Http2StreamMessageHandler$$logger().error((Throwable)ex, msg2, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.fireExceptionCaught((Throwable)ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final class ClientHttp2StreamMessageHandler
    extends Http2StreamMessageHandler {
        @Override
        public void handleReset(ChannelHandlerContext ctx, Http2ResetFrame rst, boolean observedFirstHttpObject) {
            block0: {
                if (observedFirstHttpObject) break block0;
                ctx.fireExceptionCaught((Throwable)((Object)Http2StreamMessageHandler$.MODULE$.com$twitter$finagle$http2$transport$Http2StreamMessageHandler$$rstToException(rst, (Option<SocketAddress>)Option$.MODULE$.apply((Object)ctx.channel().remoteAddress()))));
            }
        }
    }

    public static final class ServerHttp2StreamMessageHandler
    extends Http2StreamMessageHandler {
        @Override
        public void handleReset(ChannelHandlerContext ctx, Http2ResetFrame rst, boolean observedFirstHttpObject) {
        }
    }
}

