/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.H2ServerFilter$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import com.twitter.util.TimerTask;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\b\u0011\u0005IQ\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b5\u0002A\u0011\u0001\u0018\t\rI\u0002\u0001\u0015)\u00034\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u00151\u0007\u0001\"\u0011h\u000f\u0019q\u0007\u0003#\u0001\u0013_\u001a1q\u0002\u0005E\u0001%ADQ!L\u0005\u0005\u0002QDq!^\u0005C\u0002\u0013%a\u000f\u0003\u0004~\u0013\u0001\u0006Ia\u001e\u0005\b}&\u0011\r\u0011\"\u0001\u0000\u0011!\t\t\"\u0003Q\u0001\n\u0005\u0005!A\u0004%3'\u0016\u0014h/\u001a:GS2$XM\u001d\u0006\u0003#I\t\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005M!\u0012!\u00025uiB\u0014$BA\u000b\u0017\u0003\u001d1\u0017N\\1hY\u0016T!a\u0006\r\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0011$A\u0002d_6\u001c\"\u0001A\u000e\u0011\u0005q\u0019S\"A\u000f\u000b\u0005yy\u0012aB2iC:tW\r\u001c\u0006\u0003A\u0005\nQA\\3uifT\u0011AI\u0001\u0003S>L!\u0001J\u000f\u0003)\rC\u0017M\u001c8fY\u0012+\b\u000f\\3y\u0011\u0006tG\r\\3s\u0003\u0015!\u0018.\\3s\u0007\u0001\u0001\"\u0001K\u0016\u000e\u0003%R!A\u000b\f\u0002\tU$\u0018\u000e\\\u0005\u0003Y%\u0012Q\u0001V5nKJ\fa\u0001P5oSRtDCA\u00182!\t\u0001\u0004!D\u0001\u0011\u0011\u0015)#\u00011\u0001(\u00035\u0019Gn\\:f\t\u0016\fG\r\\5oKB\u0011\u0001\u0006N\u0005\u0003k%\u0012A\u0001V5nK\"\u00121a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\tm>d\u0017\r^5mK\u0006Y1/\u001a;EK\u0006$G.\u001b8f)\ty$\t\u0005\u00029\u0001&\u0011\u0011)\u000f\u0002\u0005+:LG\u000fC\u0003D\t\u0001\u00071'\u0001\u0005eK\u0006$G.\u001b8f\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u0007}25\nC\u0003H\u000b\u0001\u0007\u0001*A\u0002dib\u0004\"\u0001H%\n\u0005)k\"!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006\u0019\u0016\u0001\r!T\u0001\u0004[N<\u0007C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011a\u0017M\\4\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\u0007\u001f\nTWm\u0019;\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$2aP,Y\u0011\u00159e\u00011\u0001I\u0011\u0015If\u00011\u0001[\u0003\u0015\u0019\u0017-^:f!\tY6M\u0004\u0002]C:\u0011Q\fY\u0007\u0002=*\u0011qLJ\u0001\u0007yI|w\u000e\u001e \n\u0003iJ!AY\u001d\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\n)\"\u0014xn^1cY\u0016T!AY\u001d\u0002\u000b\rdwn]3\u0015\u0007}B\u0017\u000eC\u0003H\u000f\u0001\u0007\u0001\nC\u0003k\u000f\u0001\u00071.A\u0004qe>l\u0017n]3\u0011\u0005qa\u0017BA7\u001e\u00059\u0019\u0005.\u00198oK2\u0004&o\\7jg\u0016\fa\u0002\u0013\u001aTKJ4XM\u001d$jYR,'\u000f\u0005\u00021\u0013M\u0011\u0011\"\u001d\t\u0003qIL!a]\u001d\u0003\r\u0005s\u0017PU3g)\u0005y\u0017A\u00027pO\u001e,'/F\u0001x!\tA80D\u0001z\u0015\tQh#A\u0004m_\u001e<\u0017N\\4\n\u0005qL(A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0017!\u000bg\u000e\u001a7fe:\u000bW.Z\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\f9!\u0011QAA\u0004!\ti\u0016(C\u0002\u0002\ne\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005s\u0005a\u0001*\u00198eY\u0016\u0014h*Y7fA\u0001")
public final class H2ServerFilter
extends ChannelDuplexHandler {
    private final Timer timer;
    private volatile Time closeDeadline;

    public static String HandlerName() {
        return H2ServerFilter$.MODULE$.HandlerName();
    }

    public void setDeadline(Time deadline) {
        this.closeDeadline = deadline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2Frame) {
            Http2Frame http2Frame = (Http2Frame)object;
            ReferenceCountUtil.release((Object)http2Frame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.channelRead(ctx, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        if (connectionHandler == null) {
            String message = new StringBuilder(69).append("Found H2ServerFilter in a pipeline without a Http2ConnectionHandler. ").append(new StringBuilder(10).append("Pipeline: ").append(ctx.pipeline()).toString()).toString();
            IllegalStateException ex = new IllegalStateException(message);
            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().error((Throwable)ex, message, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close(promise);
        } else {
            Time deadline = this.closeDeadline;
            Time now = Time$.MODULE$.now();
            if (deadline.$less$eq((Object)now)) {
                connectionHandler.gracefulShutdownTimeoutMillis(0L);
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().debug(new StringBuilder(44).append("Deadline already passed (").append(deadline).append(" <= ").append(now).append("). Closing now.").toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                super.close(ctx, promise);
            } else {
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().info(new StringBuilder(33).append("Closing h2 session with deadline ").append(deadline).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DefaultHttp2GoAwayFrame goawayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
                goawayFrame.setExtraStreamIds(Integer.MAX_VALUE);
                AtomicBoolean promiseOnce = new AtomicBoolean();
                ctx.writeAndFlush((Object)goawayFrame).addListener((GenericFutureListener)new ChannelFutureListener(null, promiseOnce, ctx, promise){
                    private final AtomicBoolean promiseOnce$1;
                    private final ChannelHandlerContext ctx$1;
                    private final ChannelPromise promise$1;

                    public void operationComplete(ChannelFuture future) {
                        block0: {
                            if (future.isSuccess() || !this.promiseOnce$1.compareAndSet(false, true)) break block0;
                            this.ctx$1.close(this.promise$1);
                        }
                    }
                    {
                        this.promiseOnce$1 = promiseOnce$1;
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                    }
                });
                TimerTask closeTask = this.timer.schedule(deadline, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        if (!promiseOnce.compareAndSet(false, true)) break block0;
                        ctx.channel().eventLoop().execute(new Runnable(null, ctx, promise){
                            public final ChannelHandlerContext ctx$1;
                            public final ChannelPromise promise$1;

                            public void run() {
                                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().info("Graceful draining period lapsed. Sending final GOAWAY and closing the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                this.ctx$1.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener((GenericFutureListener)new ChannelFutureListener(this){
                                    private final /* synthetic */ $anon$2 $outer;

                                    public void operationComplete(ChannelFuture future) {
                                        this.$outer.ctx$1.close(this.$outer.promise$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.ctx$1 = ctx$1;
                                this.promise$1 = promise$1;
                            }
                        });
                    }
                });
                ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(null, closeTask, promiseOnce, promise){
                    private final TimerTask closeTask$1;
                    private final AtomicBoolean promiseOnce$1;
                    private final ChannelPromise promise$1;

                    public void operationComplete(ChannelFuture future) {
                        block0: {
                            this.closeTask$1.cancel();
                            if (!this.promiseOnce$1.compareAndSet(false, true)) break block0;
                            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$H2ServerFilter$$logger().info("Channel closed, session terminated.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            this.promise$1.setSuccess();
                        }
                    }
                    {
                        this.closeTask$1 = closeTask$1;
                        this.promiseOnce$1 = promiseOnce$1;
                        this.promise$1 = promise$1;
                    }
                });
            }
        }
    }

    public H2ServerFilter(Timer timer) {
        this.timer = timer;
        this.closeDeadline = Time$.MODULE$.Bottom();
    }
}

