/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport;

import com.twitter.finagle.http2.transport.ClientDiscardedRequestException;
import com.twitter.finagle.http2.transport.ClientDiscardedRequestException$;
import com.twitter.finagle.http2.transport.Http2StreamMessageHandler$;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=cAB\u000b\u0017\u0003\u0003A\u0002\u0005C\u0003,\u0001\u0011%Q\u0006\u0003\u00041\u0001\u0001\u0006K!\r\u0005\u0007u\u0001\u0001\u000b\u0015B\u001e\t\u000by\u0002a\u0011C \t\u000bQ\u0003A\u0011I+\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\b\rI4\u0002\u0012\u0001\rt\r\u0019)b\u0003#\u0001\u0019i\")1&\u0003C\u0001q\"9\u00110\u0003b\u0001\n\u0013Q\bbBA\u0002\u0013\u0001\u0006Ia\u001f\u0005\b\u0003\u000bIA\u0011AA\u0004\r\u0019\ti!\u0003\u0004\u0002\u0010!11F\u0004C\u0001\u0003#AaA\u0010\b\u0005\u0012\u0005]aABA\u0010\u0013\u0019\t\t\u0003\u0003\u0004,#\u0011\u0005\u00111\u0005\u0005\u0007}E!\t\"a\n\t\u0011\u0005=\u0012\u0002)C\u0005\u0003c\u0011\u0011\u0004\u0013;uaJ\u001aFO]3b[6+7o]1hK\"\u000bg\u000e\u001a7fe*\u0011q\u0003G\u0001\niJ\fgn\u001d9peRT!!\u0007\u000e\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005ma\u0012a\u00024j]\u0006<G.\u001a\u0006\u0003;y\tq\u0001^<jiR,'OC\u0001 \u0003\r\u0019w.\\\n\u0003\u0001\u0005\u0002\"AI\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\u000f\rD\u0017M\u001c8fY*\u0011aeJ\u0001\u0006]\u0016$H/\u001f\u0006\u0002Q\u0005\u0011\u0011n\\\u0005\u0003U\r\u0012Ac\u00115b]:,G\u000eR;qY\u0016D\b*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$hh\u0001\u0001\u0015\u00039\u0002\"a\f\u0001\u000e\u0003Y\taB]3tKR,%O]8s\u0007>$W\rE\u00023k]j\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005IB\u0014BA\u001d4\u0005\u0011auN\\4\u0002/=\u00147/\u001a:wK\u00124\u0015N]:u\u0011R$\bo\u00142kK\u000e$\bC\u0001\u001a=\u0013\ti4GA\u0004C_>dW-\u00198\u0002\u0017!\fg\u000e\u001a7f%\u0016\u001cX\r\u001e\u000b\u0005\u0001\u000eC5\u000b\u0005\u00023\u0003&\u0011!i\r\u0002\u0005+:LG\u000fC\u0003E\t\u0001\u0007Q)A\u0002dib\u0004\"A\t$\n\u0005\u001d\u001b#!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u0004eN$\bCA&R\u001b\u0005a%BA\rN\u0015\tqu*A\u0003d_\u0012,7M\u0003\u0002QK\u00059\u0001.\u00198eY\u0016\u0014\u0018B\u0001*M\u0005=AE\u000f\u001e93%\u0016\u001cX\r\u001e$sC6,\u0007\"\u0002\u001e\u0005\u0001\u0004Y\u0014!B<sSR,G\u0003\u0002!W/\u0006DQ\u0001R\u0003A\u0002\u0015CQ\u0001W\u0003A\u0002e\u000b1!\\:h!\tQv,D\u0001\\\u0015\taV,\u0001\u0003mC:<'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013aa\u00142kK\u000e$\b\"\u00022\u0006\u0001\u0004\u0019\u0017!\u00019\u0011\u0005\t\"\u0017BA3$\u00059\u0019\u0005.\u00198oK2\u0004&o\\7jg\u0016\f!#^:fe\u00163XM\u001c;Ue&<w-\u001a:fIR\u0019\u0001\t[5\t\u000b\u00113\u0001\u0019A#\t\u000b)4\u0001\u0019A6\u0002\u0007\u00154H\u000f\u0005\u00023Y&\u0011Qn\r\u0002\u0004\u0003:L\u0018aC2iC:tW\r\u001c*fC\u0012$2\u0001\u00119r\u0011\u0015!u\u00011\u0001F\u0011\u0015Av\u00011\u0001Z\u0003eAE\u000f\u001e93'R\u0014X-Y7NKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\u0005=J1CA\u0005v!\t\u0011d/\u0003\u0002xg\t1\u0011I\\=SK\u001a$\u0012a]\u0001\u0007Y><w-\u001a:\u0016\u0003m\u0004\"\u0001`@\u000e\u0003uT!A \u000f\u0002\u000f1|wmZ5oO&\u0019\u0011\u0011A?\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nQ!\u00199qYf$2ALA\u0005\u0011\u0019\tY!\u0004a\u0001w\u0005A\u0011n]*feZ,'OA\u0010TKJ4XM\u001d%uiB\u00144\u000b\u001e:fC6lUm]:bO\u0016D\u0015M\u001c3mKJ\u001c\"A\u0004\u0018\u0015\u0005\u0005M\u0001cAA\u000b\u001d5\t\u0011\u0002F\u0004A\u00033\tY\"!\b\t\u000b\u0011\u0003\u0002\u0019A#\t\u000b%\u0003\u0002\u0019\u0001&\t\u000bi\u0002\u0002\u0019A\u001e\u0003?\rc\u0017.\u001a8u\u0011R$\bOM*ue\u0016\fW.T3tg\u0006<W\rS1oI2,'o\u0005\u0002\u0012]Q\u0011\u0011Q\u0005\t\u0004\u0003+\tBc\u0002!\u0002*\u0005-\u0012Q\u0006\u0005\u0006\tN\u0001\r!\u0012\u0005\u0006\u0013N\u0001\rA\u0013\u0005\u0006uM\u0001\raO\u0001\u000feN$Hk\\#yG\u0016\u0004H/[8o)\u0019\t\u0019$a\u000f\u0002>A!\u0011QGA\u001c\u001b\u0005A\u0012bAA\u001d1\ta!k\u001d;Fq\u000e,\u0007\u000f^5p]\")\u0011\n\u0006a\u0001\u0015\"9\u0011q\b\u000bA\u0002\u0005\u0005\u0013!\u0004:f[>$X-\u00113ee\u0016\u001c8\u000f\u0005\u00033k\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%S,A\u0002oKRLA!!\u0014\u0002H\ti1k\\2lKR\fE\r\u001a:fgN\u0004")
public abstract class Http2StreamMessageHandler
extends ChannelDuplexHandler {
    private Option<Object> resetErrorCode = None$.MODULE$;
    private boolean observedFirstHttpObject = false;

    public static Http2StreamMessageHandler apply(boolean bl) {
        return Http2StreamMessageHandler$.MODULE$.apply(bl);
    }

    public abstract void handleReset(ChannelHandlerContext var1, Http2ResetFrame var2, boolean var3);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Option<Object> option = this.resetErrorCode;
        if (None$.MODULE$.equals(option)) {
            super.write(ctx, msg, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long code = BoxesRunTime.unboxToLong((Object)some.value());
            ReferenceCountUtil.release((Object)msg);
            p.tryFailure((Throwable)new ClientDiscardedRequestException(code, ClientDiscardedRequestException$.MODULE$.$lessinit$greater$default$2()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (object instanceof Http2ResetFrame) {
            Http2ResetFrame http2ResetFrame = (Http2ResetFrame)object;
            this.resetErrorCode = new Some((Object)BoxesRunTime.boxToLong((long)http2ResetFrame.errorCode()));
            this.handleReset(ctx, http2ResetFrame, this.observedFirstHttpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ctx.fireUserEventTriggered(evt);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2WindowUpdateFrame) {
            Http2WindowUpdateFrame http2WindowUpdateFrame = (Http2WindowUpdateFrame)object;
            ReferenceCountUtil.release((Object)http2WindowUpdateFrame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof HttpObject) {
            HttpObject httpObject = (HttpObject)object;
            this.observedFirstHttpObject = true;
            super.channelRead(ctx, (Object)httpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ReferenceCountUtil.release((Object)object);
            String msg2 = new StringBuilder(29).append("Unexpected pipeline message: ").append(object.getClass().getName()).toString();
            IllegalArgumentException ex = new IllegalArgumentException(msg2);
            Http2StreamMessageHandler$.MODULE$.com$twitter$finagle$http2$transport$Http2StreamMessageHandler$$logger().error((Throwable)ex, msg2, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.fireExceptionCaught((Throwable)ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final class ClientHttp2StreamMessageHandler
    extends Http2StreamMessageHandler {
        @Override
        public void handleReset(ChannelHandlerContext ctx, Http2ResetFrame rst, boolean observedFirstHttpObject) {
            block0: {
                if (observedFirstHttpObject) break block0;
                ctx.fireExceptionCaught((Throwable)((Object)Http2StreamMessageHandler$.MODULE$.com$twitter$finagle$http2$transport$Http2StreamMessageHandler$$rstToException(rst, (Option<SocketAddress>)Option$.MODULE$.apply((Object)ctx.channel().remoteAddress()))));
            }
        }
    }

    public static final class ServerHttp2StreamMessageHandler
    extends Http2StreamMessageHandler {
        @Override
        public void handleReset(ChannelHandlerContext ctx, Http2ResetFrame rst, boolean observedFirstHttpObject) {
        }
    }
}

