/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport.client;

import com.twitter.finagle.Failure$;
import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Status;
import com.twitter.finagle.Status$;
import com.twitter.finagle.http2.DeadConnectionException;
import com.twitter.finagle.http2.param.MaxConcurrentStreams;
import com.twitter.finagle.http2.param.MaxConcurrentStreams$;
import com.twitter.finagle.http2.param.MaxRequestsPerSession;
import com.twitter.finagle.http2.param.MaxRequestsPerSession$;
import com.twitter.finagle.http2.transport.client.ClientSession;
import com.twitter.finagle.http2.transport.client.ClientSessionImpl$;
import com.twitter.finagle.http2.transport.client.StreamChannelTransport;
import com.twitter.finagle.netty4.Netty4Transporter;
import com.twitter.finagle.netty4.param.Allocator;
import com.twitter.finagle.netty4.param.Allocator$;
import com.twitter.finagle.transport.Transport;
import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Time;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u000f\u001e\r)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\r\u0019Q\u0006\u0001)A\u00077\"AqL\u0002B\u0001B\u0003%\u0011\nC\u0003T\r\u0011\u0005\u0001\rC\u0003e\r\u0011\u0005S\r\u0003\u0004g\u0001\u0001\u0006Ia\u001a\u0005\u0007_\u0002\u0001\u000b\u0011\u00029\t\rM\u0004\u0001\u0015!\u0003u\u0011\u00199\b\u0001)Q\u0005q\"11\u0010\u0001Q\u0001\nqDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002 \u0001\u0001K\u0011B3\t\u000b\u0011\u0004A\u0011A3\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005e\u0002\u0002CA\u001f\u0001\u0001&I!!\u000f\b\u000f\u0005}R\u0004#\u0003\u0002B\u00191A$\bE\u0005\u0003\u0007Baa\u0015\f\u0005\u0002\u0005\u0015\u0003\"CA$-\t\u0007I\u0011BA%\u0011!\t\tF\u0006Q\u0001\n\u0005-\u0003\"CA*-\t\u0007I\u0011BA%\u0011!\t)F\u0006Q\u0001\n\u0005-#!E\"mS\u0016tGoU3tg&|g.S7qY*\u0011adH\u0001\u0007G2LWM\u001c;\u000b\u0005\u0001\n\u0013!\u0003;sC:\u001c\bo\u001c:u\u0015\t\u00113%A\u0003iiR\u0004(G\u0003\u0002%K\u00059a-\u001b8bO2,'B\u0001\u0014(\u0003\u001d!x/\u001b;uKJT\u0011\u0001K\u0001\u0004G>l7\u0001A\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023g5\tQ$\u0003\u00025;\ti1\t\\5f]R\u001cVm]:j_:\fa\u0001]1sC6\u001c\bCA\u001c<\u001d\tA\u0014(D\u0001$\u0013\tQ4%A\u0003Ti\u0006\u001c7.\u0003\u0002={\t1\u0001+\u0019:b[NT!AO\u0012\u0002\u0017%t\u0017\u000e^5bY&TXM\u001d\t\u0004\u0001\u001eKU\"A!\u000b\u0005\t\u001b\u0015aB2iC:tW\r\u001c\u0006\u0003\t\u0016\u000bQA\\3uifT\u0011AR\u0001\u0003S>L!\u0001S!\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0003\u0001*K!aS!\u0003\u000f\rC\u0017M\u001c8fY\u0006)b-Y5mkJ,G)\u001a;fGR|'o\u0015;biV\u001c\bc\u0001\u0017O!&\u0011q*\f\u0002\n\rVt7\r^5p]B\u0002\"\u0001O)\n\u0005I\u001b#AB*uCR,8/\u0001\u0004=S:LGO\u0010\u000b\u0006+Z;\u0006,\u0017\t\u0003e\u0001AQ!N\u0003A\u0002YBQAP\u0003A\u0002}BQAQ\u0003A\u0002%CQ\u0001T\u0003A\u00025\u0013ab\u00115jY\u0012$&/\u00198ta>\u0014Ho\u0005\u0002\u00079B\u0011!'X\u0005\u0003=v\u0011ac\u0015;sK\u0006l7\t[1o]\u0016dGK]1ogB|'\u000f^\u0001\u0003G\"$\"!Y2\u0011\u0005\t4Q\"\u0001\u0001\t\u000b}C\u0001\u0019A%\u0002\rM$\u0018\r^;t+\u0005\u0001\u0016!B2pI\u0016\u001c\u0007C\u00015n\u001b\u0005I'B\u0001\u0012k\u0015\t17N\u0003\u0002m\u0007\u00069\u0001.\u00198eY\u0016\u0014\u0018B\u00018j\u0005=AE\u000f\u001e93\rJ\fW.Z\"pI\u0016\u001c\u0017aE:ue\u0016\fW\u000eS5hQ^\u000bG/\u001a:NCJ\\\u0007C\u0001\u0017r\u0013\t\u0011XF\u0001\u0003M_:<\u0017!\u00032p_R\u001cHO]1q!\tAW/\u0003\u0002wS\nY\u0002\n\u001e;qeM#(/Z1n\u0007\"\fgN\\3m\u0005>|Go\u001d;sCB\fab\u00197pg\u0016Le.\u001b;jCR,G\r\u0005\u0002-s&\u0011!0\f\u0002\b\u0005>|G.Z1o\u0003\u0019\u0019Gn\\:f!B)Q0!\u0001\u0002\u00065\taP\u0003\u0002\u0000K\u0005!Q\u000f^5m\u0013\r\t\u0019A \u0002\b!J|W.[:f!\ra\u0013qA\u0005\u0004\u0003\u0013i#\u0001B+oSR\fQa\u00197pg\u0016$B!a\u0004\u0002\u0016A)Q0!\u0005\u0002\u0006%\u0019\u00111\u0003@\u0003\r\u0019+H/\u001e:f\u0011\u001d\t9b\u0004a\u0001\u00033\t\u0001\u0002Z3bI2Lg.\u001a\t\u0004{\u0006m\u0011bAA\u000f}\n!A+[7f\u00035\u0019Xm]:j_:\u001cF/\u0019;vg\u0006\tb.Z<DQ&dG\r\u0016:b]N\u0004xN\u001d;\u0015\t\u0005\u0015\u0012Q\u0007\t\t\u0003O\tY#a\f\u000205\u0011\u0011\u0011\u0006\u0006\u0003A\rJA!!\f\u0002*\tIAK]1ogB|'\u000f\u001e\t\u0004Y\u0005E\u0012bAA\u001a[\t\u0019\u0011I\\=\t\r\u0005]\"\u00031\u0001J\u00035\u0019HO]3b[\u000eC\u0017M\u001c8fYR\u0011\u00111\b\t\u0006{\u0006E\u0011QE\u0001\u0019S:LGOT3x\u001d\u0016$H/_\"iS2$7\t[1o]\u0016d\u0017!E\"mS\u0016tGoU3tg&|g.S7qYB\u0011!GF\n\u0003--\"\"!!\u0011\u00025\u0011+g-Y;miN#(/Z1n\u0011&<\u0007nV1uKJl\u0015M]6\u0016\u0005\u0005-\u0003c\u0001\u0017\u0002N%\u0019\u0011qJ\u0017\u0003\u0007%sG/A\u000eEK\u001a\fW\u000f\u001c;TiJ,\u0017-\u001c%jO\"<\u0016\r^3s\u001b\u0006\u00148\u000eI\u0001\u001c\t\u00164\u0017-\u001e7u\u001b\u0006D8i\u001c8dkJ\u0014XM\u001c;TiJ,\u0017-\\:\u00029\u0011+g-Y;mi6\u000b\u0007pQ8oGV\u0014(/\u001a8u'R\u0014X-Y7tA\u0001")
public final class ClientSessionImpl
implements ClientSession {
    private final Channel channel;
    private final Function0<Status> failureDetectorStatus;
    private final Http2FrameCodec codec;
    private final long streamHighWaterMark;
    private final Http2StreamChannelBootstrap bootstrap;
    private boolean closeInitiated;
    public final Promise<BoxedUnit> com$twitter$finagle$http2$transport$client$ClientSessionImpl$$closeP;

    public final com.twitter.util.Future<BoxedUnit> close() {
        return Closable.close$((Closable)this);
    }

    public com.twitter.util.Future<BoxedUnit> close(Duration after) {
        return Closable.close$((Closable)this, (Duration)after);
    }

    public com.twitter.util.Future<BoxedUnit> close(Time deadline) {
        boolean bl;
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            boolean bl2;
            if (this.closeInitiated) {
                bl2 = false;
            } else {
                this.closeInitiated = true;
                bl2 = true;
            }
            bl = bl2;
        }
        boolean doClose = bl;
        Object object = doClose ? (!this.channel.isOpen() ? BoxesRunTime.boxToBoolean((boolean)this.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$closeP.setDone(Predef$.MODULE$.$conforms())) : this.channel.close().addListener((GenericFutureListener)new ChannelFutureListener(this){
            private final /* synthetic */ ClientSessionImpl $outer;

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    this.$outer.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$closeP.setDone(Predef$.MODULE$.$conforms());
                } else {
                    this.$outer.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$closeP.setException(future.cause());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })) : BoxedUnit.UNIT;
        return this.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$closeP;
    }

    private Status sessionStatus() {
        return !this.channel.isOpen() ? Status.Closed$.MODULE$ : ((long)this.codec.connection().local().lastStreamCreated() > this.streamHighWaterMark ? Status.Closed$.MODULE$ : (this.codec.connection().goAwayReceived() ? Status.Closed$.MODULE$ : (!this.codec.connection().local().canOpenStream() ? Status.Busy$.MODULE$ : Status.Open$.MODULE$)));
    }

    @Override
    public Status status() {
        return Status$.MODULE$.worst((Status)this.failureDetectorStatus.apply(), this.sessionStatus());
    }

    public Transport<Object, Object> newChildTransport(Channel streamChannel) {
        return new ChildTransport(streamChannel);
    }

    @Override
    public com.twitter.util.Future<Transport<Object, Object>> newChildTransport() {
        com.twitter.util.Future future;
        Status status = this.status();
        Status.Closed$ closed$ = Status.Closed$.MODULE$;
        if (status == null ? closed$ != null : !status.equals(closed$)) {
            future = this.initNewNettyChildChannel();
        } else {
            DeadConnectionException ex = new DeadConnectionException(this.channel.remoteAddress(), FailureFlags$.MODULE$.Retryable() | FailureFlags$.MODULE$.Rejected());
            future = Future$.MODULE$.exception((Throwable)ex);
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private com.twitter.util.Future<Transport<Object, Object>> initNewNettyChildChannel() {
        void var2_1;
        Promise p = Promise$.MODULE$.apply();
        try {
            this.channel.eventLoop().execute(() -> {
                if (!$this.codec.connection().local().canOpenStream()) {
                    p.setException((Throwable)Failure$.MODULE$.rejected(new StringBuilder(92).append("Unable to open stream because his session has the maximum number of active streams allowed: ").append($this.codec.connection().local().maxActiveStreams()).toString()));
                } else if ($this.codec.connection().goAwayReceived()) {
                    p.setException((Throwable)Failure$.MODULE$.rejected("Unable to open stream because the session is draining."));
                } else {
                    $this.bootstrap.open().addListener((GenericFutureListener)new GenericFutureListener<Future<Http2StreamChannel>>(this, p){
                        private final /* synthetic */ ClientSessionImpl $outer;
                        private final Promise p$1;

                        public void operationComplete(Future<Http2StreamChannel> future) {
                            if (!future.isSuccess()) {
                                this.p$1.setException((Throwable)Failure$.MODULE$.rejected(future.cause()));
                            } else {
                                Http2StreamChannel channel = (Http2StreamChannel)future.get();
                                ChildTransport trans = this.$outer.new ChildTransport((Channel)channel);
                                this.p$1.setValue((Object)((Object)trans));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.p$1 = p$1;
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                p.setException((Throwable)Failure$.MODULE$.rejected(t));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return var2_1;
    }

    public ClientSessionImpl(Stack.Params params, ChannelInitializer<Channel> initializer, Channel channel, Function0<Status> failureDetectorStatus) {
        this.channel = channel;
        this.failureDetectorStatus = failureDetectorStatus;
        Closable.$init$((Closable)this);
        Http2FrameCodec codec = (Http2FrameCodec)channel.pipeline().get(Http2FrameCodec.class);
        if (codec == null) {
            throw new IllegalStateException(new StringBuilder(43).append("Parent Channel doesn't have an instance of ").append(Http2FrameCodec.class.getSimpleName()).toString());
        }
        this.codec = codec;
        long maxConcurrentStreams = BoxesRunTime.unboxToLong((Object)((MaxConcurrentStreams)params.apply(MaxConcurrentStreams$.MODULE$.param())).maxConcurrentStreams().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ClientSessionImpl$.MODULE$.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$DefaultMaxConcurrentStreams()));
        long streamHighWaterMark = BoxesRunTime.unboxToLong((Object)((MaxRequestsPerSession)params.apply(MaxRequestsPerSession$.MODULE$.param())).maxRequestsPerSession().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)r -> r * 2L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ClientSessionImpl$.MODULE$.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$DefaultStreamHighWaterMark()));
        this.streamHighWaterMark = streamHighWaterMark - 2L * maxConcurrentStreams;
        boolean streamAutoRead = !((Netty4Transporter.Backpressure)params.apply(Netty4Transporter.Backpressure$.MODULE$.param())).backpressure();
        this.bootstrap = new Http2StreamChannelBootstrap(channel).option(ChannelOption.ALLOCATOR, (Object)((Allocator)params.apply(Allocator$.MODULE$.allocatorParam())).allocator()).option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(streamAutoRead)).handler(initializer);
        this.closeInitiated = false;
        this.com$twitter$finagle$http2$transport$client$ClientSessionImpl$$closeP = Promise$.MODULE$.apply();
    }

    public final class ChildTransport
    extends StreamChannelTransport {
        public Status status() {
            return Status$.MODULE$.worst(ClientSessionImpl.this.status(), super.status());
        }

        public ChildTransport(Channel ch) {
            if (ClientSessionImpl.this == null) {
                throw null;
            }
            super(ch);
        }
    }
}

