/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.exp.routing;

import com.twitter.finagle.http.exp.routing.ParameterValue;
import com.twitter.finagle.http.exp.routing.PathMatcher;
import com.twitter.finagle.http.exp.routing.PathMatcher$NoBoundary$;
import com.twitter.finagle.http.exp.routing.PathMatcher$UnableToParse$;
import com.twitter.finagle.http.exp.routing.Segment;
import com.twitter.finagle.http.exp.routing.Segment$Slash$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public final class PathMatcher$ {
    public static final PathMatcher$ MODULE$;

    static {
        new PathMatcher$();
    }

    public void requireNonNegativeIdx(int idx) {
        Predef$.MODULE$.require(idx >= 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "idx cannot be negative";
            }
        });
    }

    public int indexAfterRegionMatch(String str, int idx, String find) {
        this.requireNonNegativeIdx(idx);
        int len = find.length();
        boolean matches = str.regionMatches(false, idx, find, 0, len);
        return matches ? idx + len : -1;
    }

    public int indexAfterMatchingSlash(String str, int idx) {
        int checkForSlash;
        this.requireNonNegativeIdx(idx);
        int len = str.length();
        for (checkForSlash = idx; checkForSlash < len && str.charAt(checkForSlash) == '/'; ++checkForSlash) {
        }
        return checkForSlash == idx ? -1 : checkForSlash;
    }

    public PathMatcher.ParameterParseResult parameterized(String str, int idx, Segment.Parameterized param, Segment segmentAfterParam) {
        PathMatcher.SegmentBoundaryResult segmentBoundaryResult;
        block7: {
            PathMatcher$UnableToParse$ pathMatcher$UnableToParse$;
            block6: {
                block5: {
                    PathMatcher.ParameterParseResult parameterParseResult;
                    this.requireNonNegativeIdx(idx);
                    segmentBoundaryResult = this.segmentBoundary(str, idx, segmentAfterParam);
                    if (!(segmentBoundaryResult instanceof PathMatcher.Boundary)) break block5;
                    PathMatcher.Boundary boundary = (PathMatcher.Boundary)segmentBoundaryResult;
                    int paramEnd = boundary.startIdx();
                    int nextSegmentEnd = boundary.nextIdx();
                    Option<ParameterValue> option = param.parse(str.substring(idx, paramEnd));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ParameterValue paramValue = (ParameterValue)some.x();
                        parameterParseResult = new PathMatcher.ParsedValue(nextSegmentEnd, paramValue);
                    } else {
                        parameterParseResult = PathMatcher$UnableToParse$.MODULE$;
                    }
                    pathMatcher$UnableToParse$ = parameterParseResult;
                    break block6;
                }
                if (!PathMatcher$NoBoundary$.MODULE$.equals(segmentBoundaryResult)) break block7;
                pathMatcher$UnableToParse$ = PathMatcher$UnableToParse$.MODULE$;
            }
            return pathMatcher$UnableToParse$;
        }
        throw new MatchError((Object)segmentBoundaryResult);
    }

    public Option<ParameterValue> parameterizedEnd(String str, int idx, Segment.Parameterized param) {
        this.requireNonNegativeIdx(idx);
        return str.length() <= idx ? None$.MODULE$ : (str.indexOf(47, idx) >= 0 ? None$.MODULE$ : param.parse(str.substring(idx)));
    }

    public boolean verifyRequiredParams(Set<String> requiredParamNames, Map<String, ParameterValue> extracted) {
        return requiredParamNames.forall((Function1)new Serializable(extracted){
            public static final long serialVersionUID = 0L;
            private final Map extracted$1;

            public final boolean apply(String key) {
                return this.extracted$1.contains((Object)key);
            }
            {
                this.extracted$1 = extracted$1;
            }
        });
    }

    private int nextConstantIdx(String str, int idx, String find) {
        this.requireNonNegativeIdx(idx);
        return idx >= str.length() ? -1 : str.indexOf(find, idx);
    }

    public PathMatcher.SegmentBoundaryResult segmentBoundary(String str, int idx, Segment segment) {
        Segment segment2;
        block6: {
            PathMatcher.SegmentBoundaryResult segmentBoundaryResult;
            block5: {
                block4: {
                    this.requireNonNegativeIdx(idx);
                    segment2 = segment;
                    if (!Segment$Slash$.MODULE$.equals(segment2)) break block4;
                    int slashIdx = str.indexOf(47, idx);
                    segmentBoundaryResult = slashIdx >= 0 ? new PathMatcher.Boundary(slashIdx, this.indexAfterMatchingSlash(str, slashIdx)) : PathMatcher$NoBoundary$.MODULE$;
                    break block5;
                }
                if (!(segment2 instanceof Segment.Constant)) break block6;
                Segment.Constant constant = (Segment.Constant)segment2;
                String path = constant.value();
                int constIdx = this.nextConstantIdx(str, idx, path);
                segmentBoundaryResult = constIdx >= 0 ? new PathMatcher.Boundary(constIdx, constIdx + path.length()) : PathMatcher$NoBoundary$.MODULE$;
            }
            return segmentBoundaryResult;
        }
        if (segment2 instanceof Segment.Parameterized) {
            throw new IllegalArgumentException("A Parameterized segment does not have a defined boundary");
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected segment type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{segment2})));
    }

    private PathMatcher$() {
        MODULE$ = this;
    }
}

