/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.Deadline;
import com.twitter.finagle.context.Deadline$;
import com.twitter.finagle.context.Retries;
import com.twitter.finagle.context.Retries$;
import com.twitter.finagle.http.Message;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.NonFatal$;
import com.twitter.util.Time$;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HttpContext$ {
    public static final HttpContext$ MODULE$;
    private final String Prefix;
    private final String DeadlineHeaderKey;
    private final String RetriesHeaderKey;
    private final Logger com$twitter$finagle$http$codec$HttpContext$$log;
    private final Function1<String, Option<Deadline>> unmarshalDeadline;
    private final Function1<String, Option<Retries>> unmarshalRetries;

    static {
        new HttpContext$();
    }

    public Logger com$twitter$finagle$http$codec$HttpContext$$log() {
        return this.com$twitter$finagle$http$codec$HttpContext$$log;
    }

    public void removeDeadline(Message msg) {
        msg.headerMap().remove((Object)this.DeadlineHeaderKey);
    }

    private String marshalDeadline(Deadline deadline) {
        return new StringBuilder().append(deadline.timestamp().inNanoseconds()).append((Object)" ").append((Object)BoxesRunTime.boxToLong((long)deadline.deadline().inNanoseconds())).toString();
    }

    private String marshalRetries(Retries retries) {
        return ((Object)BoxesRunTime.boxToInteger((int)retries.retries())).toString();
    }

    public <R> R read(Message msg, Function0<R> fn) {
        Option option;
        block4: {
            Option option2;
            block7: {
                Context.Env env;
                block6: {
                    block5: {
                        block3: {
                            block2: {
                                env = Contexts$.MODULE$.broadcast().env();
                                option = msg.headerMap().get((Object)this.DeadlineHeaderKey).flatMap(this.unmarshalDeadline);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Deadline deadline = (Deadline)some.x();
                                env = env.bound((Object)Deadline$.MODULE$, (Object)deadline);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        option2 = msg.headerMap().get((Object)this.RetriesHeaderKey).flatMap(this.unmarshalRetries);
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        Retries retries = (Retries)some.x();
                        env = env.bound((Object)Retries$.MODULE$, (Object)retries);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return (R)Contexts$.MODULE$.broadcast().let(env, fn);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public void write(Message msg) {
        Option option;
        block4: {
            Option option2;
            block7: {
                block6: {
                    block5: {
                        block3: {
                            BoxedUnit boxedUnit;
                            block2: {
                                option = Deadline$.MODULE$.current();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Deadline deadline = (Deadline)some.x();
                                boxedUnit = msg.headerMap().set(this.DeadlineHeaderKey, this.marshalDeadline(deadline));
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        option2 = Retries$.MODULE$.current();
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        Retries retries = (Retries)some.x();
                        msg.headerMap().set(this.RetriesHeaderKey, this.marshalRetries(retries));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private HttpContext$() {
        MODULE$ = this;
        this.Prefix = "Finagle-Ctx-";
        this.DeadlineHeaderKey = new StringBuilder().append((Object)this.Prefix).append((Object)Deadline$.MODULE$.id()).toString();
        this.RetriesHeaderKey = new StringBuilder().append((Object)this.Prefix).append((Object)Retries$.MODULE$.id()).toString();
        this.com$twitter$finagle$http$codec$HttpContext$$log = Logger$.MODULE$.apply(this.getClass().getName());
        this.unmarshalDeadline = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Deadline> apply(String header) {
                None$ none$;
                try {
                    String[] values = new StringOps(Predef$.MODULE$.augmentString(header)).split(' ');
                    long timestamp = new StringOps(Predef$.MODULE$.augmentString(values[0])).toLong();
                    long deadline = new StringOps(Predef$.MODULE$.augmentString(values[1])).toLong();
                    none$ = new Some((Object)new Deadline(Time$.MODULE$.fromNanoseconds(timestamp), Time$.MODULE$.fromNanoseconds(deadline)));
                }
                catch (Throwable throwable) {
                    None$ none$2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    if (HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unmarshal Deadline from header value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    none$ = none$2 = None$.MODULE$;
                }
                return none$;
            }
        };
        this.unmarshalRetries = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Retries> apply(String header) {
                Some some;
                try {
                    some = new Some((Object)new Retries(new StringOps(Predef$.MODULE$.augmentString(header)).toInt()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    if (HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        HttpContext$.MODULE$.com$twitter$finagle$http$codec$HttpContext$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unmarshal Retries from header value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    None$ none$ = None$.MODULE$;
                    some = none$;
                }
                return some;
            }
        };
    }
}

