/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.http.Fields$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Method$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class ResponseConformanceFilter$
extends SimpleFilter<Request, Response> {
    public static final ResponseConformanceFilter$ MODULE$;
    private final Logger logger;

    static {
        new ResponseConformanceFilter$();
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        return service.apply((Object)request).map((Function1)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final Request request$1;

            public final Response apply(Response rep) {
                ResponseConformanceFilter$.MODULE$.com$twitter$finagle$http$codec$ResponseConformanceFilter$$validate(this.request$1, rep);
                return rep;
            }
            {
                this.request$1 = request$1;
            }
        });
    }

    public void com$twitter$finagle$http$codec$ResponseConformanceFilter$$validate(Request req, Response rep) {
        Method method = req.method();
        Method method2 = Method$.MODULE$.Head();
        if (!(method != null ? !method.equals(method2) : method2 != null)) {
            this.handleHeadResponse(req, rep);
        } else if (rep.isChunked()) {
            this.handleChunkedResponse(rep);
        } else {
            this.handleFullyBufferedResponse(rep);
        }
    }

    private void handleFullyBufferedResponse(Response rep) {
        if (rep.contentLength().isEmpty()) {
            rep.contentLength_$eq((long)rep.content().length());
        }
    }

    private void handleChunkedResponse(Response rep) {
        rep.headerMap().set(Fields$.MODULE$.TransferEncoding(), "chunked");
        rep.headerMap().remove((Object)Fields$.MODULE$.ContentLength());
    }

    private void handleHeadResponse(Request request, Response response) {
        response.headerMap().remove((Object)Fields$.MODULE$.TransferEncoding());
        if (response.isChunked()) {
            response.headerMap().remove((Object)Fields$.MODULE$.ContentLength());
            response.reader().discard();
            response.setChunked(false);
        }
        if (!response.content().isEmpty()) {
            this.logger.error("Received response to HEAD request (%s) that contained a static body of length %d. Discarding body. If this is desired behavior, consider adding HeadFilter to your service", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.toString(), BoxesRunTime.boxToInteger((int)response.content().length())}));
            if (response.contentLength().isEmpty()) {
                response.contentLength_$eq((long)response.content().length());
            }
            response.clearContent();
        }
    }

    private ResponseConformanceFilter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.get(((Object)((Object)this)).getClass().getName());
    }
}

