/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.http.Fields$;
import com.twitter.finagle.http.Message;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114Q!\u0001\u0002\u0001\r1\u0011\u0011cQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0003d_\u0012,7M\u0003\u0002\u0006\r\u0005!\u0001\u000e\u001e;q\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\rC\u0003\u0015\u0001\u0011\u0005a#\u0001\u0004=S:LGOP\u0002\u0001)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001B\u0002\u000e\u0001A\u0003&1$A\u0006jg.+W\r]!mSZ,\u0007C\u0001\b\u001d\u0013\tirBA\u0004C_>dW-\u00198\t\r}\u0001\u0001\u0015)\u0003\u001c\u0003\u0019I7/\u00133mK\"1\u0011\u0005\u0001Q!\n\t\nQ\"Y2uSZ,7\u000b\u001e:fC6\u001c\bC\u0001\b$\u0013\t!sBA\u0002J]RDaA\n\u0001!B\u0013\u0011\u0013\u0001\u00059f]\u0012Lgn\u001a*fgB|gn]3t\u0011\u0019A\u0003\u0001)A\u0005S\u000511\r\\8tKB\u00032AK\u00170\u001b\u0005Y#B\u0001\u0017\t\u0003\u0011)H/\u001b7\n\u00059Z#a\u0002)s_6L7/\u001a\t\u0003\u001dAJ!!M\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006g\u0001!\t\u0001N\u0001\u000f_\n\u001cXM\u001d<f\u001b\u0016\u001c8/Y4f)\rySg\u000f\u0005\u0006mI\u0002\raN\u0001\b[\u0016\u001c8/Y4f!\tA\u0014(D\u0001\u0005\u0013\tQDAA\u0004NKN\u001c\u0018mZ3\t\u000bq\u0012\u0004\u0019A\u001f\u0002\u0011=tg)\u001b8jg\"\u00042A\u000b 0\u0013\ty4F\u0001\u0004GkR,(/\u001a\u0005\u0006\u0003\u0002!\tAQ\u0001\u000f_\n\u001cXM\u001d<f%\u0016\fX/Z:u)\ry3\t\u0013\u0005\u0006\t\u0002\u0003\r!R\u0001\be\u0016\fX/Z:u!\tAd)\u0003\u0002H\t\t9!+Z9vKN$\b\"\u0002\u001fA\u0001\u0004i\u0004\"\u0002&\u0001\t\u0003Y\u0015aD8cg\u0016\u0014h/\u001a*fgB|gn]3\u0015\u0007=b\u0015\u000bC\u0003N\u0013\u0002\u0007a*\u0001\u0005sKN\u0004xN\\:f!\tAt*\u0003\u0002Q\t\tA!+Z:q_:\u001cX\rC\u0003=\u0013\u0002\u0007Q\b\u0003\u0004T\u0001\u0001&I\u0001V\u0001\u000fQ\u0006tG\r\\3JMN#(/Z1n)\tyS\u000bC\u0003=%\u0002\u0007Q\b\u0003\u0004X\u0001\u0001&I\u0001W\u0001\nK:$7\u000b\u001e:fC6$\u0012a\f\u0005\u00065\u0002!\taW\u0001\fg\"|W\u000f\u001c3DY>\u001cX\rF\u0001\u001c\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u001dygn\u00117pg\u0016,\u0012!\u0010\u0005\u0007A\u0002\u0001K\u0011B1\u0002#5,8\u000f^\"m_N,wJ\u001c$j]&\u001c\b\u000e\u0006\u0002\u001cE\")1m\u0018a\u0001\u001d\u0006!!/Z:q\u0011\u0019)\u0007\u0001)C\u0005M\u0006qQ.Y=ICZ,7i\u001c8uK:$HCA\u000eh\u0011\u0015AG\r1\u0001j\u0003\u0019\u0019H/\u0019;vgB\u0011\u0001H[\u0005\u0003W\u0012\u0011aa\u0015;biV\u001c\b")
public class ConnectionManager {
    private boolean isKeepAlive = true;
    private boolean isIdle = true;
    private int activeStreams = 0;
    private int pendingResponses = 0;
    public final Promise<BoxedUnit> com$twitter$finagle$http$codec$ConnectionManager$$closeP = new Promise();

    public synchronized void observeMessage(Message message, Future<BoxedUnit> onFinish) {
        Message message2 = message;
        if (message2 instanceof Request) {
            Request request = (Request)message2;
            this.observeRequest(request, onFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message2 instanceof Response) {
            Response response = (Response)message2;
            this.observeResponse(response, onFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.isKeepAlive = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public synchronized void observeRequest(Request request, Future<BoxedUnit> onFinish) {
        ++this.pendingResponses;
        this.isIdle = false;
        this.isKeepAlive = request.keepAlive();
        this.handleIfStream(onFinish);
    }

    public synchronized void observeResponse(Response response, Future<BoxedUnit> onFinish) {
        --this.pendingResponses;
        if (!this.isKeepAlive || this.mustCloseOnFinish(response) || !response.keepAlive()) {
            response.headerMap().set(Fields$.MODULE$.Connection(), "close");
            this.isKeepAlive = false;
        }
        this.isIdle = !response.isChunked();
        this.handleIfStream(onFinish);
    }

    private void handleIfStream(Future<BoxedUnit> onFinish) {
        if (onFinish.isDefined()) {
            if (this.shouldClose()) {
                this.com$twitter$finagle$http$codec$ConnectionManager$$closeP.setDone(Predef$.MODULE$.$conforms());
            }
        } else {
            ++this.activeStreams;
            onFinish.ensure((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConnectionManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.com$twitter$finagle$http$codec$ConnectionManager$$endStream();
                    if (this.$outer.shouldClose()) {
                        this.$outer.com$twitter$finagle$http$codec$ConnectionManager$$closeP.setDone(Predef$.MODULE$.$conforms());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public synchronized void com$twitter$finagle$http$codec$ConnectionManager$$endStream() {
        --this.activeStreams;
        this.isIdle = this.activeStreams == 0 && this.pendingResponses == 0;
    }

    public synchronized boolean shouldClose() {
        return this.isIdle && !this.isKeepAlive;
    }

    public Future<BoxedUnit> onClose() {
        return this.com$twitter$finagle$http$codec$ConnectionManager$$closeP;
    }

    private boolean mustCloseOnFinish(Response resp) {
        return this.mayHaveContent(resp.status()) && !resp.isChunked() && resp.contentLength().isEmpty();
    }

    private boolean mayHaveContent(Status status) {
        boolean bl;
        Status status2 = status;
        Option option = Status.Informational$.MODULE$.unapply(status2);
        if (option.isEmpty()) {
            Status status3 = Status$.MODULE$.NoContent();
            Status status4 = status2;
            if (!(status3 != null ? !status3.equals(status4) : status4 != null)) {
                bl = false;
            } else {
                Status status5 = Status$.MODULE$.NotModified();
                Status status6 = status2;
                bl = status5 != null ? !status5.equals(status6) : status6 != null;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

