/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Failure$;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.ClientNackFilter;
import com.twitter.finagle.http.filter.HttpNackFilter$;
import com.twitter.io.Buf;
import com.twitter.io.Reader;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class ClientNackFilter$ {
    public static ClientNackFilter$ MODULE$;
    private final Logger log;
    private final Function1<Try<BoxedUnit>, Future<Response>> respondRetryableFailure;
    private final Function1<Try<BoxedUnit>, Future<Response>> respondNonRetryableFailure;
    private final Function1<Response, Future<Response>> com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn;
    private final Stackable<ServiceFactory<Request, Response>> module;

    static {
        new ClientNackFilter$();
    }

    public Function1<Response, Future<Response>> com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn() {
        return this.com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return this.module;
    }

    private Future<BoxedUnit> swallowNackResponse(Response response) {
        return !response.isChunked() ? Future$.MODULE$.Done() : this.swallowNackBody(response.reader(), 1024).onFailure((Function1 & Serializable & scala.Serializable)x$3 -> {
            ClientNackFilter$.$anonfun$swallowNackResponse$1(response, x$3);
            return BoxedUnit.UNIT;
        });
    }

    private Future<BoxedUnit> swallowNackBody(Reader reader, int maxRead) {
        return reader.read(maxRead + 1).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            boolean bl = false;
            Some some = null;
            Option option = x0$2;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Buf chunk = (Buf)some.value();
                if (chunk.length() <= maxRead) {
                    return MODULE$.swallowNackBody(reader, maxRead - chunk.length());
                }
            }
            if (bl) {
                ClientNackFilter$.MODULE$.log.warning("Received an excessively large nack response body.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                reader.discard();
                return Future$.MODULE$.Done();
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            return Future$.MODULE$.Done();
        });
    }

    public static final /* synthetic */ void $anonfun$swallowNackResponse$1(Response response$1, Throwable x$3) {
        response$1.reader().discard();
    }

    private ClientNackFilter$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(this.getClass().getName());
        this.respondRetryableFailure = (Function1 & Serializable & scala.Serializable)x$1 -> Future$.MODULE$.exception((Throwable)Failure$.MODULE$.RetryableNackFailure());
        this.respondNonRetryableFailure = (Function1 & Serializable & scala.Serializable)x$2 -> Future$.MODULE$.exception((Throwable)Failure$.MODULE$.NonRetryableNackFailure());
        this.com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Response response = x0$1;
            Future future = HttpNackFilter$.MODULE$.isRetryableNack(response) ? MODULE$.swallowNackResponse(response).transform(ClientNackFilter$.MODULE$.respondRetryableFailure) : (HttpNackFilter$.MODULE$.isNonRetryableNack(response) ? MODULE$.swallowNackResponse(response).transform(ClientNackFilter$.MODULE$.respondNonRetryableFailure) : Future$.MODULE$.value((Object)response));
            return future;
        };
        this.module = new Stack.Module0<ServiceFactory<Request, Response>>(){
            private final ClientNackFilter nackFilter;
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ServiceFactory<Request, Response> next) {
                return this.nackFilter.andThen(next);
            }
            {
                this.nackFilter = new ClientNackFilter();
                this.role = new Stack.Role("ClientNackFilter");
                this.description = "Convert HTTP nack responses to Failures";
            }
        };
    }
}

