/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.filter.StatsFilter$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Memoize$;
import com.twitter.util.Return;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015r!B\u0001\u0003\u0011\u0003i\u0011aC*uCR\u001ch)\u001b7uKJT!a\u0001\u0003\u0002\r\u0019LG\u000e^3s\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003\u001d1\u0017N\\1hY\u0016T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011CA\u0006Ti\u0006$8OR5mi\u0016\u00148CA\b\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011d\u0004C\u00015\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\b9=\u0011\r\u0011\"\u0001\u001e\u0003\u0011\u0011x\u000e\\3\u0016\u0003y\u0001\"aH\u0012\u000f\u0005\u0001\nS\"\u0001\u0004\n\u0005\t2\u0011!B*uC\u000e\\\u0017B\u0001\u0013&\u0005\u0011\u0011v\u000e\\3\u000b\u0005\t2\u0001BB\u0014\u0010A\u0003%a$A\u0003s_2,\u0007\u0005C\u0004*\u001f\t\u0007I\u0011\u0001\u0016\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u000b\u0002WA\u0011Af\r\b\u0003[E\u0002\"A\f\u000b\u000e\u0003=R!\u0001\r\u0007\u0002\rq\u0012xn\u001c;?\u0013\t\u0011D#\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\u0015\u0011\u00199t\u0002)A\u0005W\u0005aA-Z:de&\u0004H/[8oA!)\u0011h\u0004C\u0001u\u00051Qn\u001c3vY\u0016,\u0012a\u000f\t\u0004Aqr\u0014BA\u001f\u0007\u0005%\u0019F/Y2lC\ndW\r\u0005\u0003!\u007f\u0005+\u0015B\u0001!\u0007\u00059\u0019VM\u001d<jG\u00164\u0015m\u0019;pef\u0004\"AQ\"\u000e\u0003\u0011I!\u0001\u0012\u0003\u0003\u000fI+\u0017/^3tiB\u0011!IR\u0005\u0003\u000f\u0012\u0011\u0001BU3ta>t7/\u001a\u0004\u0005!\t\u0001\u0011*\u0006\u0002K!N\u0011\u0001j\u0013\t\u0005A1sU)\u0003\u0002N\r\ta1+[7qY\u00164\u0015\u000e\u001c;feB\u0011q\n\u0015\u0007\u0001\t\u0015\t\u0006J1\u0001S\u0005\u001d\u0011V)U+F'R\u000b\"aU!\u0011\u0005M!\u0016BA+\u0015\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001b\u0016%\u0003\u0002\u0003\u0006I\u0001W\u0001\u0006gR\fGo\u001d\t\u00033nk\u0011A\u0017\u0006\u0003/\u001aI!\u0001\u0018.\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s\u0011\u0015I\u0002\n\"\u0001_)\ty\u0006\rE\u0002\u000f\u0011:CQaV/A\u0002aCaA\u0019%!\u0002\u0013A\u0016AD:uCR,8OU3dK&4XM\u001d\u0005\u0007I\"\u0003\u000b\u0011\u0002-\u0002\u0019QLW.\u001a*fG\u0016Lg/\u001a:\t\r\u0019D\u0005\u0015!\u0003h\u0003A\u0011Xm\u001d9p]N,7+\u001b>f'R\fG\u000f\u0005\u0002ZQ&\u0011\u0011N\u0017\u0002\u0005'R\fG\u000f\u0003\u0004l\u0011\u0002\u0006I\u0001\\\u0001\rG>,h\u000e^3s\u0007\u0006\u001c\u0007.\u001a\t\u0005'5\\s.\u0003\u0002o)\tIa)\u001e8di&|g.\r\t\u00033BL!!\u001d.\u0003\u000f\r{WO\u001c;fe\"11\u000f\u0013Q\u0001\nQ\f\u0011b\u001d;bi\u000e\u000b7\r[3\u0011\tMi7f\u001a\u0005\u0006m\"#\ta^\u0001\u0006CB\u0004H.\u001f\u000b\u0005qz\f\t\u0001E\u0002zy\u0016k\u0011A\u001f\u0006\u0003w\"\tA!\u001e;jY&\u0011QP\u001f\u0002\u0007\rV$XO]3\t\u000b},\b\u0019\u0001(\u0002\u000fI,\u0017/^3ti\"9\u00111A;A\u0002\u0005\u0015\u0011aB:feZL7-\u001a\t\u0006A\u0005\u001da*R\u0005\u0004\u0003\u00131!aB*feZL7-\u001a\u0005\b\u0003\u001bAE\u0011CA\b\u0003\u0015\u0019w.\u001e8u)\u0019\t\t\"a\u0006\u0002\"A\u00191#a\u0005\n\u0007\u0005UAC\u0001\u0003V]&$\b\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0011\u0011,(/\u0019;j_:\u00042!_A\u000f\u0013\r\tyB\u001f\u0002\t\tV\u0014\u0018\r^5p]\"9\u00111EA\u0006\u0001\u0004)\u0015\u0001\u0003:fgB|gn]3")
public class StatsFilter<REQUEST extends Request>
extends SimpleFilter<REQUEST, Response> {
    private final StatsReceiver statusReceiver;
    private final StatsReceiver timeReceiver;
    private final Stat responseSizeStat;
    private final Function1<String, Counter> counterCache;
    private final Function1<String, Stat> statCache;

    public static Stackable<ServiceFactory<Request, Response>> module() {
        return StatsFilter$.MODULE$.module();
    }

    public static String description() {
        return StatsFilter$.MODULE$.description();
    }

    public static Stack.Role role() {
        return StatsFilter$.MODULE$.role();
    }

    public Future<Response> apply(REQUEST request, Service<REQUEST, Response> service) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        Future future = service.apply(request);
        future.respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StatsFilter.$anonfun$apply$1(this, request, elapsed, x0$1);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public void count(Duration duration, Response response) {
        String statusCode = ((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString();
        String statusClass = new StringBuilder(2).append(((Object)BoxesRunTime.boxToInteger((int)(response.statusCode() / 100))).toString()).append("XX").toString();
        ((Counter)this.counterCache.apply((Object)statusCode)).incr();
        ((Counter)this.counterCache.apply((Object)statusClass)).incr();
        ((Stat)this.statCache.apply((Object)statusCode)).add((float)duration.inMilliseconds());
        ((Stat)this.statCache.apply((Object)statusClass)).add((float)duration.inMilliseconds());
        this.responseSizeStat.add((float)response.length());
    }

    public static final /* synthetic */ void $anonfun$apply$1(StatsFilter $this, Request request$1, Function0 elapsed$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Return) {
            Return return_ = (Return)try_;
            Response response = (Response)return_.r();
            $this.count((Duration)elapsed$1.apply(), response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Response response = Response$.MODULE$.apply(request$1.version(), Status$.MODULE$.InternalServerError());
            $this.count((Duration)elapsed$1.apply(), response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public StatsFilter(StatsReceiver stats) {
        this.statusReceiver = stats.scope("status");
        this.timeReceiver = stats.scope("time");
        this.responseSizeStat = stats.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response_size"}));
        this.counterCache = Memoize$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> $this.statusReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1})));
        this.statCache = Memoize$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> $this.timeReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$2})));
    }
}

