/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.filter.StatsFilter$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Memoize$;
import com.twitter.util.Return;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015r!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007i\u0005\u0001\u000b\u0011\u0002\u0017\t\u000fU\n!\u0019!C\u0001m!1!)\u0001Q\u0001\n]BQaQ\u0001\u0005\u0002\u00113A\u0001I\n\u0001%\"Aq\f\u0003B\u0001B\u0003%\u0001\rC\u0003)\u0011\u0011\u0005Q\r\u0003\u0004i\u0011\u0001\u0006I\u0001\u0019\u0005\u0007S\"\u0001\u000b\u0011\u00021\t\r)D\u0001\u0015!\u0003l\u0011\u0019q\u0007\u0002)A\u0005_\"1Q\u000f\u0003Q\u0001\nYDQa\u001e\u0005\u0005\u0002aDq!!\u0004\t\t#\ty!A\u0006Ti\u0006$8OR5mi\u0016\u0014(B\u0001\u000b\u0016\u0003\u00191\u0017\u000e\u001c;fe*\u0011acF\u0001\u0005QR$\bO\u0003\u0002\u00193\u00059a-\u001b8bO2,'B\u0001\u000e\u001c\u0003\u001d!x/\u001b;uKJT\u0011\u0001H\u0001\u0004G>l7\u0001\u0001\t\u0003?\u0005i\u0011a\u0005\u0002\f'R\fGo\u001d$jYR,'o\u0005\u0002\u0002EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0010\u0002\tI|G.Z\u000b\u0002YA\u0011Q&\r\b\u0003]=j\u0011aF\u0005\u0003a]\tQa\u0015;bG.L!AM\u001a\u0003\tI{G.\u001a\u0006\u0003a]\tQA]8mK\u0002\n1\u0002Z3tGJL\u0007\u000f^5p]V\tq\u0007\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003u\u0011j\u0011a\u000f\u0006\u0003yu\ta\u0001\u0010:p_Rt\u0014B\u0001 %\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\"\u0013\u0001\u00043fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0013AB7pIVdW-F\u0001F!\rqc\tS\u0005\u0003\u000f^\u0011\u0011b\u0015;bG.\f'\r\\3\u0011\t9J5jT\u0005\u0003\u0015^\u0011abU3sm&\u001cWMR1di>\u0014\u0018\u0010\u0005\u0002M\u001b6\tQ#\u0003\u0002O+\t9!+Z9vKN$\bC\u0001'Q\u0013\t\tVC\u0001\u0005SKN\u0004xN\\:f+\t\u0019\u0016l\u0005\u0002\t)B!a&V,P\u0013\t1vC\u0001\u0007TS6\u0004H.\u001a$jYR,'\u000f\u0005\u0002Y32\u0001A!\u0002.\t\u0005\u0004Y&a\u0002*F#V+5\u000bV\t\u00039.\u0003\"aI/\n\u0005y##a\u0002(pi\"LgnZ\u0001\u0006gR\fGo\u001d\t\u0003C\u000el\u0011A\u0019\u0006\u0003?^I!\u0001\u001a2\u0003\u001bM#\u0018\r^:SK\u000e,\u0017N^3s)\t1w\rE\u0002 \u0011]CQa\u0018\u0006A\u0002\u0001\fab\u001d;biV\u001c(+Z2fSZ,'/\u0001\u0007uS6,'+Z2fSZ,'/\u0001\tsKN\u0004xN\\:f'&TXm\u0015;biB\u0011\u0011\r\\\u0005\u0003[\n\u0014Aa\u0015;bi\u0006a1m\\;oi\u0016\u00148)Y2iKB!1\u0005]\u001cs\u0013\t\tHEA\u0005Gk:\u001cG/[8ocA\u0011\u0011m]\u0005\u0003i\n\u0014qaQ8v]R,'/A\u0005ti\u0006$8)Y2iKB!1\u0005]\u001cl\u0003\u0015\t\u0007\u000f\u001d7z)\u0011Ix0a\u0001\u0011\u0007ilx*D\u0001|\u0015\ta\u0018$\u0001\u0003vi&d\u0017B\u0001@|\u0005\u00191U\u000f^;sK\"1\u0011\u0011\u0001\tA\u0002]\u000bqA]3rk\u0016\u001cH\u000fC\u0004\u0002\u0006A\u0001\r!a\u0002\u0002\u000fM,'O^5dKB)a&!\u0003X\u001f&\u0019\u00111B\f\u0003\u000fM+'O^5dK\u0006)1m\\;oiR1\u0011\u0011CA\f\u0003C\u00012aIA\n\u0013\r\t)\u0002\n\u0002\u0005+:LG\u000fC\u0004\u0002\u001aE\u0001\r!a\u0007\u0002\u0011\u0011,(/\u0019;j_:\u00042A_A\u000f\u0013\r\tyb\u001f\u0002\t\tV\u0014\u0018\r^5p]\"1\u00111E\tA\u0002=\u000b\u0001B]3ta>t7/\u001a")
public class StatsFilter<REQUEST extends Request>
extends SimpleFilter<REQUEST, Response> {
    private final StatsReceiver statusReceiver;
    private final StatsReceiver timeReceiver;
    private final Stat responseSizeStat;
    private final Function1<String, Counter> counterCache;
    private final Function1<String, Stat> statCache;

    public static Stackable<ServiceFactory<Request, Response>> module() {
        return StatsFilter$.MODULE$.module();
    }

    public static String description() {
        return StatsFilter$.MODULE$.description();
    }

    public static Stack.Role role() {
        return StatsFilter$.MODULE$.role();
    }

    public Future<Response> apply(REQUEST request, Service<REQUEST, Response> service) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        Future future = service.apply(request);
        future.respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StatsFilter.$anonfun$apply$1(this, elapsed, request, x0$1);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public void count(Duration duration, Response response) {
        String statusCode = ((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString();
        String statusClass = new StringBuilder(2).append(((Object)BoxesRunTime.boxToInteger((int)(response.statusCode() / 100))).toString()).append("XX").toString();
        ((Counter)this.counterCache.apply((Object)statusCode)).incr();
        ((Counter)this.counterCache.apply((Object)statusClass)).incr();
        ((Stat)this.statCache.apply((Object)statusCode)).add((float)duration.inMilliseconds());
        ((Stat)this.statCache.apply((Object)statusClass)).add((float)duration.inMilliseconds());
        this.responseSizeStat.add((float)response.length());
    }

    public static final /* synthetic */ void $anonfun$apply$1(StatsFilter $this, Function0 elapsed$1, Request request$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Return) {
            Return return_ = (Return)try_;
            Response response = (Response)return_.r();
            $this.count((Duration)elapsed$1.apply(), response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Response response = Response$.MODULE$.apply(request$1.version(), Status$.MODULE$.InternalServerError());
            $this.count((Duration)elapsed$1.apply(), response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public StatsFilter(StatsReceiver stats) {
        this.statusReceiver = stats.scope("status");
        this.timeReceiver = stats.scope("time");
        this.responseSizeStat = stats.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response_size"}));
        this.counterCache = Memoize$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> $this.statusReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1})));
        this.statCache = Memoize$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> $this.timeReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$2})));
    }
}

