/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Response$;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.filter.StatsFilter$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Memoize$;
import com.twitter.util.Return;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Throw;
import com.twitter.util.TimeLike;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ur!\u0002\f\u0018\u0011\u0003\u0011c!\u0002\u0013\u0018\u0011\u0003)\u0003\"\u0002\u0017\u0002\t\u0003i\u0003b\u0002\u0018\u0002\u0005\u0004%\ta\f\u0005\u0007q\u0005\u0001\u000b\u0011\u0002\u0019\t\u000fe\n!\u0019!C\u0001u!1a)\u0001Q\u0001\nmBQaR\u0001\u0005\u0002!3A\u0001J\f\u0001-\"A1\r\u0003B\u0001B\u0003%A\rC\u0003-\u0011\u0011\u0005\u0011\u000e\u0003\u0004m\u0011\u0001\u0006I\u0001\u001a\u0005\u0007[\"\u0001\u000b\u0011\u00023\t\r9D\u0001\u0015!\u0003p\u0011\u0019\u0011\b\u0002)A\u0005_\"11\u000f\u0003Q\u0001\n=Da\u0001\u001e\u0005!\u0002\u0013)\bBB>\tA\u0003%A\u0010C\u0003~\u0011\u0011\u0005a\u0010C\u0004\u0002\u001a!!\t\"a\u0007\t\u000f\u0005E\u0002\u0002\"\u0003\u00024!9\u0011q\u0007\u0005\u0005\n\u0005e\u0012aC*uCR\u001ch)\u001b7uKJT!\u0001G\r\u0002\r\u0019LG\u000e^3s\u0015\tQ2$\u0001\u0003iiR\u0004(B\u0001\u000f\u001e\u0003\u001d1\u0017N\\1hY\u0016T!AH\u0010\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0001%A\u0002d_6\u001c\u0001\u0001\u0005\u0002$\u00035\tqCA\u0006Ti\u0006$8OR5mi\u0016\u00148CA\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AI\u0001\u0005e>dW-F\u00011!\t\tTG\u0004\u00023g5\t1$\u0003\u000257\u0005)1\u000b^1dW&\u0011ag\u000e\u0002\u0005%>dWM\u0003\u000257\u0005)!o\u001c7fA\u0005YA-Z:de&\u0004H/[8o+\u0005Y\u0004C\u0001\u001fD\u001d\ti\u0014\t\u0005\u0002?Q5\tqH\u0003\u0002AC\u00051AH]8pizJ!A\u0011\u0015\u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005\"\nA\u0002Z3tGJL\u0007\u000f^5p]\u0002\na!\\8ek2,W#A%\u0011\u0007IRE*\u0003\u0002L7\tI1\u000b^1dW\u0006\u0014G.\u001a\t\u0005e5{5+\u0003\u0002O7\tq1+\u001a:wS\u000e,g)Y2u_JL\bC\u0001)R\u001b\u0005I\u0012B\u0001*\u001a\u0005\u001d\u0011V-];fgR\u0004\"\u0001\u0015+\n\u0005UK\"\u0001\u0003*fgB|gn]3\u0016\u0005]k6C\u0001\u0005Y!\u0011\u0011\u0014lW*\n\u0005i[\"\u0001D*j[BdWMR5mi\u0016\u0014\bC\u0001/^\u0019\u0001!QA\u0018\u0005C\u0002}\u0013qAU#R+\u0016\u001bF+\u0005\u0002a\u001fB\u0011q%Y\u0005\u0003E\"\u0012qAT8uQ&tw-A\u0003ti\u0006$8\u000f\u0005\u0002fO6\taM\u0003\u0002d7%\u0011\u0001N\u001a\u0002\u000e'R\fGo\u001d*fG\u0016Lg/\u001a:\u0015\u0005)\\\u0007cA\u0012\t7\")1M\u0003a\u0001I\u0006q1\u000f^1ukN\u0014VmY3jm\u0016\u0014\u0018\u0001\u0004;j[\u0016\u0014VmY3jm\u0016\u0014\u0018\u0001\u0005:fgB|gn]3TSj,7\u000b^1u!\t)\u0007/\u0003\u0002rM\n!1\u000b^1u\u0003]\u0011X-];fgR\u001cFO]3b[\u0012+(/\u0019;j_:l5/\u0001\rsKN\u0004xN\\:f'R\u0014X-Y7EkJ\fG/[8o\u001bN\fAbY8v]R,'oQ1dQ\u0016\u0004Ba\n<<q&\u0011q\u000f\u000b\u0002\n\rVt7\r^5p]F\u0002\"!Z=\n\u0005i4'aB\"pk:$XM]\u0001\ngR\fGoQ1dQ\u0016\u0004Ba\n<<_\u0006)\u0011\r\u001d9msR)q0a\u0003\u0002\u0010A)\u0011\u0011AA\u0004'6\u0011\u00111\u0001\u0006\u0004\u0003\u000bi\u0012\u0001B;uS2LA!!\u0003\u0002\u0004\t1a)\u001e;ve\u0016Da!!\u0004\u0013\u0001\u0004Y\u0016a\u0002:fcV,7\u000f\u001e\u0005\b\u0003#\u0011\u0002\u0019AA\n\u0003\u001d\u0019XM\u001d<jG\u0016\u0004RAMA\u000b7NK1!a\u0006\u001c\u0005\u001d\u0019VM\u001d<jG\u0016\fQaY8v]R$b!!\b\u0002$\u00055\u0002cA\u0014\u0002 %\u0019\u0011\u0011\u0005\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003K\u0019\u0002\u0019AA\u0014\u0003!!WO]1uS>t\u0007\u0003BA\u0001\u0003SIA!a\u000b\u0002\u0004\tAA)\u001e:bi&|g\u000e\u0003\u0004\u00020M\u0001\raU\u0001\te\u0016\u001c\bo\u001c8tK\u0006Q2m\\;oiJ+\u0017/^3tiN#(/Z1n\tV\u0014\u0018\r^5p]R!\u0011QDA\u001b\u0011\u0019\ti\u0001\u0006a\u00017\u0006Y2m\\;oiJ+7\u000f]8og\u0016\u001cFO]3b[\u0012+(/\u0019;j_:$B!!\b\u0002<!1\u0011qF\u000bA\u0002M\u0003")
public class StatsFilter<REQUEST extends Request>
extends SimpleFilter<REQUEST, Response> {
    private final StatsReceiver statusReceiver;
    private final StatsReceiver timeReceiver;
    private final Stat responseSizeStat;
    private final Stat requestStreamDurationMs;
    private final Stat responseStreamDurationMs;
    private final Function1<String, Counter> counterCache;
    private final Function1<String, Stat> statCache;

    public static Stackable<ServiceFactory<Request, Response>> module() {
        return StatsFilter$.MODULE$.module();
    }

    public static String description() {
        return StatsFilter$.MODULE$.description();
    }

    public static Stack.Role role() {
        return StatsFilter$.MODULE$.role();
    }

    public Future<Response> apply(REQUEST request, Service<REQUEST, Response> service) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        if (request.isChunked()) {
            this.countRequestStreamDuration(request);
        }
        Future future = service.apply(request);
        future.respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StatsFilter.$anonfun$apply$1(this, elapsed, request, x0$1);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public void count(Duration duration, Response response) {
        String statusCode = ((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString();
        String statusClass = new StringBuilder(2).append(((Object)BoxesRunTime.boxToInteger((int)(response.statusCode() / 100))).toString()).append("XX").toString();
        ((Counter)this.counterCache.apply((Object)statusCode)).incr();
        ((Counter)this.counterCache.apply((Object)statusClass)).incr();
        ((Stat)this.statCache.apply((Object)statusCode)).add((float)duration.inMilliseconds());
        ((Stat)this.statCache.apply((Object)statusClass)).add((float)duration.inMilliseconds());
        this.responseSizeStat.add((float)response.length());
    }

    private void countRequestStreamDuration(REQUEST request) {
        Function0 streamingRequestElapsed = Stopwatch$.MODULE$.start();
        request.reader().onClose().respond((Function1 & Serializable & scala.Serializable)x$3 -> {
            this.requestStreamDurationMs.add((float)((TimeLike)streamingRequestElapsed.apply()).inMilliseconds());
            return BoxedUnit.UNIT;
        });
    }

    private void countResponseStreamDuration(Response response) {
        Function0 streamingResponseElapsed = Stopwatch$.MODULE$.start();
        response.reader().onClose().respond((Function1 & Serializable & scala.Serializable)x$4 -> {
            this.responseStreamDurationMs.add((float)((TimeLike)streamingResponseElapsed.apply()).inMilliseconds());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(StatsFilter $this, Function0 elapsed$1, Request request$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Return) {
            Return return_ = (Return)try_;
            Response response = (Response)return_.r();
            if (response.isChunked()) {
                $this.countResponseStreamDuration(response);
            }
            $this.count((Duration)elapsed$1.apply(), response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Response response = Response$.MODULE$.apply(request$1.version(), Status$.MODULE$.InternalServerError());
            $this.count((Duration)elapsed$1.apply(), response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public StatsFilter(StatsReceiver stats) {
        this.statusReceiver = stats.scope("status");
        this.timeReceiver = stats.scope("time");
        this.responseSizeStat = stats.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response_size"}));
        this.requestStreamDurationMs = stats.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request_stream_duration_ms"}));
        this.responseStreamDurationMs = stats.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response_stream_duration_ms"}));
        this.counterCache = Memoize$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> $this.statusReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1})));
        this.statCache = Memoize$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$2 -> $this.timeReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$2})));
    }
}

