/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Failure$;
import com.twitter.finagle.FailureFlags;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.ClientNackFilter;
import com.twitter.finagle.http.filter.HttpNackFilter$;
import com.twitter.io.Buf;
import com.twitter.io.Reader;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class ClientNackFilter$ {
    public static ClientNackFilter$ MODULE$;
    private final Logger log;
    private final Function1<Try<BoxedUnit>, Future<Response>> respondRetryableFailure;
    private final Function1<Try<BoxedUnit>, Future<Response>> respondNonRetryableFailure;
    private final Function1<Try<Response>, Future<Response>> com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn;
    private final Function1<Try<Response>, Future<Response>> com$twitter$finagle$http$filter$ClientNackFilter$$convertChunkedReqNackFn;
    private final Stackable<ServiceFactory<Request, Response>> module;

    static {
        new ClientNackFilter$();
    }

    public Function1<Try<Response>, Future<Response>> com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn() {
        return this.com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn;
    }

    public Function1<Try<Response>, Future<Response>> com$twitter$finagle$http$filter$ClientNackFilter$$convertChunkedReqNackFn() {
        return this.com$twitter$finagle$http$filter$ClientNackFilter$$convertChunkedReqNackFn;
    }

    public Stackable<ServiceFactory<Request, Response>> module() {
        return this.module;
    }

    private Future<BoxedUnit> swallowNackResponse(Response response) {
        return !response.isChunked() ? Future$.MODULE$.Done() : this.swallowNackBody((Reader<Buf>)response.reader(), 1024).onFailure((Function1 & Serializable & scala.Serializable)x$3 -> {
            ClientNackFilter$.$anonfun$swallowNackResponse$1(response, x$3);
            return BoxedUnit.UNIT;
        });
    }

    private Future<BoxedUnit> swallowNackBody(Reader<Buf> reader, int maxRead) {
        return reader.read().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Some some = null;
            Option option = x0$1;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Buf chunk = (Buf)some.value();
                if (chunk.length() <= maxRead) {
                    return MODULE$.swallowNackBody(reader, maxRead - chunk.length());
                }
            }
            if (bl) {
                ClientNackFilter$.MODULE$.log.warning("Received an excessively large nack response body.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                reader.discard();
                return Future$.MODULE$.Done();
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            return Future$.MODULE$.Done();
        });
    }

    public static final /* synthetic */ void $anonfun$swallowNackResponse$1(Response response$1, Throwable x$3) {
        response$1.reader().discard();
    }

    private ClientNackFilter$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(this.getClass().getName());
        this.respondRetryableFailure = (Function1 & Serializable & scala.Serializable)x$1 -> Future$.MODULE$.exception((Throwable)Failure$.MODULE$.RetryableNackFailure());
        this.respondNonRetryableFailure = (Function1 & Serializable & scala.Serializable)x$2 -> Future$.MODULE$.exception((Throwable)Failure$.MODULE$.NonRetryableNackFailure());
        this.com$twitter$finagle$http$filter$ClientNackFilter$$convertNackFn = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Return return_ = null;
            Try try_ = x0$1;
            if (try_ instanceof Return) {
                bl = true;
                return_ = (Return)try_;
                Response res = (Response)return_.r();
                if (HttpNackFilter$.MODULE$.isRetryableNack(res)) {
                    return MODULE$.swallowNackResponse(res).transform(ClientNackFilter$.MODULE$.respondRetryableFailure);
                }
            }
            if (!bl) return Future$.MODULE$.const(try_);
            Response res = (Response)return_.r();
            if (!HttpNackFilter$.MODULE$.isNonRetryableNack(res)) return Future$.MODULE$.const(try_);
            return MODULE$.swallowNackResponse(res).transform(ClientNackFilter$.MODULE$.respondNonRetryableFailure);
        };
        this.com$twitter$finagle$http$filter$ClientNackFilter$$convertChunkedReqNackFn = (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Throw throw_;
            Throwable ex;
            Future future;
            Return return_;
            Response res;
            Try try_ = x0$2;
            if (try_ instanceof Return && HttpNackFilter$.MODULE$.isNack(res = (Response)(return_ = (Return)try_).r())) {
                future = MODULE$.swallowNackResponse(res).transform(ClientNackFilter$.MODULE$.respondNonRetryableFailure);
            } else if (try_ instanceof Throw && (ex = (throw_ = (Throw)try_).e()) instanceof FailureFlags) {
                FailureFlags failureFlags = (FailureFlags)ex;
                future = Future$.MODULE$.exception((Throwable)failureFlags.asNonRetryable());
            } else {
                future = Future$.MODULE$.const(try_);
            }
            return future;
        };
        this.module = new Stack.Module0<ServiceFactory<Request, Response>>(){
            private final ClientNackFilter nackFilter;
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ServiceFactory<Request, Response> next) {
                return this.nackFilter.andThen(next);
            }
            {
                this.nackFilter = new ClientNackFilter();
                this.role = new Stack.Role("ClientNackFilter");
                this.description = "Convert HTTP nack responses to Failures";
            }
        };
    }
}

