/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.AsyncFilter;
import com.twitter.finagle.http.KerberosAuthenticationFilter$ExtractAuthAndCatchUnauthorized$;
import com.twitter.finagle.http.KerberosAuthenticationFilter$SpnegoClientFilter$;
import com.twitter.finagle.http.KerberosAuthenticationFilter$SpnegoServerFilter$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.SpnegoAuthenticator;
import com.twitter.finagle.http.param.ClientKerberos;
import com.twitter.finagle.http.param.KerberosConfiguration;
import com.twitter.finagle.http.param.ServerKerberos;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.security.auth.login.Configuration;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class KerberosAuthenticationFilter$ {
    public static KerberosAuthenticationFilter$ MODULE$;
    private final Stack.Role role;

    static {
        new KerberosAuthenticationFilter$();
    }

    public Stack.Role role() {
        return this.role;
    }

    public Stackable<ServiceFactory<Request, Response>> serverModule() {
        return new Stack.Module1<ServerKerberos, ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ServerKerberos serverKerberos, ServiceFactory<Request, Response> next) {
                return serverKerberos.serverKerberosConfiguration().authEnabled() ? new AsyncFilter<Request, SpnegoAuthenticator.Authenticated<Request>, Response>(KerberosAuthenticationFilter$SpnegoServerFilter$.MODULE$.apply(serverKerberos.serverKerberosConfiguration())).andThen(KerberosAuthenticationFilter$ExtractAuthAndCatchUnauthorized$.MODULE$).andThen(next) : next;
            }
            {
                this.role = KerberosAuthenticationFilter$.MODULE$.role();
                this.description = "Add kerberos server authentication to requests";
            }
        };
    }

    public Stackable<ServiceFactory<Request, Response>> clientModule() {
        return new Stack.Module1<ClientKerberos, ServiceFactory<Request, Response>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Request, Response> make(ClientKerberos clientKerberos, ServiceFactory<Request, Response> next) {
                return clientKerberos.clientKerberosConfiguration().authEnabled() ? new AsyncFilter<Request, Request, Response>(KerberosAuthenticationFilter$SpnegoClientFilter$.MODULE$.apply(clientKerberos.clientKerberosConfiguration())).andThen(next) : next;
            }
            {
                this.role = KerberosAuthenticationFilter$.MODULE$.role();
                this.description = "Add kerberos client authentication to requests";
            }
        };
    }

    public void com$twitter$finagle$http$KerberosAuthenticationFilter$$jaas(KerberosConfiguration kerberosConfiguration, String loginContext) {
        PrintWriter printWriter;
        String jaas = "jaas-internal.conf";
        String jaasConfiguration = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(275).append(loginContext).append(" {\n         |  com.sun.security.auth.module.Krb5LoginModule required\n         |  keyTab=\"").append(kerberosConfiguration.keyTab().get()).append("\"\n         |  principal=\"").append(kerberosConfiguration.principal().get()).append("\"\n         |  useKeyTab=").append(kerberosConfiguration.useKeyTab()).append("\n         |  storeKey=").append(kerberosConfiguration.storeKey()).append("\n         |  refreshKrb5Config=").append(kerberosConfiguration.refreshKrb5Config()).append("\n         |  debug=").append(kerberosConfiguration.debug()).append("\n         |  doNotPrompt=").append(kerberosConfiguration.doNotPrompt()).append("\n         |  authEnabled=").append(kerberosConfiguration.authEnabled()).append("; \n         |};").toString())).stripMargin();
        Path jaasFilePath = FileSystems.getDefault().getPath(jaas, new String[0]).toAbsolutePath();
        if (Files.exists(jaasFilePath, new LinkOption[0])) {
            if (!Files.lines(jaasFilePath).anyMatch(line -> line.equals(new StringBuilder(2).append(loginContext).append(" {").toString()))) {
                this.writeFile(jaasFilePath, new StringBuilder(2).append("\n\n").append(jaasConfiguration).toString(), true);
                Configuration.getConfiguration().refresh();
            }
            printWriter = BoxedUnit.UNIT;
        } else {
            printWriter = this.writeFile(jaasFilePath, jaasConfiguration, this.writeFile$default$3());
        }
        System.setProperty("java.security.auth.login.config", ((Object)jaasFilePath).toString());
    }

    private PrintWriter writeFile(Path path, String content, boolean append) {
        return new PrintWriter(path, append, content){
            {
                this.write(content$1);
                this.close();
            }
        };
    }

    private boolean writeFile$default$3() {
        return false;
    }

    private KerberosAuthenticationFilter$() {
        MODULE$ = this;
        this.role = new Stack.Role("KerberosAuthentication");
    }
}

